/*******************************************************************************
+
+  LEDA  3.0
+
+
+  _sunview.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>
#include <math.h>
#include <string.h>
#include <stdio.h>


#define NOCLIP 0x1

#define XCOL(c) PIX_SRC ^ PIX_DST | PIX_COLOR(c)

#define COL(c) PIX_SRC|PIX_COLOR(c)

#define pix_mode(c) (pix_mode_op  | PIX_COLOR(c))

#define XPIX(coord) (int)(xorigin + (coord)*x_draw_scale)
#define YPIX(coord) (int)(yorigin - (coord)*x_draw_scale)

#define XREAL(pix)  ((double)(pix-xorigin)/x_draw_scale)
#define YREAL(pix)  ((double)(yorigin-pix)/x_draw_scale)


extern Notify_error notify_dispatch();

static short icon_image[] = {

#include "leda.icon"

};

static mpr_static(leda_icon_pixrect,64,64,1,icon_image);



static char default_frame_label[128];

static char frame_label[80];

static char read_frame_format[] = "%8.2f %8.2f      %s";

static Frame	frame;
static Canvas	canvas;
static Pixwin  *pw = 0;
static Icon    icon;

static Frame panel_frame;
static Panel panel;

typedef void (*PRD)();
typedef void (*PMA)();

static void x_draw_default_redraw() { /* do nothing */ }

static void x_draw_mouse_default_action(x,y) 
double x,y;
{ /* do nothing */}

PRD x_draw_redraw = x_draw_default_redraw;
PMA x_draw_mouse_action = x_draw_mouse_default_action;

static int x_draw_done;

static Pixfont *font;

static int pix_mode_op;

static int xdots,ydots, xorigin,yorigin;  /* pixels          */

static int mouse_key,mouse_xpix, mouse_ypix; 
static int mouse_last_xpix, mouse_last_ypix;
static int mouse_start_xpix, mouse_start_ypix;  /* start for segments  ... */
static int mouse_read_kind;


static double mouse_xreal,mouse_yreal;
static double mouse_last_xreal,mouse_last_yreal;
static double mouse_start_xreal,mouse_start_yreal;


static char* mesg_list[32];
static int   mesg_count;


/* external variables */

/*
SCREEN_WIDTH = 1152;
SCREEN_HEIGHT = 900;
*/

int x_draw_window_xpos = 0;
int x_draw_window_ypos = 0;
int x_draw_window_width = 0;
int x_draw_window_height = 0;
   

   
double x_draw_xmax,x_draw_xmin,x_draw_ymax,x_draw_ymin,x_draw_scale;   

int x_draw_grid_mode;
int x_draw_depth;

int    x_draw_line_width, 
       x_draw_node_width, 
       x_draw_line_style, 
       x_draw_text_mode, 
       x_draw_drawing_mode,
       x_draw_screen_flush;


static unsigned char RED[256],GREEN[256],BLUE[256];

static char* x_draw_default_font = "screen.r.12";


static Pr_texture *Line_style = 0;

static Pr_texture *solid;
static Pr_texture *dashed;
static Pr_texture *dotted;

/*
x_draw_new_color(r,g,b)
int r,g,b;
{ int col = col_count;
  col_count++;
  RED[col] =   r;  
  GREEN[col] =   g;  
  BLUE[col] =   b;
  pw_setcmsname(pw,"new_color");
  pw_putcolormap(pw,0,col_count,RED,GREEN,BLUE);
  return col;
 }
*/



x_draw_init_colors()
{ RED[0] = 255;  GREEN[0] = 255;  BLUE[0] = 255;  /* white  */
  RED[1] =   0;  GREEN[1] =   0;  BLUE[1] =   0;  /* black  */
  RED[2] = 255;  GREEN[2] =   0;  BLUE[2] =   0;  /* red    */
  RED[3] =   0;  GREEN[3] = 255;  BLUE[3] =   0;  /* green  */
  RED[4] =   0;  GREEN[4] = 100;  BLUE[4] = 255;  /* blue   */
  RED[5] = 128;  GREEN[5] = 128;  BLUE[5] =   0;  /* yellow */
  RED[6] = 128;  GREEN[6] =   0;  BLUE[6] = 178;  /* violet */
  RED[7] = 192;  GREEN[7] =  64;  BLUE[7] =   0;  /* orange */
/*
indigo: RED[]  =  64;	 GREEN[]  =   0;  BLUE[]  =  76; 
*/
  pw_setcmsname(pw,"new_color");
  pw_putcolormap(pw,0,8,RED,GREEN,BLUE);
 }


x_draw_set_redraw(f)
PRD f;
{ x_draw_redraw = f; }

x_draw_set_frame_label(message)
char* message;
{ strcpy(frame_label,message); }

x_draw_reset_frame_label()
{ strcpy(frame_label,default_frame_label); }

void x_draw_mouse_segment_action(x,y)
double x,y;
{ pw_vector(pw, mouse_start_xpix,mouse_start_ypix,
                XPIX(x), YPIX(y),PIX_SRC^PIX_DST,1); 
}

void x_draw_mouse_rect_action(x,y)
double x,y;
{   int save_pix_mode = pix_mode_op;
    pix_mode_op = PIX_SRC ^ PIX_DST;
    x_draw_rectangle(mouse_start_xreal,mouse_start_yreal,x,y,1,1);
    pix_mode_op = save_pix_mode;
 } 

void x_draw_mouse_circle_action(x,y)
double x,y;
{   double r = hypot(x - mouse_start_xreal, y - mouse_start_yreal);
    int save_pix_mode = pix_mode_op;
    pix_mode_op = PIX_SRC ^ PIX_DST;
    x_draw_circle(mouse_start_xreal, mouse_start_yreal, r, 1, 1);    
    pix_mode_op = save_pix_mode;
}


x_draw_set_font(fname)
char* fname;
{ char buf[256];
  Pixfont *f;

  sprintf(buf,"/usr/lib/fonts/fixedwidthfonts/%s",fname); 

  if ( f=pf_open(buf) ) 
  { font =f ;
    return 1;
   }
  else return 0;

}

x_draw_set_line_style(s)
int s;
{ int save = x_draw_line_style;
  x_draw_line_style = s;
   
   switch (x_draw_line_style)  {

   case 0 : Line_style = solid;
            break;

   case 1 : Line_style = dashed;
            break;

   case 2 : Line_style = dotted;
            break;

   default: break;

   }
  return save;
}

int x_draw_set_mode(m)
int m;
{ int save = x_draw_drawing_mode;
  x_draw_drawing_mode = m;
   
   switch (x_draw_drawing_mode)  {

   case 0 : pix_mode_op  = PIX_SRC;
            break;

   case 1 : pix_mode_op = PIX_SRC ^ PIX_DST;
            break;

   default: break;

   }
  return save;
}

int x_draw_set_line_width(w)
int w;
{ int save = x_draw_line_width;
  x_draw_line_width = w;
  return save;
 }

int x_draw_set_node_width(w)
int w;
{ int save = x_draw_node_width;
  x_draw_node_width = w;
  return save;
 }

int x_draw_set_text_mode(m)
int m;
{ int save = x_draw_text_mode;
  x_draw_text_mode = m;
  return save;
 }



static void my_event_proc(canvas,event)
Canvas canvas;
Event* event;
{ 
  char s[256];

  /*int k = event_action(event);  does not work for SUN3  */

  int k = event_id(event);

  switch (k) {

  case WIN_RESIZE: x_draw_init(x_draw_xmin,x_draw_xmax,x_draw_ymin,x_draw_grid_mode);
                   break;

  case MS_LEFT:   mouse_key = 1;
                  if (event_ctrl_is_down(event))  mouse_key +=3;
                  if (event_shift_is_down(event)) mouse_key = -mouse_key;
                  break;

  case MS_MIDDLE: mouse_key = 2;
                  if (event_ctrl_is_down(event))  mouse_key +=3;
                  if (event_shift_is_down(event)) mouse_key = -mouse_key;
                  break;

  case MS_RIGHT:  mouse_key = 3;
                  if (event_ctrl_is_down(event))  mouse_key +=3;
                  if (event_shift_is_down(event)) mouse_key = -mouse_key;
                  break;

  case KEY_RIGHT(7): /* left arrow */
                     mouse_xpix -= (int)x_draw_scale*x_draw_grid_mode;
                     window_set(canvas,WIN_MOUSE_XY,mouse_xpix,mouse_ypix,0);
                     break;

  case KEY_RIGHT(9): /* right arrow */
                     mouse_xpix += (int)x_draw_scale*x_draw_grid_mode;
                     window_set(canvas,WIN_MOUSE_XY,mouse_xpix,mouse_ypix,0);
                     break;

  case KEY_RIGHT(11): /* down arrow */
                     mouse_ypix += (int)x_draw_scale*x_draw_grid_mode;
                     window_set(canvas,WIN_MOUSE_XY,mouse_xpix,mouse_ypix,0);
                     break;

  case KEY_RIGHT(5): /* up arrow */
                     mouse_ypix -= (int)x_draw_scale*x_draw_grid_mode;
                     window_set(canvas,WIN_MOUSE_XY,mouse_xpix,mouse_ypix,0);
                     break;

  case KEY_RIGHT(1): /* center */
                     mouse_xpix = XPIX(0);
                     mouse_ypix = YPIX(0);
                     window_set(canvas,WIN_MOUSE_XY,mouse_xpix,mouse_ypix,0);
                     break;


  default: mouse_xpix = event_x(event);
           mouse_ypix = event_y(event);
           break;

  }


  if (x_draw_grid_mode)  x_draw_cursor();
  
    mouse_xreal =  x_draw_xmin+((double)mouse_xpix)/x_draw_scale;
    mouse_yreal =  x_draw_ymax-((double)mouse_ypix)/x_draw_scale;
  
  if (x_draw_grid_mode) 
  { 
    mouse_xreal = x_draw_grid_mode * (int)(mouse_xreal/x_draw_grid_mode + ((mouse_xreal > 0) ? 0.5 : -0.5));
    mouse_yreal = x_draw_grid_mode * (int)(mouse_yreal/x_draw_grid_mode + ((mouse_yreal > 0) ? 0.5 : -0.5));
    mouse_xpix  = XPIX(mouse_xreal);
    mouse_ypix  = YPIX(mouse_yreal);
  
    x_draw_cursor();
  }


  sprintf(s,read_frame_format, mouse_xreal,mouse_yreal,frame_label);
  window_set(frame,FRAME_LABEL,s,0);


  if (x_draw_mouse_action)  /* user defined action */
  { x_draw_mouse_action(mouse_last_xreal,mouse_last_yreal);
    x_draw_mouse_action(mouse_xreal,mouse_yreal);
   }
    

  mouse_last_xpix = mouse_xpix;
  mouse_last_ypix = mouse_ypix;

  mouse_last_xreal = mouse_xreal;
  mouse_last_yreal = mouse_yreal;

}

int x_read_mouse(kind, xstart,ystart,x,y)
int    kind;   /* 0: point, 1: segment, 2:rectangle, 3: circle */
double xstart;
double ystart;
double *x;
double *y;
{ 
  PMA f;

  switch(kind) {

  case 0 : f = x_draw_mouse_default_action;
          break;

  case 1:  f = x_draw_mouse_segment_action;
           break;

  case 2:  f = x_draw_mouse_rect_action;
           break;

  case 3:  f = x_draw_mouse_circle_action;
           break;

  default: f = x_draw_mouse_default_action;
           break;

  }

  return x_read_mouse_action(f,xstart,ystart,x,y);

}

int x_draw_get_button()
{ x_draw_mouse_action = x_draw_mouse_default_action;
  mouse_key = 0;
  notify_dispatch();
  return mouse_key;
 }

int x_read_mouse_action(action, xstart,ystart,x,y)
PMA   action;
double xstart;
double ystart;
double *x;
double *y;
{ 
  x_draw_mouse_action = action;

  mouse_key = 0;

  mouse_start_xreal = xstart;
  mouse_start_yreal = ystart;

  mouse_start_xpix = XPIX(xstart);
  mouse_start_ypix = YPIX(ystart);

  if (x_draw_grid_mode) x_draw_cursor();

  if (x_draw_mouse_action)  /* user defined action */
  { x_draw_mouse_action(mouse_last_xreal,mouse_last_yreal);
   }



  while (!mouse_key && !x_draw_done)  notify_dispatch();

  if (x_draw_done) return 0;


  if (x_draw_mouse_action)  /* user defined action */
  { x_draw_mouse_action(mouse_xreal,mouse_yreal);
   }


  if (x_draw_grid_mode) x_draw_cursor();

  *x = mouse_xreal;
  *y = mouse_yreal;


  return mouse_key;
}
  





Notify_value my_notice_destroy(frame, status)
Frame frame;
Destroy_status status;
{
  if (status !=DESTROY_CHECKING)
  {
    x_draw_done = 1;
    (void) notify_stop();
   }

  return (notify_next_destroy_func(frame,status));
}




x_draw_init_window(w_width,w_height,w_xpos,w_ypos,label)
int w_width,
    w_height,
    w_xpos,
    w_ypos;
char* label;
{ 
  if (pw!=0) 
  { fprintf(stderr,"warning: second initialization of window ignored.\n");
    return;
   } 

  strcpy(default_frame_label,label);

  icon = icon_create(ICON_IMAGE, &leda_icon_pixrect, 0);

  frame = window_create(0, FRAME, 
              WIN_WIDTH,    w_width,
              WIN_HEIGHT,   w_height,
              WIN_X,        w_xpos,
              WIN_Y,        w_ypos,
              FRAME_ICON,  icon,
              FRAME_NO_CONFIRM, TRUE,
              FRAME_LABEL, default_frame_label, 0);

  canvas = window_create(frame, CANVAS, 
              WIN_CONSUME_KBD_EVENT,    WIN_RIGHT_KEYS,
              WIN_IGNORE_PICK_EVENT,    WIN_UP_EVENTS,
              WIN_EVENT_PROC,           my_event_proc,
              0); 

  pw = canvas_pixwin(canvas);

  notify_interpose_destroy_func(frame,my_notice_destroy);

  window_set(frame,WIN_SHOW,TRUE,0);



/* init panel */

    panel_frame = window_create(0, FRAME,
                             FRAME_NO_CONFIRM, TRUE, 
                             WIN_X, 100, WIN_Y, 100, 0);

    panel = window_create(panel_frame, PANEL, 0);



  x_draw_set_font(x_draw_default_font);

  pix_mode_op = PIX_SRC;

  x_draw_init_colors(); 

  solid  = 0;
  dashed = (Pr_texture*) malloc(sizeof(Pr_texture));
  dashed->pattern = pr_tex_dashed;
  dotted = (Pr_texture*) malloc(sizeof(Pr_texture));
  dotted->pattern = pr_tex_dotted;

  x_draw_line_style   = 0;   /* solid */
  x_draw_node_width   = 12;
  x_draw_line_width   = 1;
  x_draw_text_mode    = 0;   /* transparent   */
  x_draw_drawing_mode = 0;   /* src           */

  x_draw_window_xpos = w_xpos;
  x_draw_window_ypos = w_ypos;
  x_draw_window_width = w_width;
  x_draw_window_height = w_height;


  mesg_count = 0;

}


x_draw_init(x0,x1,y0,g_mode)
double x0,x1,y0;
int g_mode;
{
  double x,y;

  if (x0>=x1) 
  { fprintf(stderr,"Illegal arguments in draw_init: x0 >= x1\n");
    exit(1);
   }

  x_draw_grid_mode = g_mode; 

  x_draw_reset_frame_label();

  xdots = (int)window_get(canvas, CANVAS_WIDTH);
  ydots = (int)window_get(canvas, CANVAS_HEIGHT);

  x_draw_depth = pw->pw_pixrect->pr_depth;

  x_draw_scale = ((double)xdots)/(x1-x0);

  /* at least grid distance of 2 pixels */
  if ((x_draw_grid_mode) && (x_draw_grid_mode*x_draw_scale < 2)) 
  { x_draw_grid_mode=0;  
    fprintf(stderr,"warning: grid distance to small.\n");
   }

  if (x_draw_grid_mode) 
    if (x_draw_scale < 1) x_draw_scale = 1;
    else x_draw_scale = (int)x_draw_scale;

  x_draw_xmin = x0;
  x_draw_ymin = y0;
  x_draw_xmax = x0+xdots/x_draw_scale;
  x_draw_ymax = y0+ydots/x_draw_scale;

  xorigin = -x0*x_draw_scale;
  yorigin = ydots+y0*x_draw_scale;

  mouse_xreal = 0;
  mouse_yreal = 0;

  x_draw_clear(0);

 if (x_draw_grid_mode)  x_draw_cursor();

 notify_dispatch();

 if (x_draw_grid_mode)  x_draw_cursor();

 (*x_draw_redraw)();

}


x_show_window() 
{ while (!x_draw_done) notify_dispatch(); }

x_draw_end()
{ if (pw)
  { pw_close(pw);
    pf_close(font);
    /* window_destroy(frame); */
    pw = 0;
   }
}

x_draw_line(x1, y1, x2, y2, col)
double x1,y1,x2,y2;
int col;
{ 
  int C[4];
  int i;
  int M = 32768;   /* 2^15    */ 

  Pr_brush br;
  br.width = x_draw_line_width;


  C[0] = XPIX(x1);
  C[1] = YPIX(y1);
  C[2] = XPIX(x2);
  C[3] = YPIX(y2);

  /* 
    Fehler beim Clipping fuer Koordinaten mit Absolutwert in
    [i*2^15..(i+1)*2^15-1],i ungerade.
  */

 /*
  for(i=0; i<4; i++)
    if ((C[i]/M) % 2) C[i] = -C[i];

 */

  pw_line(pw,C[0],C[1],C[2],C[3],&br,Line_style,pix_mode(col));

}


x_draw_point(x,y,col)
double x,y;
int col;

{ int X,Y;

  Pr_brush br;
  br.width = 1;

  X = XPIX(x);
  Y = YPIX(y);

  if (x_draw_depth==1 && col>1) col = 1;

  pw_line(pw,X-2,Y-2,X+2,Y+2,&br,solid,pix_mode(col));
  pw_line(pw,X+1,Y-1,X+2,Y-2,&br,solid,pix_mode(col));
  pw_line(pw,X-1,Y+1,X-2,Y+2,&br,solid,pix_mode(col));


}


x_draw_node(x0,y0,col)
double x0,y0;
int col;

{ int X0,Y0,x,y,e;

  int r = x_draw_node_width;

  struct pr_pos *points;
  int n = 8*r;
  int i = 0;

  points = (struct pr_pos*) malloc(n*sizeof(struct pr_pos));


  X0 = XPIX(x0);
  Y0 = YPIX(y0);

  if (x_draw_depth==1 && col>1) col = 1;

    x = 0;
    y = r;
    e = 3-2*y;

   points[i].x = X0;   points[i].y = Y0+r;
   i++;
   points[i].x = X0;   points[i].y = Y0-r;
   i++;
   points[i].x = X0+r; points[i].y = Y0;
   i++;
   points[i].x = X0-r; points[i].y = Y0;
   i++;
  
    for (x=1;x<y;)
    { points[i].x = X0+x; points[i].y = Y0+y;
      i++;
      points[i].x = X0+x; points[i].y = Y0-y;
      i++;
      points[i].x = X0-x; points[i].y = Y0+y;
      i++;
      points[i].x = X0-x; points[i].y = Y0-y;
      i++;
      points[i].x = X0+y; points[i].y = Y0+x;
      i++;
      points[i].x = X0+y; points[i].y = Y0-x;
      i++;
      points[i].x = X0-y; points[i].y = Y0+x;
      i++;
      points[i].x = X0-y; points[i].y = Y0-x;
      i++;

      x++;
      if (e>=0) { y--; e = e - 4*y; }
      e = e + 4*x + 2;
     }


   points[i].x = X0+x; points[i].y = Y0+y;
   i++;
   points[i].x = X0+x; points[i].y = Y0-y;
   i++;
   points[i].x = X0-x; points[i].y = Y0+y;
   i++;
   points[i].x = X0-x; points[i].y = Y0-y;
   i++;

   pw_polypoint(pw,0,0,i,points,pix_mode(col));

   free((char*)points);

}

x_draw_message(s)
char* s;
{ int y;
  mesg_list[mesg_count] = (char*)malloc(strlen(s)+1);
  strcpy(mesg_list[mesg_count],s);
  mesg_count++;
  y = 30*mesg_count+15;
  x_draw_set_font("cour.b.24");
  pw_ttext(pw,30,y,XCOL(1),font,s);
  x_draw_set_font(x_draw_default_font);
}


x_draw_del_messages()
{ int y;
  char* s;
  x_draw_set_font("cour.b.24");
  while(mesg_count > 0)
  { s = mesg_list[mesg_count-1];
    y = 30*mesg_count+15;
    pw_ttext(pw,30,y,XCOL(1),font,s);
    mesg_count--;
    free(s);
   }
  x_draw_set_font(x_draw_default_font);
}


x_draw_text_node(x0,y0,s,col)
double x0,y0;
int col;
char* s;
{ 
  if (x_draw_depth==1 || col == 1)
   { x_draw_node(x0,y0,1);
     x_draw_ctext(x0,y0,s,1);
    }
  else
   { x_draw_filled_node(x0,y0,col);
     x_draw_ctext(x0,y0,s,0);
    }

 }

x_draw_int_node(x0,y0,i,col)
double x0,y0;
int i,col;
{ 
  char buf[16];
  sprintf(buf,"%d",i);
  x_draw_text_node(x0,y0,buf,col);
 }


x_draw_filled_node(x0,y0,col)
double x0,y0;
int col;
{ 
  int X0,Y0,x,y,e;
  int r = x_draw_node_width;

  Pr_brush br;
  br.width = 1;

  X0 = XPIX(x0);
  Y0 = YPIX(y0);

  x = 1;
  y = r;
  e = 3-2*r;

  pw_line(pw,X0,Y0+y,X0,Y0-y,&br,0,pix_mode(col));

  while (x<=y)
  { pw_line(pw,X0+x,Y0+y,X0+x,Y0,  &br,0,pix_mode(col));
    pw_line(pw,X0+x,Y0-y,X0+x,Y0-1,&br,0,pix_mode(col));
    pw_line(pw,X0-x,Y0+y,X0-x,Y0,  &br,0,pix_mode(col));
    pw_line(pw,X0-x,Y0-y,X0-x,Y0-1,&br,0,pix_mode(col));


    if (x<y && e>=0) 
    { pw_line(pw,X0+y,Y0+x,X0+y,Y0,  &br,0,pix_mode(col));
      pw_line(pw,X0+y,Y0-x,X0+y,Y0-1,&br,0,pix_mode(col));
      pw_line(pw,X0-y,Y0+x,X0-y,Y0,  &br,0,pix_mode(col));
      pw_line(pw,X0-y,Y0-x,X0-y,Y0-1,&br,0,pix_mode(col));
      y--; 
      e = e - 4*y; 
     }

    x++;

    e = e + 4*x + 2;
   }

}


typedef struct{ int x,y,d; } queue_el;

static  queue_el P_QUEUE[2048];

#define FILLPUT(x1,y1,d1)\
{if (pw_get(pw,x1,y1) != col)\
  { pw_put(pw,x1,y1,col);\
    top->x = x1;\
    top->y = y1;\
    top->d = d1;\
    top++;\
    if (top==stop) top=P_QUEUE; }\
}

static void bfs_fill(x,y,col)
int x,y,col;
{ register queue_el* bot  = P_QUEUE;
  register queue_el* top  = P_QUEUE;
  register queue_el* stop = P_QUEUE+2048;

  FILLPUT(x,y,0)

  while (top != bot)
  { if (bot->d != 1) FILLPUT(bot->x-1,bot->y,3)
    if (bot->d != 3) FILLPUT(bot->x+1,bot->y,1)
    if (bot->d != 2) FILLPUT(bot->x,bot->y-1,4)
    if (bot->d != 4) FILLPUT(bot->x,bot->y+1,2)
    bot++;
    if (bot==stop) bot=P_QUEUE;
  }
}




x_draw_fill(x,y,col)
double x,y;
int col;
{ Rect *r = (Rect *) window_get(canvas, WIN_SCREEN_RECT);
  pw_lock(pw,r);
  bfs_fill(XPIX(x),YPIX(y),col); 
  pw_unlock(pw);
}
  

x_draw_arc()
{ fprintf(stderr,"sorry, draw arc not implemented\n"); }

x_draw_filled_arc()
{ fprintf(stderr,"sorry, draw arc not implemented\n"); }

x_draw_ellipse()
{ fprintf(stderr,"sorry, draw ellipse not implemented\n"); }

x_draw_filled_ellipse()
{ fprintf(stderr,"sorry, draw ellipse not implemented\n"); }

x_draw_circle(x0,y0,r,col)
double x0,y0,r; 
int col;

{ int save = x_draw_node_width;
  x_draw_node_width = (int)(r*x_draw_scale);
  x_draw_node(x0,y0,col);
  x_draw_node_width = save;
 }


x_draw_filled_circle(x0,y0,r,col)
double x0,y0,r; 
int col;
{ int save = x_draw_node_width;
  x_draw_node_width = (int)(r*x_draw_scale);
  x_draw_filled_node(x0,y0,col);
  x_draw_node_width = save;
 }


x_draw_xpix(x)
double x;
{ return XPIX(x); }

x_draw_ypix(x)
double x;
{ return YPIX(x); }

x_draw_pix(x,y,col)
double x,y;
int col;
{ pw_put(pw,XPIX(x),YPIX(y),col); }


x_draw_plot_xy(x0,x1,f,col)
double x0,x1;
double (*f)();
int col;
{ 

  int x = XPIX(x0);
  int y_old = YPIX((*f)(x0));
  int i,y_new;
  int size = 0;
  int n = 0;

  struct pr_pos *points;

  for(x = XPIX(x0)+1; x <= XPIX(x1); x++)
  { y_new = YPIX((*f)(XREAL(x)));
    if (y_new > y_old)
       size += (y_new-y_old+1);
    else
       size += (y_old-y_new+1);
    y_old = y_new;
   }

  points = (struct pr_pos*) malloc(size*sizeof(struct pr_pos));

  y_old = YPIX((*f)(x0));

  for(x = XPIX(x0)+1; x <= XPIX(x1); x++)
  { y_new = YPIX((*f)(XREAL(x)));
    if (y_new > y_old)
      for(i=y_old; i<=y_new; i++)  
      { points[n].x = x; 
        points[n].y = i;
        n++;
       }
    else
      for(i=y_old; i>=y_new; i--)  
      { points[n].x = x; 
        points[n].y = i;
        n++;
       }
    y_old = y_new;
  }

 pw_polypoint(pw,0,0,size,points,pix_mode(col));

 free((char*)points);
  
}

x_draw_plot_yx(y0,y1,f,col)
double y0,y1;
double (*f)();
int col;
{ 

  int y;
  int i,x_new;
  int x_old = XPIX((*f)(y0));
  int size = 0;
  int n = 0;

  struct pr_pos *points;

  for(y = YPIX(y0)-1; y >= YPIX(y1); y--)
  { x_new = XPIX((*f)(YREAL(y)));
    if (x_new > x_old)
       size += (x_new-x_old+1);
    else
       size += (x_old-x_new+1);
    x_old = x_new;
   }

  points = (struct pr_pos*) malloc(size*sizeof(struct pr_pos));

  x_old = XPIX((*f)(y0));

  for(y = YPIX(y0)-1; y >= YPIX(y1); y--)
  { 
    x_new = XPIX((*f)(YREAL(y)));
    if (x_new > x_old)
      for(i=x_old; i<=x_new; i++)  
      { points[n].x = i; 
        points[n].y = y;
        n++;
       }
    else
      for(i=x_old; i>=x_new; i--)  
      { points[n].x = i; 
        points[n].y = y;
        n++;
       }
    x_old = x_new;
  }

 pw_polypoint(pw,0,0,size,points,pix_mode(col));

 free((char*)points);
  
}


x_draw_filled_polygon(n,xcoord,ycoord,col)
int col, n;
double *xcoord, *ycoord;
{struct pr_pos *edges;
 int i;

 edges = (struct pr_pos*) malloc(n*sizeof(struct pr_pos));

 for(i=0;i<n;i++) 
 { edges[i].x = XPIX(xcoord[i]);
   edges[i].y = YPIX(ycoord[i]);
  }

 pw_polygon_2(pw,0,0,1,&n,edges,pix_mode(col),0,0,0);

/*
 free((char*)edges);
*/

 }

x_draw_polygon(n,xcoord,ycoord,col)
int col, n;
double *xcoord, *ycoord;
{ int i;

  for(i=0;i<n-1;i++) 
    x_draw_line(xcoord[i],ycoord[i], xcoord[i+1],ycoord[i+1],col);

  x_draw_line(xcoord[n-1],ycoord[n-1],xcoord[0],ycoord[0],col);

 }

x_draw_rectangle(x1,y1,x2,y2,col)
double x1,y1,x2,y2;
int col;
{
 x_draw_line(x1,y1,x1,y2,col);
 x_draw_line(x1,y2,x2,y2,col);
 x_draw_line(x2,y2,x2,y1,col);
 x_draw_line(x2,y1,x1,y1,col);

 }


x_draw_filled_rectangle(x1,y1,x2,y2,col)
double x1,y1,x2,y2; 
int col;
{ double xcoord[4], ycoord[4];

 xcoord[0] = x1;   
 ycoord[0] = y1;   
 xcoord[1] = x1;  
 ycoord[1] = y2;   
 xcoord[2] = x2; 
 ycoord[2] = y2;   
 xcoord[3] = x2;
 ycoord[3] = y1;

 x_draw_filled_polygon(4,xcoord,ycoord,col);

 }

x_draw_copy_rect(x1,y1,x2,y2,x,y)
double x1,y1,x2,y2,x,y;
{
 pw_copy(pw,XPIX(x1),YPIX(y1),(x2-x1)*x_draw_scale,(y2-y1)*x_draw_scale,
         pix_mode(1), pw,XPIX(x),YPIX(y));
 }


x_draw_clear(col)
int col;
{struct pr_pos edges[4];
 struct pr_pos *grid_points;
 int i=0;
 int n = 4;
 double x,y;
 int save;

 x_draw_del_messages();

 edges[0].x = 0;
 edges[0].y = 0;
 edges[1].x = xdots;
 edges[1].y = 0;
 edges[2].x = xdots;
 edges[2].y = ydots;
 edges[3].x = 0;
 edges[3].y = ydots;

 pw_polygon_2(pw,0,0,1,&n,edges,COL(col),0,0,0);

 save = x_draw_set_node_width(1);

 n = 0;
 if (x_draw_grid_mode) /* draw grid */
 { for(x = (int)(x_draw_xmin/x_draw_grid_mode)*x_draw_grid_mode; x<=x_draw_xmax; x+=x_draw_grid_mode)
   for(y = (int)(x_draw_ymin/x_draw_grid_mode)*x_draw_grid_mode; y<=x_draw_ymax; y+=x_draw_grid_mode)
     n++;

   grid_points = (struct pr_pos*) malloc(n*sizeof(struct pr_pos));


   for(x = (int)(x_draw_xmin/x_draw_grid_mode)*x_draw_grid_mode; x<=x_draw_xmax; x+=x_draw_grid_mode)
   for(y = (int)(x_draw_ymin/x_draw_grid_mode)*x_draw_grid_mode; y<=x_draw_ymax; y+=x_draw_grid_mode)
   { if (x*y == 0) x_draw_filled_node(x,y,1,1);
     else { grid_points[i].x = XPIX(x);
            grid_points[i].y = YPIX(y);
            i++;
           }
    }
   pw_polypoint(pw,0,0,n,grid_points,COL(1));
  }

  x_draw_set_node_width(save);

 }


/* TEXT  */

x_draw_text(x,y,s,col)
double x,y;
char * s;
int col;
{ if (x_draw_text_mode == 1)   /* opaque */
    pw_text(pw,XPIX(x),YPIX(y),pix_mode(col),font,s);
  else
    pw_ttext(pw,XPIX(x),YPIX(y),pix_mode(col),font,s);
}

x_draw_ctext(x,y,s,col)
double x,y;
char * s;
int col;
{ 
  struct pr_size size;
  size = pf_textwidth(strlen(s),font,s);
  x -= ((double)size.x)/(2*x_draw_scale);
  y -= ((double)size.y)/(3*x_draw_scale);
  x_draw_text(x,y,s,col);
}


x_draw_int(x0,y0,i,col)
double x0,y0;
int i,col;
{ 
  char buf[16];
  sprintf(buf,"%d",i);
  x_draw_ctext(x0,y0,buf,col);
 }


x_draw_cursor()
{ 
  int X,Y;

  X = XPIX(mouse_xreal);
  Y = YPIX(mouse_yreal);

  pw_vector(pw,X,Y,X+10,Y,PIX_SRC^PIX_DST,1);
  pw_vector(pw,X,Y,X-10,Y,PIX_SRC^PIX_DST,1);
  pw_vector(pw,X,Y,X,Y+10,PIX_SRC^PIX_DST,1);
  pw_vector(pw,X,Y,X,Y-10,PIX_SRC^PIX_DST,1);

}


int x_draw_screen_width()
{ Rect *r;
  Frame frame = window_create(0, FRAME,NULL); 
  r = (Rect *) window_get(frame, WIN_SCREEN_RECT);
  window_set(frame, FRAME_NO_CONFIRM, TRUE, 0);
  window_destroy(frame);
  return(r->r_width);
}


int x_draw_screen_height()
{ Rect *r;
  Frame frame = window_create(0, FRAME,NULL); 
  r = (Rect *) window_get(frame, WIN_SCREEN_RECT);
  window_set(frame, FRAME_NO_CONFIRM, TRUE, 0);
  window_destroy(frame);
  return(r->r_height);
}

static void
center_frame(frame)
Frame frame;
{ Rect * r;
  int left,top,width,height;

    /* center frame on the screen */

    r = (Rect *) window_get(frame, WIN_SCREEN_RECT);

    width = (int) window_get(frame, WIN_WIDTH);
    height = (int) window_get(frame, WIN_HEIGHT);

    left = (r->r_width - width) / 2;
    top = (r->r_height - height) / 2;

    if (left < 0)
	left = 0;
    if (top < 0)
	top = 0;

    window_set(frame, WIN_X, left, WIN_Y, top, 0);
}


int x_draw_confirm(header)
char *header;
{ /* ask for yes or no */
  char* s[2];
  s[0] = "NO";
  s[1] = "YES";
  return x_draw_read_panel(header,2,s,0);
}

int x_draw_acknowledge(header)
char *header;
{ /* ask for ok */
  char *s = "OK";
  return x_draw_read_panel(header,1,&s,0);
}

static Frame	init_panel_frame();
static void	panel_input_notify();
static int      panel_answer;

int x_draw_read_panel(message,n,labels,vertical)
char	*message;
int n;
char	**labels;
int    vertical;
{
    Frame	panel_frame;
    int		answer;

    if (x_draw_grid_mode) x_draw_cursor();

    /* create the panel_frame */
    panel_frame = init_panel_frame(message,n,labels,vertical);

    /* make the user answer */
    window_main_loop(panel_frame);

    /* destroy the panel_frame */
    window_set(panel_frame, FRAME_NO_CONFIRM, TRUE, 0);
    window_destroy(panel_frame);

    if (x_draw_grid_mode) x_draw_cursor();

    return panel_answer;
}


static Frame
init_panel_frame(message,num,label,vertical)
char	*message;
int     num;
char   **label;
int    vertical;
{
    Frame		panel_frame;
    Panel		panel;
    Panel_item		message_item;
    int			left, top, width, height;
    struct pixrect	*pr[32];
    Rect                *r;
    int                 i;

    panel_frame = window_create(0, FRAME, FRAME_SHOW_LABEL, FALSE, 0);

    panel = window_create(panel_frame, PANEL, 0);

    message_item = panel_create_item(panel, PANEL_MESSAGE, 
                           PANEL_LABEL_STRING, message,
	                   0);

    r = (Rect *) panel_get(message_item, PANEL_ITEM_RECT);

    width = 0;

    for(i=0;i<num;i++)
    { pr[i] = panel_button_image(panel, label[i], 3, 0);
      width += pr[i]->pr_width;
     }
 
    /* center buttons under the message */

    left = (r->r_width - width) / 2;
    if (left < 0)
	left = 0;

    height = rect_bottom(r) + 5;
    top = height;

    panel_create_item(panel, PANEL_BUTTON, 
	    PANEL_ITEM_X, left, PANEL_ITEM_Y, top,
            PANEL_LABEL_IMAGE, pr[0],
            PANEL_CLIENT_DATA, 0,
            PANEL_NOTIFY_PROC, panel_input_notify,
            0);


    for(i=1;i<num;i++)
    { if (vertical)
         panel_create_item(panel, PANEL_BUTTON, 
                 PANEL_ITEM_X, left, PANEL_ITEM_Y, top+=height,
                 PANEL_LABEL_IMAGE, pr[i],
                 PANEL_CLIENT_DATA, i,
                 PANEL_NOTIFY_PROC, panel_input_notify,
                 0);
      else
         panel_create_item(panel, PANEL_BUTTON, 
                    PANEL_LABEL_IMAGE, pr[i],
                    PANEL_CLIENT_DATA, i,
                    PANEL_NOTIFY_PROC, panel_input_notify,
                    0);
    }


    window_fit(panel);
    window_fit(panel_frame);

    center_frame(panel_frame);

    return panel_frame;

}


/* notify proc */
static void panel_input_notify(item, event)
Panel_item	item;
Event		*event;
{   panel_answer = (int)panel_get(item, PANEL_CLIENT_DATA);
    notify_stop(); 
}




/* Text Panels */


static Frame  init_text_panel_frame();
static void   text_panel_ok_notify();
static void   text_panel_input_notify();
static void   text_panel_menu_proc();
static char   text_panel_answer[256];

static char **text_panel_menu_strings;
static Menu   text_panel_menu;
static Frame  text_panel_frame;
static Panel  text_panel;
static Panel_item panel_text_item;

char* x_draw_read_text_panel(message,menu_label,n,items)
int      n;
char   **items;
char	*message;
char	*menu_label;
{
    if (x_draw_grid_mode) x_draw_cursor();

    init_text_panel_frame(message,menu_label,n,items);

    window_main_loop(text_panel_frame);

    window_set(text_panel_frame, FRAME_NO_CONFIRM, TRUE, 0);
    window_destroy(text_panel_frame);

    if (x_draw_grid_mode) x_draw_cursor();

    return text_panel_answer;
}





static Frame
init_text_panel_frame(message,menu_l,n,items)
int      n;
char	*message;
char	*menu_l;
char   **items;
{
    Panel_item		message_item;
    int			left, top, width, height;
    Rect		*r;
    int i;
    int cols;
    char* menu_label[64];
  
    cols = 1 +n/15;

    sprintf(menu_label,"%s -->",menu_l);


    text_panel_frame = window_create(0, FRAME, FRAME_SHOW_LABEL, FALSE, 0);

    text_panel = window_create(text_panel_frame, PANEL, 0);

    panel_text_item = panel_create_item(text_panel, PANEL_TEXT, 
                           PANEL_ITEM_Y, 15,
                           PANEL_NOTIFY_PROC,  text_panel_input_notify,
                           PANEL_LABEL_STRING, message,
                           PANEL_VALUE_DISPLAY_LENGTH, 25,
                           PANEL_VALUE_STORED_LENGTH, 256, 
                        /* PANEL_VALUE, default_text,   */
	                   0);

    if (n > 0)
    { text_panel_menu_strings = items;

      text_panel_menu = menu_create( MENU_DEFAULT, 0, MENU_NCOLS, cols, 0);

      for(i=0;i<n;i++) menu_set(text_panel_menu,MENU_STRING_ITEM,items[i],i,0);

      panel_create_item(text_panel, PANEL_BUTTON,
              PANEL_LABEL_IMAGE,panel_button_image(text_panel,menu_label,0,0), 
              PANEL_EVENT_PROC, text_panel_menu_proc,
                        0);
     }


    window_fit(text_panel);
    window_fit(text_panel_frame);

    center_frame(text_panel_frame);

}


/* notify proc */
static void text_panel_input_notify(item, event)
Panel_item	item;
Event		*event;
{
    strcpy(text_panel_answer,(char*)panel_get_value(item));
    notify_stop();
}


static void text_panel_menu_proc(item, event)
Panel_item item;
Event *event;
{ int i;
  if (event_id(event) == MS_RIGHT && event_is_down(event))
  { i = (int)menu_show(text_panel_menu, text_panel, event,0);
    window_set(panel_text_item,PANEL_VALUE,text_panel_menu_strings[i],0);
    strcpy(text_panel_answer,text_panel_menu_strings[i]);
    notify_stop();
   }
  else panel_default_handle_event(item,event);
}

void x_draw_flush() {}

void x_draw_notice() {}


x_draw_message_panel(argc, argv)
char *argv[];
{
    Frame      panel_frame;
    Panel      panel;
    Panel_item item,but;
    int        i,left, top, width, height;
    Rect      *r;

    if (x_draw_grid_mode) x_draw_cursor();

    panel_frame = window_create(0, FRAME,
                                FRAME_LABEL, argv[0],
                                0);

    panel = window_create(panel_frame, PANEL,0);

    if (argc > 1)
    { item = panel_create_item(panel, PANEL_MESSAGE, 
                PANEL_ITEM_Y,20,
                PANEL_ITEM_X,25,
                PANEL_LABEL_BOLD, TRUE, 
                PANEL_LABEL_STRING, argv[1],
                NULL);
      r = (Rect *) panel_get(item, PANEL_ITEM_RECT);
      width = r->r_width;
     }

    for(i = 2; i< argc; i++)
    { item = panel_create_item(panel, PANEL_MESSAGE, 
                PANEL_ITEM_X,25,
                PANEL_ITEM_Y,20*i,
                PANEL_LABEL_BOLD, TRUE, 
                PANEL_LABEL_STRING, argv[i],
                NULL);
      r = (Rect *) panel_get(item, PANEL_ITEM_RECT);
      if (width < r->r_width) width = r->r_width;
     }

    but = panel_create_item(panel, PANEL_BUTTON,
/*
                PANEL_ITEM_X,width/2 - 15,
*/
                PANEL_CLIENT_DATA, 0,
                PANEL_LABEL_IMAGE, panel_button_image(panel, "OK", 3, 0),
                PANEL_NOTIFY_PROC, panel_input_notify,
                NULL);

    window_fit(panel);
    window_fit(panel_frame);

    center_frame(panel_frame);

    window_main_loop(panel_frame);

    window_set(panel_frame, FRAME_NO_CONFIRM, TRUE, 0);
    window_destroy(panel_frame);

    if (x_draw_grid_mode) x_draw_cursor();

}

