/*******************************************************************************
+
+  LEDA  3.0
+
+
+  _misc.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



#include <LEDA/plane.h>
#include <math.h>

static const double eps = 1e-10;


//------------------------------------------------------------------------------
// some usefull functions
//------------------------------------------------------------------------------

/*
bool right_turn(point a, point b, point c)
{
return ( (a.ycoord()-b.ycoord())*(a.xcoord()-c.xcoord())
         + (b.xcoord()-a.xcoord())*(a.ycoord()-c.ycoord()) >= 0)
 }
*/

bool right_turn(point a, point b, point c)
{ segment s(a,b);
  segment t(b,c);
  return (s.angle(t) < 0);
 }

bool left_turn(point a, point b, point c)
{ segment s(a,b);
  segment t(b,c);
  return (s.angle(t) > 0);
 }


line p_bisector(point p, point q)
{ line l(p,q);
  double m_x = (p.xcoord() + q.xcoord())/2;
  double m_y = (p.ycoord() + q.ycoord())/2;
  point M(m_x,m_y);

  double alpha = l.angle();

  return line(M,alpha+M_PI_2);

}




  
