/*******************************************************************************
+
+  LEDA  3.0
+
+
+  _planar.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




/*******************************************************************************
 *
 *                       int PLANAR(graph& G )
 *
 * testet einen zweifach zusammenhaengenden Graphen auf Planaritaet und
 * berechnet die kombinatorische Einbettung des Graphen.Die Implementierung 
 * basiert auf dem Algorithmus aus Mehlhorn, Band 2.
 * Kommentare beziehen sich fast immer auf die entsprechenden Stellen im Buch.
 * Zur Zeit funktioniert das Programm nur, wenn die Eingabe aus der gerichteten
 * Version eines ungerichteten 2-fach zus.haengenden Graphen besteht !!!
 *
 * Andreas Thieltges 
 *
 ******************************************************************************/


#include <LEDA/graph_alg.h>


struct edge_info
{ // edgeinfo verwaltet zur Kante e die Segmentnr, die aktuelle Blocknr
  // und die aktuelle Plazierung der Kante rechts oder links vom Spine
  edge e;
  int seg_nr;
  int block_nr;
  char plaz;

 LEDA_MEMORY(edge_info)
};

typedef edge_info* ed_inf;

void Clear(ed_inf& x) { delete x; }



struct block 
{ // ein Block besteht aus der Liste der rechten und der Liste der linken
  // Befestigungen (Attachments)
 list<int> L, R;

 LEDA_MEMORY(block)
};

typedef block* blptr;


void Clear(blptr& x)  { delete x; }





void swap_plaz( ed_inf& p ) // tauscht die Plaz. von L/R oder umgekehrt
{
 switch( p->plaz )
      {
       case 'L' : p->plaz = 'R'; break;
       case 'R' : p->plaz = 'L'; break;
       case '=' : p->plaz = '!'; break;
       case '!' : p->plaz = '='; break;
      }
 }


// mirror tauscht rekursiv Basisbefestigungen frueher eingebetter
// Segmente

void mirror(list<ed_inf>* segment, int s_nr)
{
int i = 1;
ed_inf x;

   forall( x, segment[s_nr]) 
      if( i++ == 1 )
          swap_plaz( x );
      else 
          if( x->seg_nr > s_nr ) mirror(segment, x->seg_nr);

}




void flipping( list<ed_inf>* segment, int s_nr, int h)
{
  ed_inf x;
   
     forall( x, segment[s_nr])
      { 
        if( x->block_nr == h )
          { swap_plaz( x );
            if( x->seg_nr > s_nr ) mirror(segment, x->seg_nr);
           }
       }

}


void null_block( list<ed_inf>& s, int h)
{
ed_inf x;
   
    forall( x, s)
      if( x->block_nr == h )
           x->block_nr = 0;

}


void upd_block_ctr( list<ed_inf>& s, int h)
{
ed_inf x;
   
    forall( x, s)
      if( x->block_nr > h )
           x->block_nr = h;

}




void init_segm( list<ed_inf>* segment, int cur_nr, edge e)
{
ed_inf neu = new edge_info;

   neu->e = e;
   neu->block_nr = 0;
   neu->seg_nr = cur_nr;
   neu->plaz = 'L';
   segment[cur_nr].push(neu);
}


void add_edge( list<ed_inf>& s, int s_nr, int h, edge e)
{
ed_inf neu = new edge_info;

   neu->e = e;
   neu->block_nr = h;
   neu->seg_nr = s_nr;
   neu->plaz = '=';

   s.append(neu);
}




// max_L_R berechnet die maximale Befestigung des Blockstack-
// eintrags top

int max_L_R(blptr& top)
{
int lmax, rmax;

 lmax = rmax = 0;

 if( !(top->L).empty() )
    lmax = (top->L).head();
 if(!(top->R).empty() )
    rmax = (top->R).head();

 return  Max(lmax,rmax);
}



// Linke und Rechte Attachment-Liste des Blockstackelements werden vertauscht
void swap_at(blptr& top)
{
list<int> tmp = top->L;
 
      if( ! top->R.empty() )
         top->L = top->R;
      else top->L.clear();
      top->R = tmp;
}



/* Test, ob der Graph noch bipartit, analog zum Buch. 
k: Hoehe des Blockstacks + 1, 
zurueckgegeben wird die Anzahl zu verschraenkender Blocks, falls G bipartit,
sonst -1
*/


 
int bipartite_test(list<blptr>& atblock, list<int>& A, int k,
                    list<ed_inf>* segment, int seg_nr)
{
int min_att;
list_item top = atblock.first(); // top zeigt auf oberstes Kellerelement

   min_att = A.tail(); // min. Befestigung der Liste A steht am Ende, da
                       // A absteigend sortiert
   while( top != nil && max_L_R(atblock[top]) > min_att )
    {
     if( !atblock[top]->L.empty() && atblock[top]->L.head() > min_att )
        { // links gibt es im Stack eine Befestigung > min_att
          // printf("vor swap %d %d %d\n",atblock[top]->L.head(),k,seg_nr);
           flipping(segment, seg_nr, k-1 ); // klappen von Segmenten
           swap_at( atblock[top] ); // tausche Att.listen von top
           if( !atblock[top]->L.empty() && atblock[top]->L.head() > min_att )
                 return -1; // Graph ist nicht planar
        }
     k--;
     top = atblock.succ(top);
    }
 return k-1;
}




void update_block_stack(list<blptr>& atblock, int h,int dist,
                        list<int>& A)
{
int i;
list<int> ALB, ARB;
list_item j;
blptr neu;

  for(i=h; i > dist; i--)
    {
      j = atblock.first();
      ALB.conc( atblock[j]->L);
      ARB.conc(atblock[j]->R);

     atblock.pop();
    }
  neu = new  block;  
  A.conc( ALB );
  neu->L = A;
  neu->R = ARB;
  atblock.push(neu); 

}

void remove_node_below(int j,int sp_start,int wr,
                       list<blptr>& atblock, list<ed_inf>& s)
{
int h;
 if( j == sp_start)
     j = wr;
 else --j;
 
 list_item top = atblock.first();

 while(  top != nil && ( !atblock[top]->L.empty() && atblock[top]->L.head() == j 
         ||    !atblock[top]->R.empty() && atblock[top]->R.head() == j ) )
   {
    if( !atblock[top]->L.empty() && atblock[top]->L.head() == j)
        atblock[top]->L.pop();
      
    if( !atblock[top]->R.empty() && atblock[top]->R.head() == j)
        atblock[top]->R.pop();

    if( atblock[top]->L.empty() && atblock[top]->R.empty() )
       {
        h = atblock.length();
        atblock.pop();
        top=atblock.first();
        null_block( s, h);
       }
        
   }

}


int strongly_planar(list<blptr>& atblock, int w0, list<int>& A,
                    list<ed_inf>* segment, int seg_nr)
{
int h;
 A.clear();
 
 h = atblock.length();
 while ( !atblock.empty())
  {
   list_item top = atblock.first();
   if(  !atblock[top]->R.empty() && atblock[top]->R.head() > w0 )
     {
      swap_at( atblock[top] );
      flipping(segment, seg_nr, h);
      if( !atblock[top]->R.empty() && atblock[top]->R.head() > w0 )
           return false;
     }
   
    A.conc( atblock[top]->L );

    A.conc( atblock[top]->R );
 
    atblock.pop();
    h--;
  }
    A.append(w0);
    return true;

}







list<int> plantest(node* Graph_order, node_array<int>& Dfsnr, edge e,
                   list<ed_inf>* segment, int& seg_nr)
{

node v, w, spine_node;
edge seg_start;
list<int> A;
list<blptr> atblock;
int i,j, wr = 0, w0, h, dist, sp_start, sp_end,
    start_nr, cur_nr;

  spine_node = target(e);  // target(e) ist 1. Knoten des Spines zu S(e) 

  sp_start = Dfsnr[spine_node];

 // wr ist der Knoten, an dem S(e) den Stamm verlaesst
     wr = Dfsnr[source(e)];

  // finde den Spine: laufe ueber T-Kanten bis zur 1. B-Kante

  forall_adj_edges(e,spine_node)
     if( Dfsnr[target(e)] > Dfsnr[spine_node] ) // e ist T-Kante 
        spine_node = target(e);
     else break;

  sp_end = Dfsnr[source(e)]; // e ist die Basiskante von S(e)
  w0 = Dfsnr[target(e)];     // w0 ist die Basisbefestigung am Stamm
  cur_nr = seg_nr;
   init_segm( segment, cur_nr, e);
 // printf("wr %d sp_st %d end %d w0 %d\n",wr, sp_start,sp_end,w0); 

  for(j = sp_end; j >= sp_start; j--)
   {
     v = Graph_order[j]; // v ist der Knoten mit dfsnum j
      
     i = 1;
     forall_adj_edges(seg_start,v) // betr. alle v verlassenden Kanten ausser
                                   // der ersten Kante 
      {
       start_nr = cur_nr;
       if( i++ > 1)
       {
        w = target(seg_start);
         // printf(" next edge : %d --> %d\n",Dfsnr[v],Dfsnr[w]);
        if( Dfsnr[w] > Dfsnr[v] )  // Segment startet mit T-Kante 
         { // teste S(seg_start)
           start_nr = ++seg_nr;
           A = plantest(Graph_order, Dfsnr, seg_start, segment, seg_nr);
           if( A.empty() )
               return A;  // wenn A leer: nicht planar
         }
        else
          { A.clear();
            A.append(Dfsnr[w]); // Segment besteht nur aus einer B-Kante 
           }

        h = atblock.length(); // Anzahl der Eintraege im Blockstack
        // teste, ob Graph noch bipartit, dist liefert Anzahl der zu
        // verschraenkenden Bloecke

        if((dist=bipartite_test(atblock,A,h+1,segment,cur_nr)) == -1 )
         {  A.clear();
            return A; 
         }
     /* aktualisiere die Liste der Bloecke, evtl. werden Bloecke mit
        der Liste A zu einem neuen Block verschmolzen */
        update_block_stack(atblock, h, dist, A);
        h = atblock.length(); // Anzahl der Eintraege im Blockstack
        upd_block_ctr(segment[cur_nr], h);
        add_edge(segment[cur_nr],start_nr,h,seg_start);
       }
      }
    /* alle wj verlassenden Kanten sind betrachtet, entferne nun
       alle Befestigungen parent( wj ) */
    remove_node_below(j,sp_start, wr, atblock,segment[cur_nr]);
   }

   /* teste, ob S(e) stark planar */
  if( ! strongly_planar(atblock, w0, A,segment,cur_nr))
           A.clear();

null_block(segment[cur_nr],1);
// forall(k,A)
  // printf("%d ",k);

  return A;  // liefere Liste der Attachments ab

}








int edge_cost(int vnum, int wnum, int l1, int l2)
{
  if( wnum < vnum )
     return 2*wnum;
  else if ( l2 >= vnum)
        return 2*l1;
       else return (2*l1 + 1);
}

void bucket_s ( graph& G, 
                const node_array<int>& Dfsnr,
                const node_array<int>& low1, 
                const node_array<int>& low2)
{
 node v,w;
 edge e;
 edge_array<int> cost(G);

 forall_edges(e,G)
 { v = source(e);
   w = target(e);
   cost[e] = edge_cost(Dfsnr[v],Dfsnr[w],low1[w],low2[w]);
  }

  G.sort_edges(cost);
    
}







void low(list<edge>& DEL, node v, node prep,
         int& cur_nr, node_array<int>& reached,node_array<int>& Dfsnr,
         node_array<int>& low1, node_array<int>& low2, node_array<int>& father)
{
node w;
edge e;
int tcan1, tcan2, bcan1, bcan2, vnum;

  Dfsnr[v] = ++ cur_nr;
  tcan1 = tcan2 = bcan1 = bcan2 = vnum = Dfsnr[v];
  reached[v] = true;
  forall_adj_edges(e,v)
    {
     w = target(e);
     if( !reached[w] )
      {
       father[w] = vnum;
       low(DEL,w,v,cur_nr,reached,Dfsnr,low1,low2,father);
       if( low1[w] < tcan1 )
        {
         tcan2 = tcan1;
         tcan1 = low1[w];
        }
       else if( low1[w] < tcan2 )
              tcan2 = low1[w];
      }
     else if(( Dfsnr[w] >= Dfsnr[v])  || w == prep ) 
               DEL.append(e) ; 
          else if( Dfsnr[w] < bcan1 )
                 { bcan2=bcan1;
                   bcan1 = Dfsnr[w];
                 }
               else if( Dfsnr[w] < bcan2)
                     bcan2 = Dfsnr[w];
     }


  low1[v] = Min(tcan1,bcan1);
  if( tcan1 == bcan1)
      low2[v] = Min(tcan2,bcan2);
  else if ( tcan1 < bcan1)
         low2[v] = Min(bcan1,tcan2);
       else low2[v] = Min(tcan1,bcan2);

  if( vnum > 2 && low1[v] == father[v] )
      error_handler(1,"PLANAR: graph is not biconnected");


}


void lowstart(graph& G,node_array<int>& Dfsnr,node_array<int>& low1,
          node_array<int>& low2)
{
node v;
node_array<int> reached(G,false);
int cur_nr = 0;
list<edge> DEL;
node_array<int> father(G);
edge e;

G.reset(); 
forall_nodes(v,G)
  {
    if( !reached[v] )
      low(DEL,v,v,cur_nr,reached,Dfsnr,low1,low2,father);
  }
G.reset();
    forall(e,DEL)
    { 
        G.del_edge(e);
    }
}


void dfs( node v, 
         int& cur_nr, node_array<int>& reached,node_array<int>& Dfsnr)
{
node w;
edge e;

  Dfsnr[v] = ++ cur_nr;
  reached[v] = true;
  forall_adj_edges(e,v)
   {
     w = target(e);
     if( !reached[w] )
       dfs(w,cur_nr,reached,Dfsnr);
   }
}

void dfsstart(graph& G,node_array<int>& Dfsnr)
{
node v;
node_array<int> reached(G,false);
int cur_nr = 0;

G.reset(); 
forall_nodes(v,G)
    if( !reached[v] )
      dfs(v,cur_nr,reached,Dfsnr);
G.reset();
}


/* cycl_embedding() berechnet die zykl. Adjazenzlisten des Eingabegraphen
   Or ( Original ). Alle Ad.listen stehen in der Kantenliste cyc_lst.
   Die Kopie des Eingabegraphen Cp enthaelt die wie sie fuer den
   Planaritaetstest benoetigt wird 
*/

void cycl_embedding(list<edge>& cyc_lst, graph& Or, graph& Cp, 
                    node* Or_ord, node* Cp_ord,
                    node_array<int>& Or_dfs, node_array<int>& Cp_dfs,
                    edge_array<int>& alpha, edge e, edge& grenze)
{
node v, w, spine_node,att;
edge x, y,seg_start, Lcur, Rcur;
list<edge> Cp_List, E_List;
list_item i, anf, end;
int j, k, wr, w0, sp_start, sp_end;
char pos;

wr = Cp_dfs[source(e)];

sp_start = Cp_dfs[target(e)];
pos = alpha[e];
spine_node = target(e);

if( wr < sp_start )  // suche Spine in Kopie
{
  forall_adj_edges(e,spine_node)
     if( Cp_dfs[target(e)] > Cp_dfs[spine_node] ) // e ist T-Kante 
        spine_node = target(e);
     else break;
}  

  sp_end = Cp_dfs[source(e)]; // e ist die Basiskante von S(e)
  w0 = Cp_dfs[target(e)];     // w0 ist die Basisbefestigung am Stamm

// printf("cyc: wr %d sp_st %d sp_end %d w0 %d pos %c\n",wr,sp_start,sp_end,w0,pos);
  E_List = Or.adj_edges(Or_ord[wr]);
  forall(x, E_List)
     if( Or_dfs[target( x )] == sp_start) // suche (wr,sp_start) in Original
     break;

  if( wr == 1)  // cyc_lst ist leer
    anf = end = cyc_lst.push(x);
 else 
   forall_list_items(i,cyc_lst) // suche 1.Kante in cyc_lst mit source = wr
        if( Or_dfs[source(cyc_lst[i])] == wr)
          {   anf = end = i; // merke Kante in anf 
              break; 
          }

 att = Cp_ord[w0];  // merke Befestigungsknoten
 if( wr < sp_start && wr > 1)
   {
    if( pos == 'L')  // (wr,sp_start) wird in cyc_lst eingefuegt
        cyc_lst.insert(x,anf,after);
    else
     {
      i = anf;
      for( ; i!=nil  && Or_dfs[source(cyc_lst[i])] == wr; )
           i = cyc_lst.succ(i);

      if( i != nil )
         cyc_lst.insert(x,i,before);
      else cyc_lst.append(x);
     }

   }

 if( wr < sp_start )
  for(j= sp_start; j < sp_end; j++) // alle T-Knoten sp_start.. sp_end
    {
     if( j == sp_start )
         w = Or_ord[wr];
     else w = Or_ord[j-1];

     E_List = Or.adj_edges(Or_ord[j]);
     forall_list_items(i,E_List)
        if( Or_dfs[target(E_List[i])] == Or_dfs[w])
           break;
       
     cyc_lst.append(E_List[i]); // anhaengen von (wj, wj-1)
     w = Or_ord[j+1];
     forall_list_items(i,E_List)
       if( Or_dfs[target(E_List[i])] == Or_dfs[w])
          break;

     cyc_lst.append(E_List[i]);

    }

  if( wr < sp_start )
    {
     E_List = Or.adj_edges( Or_ord[sp_end] );
     if(sp_end == sp_start)
       w = Or_ord[wr];
     else
       w = Or_ord[sp_end -1];
     forall(x,E_List)    // suche (sp_end, sp_end-1)
       if( Or_dfs[target(x)] == Or_dfs[w])
         break;
      
     end = cyc_lst.append(x); // anhaengen von (sp_end,sp_end-1)

     w = Or_ord[w0];
     E_List = Or.adj_edges( Or_ord[sp_end] );
     forall(x,E_List)
        if( Or_dfs[target(x)] == Or_dfs[w])
          break;
    }

  if( pos == 'L' )  // einfuegen von (sp_end, w0)
     cyc_lst.insert(x,end,after);
  else
  {
   i = end;
   for(; i != nil && Or_dfs[source(cyc_lst[i])] == sp_end; )
          i = cyc_lst.succ(i); 
      
   if( i != nil)
      cyc_lst.insert(x,i,before);
   else cyc_lst.append(x);
  }


 w = Or_ord[sp_end];
 E_List = Or.adj_edges(Or_ord[w0]);
 forall(x,E_List)  // suche (w0, sp_end)
  if(Or_dfs[target(x)] == Or_dfs[w])
    break;

 if( w0 != Or_dfs[source(grenze) ])
  {
   if( wr == 1 )
     k = 2;
   else
    {
     Cp_List = Cp.adj_edges( att ); // suche in Kopie die Aktivkante (w0,w1) des Stamms
     k = Cp_dfs[att];
     forall(y, Cp_List)
        if( (j=Cp_dfs[target(y)]) > k && j <= wr )
            k = j;
    }
   
    forall_list_items(i,cyc_lst) // suche "gleiche" Kante auch in Or
       {
         y = cyc_lst[i];
         if( Or_dfs[source(y)] == w0 && Or_dfs[target(y)] == k )
            break;
       }

  
  if( pos == 'L' )  // einfuegen von (w0, sp_end) vor/nach Aktivkante
     cyc_lst.insert(x,i,before);
  else
     cyc_lst.insert(x,i,after);

   }


 else { 
      i = cyc_lst.search(grenze);
      if(pos == 'L') // einfuegen von (w0,sp_end) vor/nach grenze
        cyc_lst.insert(x,i,after);
      else cyc_lst.insert(x,i,before);
      }

 Lcur = Rcur = x; // merke (w0,sp_end)


  if( wr < sp_start) // rek. Durchmusterung analog zum Test
         for(j = sp_end; j >= sp_start; j--)
          {
            v = Cp_ord[j];
            k = 1;
            forall_adj_edges(seg_start,v) // betrachte Kanten aus Cp !!
              if( k++ > 1)
               {
                 if( alpha[seg_start] == 'L' ) 
                  cycl_embedding(cyc_lst,Or,Cp,Or_ord,Cp_ord,Or_dfs,Cp_dfs,alpha,seg_start,Lcur);
                 else
                   cycl_embedding(cyc_lst,Or,Cp,Or_ord,Cp_ord,Or_dfs,Cp_dfs,alpha,seg_start,Rcur);
               }
           }

      // aktualisiere Grenzkante, falls erforderlich
         if( pos == 'R' && Or_dfs[source(Rcur)] <= Or_dfs[source(grenze)] )
                 grenze = Rcur;
         else
             if( pos == 'L' && Or_dfs[source(Lcur)] <= Or_dfs[source(grenze)] )
                 grenze = Lcur;


}   

/*
  Planar(G) testet den Graphen G auf Planaritaet und berechnet
  die kombinatorische Einbettung von G. Der Graph enthaelt am Ende
  die zyklischen
  Adjazenzlisten zu allen Knoten.
  Eingabe G : gerichtete Version eines zweifach  zusammenhaengenden
              ungerichteten Graphen.
  
  Planar() liefert true, falls G planar, sonst false
*/



int PLANAR(graph& Or )
{
int N;
int i, ed, n=0, seg_num = 0;
char basis;
node v, w;
edge e, grenze;
ed_inf x;

list<edge> cyc_lst;
list<int> A;
list_item t;


//insert reverse edges, if not present

list<edge> RE = Or.insert_reverse_edges();

eliminate_parallel_edges(Or);  //not ok, should eliminate only edges from RE


graph G = Or;  // teste Planaritaet auf einer Kopie der Eingabe

edge_array<edge> Rev(G);

node_array<int> Or_dfs(Or), 
                Dfsnr(G),
                low1(G),
                low2(G);

if(! compute_correspondence(G, Rev) )
 error_handler(1,"PLANAR: graph must be directed version of undirected graph");

lowstart(G,Dfsnr,low1,low2); // berechne low1 und low2 aller Knoten

N = G.number_of_nodes();
ed = G.number_of_edges();
// printf("n: %d, e: %d\n",n,ed);


if( ed  > 3*N - 6 ) return false;

G.reset();
bucket_s(G,Dfsnr,low1,low2);  // sortiere Kanten nach ihren low-Werten


dfsstart(G,Dfsnr);  // dfs auf umgeordneten Ad.listen
G.reset();


list<ed_inf>* segment = new list<ed_inf>[2*N];


node*  Graph_order = new node[N+1];
edge_array<int> alpha(G);

forall_nodes(w,G)
  Graph_order[Dfsnr[w]] = w;

G.reset();
v = Graph_order[1];
e = G.first_adj_edge( v );


// starte Test mit Kante (1,2)

A = plantest(Graph_order, Dfsnr, e, segment, seg_num);

if( A.empty()) 
{ for(i=0; i<2*N; i++) segment[i].clear();
  delete segment; 
  delete Graph_order;
  return false;
}


// eintragen der Segmentplazierung in Kantenfeld alpha. alpha[e] ist L oder R

for(i=0; i <= seg_num ; i++)
    {
      x = segment[i].head();
      basis = x->plaz;
      forall(x, segment[i])
         {
           e = x->e;
          if( basis == 'L' )
             {
              if ( x->plaz == 'L' || x->plaz == '=')
                  alpha[e] = 'L';
              else if( x->plaz == '!')
                  alpha[e] = 'R';
             }
           else
               if(x->plaz == 'R' || x->plaz == '=')
                        alpha[e] = 'R';
               else alpha[e] = 'L';
         }
     } 
 
list<node> G_Lst, Or_Lst;


n = Or.number_of_nodes();
node* Or_ord = new node[n+1];

G_Lst = G.all_nodes();
Or_Lst = Or.all_nodes();
list_item topn = Or_Lst.first();

forall_list_items(t, G_Lst)
{ 
  Or_dfs[Or_Lst[topn]] = Dfsnr[G_Lst[t]];
  topn = Or_Lst.succ(topn);
}

forall_nodes(w,Or)
     Or_ord[Or_dfs[w]] = w;

 
v = Or_ord[2];
grenze = Or.first_adj_edge(v); // init. Grenzkante mit grenze = (2,x)
 
e = G.first_adj_edge(Graph_order[1]);
alpha[e] = 'L'; // Plaz. des Basissegments

// berechne komb. Einbettung von G. Ergebnis steht in cyc_lst

cycl_embedding(cyc_lst,Or,G,Or_ord,Graph_order,Or_dfs,Dfsnr,alpha,e,grenze);

edge_array<int> ord_in_cycl_emb(Or);


n = 0;
forall(e,cyc_lst) ord_in_cycl_emb[e] = n++;

// Umordnen der Ad.listen des Eingabegraphen
Or.sort_edges(ord_in_cycl_emb);

for (i=0; i<2*N; i++) segment[i].clear();
delete segment; 
delete Graph_order;
delete Or_ord;

return true;

}
