/*******************************************************************************
+
+  LEDA  3.0
+
+
+  _basic.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#include <LEDA/basic.h>

#include <time.h>
#include <string.h>
#include <sys/types.h>


#if defined(__GNUG__)
#include <std.h>
#endif


#if defined(__MSDOS__)
#include <dos.h>

#else
#include <sys/times.h>

#if __GNUG__ == 1
#define HZ 60
#else
#include <sys/param.h>
#endif

#endif


LEDA::LEDA()
{ init_list = getenv("LEDA_INIT");
  init_random();
 }


LEDA::~LEDA() 
{ 
  if (init_list && strcmp(init_list,"statistics")==0)
  { if (version_string) printf("\n%s\n",version_string);
    printf("\n");
    print_statistics(); 
   }
 } 


LEDA L_E_D_A;



//------------------------------------------------------------------------------
// Error Handling
//------------------------------------------------------------------------------


PEH p_error_handler = default_error_handler;

void default_error_handler(int i, char* s)
{ if (i==0) 
   cout << "(warning) " << s << "\n";
  else 
   { cout << "ERROR "<< s << "\n";
     cout.flush();
     abort();
    }
}

PEH set_error_handler(PEH handler)
{ PEH old = error_handler;
  p_error_handler = handler;
  return old;
}

//------------------------------------------------------------------------------
// useful functions
//------------------------------------------------------------------------------

int interrupt_handler()
{ string cmd;

  cout << "\n INTERRUPT \n";

  for(;;) 
  { newline;
    cmd=read_string("m(emory) / t(ime) / !(cmd) / c(ontinue) / i(nterrupt): ");
    switch(cmd[0]) 
     { case 'c': { cout << "execution continued\n";
                   return(0);
                  }
       case 'i': { cout << "execution terminated\n";
                   exit(1);
                  }
       case 'm': { print_statistics(); 
                   newline;
                   break;
                  }
       case 't': { newline;
                   print_time();
                   break;
                  }
       case '!': { cmd[0] = ' ';
                   system(cmd.cstring());
                   newline;
                   break;
                  }
      }
    }
}


void init_random(int seed)
{ long l = seed;
  if (l==0) time(&l);
  srandom(int(l));
 }


#if defined(__MSDOS__) 

#if defined(__GNUG__)
static long clock()
{ union REGS regs;
  regs.h.ah=0x00;
  int86(0x1A,&regs,&regs);
  return (regs.x.cx << 16) + regs.x.dx;
}
#define CLK_TCK  18.2
#endif
 
float used_time() { return  float(clock())/CLK_TCK; }

#else

float used_time()
{ tms x;
  times(&x);
  return  float(x.tms_utime)/HZ;
}

#endif


float used_time(float& T)
{ float t = T;
  T =  used_time();
  return  T-t;
}


void print_time(string s)
{ cout << s;
  cout << string("  time= %.2f sec",used_time());
  newline;
}


void wait(unsigned int sec) { sleep(sec); }
  

//------------------------------------------------------------------------------
// Input/Ouput
//------------------------------------------------------------------------------


int Yes(string s)
{ char answer = read_char(s);
  return ((answer == 'y') || (answer == 'Y'));
}

int read_int(string s)
{ int answer;
  char c;
  int success = 0;
  while (!success)
  { cout << s;
    cin >> answer;
    if (!cin) { cin.clear();
                cin.get(c);
                cout << string("read_int: illegal input \"%c\"\n",c);
                while (c!='\n') cin.get(c); //skip rest of line
               }
    else  success=1;
   }
  cin.get(c);   // eat '\n'

  return answer;
}

char read_char(string s)
{ char c;
  cout << s;
  cin.get(c);
  if (c!='\n') read_line(cin);
  return c;
}

double read_real(string s)
{ double answer;
  cout << s;
  cin >> answer;
  read_line(cin);
  return answer;
}

char*  read_line(istream& s)
{ char buf[256];
  char* p = buf;

  while (s.get(*p))
  { if (*p == '\n') break;
    p++;
   } 
  *p = '\0';
  return ~string(buf);
}

char*  read_string(string s)
{ cout << s;
  return read_line(cin); 
 }

int     Yes()              { return Yes(""); }
int     read_int()         { return read_int(""); }
char    read_char()        { return read_char(""); }
double  read_real()        { return read_real(""); }
char*   read_string()      { return read_string(""); } 
char*   read_line()        { return read_line(cin); }


#if !defined(__GNUG__) && defined(sparc)

/* save_sparc_registers(): save sparc registers on the stack */

asm (".global _save_sparc_registers");
asm ("_save_sparc_registers:");
asm ("st %i0,[%fp+68]");
asm ("st %i1,[%fp+72]");
asm ("st %i2,[%fp+76]");
asm ("st %i3,[%fp+80]");
asm ("st %i4,[%fp+84]");
asm ("retl");
asm ("st %i5,[%fp+88]");

#endif

