/*******************************************************************************
+
+  LEDA  3.0
+
+
+  real.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef LEDA_REAL_H
#define LEDA_REAL_H

#include <LEDA/basic.h>


struct rrep : handle_rep{ 

      double  d;     

  rrep(double x=0)  { d = x; }
 ~rrep()            {}

  LEDA_MEMORY(rrep)

};


class real   : public handle_base 
{

rrep*  ptr() const { return (rrep*)PTR; }

public:

 real()               { PTR = new rrep; }
 real(const double d) { PTR = new rrep(d); }
 real(const real& r)  : handle_base(r) {}

~real()              { clear(); }

 real& operator=(const real& x) { handle_base::operator=(x); return *this; }


double operator~() const { return ptr()->d; }

double* dp()       { return &(ptr()->d); }

int round()        const { return (ptr()->d>0) ? int(ptr()->d+0.5) : int(ptr()->d-0.5); }
int trunc()        const { return int(ptr()->d); }

operator double() const { return ptr()->d; }  

real  operator-() const { return -(ptr()->d); }


real& operator+=(const real& r)  { *this = ptr()->d + r.ptr()->d; return *this ; }
real& operator+=(double d)       { *this = ptr()->d + d;      return *this ; }

real& operator-=(const real& r)  { *this = ptr()->d - r.ptr()->d; return *this ; }
real& operator-=(double d)       { *this = ptr()->d - d;      return *this ; }

real& operator*=(const real& r)  { *this = ptr()->d * r.ptr()->d; return *this ; }
real& operator*=(double d)       { *this = ptr()->d * d;      return *this ; }

real& operator/=(const real& r)  { *this = ptr()->d / r.ptr()->d; return *this ; }
real& operator/=(double d)       { *this = ptr()->d / d;      return *this ; }


friend istream& operator>>(istream&, real&);
friend ostream& operator<<(ostream&, const real&);

friend int  compare(const real&, const real&); 

};


inline istream& operator>>(istream& s, real& r) 
{ double d; s >> d; r = d; return s;}

inline ostream& operator<<(ostream& s, const real& r) 
{ return s << r.ptr()->d; }

inline void Print(const real& x, ostream& out=cout) { out << x; }
inline void Read(real& x, istream& in=cin)          { in  >> x; }

inline int  compare(const real& x, const real& y) 
{ return compare(x.ptr()->d,y.ptr()->d); }

LEDA_HANDLE_TYPE(real)


#endif
