/*****************************************************************************
*   Default object drawing routine common to graphics drivers.		     *
*									     *
* Written by:  Gershon Elber				Ver 0.1, June 1993.  *
*****************************************************************************/

#include "irit_sm.h"
#include "iritprsr.h"
#include "cagd_lib.h"
#include "symb_lib.h"
#include "iritgrap.h"
#include "attribut.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Draw a single object using current modes and transformations.		     M
*                                                                            *
* PARAMETERS:                                                                M
*   PObj:      Object to draw.                                               M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   IGDrawObject                                                             M
*****************************************************************************/
void IGDrawObject(IPObjectStruct *PObj)
{
    CagdRType *R;
    PointType Pt;
    int Width;

    IGSetColorObj(PObj);
    if ((Width = AttrGetObjectIntAttrib(PObj, "DWidth")) != IP_ATTR_BAD_INT)
	IGSetWidthObj(Width * IGGlblLineWidth);
    else
	IGSetWidthObj(IGGlblLineWidth);

    switch (PObj -> ObjType) {
	case IP_OBJ_POLY:
	    IGDrawPoly(PObj);
	    break;
	case IP_OBJ_CTLPT:
	    /* Coerce, in place, a control points to a regular point. */
	    R = PObj -> U.CtlPt.Coords;
	    CagdCoercePointTo(Pt, CAGD_PT_E3_TYPE,
			      &R, -1, PObj -> U.CtlPt.PtType);
	    PT_COPY(PObj -> U.Pt, Pt);
	    PObj -> ObjType = IP_OBJ_POINT;
	case IP_OBJ_POINT:
	    IGDrawPtVec(PObj);
	    break;
	case IP_OBJ_VECTOR:
	    IGDrawPtVec(PObj);
	    break;
	case IP_OBJ_CURVE:
	    IGDrawCurve(PObj);
	    break;
	case IP_OBJ_SURFACE:
	    IGDrawSurface(PObj);
	    break;
	case IP_OBJ_TRIMSRF:
	    IGDrawTrimSrf(PObj);
	    break;
	case IP_OBJ_TRIVAR:
	    IGDrawTrivar(PObj);
	    break;
	case IP_OBJ_LIST_OBJ:
	    IritFatalError("Should not have lists at this time");
	    break;
	default:
	    break;
    }
}
