'\"et
.if t .TH IMX 3IM "August 25, 1992" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY"
.if n .TH IMX 3IM "August 25, 1992" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
imx \- AVS X file translation
.SH SYNOPSIS
.nf
\fB
#include <stdio.h>
#include "sdsc.h"
#include "im.h"
.sp 1
int ImFileRead( fd, "x", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFRead( fp, "x", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileWrite( fd, "x", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFWrite( fp, "x", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
\fR
.fi
.SH DESCRIPTION
\fBx\fR image files are generated by Stardent Computer, Inc.'s Application
Visualization System (AVS).
See the AVS documentation set for details on how to use these tools.
.SH "FILE RECOGNITION"
AVS \fBx\fR files are recognized by the following filename
suffixes:  .x and .avs.
.SH NOTES
SDSC image library support of the AVS \fBx\fR format does not require
use of any AVS tools or Stardent hardware and
contains no proprietary code.  AVS \fBx\fR format handling
is available on any machine for which the SDSC image library is available.
.SS "Reading AVS X files"
The SDSC image library reads uncompressed,
noninterlaced, 32-bit RGB-Alpha AVS \fBx\fR files and maps them to
\fB(IMVFBRGB | IMVFBALPHA)\fR
VFBs without color lookup tables (CLTs).
.SS "Writing AVS X files"
Image library \fBIMVFBRGB\fR and \fB(IMVFBRGB | IMVFBALPHA)\fR
VFBs are written to
uncompressed, noninterlaced, 32-bit RGB-Alpha AVS \fBx\fR files.
The AVS \fBx\fR format does not support scanline- and plane-interlaced
modes.  
.LP
Other image library VFB types are converted to \fBIMVFBRGB\fR VFBs prior
to being written out.  See the \fBImFileWrite\fR (3IM) \fBman\fP 
page for details.
.SH ERRORS
In addition to those listed for \fBImFileRead\fR (3IM),
AVS \fBx\fR file reading returns the following error codes: 
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory
IMESYS	System call error in read operation
.TE
.if t .in -0.5i
.if n .in -5
.LP
In addition to those listed for \fBImFileWrite\fR (3IM),
AVS \fBx\fR file writing returns the following error codes: 
.ne 2
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory
IMESYS	System call error in write operation
.TE
.if t .in -0.5i
.if n .in -5
.SH DOCUMENTATION
\fIAVS User's Guide\fR, Appendix E, p. E-3, Stardent Computer Inc.
.SH SEE ALSO
\fBImIntro\fR(3IM),
\fBImErrNo\fR(3IM),
\fBimconv\fR(1IM),
\fBimfile\fR(1IM),
\fBimformats\fR(1IM)
.SH AUTHOR
Dave Nadeau
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
