'\"t
.if t .TH IMRLA 3IM "August 24, 1992" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY"
.if n .TH IMRLA 3IM "August 24, 1992" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
imrla \- Wavefront RLA and RLB file translation
.SH SYNOPSIS
.nf
\fB
#include <stdio.h>
#include "sdsc.h"
#include "im.h"
.sp 1
int ImFileRead( fd, "rla", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFRead( fp, "rla", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileWrite( fd, "rla", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFWrite( fp, "rla", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
\fR
.fi
.SH DESCRIPTION
.LP
\fBrla\fR image files are generated by Wavefront Technologies, Inc.,
software such as \fBimage\fR and \fBtdv\fR.
See the Wavefront documentation for information on how to use these 
and other Wavefront programs.
.LP
\fBrla\fR is a subset of the newer Wavefront \fBrlb\fR specification.  Programs
that can read and write \fBrlb\fR files can also read and write \fBrla\fR files.
The SDSC image library reader/writer is written to accommodate both
types of files.
.SH "FILE RECOGNITION"
Wavefront \fBrla\fR files are recognized by the following
filename suffixes:  .rla and .rlb.
.SH NOTES
SDSC image library support of the Wavefront \fBrla\fR format does not require
use of any Wavefront tools and contains no proprietary code.  
Wavefront \fBrla\fR
is available on any machine for which the SDSC image library is available.
.SS "Reading Wavefront RLA files"
The SDSC image library reads runlength-encoded (RLE),
scanline-interlaced, 24-bit RGB and 32-bit RGB-Alpha Wavefront files 
and maps them to \fBIMVFBRGB\fR and \fB(IMVFBRGB | IMVFBALPHA)\fR VFBs without 
color lookup tables (CLTs).
.SS "Writing Wavefront RLA files"
Image library \fBIMVFBRGB\fR VFBs with or without alpha planes
are written to runlength-encoded,
scanline-interlaced, 32-bit RGB-Alpha Wavefront \fBrla\fR files.
If the incoming VFB does not have an alpha plane, outgoing image file
alpha values are all set to 255.
Noninterlaced and plane-interlaced modes are not
supported by Wavefront \fBrla\fR files.
.LP
Other image library VFB types are converted to \fB(IMVFBRGB | IMVFBALPHA)\fR
prior to being written out.  See the \fBImFileWrite\fR(3IM) \fBman\fP
page for details.
.LP
Note that the Wavefront \fBrla\fR specification requires the presence of
an alpha channel in an \fBrla\fR image file, yet at least one of the
Wavefront programs does not include alpha channels in the images that
it writes to files.
.SH ERRORS
In addition to those listed for \fBImFileRead\fR(3IM),
Wavefront \fBrla\fR file reading returns the following error codes:
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory
IMESYNTAX	Syntax error
IMESYS	System call error in read operation
.TE
.if t .in -0.5i
.if n .in -5
.LP
In addition to those listed for \fBImFileWrite\fR(3IM),
Wavefront \fBrla\fR file writing returns the following error codes:
.ne 2
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory
IMESYS	System call error in write operation
.TE
.if t .in -0.5i
.if n .in -5
.SH DOCUMENTATION
\fIWavefront RLA Specification\fR, Wavefront Technologies, Inc.
.SH "SEE ALSO"
\fBImIntro\fR(3IM),
\fBImErrNo\fR(3IM),
\fBimconv\fR(1IM),
\fBimfile\fR(1IM),
\fBimformats\fR(1IM)
.SH AUTHOR
T. Todd Elvins
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
