.if t .TH IMPICT 3IM "September 25, 1991" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY"
.if n .TH IMPICT 3IM "September 25, 1991" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
impict \- SDSC Apple Macintosh PICT translation
.SH SYNOPSIS
.nf
\fB
#include <stdio.h>
#include "sdsc.h"
#include "im.h"
.sp 1
int ImFileRead( fd, "pict", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFRead( fp, "pict", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileWrite( fd, "pict", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFWrite( fp, "pict", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;\fR
.fi
.SH DESCRIPTION
.LP
The \fBPICT\fR file is the standard Apple Macintosh image file format.
It can be read by almost any Macintosh graphics application.  
Most Macintosh applications that can export graphics do so
in the \fBPICT\fR file format.
.SH "FILE RECOGNITION"
\fBpict\fR
files are recognized by these filename suffixes: .pict and .pict2.
.SH NOTES
SDSC image library support of the Apple \fBpict\fR format does not
require use of Apple tools or hardware and contains no proprietary
code.  Apple \fBpict\fR format handling is available on any machine
for which the SDSC image library is available.  
.SS "Reading Apple PICT files"
The SDSC image library reads 1-, 2-, 4-, 8-, and 16-bit color index images,
with or without a CLT, compressed using Apple's PackBits, and maps them
into \fBIMVFBRGB\fR VFBs.
.LP
Note that all \fBpict\fR images are read into \fBIMVFBRGB\fR VFBs.
This is necessary because of a \fBpict\fR feature that allows each
piece of an image to have its own CLT.  This can easily exceed any
reasonable size color index image CLT very quickly.  To avoid this,
incoming image pieces in a \fBpict\fR file are always converted and
stored into an RGB VFB. 
.LP
Both type 1 (monochrome and "old" color) and type 2 (full color)
\fBpict\fR files are handled.
.SS "Writing Apple PICT files"
SDSC image library \fBIMVFBINDEX8\fR VFBs are written out to Apple \fBpict\fR
files as 8-bit color index images with a CLT and compressed using Apple's
PackBits compression.  Written images are always type 2 \fBpict\fR files.
.SH ERRORS
In addition to those listed for \fBImFileRead\fR(3IM),
Apple \fBpict\fR file reading returns the following error codes:
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory
IMESYNTAX	Syntax error
IMESYS	System call error in read operation
IMEUNSUPPORTED	Unsupported opcode
.TE
.if t .in -0.5i
.if n .in -5
.LP
In addition to those listed for \fBImFileWrite\fR(3IM),
Apple \fBpict\fR file writing returns the following error codes:
.ne 2
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory
IMESYS	System call error in write operation
.TE
.if t .in -0.5i
.if n .in -5
.SH DOCUMENTATION
\fIInside Macintosh, Volumes I-V\fR, Apple Computer, Inc.
.SH "SEE ALSO"
\fBimconv\fR(1IM),
\fBimfile\fR(1IM),
\fBimformats\fR(1IM),
\fBimmpnt\fR(3IM)
.SH AUTHOR
John Moreland
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
