'\"et
.if t .TH IMPIX 3IM "September 25, 1991" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY"
.if n .TH IMPIX 3IM "September 25, 1991" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
impix \- SDSC Alias PIX file translation
.SH SYNOPSIS
.nf
\fB
#include <stdio.h>
#include "sdsc.h"
#include "im.h"
.sp 1
int ImFileRead( fd, "pix", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFRead( fp, "pix", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileWrite( fd, "pix", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFWrite( fp, "pix", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
\fR
.fi
.SH DESCRIPTION
\fBpix\fR image files are generated by the rendering and painting
tools of Alias Research, Inc., such as \fBrenderer\fR,
\fBraytracer\fR, and \fBpaint\fR.  See the Alias documentation set for
details on how to use these tools. 
.LP
\fINote:\fR  
Alias \fBquickpaint\fR, available on Silicon Graphics, Inc., IRIS
workstations, uses Silicon Graphic's \fBrgb\fR image file format rather
than the Alias \fBpix\fR image file format.  See the \fBimrgb\fR(3IM)
\fBman\fP page for details on the \fBrgb\fR format. 
.SH "FILE RECOGNITION"
Alias \fBpix\fR files are recognized by these following filename 
suffixes: .alias and .pix.
.SH NOTES
SDSC image library support of the Alias \fBpix\fR format does not require
use of Alias tools and contains no proprietary code.  Alias \fBpix\fR
format handling
is available on any machine for which the SDSC image library is available.
.SS "Reading Alias PIX files"
The SDSC image library reads run-length-encoded (RLE),
noninterlaced, 24-bit RGB Alias \fBpix\fR files 
and maps them to \fBIMVFBRGB\fR VFBs without
color lookup tables (CLTs).
.SS "Writing Alias PIX files"
Image library \fBIMVFBRGB\fR VFBs are written to 
run-length-encoded, noninterlaced, 24-bit RGB Alias \fBpix\fR files.
Scanline- and plane-interlaced modes are not
supported by Alias \fBpix\fR files.
.LP
Other image library VFB types are converted to \fBIMVFBRGB\fR VFBs prior
to being written out.  See the \fBImFileWrite\fR(3IM) \fBman\fP page for
details.
.SH ERRORS
In addition to those listed for \fBImFileRead\fR(3IM),
Alias \fBpix\fR file reading returns the following error codes: 
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory
IMESYS	System call error in read operation
.TE
.if t .in -0.5i
.if n .in -5
.LP
In addition to those listed for \fBImFileWrite\fR(3IM),
Alias \fBpix\fR file writing returns the following error codes: 
.ne 2
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory
IMESYS	System call error in write operation
.TE
.if t .in -0.5i
.if n .in -5
.SH DOCUMENTATION
\fIAlias Reference Manual\fR, Alias Research, Inc.
.SH SEE ALSO
\fBimconv\fR(1IM), \fBimfile\fR(1IM), \fBimformats\fR(1IM)
.SH AUTHOR
Dave Nadeau
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
