/* write.c
 * Routines for writing out files of various types 
 * 
 * Peter Webb, Summer 1990
 */

/* Standard include files */

#include <stdio.h>

/* Package include files */

#include "reformat.h"
#include "types.h"
#include "extern.h"
#include "error.h"

/* HDF File format */

#include "df.h"

/* Write out an HDF file */

ErrorCode WriteHDF(info)
  FileInfo *info;
{
/* Set the palette */

  DFR8setpalette(info->palette);

/* Write out the image */

  DFR8putimage(info->name, info->image, info->rows, info->cols, DFTAG_RLE);

/* All done */

  return(AllOk);
}

/* Write out a FITS file */

ErrorCode WriteFITS(info)
  FileInfo *info;
{
  return(NotSupported);
}

/* Write out a GIF file */

ErrorCode WriteGIF(info)
  FileInfo *info;
{
  return(NotSupported);
}

/* Write out an XWD file */

ErrorCode WriteXWD(info)
  FileInfo *info;
{
  return(NotSupported);
}

/* Write out a TIFF file */

ErrorCode WriteTIFF(info)
  FileInfo *info;
{
  return(NotSupported);
}

