/* utils.c
 * Assorted utilities for the file conversion package.  
 *
 * Peter Webb, Summer 1990
 */

#include <stdio.h>

/* Package include files */

#include "reformat.h"
#include "types.h"
#include "error.h"
#include "extern.h"

static int file_suffix = 0;
static char t_file[FILE_SIZE];

/* Make a new temporary file name.  Result only valid until the routine is
 * called again (static space).
 */

char *NewTempFile()
{
  sprintf(t_file, "rfmt_%d.%d", getpid(), file_suffix++);
  return(t_file);
}

/* Allocate and initialize a CvtBlkPtr structure */

CvtBlkPtr NewCvtBlk()
{
  CvtBlkPtr new;

  new = (CvtBlkPtr) malloc(sizeof(CvtBlk));
  if (new == NULL) return(NULL);
  NEXT_BLK(new) = NULL;
  FROM_FILE(new) = NULL;
  TO_FILE(new) = NULL;
  FROM_TYPE(new) = none;
  TO_TYPE(new) = none;
  
  return(new);
}

/* Print out the contents of a FileInfo structure */

void PrintFileInfoStruct(info)
     FileInfo *info;
{
  printf("Info record\n");
  printf(" Name = %s\n", info->name);
  printf(" Dimension = %d\n", info->dimension);
  printf(" Height = %d\n", info->height);
  printf(" Width = %d\n", info->width);
  printf(" Image ptr = %d\n", info->image);
  printf(" Value bitmask = %d\n", info->values);
}

/* Allocate and initialize a StrList structure */

StrListPtr NewStrListElt(str)
  char *str;
{
  StrListPtr new;

  new = (StrListPtr) malloc(sizeof(StrList));
  if (new == NULL) return(NULL);
  if (str != NULL)
    LIST_STR(new) = strsave(str);
  else LIST_STR(new) = NULL;
  NEXT_STR(new) = NULL;
  
  return(new);
}

/* Print an informational message */

void InfoMsg(str)
     char *str;
{
#ifdef XGUI
  WriteOutputMsg(str);
#else
  printf("%s", str);
#endif
}

/* Free a list of StrListPtr structures */

ErrorCode FreeStrList(list)
  StrListPtr list;
{
  StrListPtr cur;

  if (list == NULL) return(err_msg(FreeStringList, NullPtr));
  cur = list;
  while (cur != NULL)
    {
      cur = NEXT_STR(list);
      free(LIST_STR(list));
      free(list);
      list = cur;
    }
  return(AllOk);
}

/* Free an array of character strings.  Must be NULL-terminated. */

ErrorCode FreeStrArray(array)
  char *array[];
{
  char *ptr;
  int i = 0;

  if (array == NULL) return(err_msg(FreeStringArray, NullPtr));

  ptr = array[0];
  while (ptr != NULL)
    {
      free(ptr);
      ptr = array[++i];
    }
  return(AllOk);
}

/* Compute x ^ y */

long power (x, y)
  register long x, y;
{
  register long result = 1, i = 0;

  for (i = 0; i < y; i++) result *= x;
  return (result);
}

/* Does a given file exist? */

int FileExists(name)
     char *name;
{
  FILE *fp;

/* Check to see if the file already exists */

  fp = fopen(name, "r");
  if (fp == NULL) return(FALSE);
  return(TRUE);
}

void FileOverWriteMsg(buf, file)
     char *buf, *file;
{
  sprintf(buf, "%s\nalready exists.  Overwrite (y/n)? ", file);
}

/* Confirm overwrite */

int OverWrite(file)
  char *file;
{
  char c = (char)NULL;

/* Check to see if the file already exists */

  if (!FileExists(file)) return(TRUE);

/* Simple dialog with user */

  FileOverWriteMsg(ScratchBuf, file);

  printf("%s", ScratchBuf);
  
  while (c != 'Y' &&c != 'y' &&c != 'n' &&c != 'N' && c != '\n')
    c = getchar();
  if (c == 'Y' || c == 'y') return(TRUE);
  return(FALSE);
}

ErrorCode FullInputPath(name, buf)
  char *name, *buf;
{
  if (name == NULL || buf == NULL)
    return(err_msg(FullInputPathname, NullPtr));

/* Get the current string from the input directory box, and append the
 * file name to it.
 */

  sprintf(buf, "%s/%s", InputDirectory, name);
  return(AllOk);
}

ErrorCode FullOutputPath(name, buf)
  char *name, *buf;
{
  if (name == NULL || buf == NULL)
    return(err_msg(FullOutputPathname, NullPtr));

/* Get the current string from the input directory box, and append the
 * file name to it.
 */

  sprintf(buf, "%s/%s", OutputDirectory, name);
  return(AllOk);
}

