
/*
 *                  make_data.c
 *
 *	A simple routine that writes a data set to be used as
 *	input for multi_test.c
 *      
 *       compile with          cc -o outfile infile.c
 *
 *       Output file: argv[1]: a binary file containing a ROWxCOL
 *                    array of floating point values, with 1's along
 *                    the diagonal and 0's elsewhere.
 */

#include <stdio.h>

FILE *stream;
#define ROWS 10
#define COLS 10

main(argc, argv)
int argc;
char *argv[];
{

	int	i, j;
	float	*data_array;
			
    if (argc != 2) {
		printf("Usage: %s <outfile>\n", argv[0]);
		exit(1);
	}
	
	data_array = (float *)malloc(ROWS*COLS*sizeof(float));
	for(i=0;i<ROWS;i++)
	{
	   for(j=0;j<COLS;j++)
	   {
	      *(data_array+i*COLS+j) = (i==j) ? 1.0 : 0; 
       }
	}

	stream = fopen(argv[1],"w");
	fwrite(data_array,sizeof(float),ROWS*COLS,stream);
	fclose(stream);
	
}
