#include <stdio.h>

/*********************************************/
/* X include files                           */
/*********************************************/
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

/*********************************************/
/* variable declaration                      */
/*********************************************/

int nplanes;
char display[200];

Display *dpy;
int screen;
Window i_win, root_win;
Visual *visual = NULL;
XColor colors[256];
Colormap  colormap;
int ncolors;
XEvent event;
XExposeEvent *expose;
GC i_gc;
XGCValues  gcv;

xdis(image,pal,x,y,palsize)
     int *x, *y, *palsize;
     char *pal,*image;
{
  XImage *img;
  XVisualInfo vinfo_ret;
  unsigned long white,black;
  Status result;
  int i;
  XVisualInfo vtmp, *vrtn;
  long vmask;
  int nrtn;
  unsigned long vmask2;
  XSetWindowAttributes attr;
  /*********************************************/
  /* X windows setup 			     */
  /*********************************************/
  
  /* display setup */
  dpy = XOpenDisplay(display);
  if (dpy == NULL)
    perror("Can't open X display \n");
  screen   = XDefaultScreen(dpy);	
  root_win = XRootWindow(dpy,screen);
  nplanes  = XDisplayPlanes(dpy,screen);  /* find number of display planes
					    of workstation */
  vmask = VisualClassMask;
  vtmp.class = PseudoColor;
  vrtn = XGetVisualInfo(dpy, vmask, &vtmp, &nrtn); 

  if (nrtn == 0) {
    printf("No items returned from XGetVisualInfo\n");
    exit(0);
  } else {
    printf("\nPsuedoColor visual Created\n");
    visual = vrtn->visual;
  }

/*   visual = XDefaultVisual(dpy,screen); */
  img = XCreateImage(dpy, 
		     visual, 
		     nplanes, 
		     ZPixmap, 
		     0, 
		     image,
		     x,
		     y,
		     8, 
		     0);
  
  if (img == NULL)
    perror("XCreateImage: failed");



  /*********************************************/
  /* Windows 				         */
  /*****************************************/
  white = XWhitePixel(dpy, screen);
  black = XBlackPixel(dpy, screen);
  vmask2 = CWBackPixel | CWBorderPixel | CWEventMask | CWColormap;
  attr.background_pixel = black;
  attr.border_pixel = white;
  attr.colormap = colormap; 
  attr.event_mask = ExposureMask;

  i_win = XCreateWindow (dpy, 
			 root_win, 
			 50, 
			 50, 
			 x,
			 y,
			 4, 
			 nplanes,
			 InputOutput, 
			 visual, 
			 vmask2, 
			 &attr);

  XSetStandardProperties(dpy,i_win,"XIMG","XIMG",None,0,0,0);
  i_gc = XCreateGC(dpy, i_win, 0, 0);
  XSetBackground(dpy, i_gc, black);
  XSetForeground(dpy, i_gc, white);

  cmc(image, pal, palsize, &colormap, dpy, i_win, visual);

  XSelectInput(dpy, i_win, (ButtonPress | ExposureMask | ColormapChangeMask |
			    LeaveWindowMask | EnterWindowMask));
  XMapWindow(dpy, i_win);
  expose = (XExposeEvent *)&event;
  /*********************************************/
  /* main loop should begin here               */
  /*********************************************/
  
  while (True)
    {
      XNextEvent(dpy, &event);
      switch((int)event.type) {
      case Expose:
	XPutImage(dpy, i_win, i_gc, img, 0, 0, 0, 0, x, y);
	break;
      case ButtonPress:
	switch ((int) event.xbutton.button) {
	case Button1:
	  break;
	case Button2:
	  break;
	case Button3:
	  XDestroyWindow(dpy, i_win);
	  XCloseDisplay(dpy);
	  exit(0);
	  break;
	}
	break;
      case LeaveNotify:
	break;
      case EnterNotify:
	break;
      case ColormapNotify:
	break;
      default:
	;
      }
    }	
}	

/*********************************************/
/* end loop - cleanup 			     */
/*********************************************/
