/*****************************************************************************/
/* module dentiste4.c							     */
/*									     */
/* Copyright: Labo Image						     */
/*            Computing Science Center					     */
/*	      University of Geneva, Switzerland				     */
/* (This copyright notice should appear).				     */
/*									     */
/* Date:   June 1991							     */
/* Modifications:   							     */
/*									     */
/*****************************************************************************/
#include <stdio.h>
#include <memory.h>
#include <malloc.h>
#include <math.h>

#include "global.h"
#include "define.h"
#include "structure.h"
#include "type.h"



/*****************************************************************************/

void
liberer_vecteur(vect)
{
    int N, NP;
    struct profil_s *profil;
    struct profil_affiche_s *profil_aff;
    if (dir_desc_vect[vect].prive == NULL)
	return;
    switch (dir_desc_vect[vect].genre) {
	case 0:
	    free(((struct histogr *)dir_desc_vect[vect].prive)->tab_hist);
	    break;
	case 1:
	    break;
	case 2:
	    profil = (struct profil_s *)dir_desc_vect[vect].prive;
	    for(N = 0 ; N < profil->NPr ; N++)
		free(profil->Vals[N]);
	    for (NP = 0 ; NP < MAX_PROFIL ; NP++)
	    {
		profil_aff = (struct profil_affiche_s *)profil->aff_profil[NP];
		if (profil_aff != NULL)
		{
		    profil->aff_profil[NP] = NULL;
		}
	    }
	    break;
    }
    free(dir_desc_vect[vect].prive);
    dir_desc_vect[vect].prive = NULL;
    dir_vecteur[vect].flag_reserve = LIBRE;
    dir_vecteur[vect].image = NULL;
}
