/* SCCS @(#)convert4.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      convert4.c                                      */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   convert4.c                                          */
/*                                                                      */
/* DESCRIPTION  :   Conversion oprations                                */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <math.h>

#include "type.h"

/*****************************************************************************/
/*									     */
/* nom      : convert_byte						     */
/*									     */
/* fonction : convertit l'image d'input en byte et la	     		     */
/*	      stocke dans une image d'output.			     	     */
/*                                                                           */
/* entrees  : unsigned char *imageIn	: plan-image de depart               */
/*            unsigned char **imageOut	: pointeur sur plan-image d'arrivee  */
/*                                                                           */
/* return   : neant                                     		     */
/*									     */
/*									     */
/*****************************************************************************/

int convert_byte (imageIn, type, colonne, ligne, mmin, mmax, 
		  imageOut, mmin2, mmax2, conv)
unsigned char *imageIn, **imageOut;
int type, colonne, ligne;
float mmin, mmax, *mmin2, *mmax2;
struct convert *conv;
{
    unsigned char *im;
    register int j;
    int taille;
    register float delta, minim;
    register int minarr;

/* voir si on peut mettre ce bloc ailleurs */
    if (conv->flag_mind) conv->mind = mmin;
    if (conv->flag_maxd) conv->maxd = mmax;
    if (conv->flag_mina) conv->mina = mmin;
    if (conv->flag_maxa) conv->maxa = mmax;

    taille = colonne * ligne;
    *imageOut = im = (unsigned char *) malloc (taille);

    if (mmin>=MINBYTE && mmax<=MAXBYTE &&
	mmin==conv->mind && conv->mind==conv->mina &&
	mmax==conv->maxd && conv->maxd==conv->maxa)
    {
      /* image depart comprise dans l'intervalle des byte */
      /* +pas changement dynamique = convertir avec les "cast" */
      switch (type) {
        case -1:
        case 0 : {   /* image de depart de type unsigned char(recopie)*/
	  unsigned char *b;
	  b = (unsigned char *)imageIn;
	  for (j=0; j < taille; j++) {
	    *im = (unsigned char)*b;
	    im++;  b++;
	  }
	  break;
	}        
	case 1 : {   /* image de depart de type short */
	  short *s;
	  s = (short *)imageIn;
	  for (j=0; j < taille; j++) {
	    *im = (unsigned char)*s;
	    im++;  s++;
	  }
	  break; 
	}       
	case 2 : {   /* image de depart de type int */
	  int *i;
	  i = (int *)imageIn;
	  for (j=0; j < taille; j++) {
	    *im = (unsigned char)*i;
	    im++;  i++;
	  }
	  break;
	}        
	case 3 : {   /* image de depart de type float */
	  float *f;
	  f = (float *)imageIn;
	  for (j=0; j < taille; j++) {
	    *im = (unsigned char)*f;
	    im++;  f++;
	  }
	  break;
	}
	}
      /* les statistiques de l'image d'arrivee sont inchangees */
      *mmin2 = mmin;
      *mmax2 = mmax;
    }
    else { /* else with if dir_desc..... */
      /* on fait une regle de trois en etalant la dynamique de */
      /* l'intervalle de depart sur la dynamique choisie	*/
      delta=(conv->maxa - conv->mina)/(conv->maxd - conv->mind);
      minim = conv->mind;
      minarr = (int)conv->mina;
      switch (type) {
        case -1:
        case 0 : {   /* l'image de depart est de type byte */
	  unsigned char *b, bb;
	  b = (unsigned char *)imageIn;
	  for (j=0; j < taille; j++) {
	    if (*b > conv->maxd) bb = conv->maxd;
	    else if (*b < conv->mind) bb = conv->mind;
	    else bb = *b;
	    *im = (unsigned char)(((bb - minim) * delta + minarr) + 0.5);
	    im++;  b++;
	  }
	  break;
	}
	case 1 : {   /* image de depart de type short */
	  short *s, ss;
	  s = (short *)imageIn;
	  for (j=0; j < taille; j++) {
	    if (*s > conv->maxd) ss = conv->maxd;
	    else if (*s < conv->mind) ss = conv->mind;
	    else ss = *s;
	    *im = (unsigned char)(((ss - minim) * delta + minarr) + 0.5);
	    im++;  s++;
	  }
	  break;
	}
	case 2 : {   /* image de depart de type int */
	  int *i, ii;
	  i = (int *)imageIn;
	  for (j=0; j < taille; j++) {
	    if (*i > conv->maxd) ii = conv->maxd;
	    else if (*i < conv->mind) ii = conv->mind;
	    else ii = *i;
	    *im = (unsigned char)(((ii - minim) * delta + minarr) + 0.5);
	    im++;  i++;
	  }
	  break;
	}
	case 3 : {   /* image de depart de type float */
	  float *f, ff;
	  f = (float *)imageIn;
	  for (j=0; j < taille; j++) {
	    if (*f > conv->maxd) ff = conv->maxd;
	    else if (*f < conv->mind) ff = conv->mind;
	    else ff = *f;
	    *im = (unsigned char)(((ff - minim) * delta + minarr) + 0.5);
	    im++;  f++;
	  }
	  break;
	}
	}
      /* on doit recalculer les statistiques de l'image */    
      *mmin2 = conv->mina;
      *mmax2 = conv->maxa;
    }
    return 0;
}


/*****************************************************************************/

short *conv_short (imageIn, type, ligne, colonne)
unsigned char *imageIn;
int type, ligne, colonne;
{
    short *im, *imsave;
    int taille, j;

    taille = colonne * ligne;
    imsave = im = (short *)malloc (taille * sizeof(*im));
    if (type == 0 || type == -1 ) {
	/* image de depart en unsigned char */
	unsigned char *b;
	b = (unsigned char *)imageIn;
	for (j=0; j < taille; j++) {
	    *im = (short)*b;
	    im++;  b++;
	}
    }   
    return (imsave);    
}


/*****************************************************************************/
/*									     */
/* nom      : convert_short						     */
/*									     */
/* fonction : convertit l'image d'input en short et la	    		     */
/*	      stocke dans une image d'output.				     */
/*                                                                           */
/* entrees  : unsigned char *imageIn	: plan-image de depart               */
/*            short **imageOut		: pointeur sur plan-image d'arrivee  */
/*                                                                           */
/* return   : neant                                     		     */
/*									     */
/*									     */
/*****************************************************************************/

int convert_short (imageIn, type, colonne, ligne, mmin, mmax, 
		  imageOut, mmin2, mmax2, conv)
unsigned char *imageIn;
short **imageOut;
int type, colonne, ligne;
float mmin, mmax, *mmin2, *mmax2;
struct convert *conv;
{
    short *im;
    register int j;
    int taille;
    register float delta, minim;
    register int minarr;

    /* voir si on peut mettre ce bloc ailleurs */
    if (conv->flag_mind) conv->mind = mmin;
    if (conv->flag_maxd) conv->maxd = mmax;
    if (conv->flag_mina) conv->mina = mmin;
    if (conv->flag_maxa) conv->maxa = mmax;

    taille = colonne * ligne;
    *imageOut = im = (short *) malloc (taille * 2); /* 2 bytes par short */

    if (mmin>=MINSHORT && mmax<=MAXSHORT &&
	mmin==conv->mind && conv->mind==conv->mina&&
	mmax==conv->maxd && conv->maxd==conv->maxa){
      /* image depart comprise dans l'intervalle des short    */
      /* +pas changement dynamique = convertir avec les "cast" */
      switch (type) {
        case -1:
        case 0 : {  /* image de depart de type unsigned char */
	  unsigned char *b;
	  b = (unsigned char *)imageIn;
	  for (j=0; j < taille; j++) {
	    *im = (short)*b;
	    im++;  b++;
	  }
	  break;
	}        
	case 1 : { /* image de depart de type short (recopie)*/
	  short *s;
	  s = (short *)imageIn;
	  for (j=0; j < taille; j++) {
	    *im = (short)*s;
	    im++;  s++;
	  }
	  break; 
	}       
	case 2 : {   /* image de depart de type int */
	  int *i;
	  i = (int *)imageIn;
	  for (j=0; j < taille; j++) {
	    *im = (short)*i;
	    im++;  i++;
	  }
	  break;
	}        
	case 3 : {   /* image de depart de type float */
	  float *f;
	  f = (float *)imageIn;
	  for (j=0; j < taille; j++) {
	    *im = (short)*f;
	    im++;  f++;
	  }
	  break;
	}        
	}
      /* les statistiques de l'image d'arrivee sont inchangees */
      *mmin2 = mmin;
      *mmax2 = mmax;
     }
    else { 
      /* on fait une regle de trois en etalant la dynamique de */
      /* l'intervalle de depart sur la dynamique choisie	*/
      delta=(conv->maxa - conv->mina)/(conv->maxd - conv->mind);
      minim = conv->mind;
      minarr = (int)conv->mina;
      switch (type) {
        case -1:
        case 0 : {   /* l'image de depart est de type byte */
	  unsigned char *b, bb;
	  b = (unsigned char *)imageIn;
	  for (j=0; j < taille; j++) {
	    if (*b > conv->maxd) bb = conv->maxd;
	    else if (*b < conv->mind) bb = conv->mind;
	    else bb = *b;
	    *im = (short)(((bb - minim) * delta + minarr) + 0.5);
	    im++;  b++;
	  }
	  break;
	}
	case 1 : {   /* l'image de depart est de type short */
	  short *s, ss;
	  s = (short *)imageIn;
	  for (j=0; j < taille; j++) {
	    if (*s > conv->maxd) ss = conv->maxd;
	    else if (*s < conv->mind) ss = conv->mind;
	    else ss = *s;
	    *im = (short)(((ss - minim) * delta + minarr) + 0.5);
	    im++;  s++;
	  }
	  break;
	}
	case 2 : {   /* l'image de depart est de type int */
	  int *i, ii;
	  i = (int *)imageIn;
	  for (j=0; j < taille; j++) {
	    if (*i > conv->maxd) ii = conv->maxd;
	    else if (*i < conv->mind) ii = conv->mind;
	    else ii = *i;
	    *im = (short)(((ii - minim) * delta + minarr) + 0.5);
	    im++;  i++;
	  }
	  break;
	}
	case 3 : {   /* l'image de depart est de type float */
	  float *f, ff;
	  f = (float *)imageIn;
	  for (j=0; j < taille; j++) {
	    if (*f > conv->maxd) ff = conv->maxd;
	    else if (*f < conv->mind) ff = conv->mind;
	    else ff = *f;
	    *im = (short)(((ff - minim) * delta + minarr) + 0.5);
	    im++;  f++;
	  }
	  break;
	}
	}
      /* on doit recalculer les statistiques de l'image */
      *mmin2 = conv->mina;
      *mmax2 = conv->maxa;
    }
    return 0;
}



/*****************************************************************************/

int *conv_int (imageIn, type, ligne, colonne)
unsigned char *imageIn;
int type, ligne, colonne;
{
    int *im, *imsave, taille, j;

    taille = colonne * ligne;
    imsave = im = (int *)malloc (taille * sizeof(*im));
    switch (type) {
	case -1:
	case 0 : {   /* image de depart en unsigned char */
		    unsigned char *b;
		    b = (unsigned char *)imageIn;
		    for (j=0; j < taille; j++) {
			*im = *b;
			im++;  b++;
		    }
		    break;
		}        
	case 1 : {   /* image de depart en short */
                     short *s;
                     s = (short *)imageIn;
                     for (j=0; j < taille; j++) {
                         *im = (int)*s;
                         im++;  s++;
                     }
                     break; 
                 }
    }   
    return (imsave);    
}

/*****************************************************************************/
/*									     */
/* nom      : convert_integer						     */
/*									     */
/* fonction : convertit l'image d'input en entier et la	    		     */
/*	      stocke dans une image d'output.				     */
/*                                                                           */
/* entrees  : unsigned char *imageIn	: plan-image de depart               */
/*            int **imageOut		: pointeur sur plan-image d'arrivee  */
/*									     */
/* return   : neant                                     		     */
/*									     */
/*****************************************************************************/

int convert_integer (imageIn, type, colonne, ligne, mmin, mmax, imageOut, mmin2, mmax2, conv)
unsigned char *imageIn;
int **imageOut;
int type, colonne, ligne;
float mmin, mmax, *mmin2, *mmax2;
struct convert *conv;
{
    int *im;
    register int j;
    int taille;
    register float delta, minim;
    register int minarr;

    taille = colonne * ligne;
    *imageOut = im = (int *) malloc (taille * 4); /* 4 bytes par int */

/* voir si on peut mettre ce bloc ailleurs */
    if (conv->flag_mind) conv->mind = mmin;
    if (conv->flag_maxd) conv->maxd = mmax;
    if (conv->flag_mina) conv->mina = mmin;
    if (conv->flag_maxa) conv->maxa = mmax;

    if (mmin>=MININT && mmax<=MAXINT &&
	mmin==conv->mind && conv->mind==conv->mina&&
	mmax==conv->maxd && conv->maxd==conv->maxa){
      /* image depart comprise dans l'intervalle des int      */
      /* +pas changement dynamique = convertir avec les "cast" */
      switch (type) {
        case -1:
        case 0 : {   /* image de depart en unsigned char */
	  unsigned char *b;
	  b = (unsigned char *)imageIn;
	  for (j=0; j < taille; j++) {
	    *im = (int)*b;
	    im++;  b++;
	  }
	  break;
	}        
	case 1 : {   /* image de depart en short */
	  short *s;
	  s = (short *)imageIn;
	  for (j=0; j < taille; j++) {
	    *im = (int)*s;
	    im++;  s++;
	  }
	  break; 
	}       
	case 2 : {   /* image de depart en int (recopie) */
	  int *i;
	  i = (int *)imageIn;
	  for (j=0; j < taille; j++) {
	    *im = (int)*i;
	    im++;  i++;
	  }
	  break;
	}        
	case 3 : {   /* image de depart en float */
	  float *f;
	  f = (float *)imageIn;
	  for (j=0; j < taille; j++) {
	    *im = (int)*f;
	    im++;  f++;
	  }
	  break;
	}        
	}
      /* les statistiques de l'image d'arrivee sont inchangees */
      *mmin2 = mmin;
      *mmax2 = mmax;
    }
    else {  
      /* on fait une regle de trois en etalant la dynamique de */
      /* l'intervalle de depart sur toute la dynamique des int */
      delta = (conv->maxa - conv->mina) / (mmax - mmin);
      minim = mmin;
      minarr = (int)conv->mina;
      switch (type) {
        case -1:
        case 0 : {   /* l'image de depart est de type byte */
	  unsigned char *b, bb;
	  b = (unsigned char *)imageIn;
	  for (j=0; j < taille; j++) {
	    if (*b > conv->maxd) bb = conv->maxd;
	    else if (*b < conv->mind) bb = conv->mind;
	    else bb = *b;
	    *im = (int)(((bb - minim) * delta + minarr) + 0.5);
	    im++;  b++;
	  }
	  break;
	}
	case 1 : {   /* l'image de depart est de type short */
	  short *s, ss;
	  s = (short *)imageIn;
	  for (j=0; j < taille; j++) {
	    if (*s > conv->maxd) ss = conv->maxd;
	    else if (*s < conv->mind) ss = conv->mind;
	    else ss = *s;
	    *im = (int)(((ss - minim) * delta + minarr) + 0.5);
	    im++;  s++;
	  }
	  break;
	}
	case 2 : {   /* l'image de depart est de type int */
	  int *i, ii;
	  i = (int *)imageIn;
	  for (j=0; j < taille; j++) {
	    if (*i > conv->maxd) ii = conv->maxd;
	    else if (*i < conv->mind) ii = conv->mind;
	    else ii = *i;
	    *im = (int)(((ii - minim) * delta + minarr) + 0.5);
	    im++;  i++;
	  }
	  break;
	}
	case 3 : {   /* l'image de depart est de type float */
	  float *f, ff;
	  f = (float *)imageIn;
	  for (j=0; j < taille; j++) {
	    if (*f > conv->maxd) ff = conv->maxd;
	    else if (*f < conv->mind) ff = conv->mind;
	    else ff = *f;
	    *im = (int)(((ff - minim) * delta + minarr) + 0.5);
	    im++;  f++;
	  }
	  break;
	}
	}
      /* on doit recalculer les statistiques de l'image */
      *mmin2 = conv->mina;
      *mmax2 = conv->maxa;
    }
    return 0;
}



/*****************************************************************************/

float *conv_float (imageIn, type, ligne, colonne)
unsigned char *imageIn;
int type, ligne, colonne;
{
    float *im, *imsave;
    int taille, j;

    taille = colonne * ligne;
    imsave = im = (float *)malloc (taille * sizeof(*im));
    switch (type) {
	case -1:
	case 0 : {   /* image de depart en unsigned char */
		    unsigned char *b;
		    b = (unsigned char *)imageIn;
		    for (j=0; j < taille; j++) {
			*im = (float)*b;
			im++;  b++;
		    }
		    break;
		}        
	case 1 : {   /* image de depart en short */
                     short *s;
                     s = (short *)imageIn;
                     for (j=0; j < taille; j++) {
                         *im = (float)*s;
                         im++;  s++;
                     }
                     break; 
                 }
	case 2 : {   /* image de depart en short */
                     int *in;
                     in = (int *)imageIn;
                     for (j=0; j < taille; j++) {
                         *im = (float)*in;
                         im++;  in++;
                     }
                     break; 
                 }
    }  

    return (imsave);    
}


/*****************************************************************************/
/*									     */
/* nom      : convert_float						     */
/*									     */
/* fonction : convertit l'image d'input en float et la	    		     */
/*	      stocke dans une image d'output.				     */
/*                                                                           */
/* entrees  : unsigned char *imageIn	: plan-image de depart               */
/*            float **imageOut		: pointeur sur plan-image d'arrivee  */
/*                                                                           */
/* return   : neant                                     		     */
/*									     */
/*****************************************************************************/

int convert_float  (imageIn, type, colonne, ligne, mmin, mmax, imageOut, mmin2, mmax2, conv)
unsigned char *imageIn;
float **imageOut;
int type, colonne, ligne;
float mmin, mmax, *mmin2, *mmax2;
struct convert *conv;
{
    float *im;
    register int j;
    int taille;
    register float delta, minim;
    register int minarr;

    taille = colonne * ligne;
    *imageOut = im = (float *) malloc (taille * 4); /* 4 bytes par float */

    if (conv->flag_mind) conv->mind = mmin;
    if (conv->flag_maxd) conv->maxd = mmax;
    if (conv->flag_mina) conv->mina = mmin;
    if (conv->flag_maxa) conv->maxa = mmax;

    if (mmin>=MINFLOAT && mmax<=MAXFLOAT &&
	mmin==conv->mind && conv->mind==conv->mina&&
	mmax==conv->maxd && conv->maxd==conv->maxa)
    {
      /* image depart comprise dans l'intervalle des float    */
      /* +changement dynamique = convertir avec les "cast" */
      switch (type) {
        case -1:
        case 0 : {  /* image de depart de type unsigned char */
	  unsigned char *b;
	  b = (unsigned char *)imageIn;
	  for (j=0; j < taille; j++) {
	    *im = (float)*b;
	    im++;  b++;
	  }
	  break;
	}        
	case 1 : {   /* image de depart de type short */
	  short *s;
	  s = (short *)imageIn;
	  for (j=0; j < taille; j++) {
	    *im = (float)*s;
	    im++;  s++;
	  }
	  break; 
	}       
	case 2 : {   /* image de depart de type int */
	  int *i;
	  i = (int *)imageIn;
	  for (j=0; j < taille; j++) {
	    *im = (float)*i;
	    im++;  i++;
	  }
	  break;
	}        
	case 3 : {   /* image de depart de type float */
	  float *f;
	  f = (float *)imageIn;
	  for (j=0; j < taille; j++) {
	    *im = (float)*f;
	    im++;  f++;
	  }
	  break;
	} 
	}       
      /* les statistiques de l'image d'arrivee sont inchangees */
      *mmin2 = mmin;
      *mmax2 = mmax;
    }
    else {
      /* on fait une regle de trois en etalant la dynamique de */
      /* l'intervalle de depart sur toute la dynamique des int */
      delta = (conv->maxa - conv->mina) / (mmax - mmin);
      minim = mmin;
      minarr = (int)conv->mina;
      switch (type) {
        case -1:
        case 0 : {   /* l'image de depart est de type byte */
	  unsigned char *b, bb;
	  b = (unsigned char *)imageIn;
	  for (j=0; j < taille; j++) {
	    if (*b > conv->maxd) bb = conv->maxd;
	    else if (*b < conv->mind) bb = conv->mind;
	    else bb = *b;
	    *im = (float)(((bb - minim) * delta + minarr) + 0.5);
	    im++;  b++;
	  }
	  break;
	}
	case 1 : {   /* l'image de depart est de type short */
	  short *s, ss;
	  s = (short *)imageIn;
	  for (j=0; j < taille; j++) {
	    if (*s > conv->maxd) ss = conv->maxd;
	    else if (*s < conv->mind) ss = conv->mind;
	    else ss = *s;
	    *im = (float)(((ss - minim) * delta + minarr) + 0.5);
	    im++;  s++;
	  }
	  break;
	}
	case 2 : {   /* l'image de depart est de type int */
	  int *i, ii;
	  i = (int *)imageIn;
	  for (j=0; j < taille; j++) {
	    if (*i > conv->maxd) ii = conv->maxd;
	    else if (*i < conv->mind) ii = conv->mind;
	    else ii = *i;
	    *im = (float)(((ii - minim) * delta + minarr) + 0.5);
	    im++;  i++;
	  }
	  break;
	}
	case 3 : {   /* l'image de depart est de type float */
	  float *f, ff;
	  f = (float *)imageIn;
	  for (j=0; j < taille; j++) {
	    if (*f > conv->maxd) ff = conv->maxd;
	    else if (*f < conv->mind) ff = conv->mind;
	    else ff = *f;		
	    *im = (float) ((ff - minim) * delta + minarr);
	    im++;  f++;
	  }
	  break;
	}
	}
      *mmin2 = conv->mina;
      *mmax2 = conv->maxa;
    }
    return 0;
}



/*****************************************************************************/
/*									     */
/* nom      : convert_cart_en_pol					     */
/*									     */
/* fonction : convertit l'image complexe cartesienne			     */
/*	      (2 plans d'input) en une image complexe	     		     */
/*	      polaire (2 plans d'output) 				     */
/*                                                                           */
/* entrees  : unsigned char *imageIn1	: plan-image de depart               */
/*            unsigned char *imageIn2	: plan-image de depart               */
/*            float **imageOut1		: pointeur sur plan-image d'arrivee  */
/*            float **imageOut2		: pointeur sur plan-image d'arrivee  */
/*                                                                           */
/* return   : neant                                     		     */
/*									     */
/*****************************************************************************/
 
int convert_cart_en_pol (imageIn1, imageIn2, ligne, colonne, imageOut1, imageOut2)
unsigned char *imageIn1, *imageIn2;
float **imageOut1, **imageOut2; 
int ligne, colonne;
{
    float *x, *y, *module, *arg;
    register int taille, n;

    taille = ligne * colonne;
    x = (float *) imageIn1;
    y = (float *) imageIn2;
    *imageOut1 = module = (float *)malloc(taille*4);
    *imageOut2 = arg = (float *)malloc(taille*4);

    for ( n = 0 ; n < taille ; n++){
      *module = (float) hypot((double) *x , (double) *y);
      if (*x==0)
	if (*y>0) *arg = M_PI_2;
	else if (*y<0) *arg = - M_PI_2;
	else *arg = 0;
      else
	*arg = (float) atan ( (double) *y / (double) *x);
      module++;  arg++;
      x++;  y++;
    }
    return 0;
}




/*****************************************************************************/
/*									     */
/* nom      : convert_pol_en_cart					     */
/*									     */
/* fonction : convertit l'image complexe polaire			     */
/*	      (2 plans d'input) en une image complexe	     		     */
/*	      cartesienne (2 plans d'output) 				     */
/*                                                                           */
/* entrees  : unsigned char *imageIn1	: plan-image de depart               */
/*            unsigned char *imageIn2	: plan-image de depart               */
/*            float **imageOut1		: pointeur sur plan-image d'arrivee  */
/*            float **imageOut2		: pointeur sur plan-image d'arrivee  */
/*                                                                           */
/* return   : neant                                     		     */
/*									     */
/*****************************************************************************/
 
int convert_pol_en_cart (imageIn1, imageIn2, ligne, colonne, imageOut1, imageOut2)
unsigned char *imageIn1, *imageIn2;
float **imageOut1, **imageOut2; 
int ligne, colonne;
{
    float *x, *y, *module, *arg;
    register int taille, n;

    taille = ligne * colonne;
    module = (float *) imageIn1;
    arg = (float *) imageIn2;

    *imageOut1 = x = (float *)malloc(taille*4);
    *imageOut2 = y = (float *)malloc(taille*4);

    for ( n = 0 ; n < taille ; n++){
      *x = *module * cos (*arg);
      *y = *module * sin (*arg);
      x++;  y++;
      module++;  arg++;
    }
    return 0;
}



    
/*****************************************************************************/
/*                							     */
/* nom      : creer_image_bin 						     */
/*									     */
/* fonction : convertit l'image d'input en une image binaire (0 -> 255)      */
/*	      en lui appliquant un seuil				     */
/*									     */
/* entrees  : unsigned char *imageIn	: plan-image de depart               */
/*            unsigned char **imageOut	: pointeur sur plan-image d'arrivee  */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : statis							     */
/*								             */
/*****************************************************************************/

void creer_image_bin (imageIn, type, colonne, ligne, mmin, mmax, 
		     imageOut, mmin2, mmax2, conv)
unsigned char *imageIn, **imageOut;
int type, colonne, ligne;
float mmin, mmax, *mmin2, *mmax2;
struct convert *conv;  
{
    int taille;
    float valeur;
    unsigned char *image;
    register unsigned char *b;
    register short *s;
    register int *i, x, y;
    register float *f;

    valeur = conv->mind;

    taille = ligne * colonne; 
    *imageOut = image = (unsigned char *)malloc (taille); 
   
    switch (type) {
        case -1:
	case 0: b = (unsigned char *) imageIn; break;
        case 1: s = (short *) imageIn; break;
        case 2: i = (int *) imageIn; break;
        case 3: f = (float *) imageIn; break;
    }
    switch (type) {
	case -1:
	case 0:
	    for ( y = 0 ; y < ligne ; y++) 
		for ( x = 0 ; x < colonne; x++) {
	            if ( *b > valeur ) *image = 255;
		    else *image = 0;
		    b++;
	            image++;
		}
	    break;
	case 1:
	    for ( y = 0 ; y < ligne ; y++) 
		for ( x = 0 ; x < colonne; x++) {
	            if ( *s > valeur ) *image = 255;
		    else *image = 0;
		    s++;
	            image++;
		}
	    break;
	case 2:
	    for ( y = 0 ; y < ligne ; y++) 
		for ( x = 0 ; x < colonne; x++) {
	            if ( *i > valeur ) *image = 255;
		    else *image = 0;
		    i++;
	            image++;
		}
	    break;
	case 3:
	    for ( y = 0 ; y < ligne ; y++) 
		for ( x = 0 ; x < colonne; x++) {
	            if ( *f > valeur ) *image = 255;
		    else *image = 0;
		    f++;
	            image++;
		}
	    break;
    }
    *mmax2 = valeur;
    *mmin2 = 0;
}


