/*****************************************************************************/
/* module interface.c							     */
/*									     */
/* Author: Alain Jacot-Descombes					     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1989							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/

/********************************************************************/
/*  Programme d'interface avec :    MORPHOLOGIE BINAIRE             */
/*                                  MORPHOLOGIE A NIVEAUX DE GRIS   */
/*                                  GENERATION D'IMAGES             */ 
/********************************************************************/

#include <suntool/sunview.h>
#include <suntool/textsw.h>
#include <suntool/panel.h>
#include <suntool/canvas.h>
#include <suntool/icon.h>
#include <math.h>

#include "define.h"
#include "structure.h"
#include "global.h"
#include "type.h"

/*****************************************************************************/
/*  MORPHOLOGIE BINAIRE                                                      */
/*****************************************************************************/

static short dial_0[] = {
#include "icon/dial_0.pr"
};
mpr_static (dial_0_pr, 64, 64, 1, dial_0);

static short dial_60[] = {
#include "icon/dial_60.pr"
};
mpr_static (dial_60_pr, 64, 64, 1, dial_60);

static short dial_120[] = {
#include "icon/dial_120.pr"
};
mpr_static (dial_120_pr, 64, 64, 1, dial_120);

static short dial_180[] = {
#include "icon/dial_180.pr"
};
mpr_static (dial_180_pr, 64, 64, 1, dial_180);

static short dial_240[] = {
#include "icon/dial_240.pr"
};
mpr_static (dial_240_pr, 64, 64, 1, dial_240);

static short dial_300[] = {
#include "icon/dial_300.pr"
};
mpr_static (dial_300_pr, 64, 64, 1, dial_300);

void handle_morphbin_menu();

extern  Menu    mprincipal, mmorphbin;
extern  Textsw  master;
extern  Panel   menu_win;
extern  char *morphbintabs[];
extern  Frame menu_frame;

struct commande *com;

Frame	    frame_taille;
Panel	    panel_taille;
Panel       menu_morphbin;
Panel_item  barre_taille, cercle_angle, ok_bouton, quit_bouton;
Panel_item  morphbin_title, button_mbmenu, button_mbquit, button_affiche;
int	    taille;
int         angle;

 void hproc_entree_morphbin();

void extern hproc_erode_sphere();
void extern hproc_erode_cone();
void extern hproc_erode_cylinder();
void extern hproc_erode_gauss();
void extern hproc_erode_plan_image(); 
void extern hproc_dilate_sphere();
void extern hproc_dilate_cone();
void extern hproc_dilate_cylinder();
void extern hproc_dilate_gauss();
void extern hproc_dilate_plan_image(); 
void extern hproc_ouverture_sphere();
void extern hproc_ouverture_cone();
void extern hproc_ouverture_cylinder();
void extern hproc_ouverture_gauss();
void extern hproc_ouverture_plan_image();
void extern hproc_fermeture_sphere();
void extern hproc_fermeture_cone();
void extern hproc_fermeture_cylinder();
void extern hproc_fermeture_gauss();
void extern hproc_fermeture_plan_image();  

extern void hproc_affiche_morphbin();
extern void hproc_complem_mbtranslog();
extern void hproc_intersect_mbtranslog();
extern void hproc_union_mbtranslog();
extern void hproc_diffsym_mbtranslog();
extern void hproc_diff_mbtranslog();
extern void hproc_erosion_mbtranssimple();
extern void hproc_erocond_mbtranssimple();
extern void hproc_erolin_mbtranssimple();
extern void hproc_diltate_mbtranssimple();
extern void hproc_dilacond_mbtranssimple();
extern void hproc_dilacond_mbtranssimple();
extern void hproc_dilalin_mbtranssimple();
extern void hproc_ouvert_mbtranssimple();
extern void hproc_ferme_mbtranssimple();
extern void hproc_homotopL_mbaminciss();
extern void hproc_homotopD_mbaminciss();
extern void hproc_ebarb_mbaminciss();
extern void hproc_contour_mbaminciss();
extern void hproc_homotopL_mbamincond();
extern void hproc_homotopD_mbamincond();
extern void hproc_ebarb_mbamincond();
extern void hproc_L_epaiss();
extern void hproc_M_epaiss();
extern void hproc_D_epaiss();
extern void hproc_E_epaiss();
extern void hproc_C_epaiss();
extern void hproc_L_epaisscond();
extern void hproc_M_epaisscond();
extern void hproc_D_epaisscond();
extern void hproc_E_epaisscond();
extern void hproc_C_epaisscond();
extern void hproc_extrem_toutrien();
extern void hproc_triple_toutrien();
extern void hproc_isole_toutrien();
extern void hproc_cont_hautniv();
extern void hproc_bord_hautniv();
extern void hproc_trou_hautniv();
extern void hproc_squelhom_hautniv();
extern void hproc_marqhom_hautniv();
extern void hproc_envfortcomp_hautniv();
extern void hproc_envquasicomp_hautniv();
extern void hproc_squelzone_hautniv();

extern int Confirm();


extern char *mastertabs[], *mmb3tabs[], *mmb4tabs[], *mmb5tabs[];
extern char *paneltabs[], *mmb6tabs[], *mmb7tabs[];
/*****************************************************************************/
caddr_t proc_sortie_morphbin(m, mi)
Menu m;
Menu_item mi;
{
    window_set(menu_win, WIN_SHOW, TRUE, 0);
    window_destroy(menu_morphbin);
    window_set (menu_win, WIN_CONSUME_PICK_EVENTS,WIN_MOUSE_BUTTONS,
                0,0);

    if (flag_creer){
	com = (struct commande *)malloc(sizeof(*com));
	com = (struct commande *)new_commande (&macro_cour);
	strcpy(com->nom,"PROBMOQUI");
	com->code = 699;
	com->param = NULL;
	sprintf (buf, "PROBMOQUI\n");
	write_macro(buf);
    }
    else {
	sprintf(buf, mastertabs[96]);
	write_master(buf);
	sortie_morpho();
    }
}


void proc1_sortie_morphbin(item, event)
Panel_item item;
  Event *event;
{
    if (!Confirm("quit morphbin?"))
	    return; 
    window_set(menu_win, WIN_SHOW, TRUE, 0);
    window_destroy(menu_morphbin);
    window_set (menu_win, WIN_CONSUME_PICK_EVENTS,WIN_MOUSE_BUTTONS,
                0,0);

    if (flag_creer){
	com = (struct commande *)malloc(sizeof(*com));
	com = (struct commande *)new_commande (&macro_cour);
	strcpy(com->nom,"PROBMOQUI");
	com->code = 699;
	com->param = NULL;
	sprintf (buf, "PROBMOQUI");
	write_macro(buf);
    }
    else {
	sprintf(buf,mastertabs[96]);
	write_master(buf);
	sortie_morpho();
    }
}


void proc_affiche_morphbin(item, event)
Panel_item item;
 Event *event;
{
    if (flag_bother){
	 hproc_affiche_morphbin();
	 return;
    }
    if (flag_help) hproc_affiche_morphbin();
    if (flag_creer) {
	com = (struct commande *)malloc(sizeof(*com));
	com = (struct commande *)new_commande (&macro_cour);
    }   
    if (flag_creer){
	strcpy(com->nom,"PROBMODIS");
	com->code = 601;
    }
    else write_master(mastertabs[98]);
    if (flag_exec==AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
    }
    else fromto (FROM, DEFAUT);
    if (flag_break){
	interruption();
	return;
    }
    if (flag_creer){
	com->from[0] = index_image[0];
	sprintf (buf, "%s FROM %d", com->nom,index_image[0]);
    }
    else{
	sprintf (buf, "--> %d", index_image[0]);
	write_master (buf);
    }
    if (flag_creer) {
	com->param = NULL;
	strcat (buf, "\n");
	write_macro(buf);
    }
    else{
	entree_morpho (1);
	sprintf(buf,"\n"); 
	write_master (buf);
    }
}
/*****************************************************************************/

caddr_t proc_entree_morphbin (m, mi)
    Menu m;
    Menu_item mi;

{
    extern Menu mmorphbin;
    int resul;


    if (flag_bother){
	 hproc_affiche_morphbin();
/*	 return; */
    }
    if (flag_help) hproc_entree_morphbin();  
    window_set (menu_win, WIN_IGNORE_PICK_EVENTS,WIN_MOUSE_BUTTONS,
                0, 0);
    window_set(menu_win, WIN_SHOW, FALSE, 0);

    menu_morphbin = window_create(menu_frame, PANEL,
                                  WIN_SHOW, TRUE,
                                  WIN_RIGHT_OF, master,
                                  WIN_X, 0, WIN_Y, 0,
				  WIN_HEIGHT, 320,
                                  PANEL_LABEL_BOLD, TRUE,
                                  PANEL_LAYOUT, PANEL_VERTICAL,
                                  0);
/*                                  WIN_COLUMNS, 18, WIN_ROWS, 14, */


     morphbin_title = panel_create_item (menu_morphbin, PANEL_MESSAGE,
				PANEL_LABEL_X, ATTR_COL(0),
				PANEL_LABEL_Y, ATTR_ROW(0),
				PANEL_LABEL_STRING,"** MORPHBIN **",
				0);

     button_mbmenu = panel_create_item(menu_morphbin, PANEL_BUTTON,
                                     PANEL_LABEL_IMAGE, panel_button_image(menu_morphbin, "OPERATIONS  =>",15,0),
                                     PANEL_LABEL_X, ATTR_COL(1),
                                     PANEL_LABEL_Y, ATTR_ROW(3),
                                     PANEL_EVENT_PROC, handle_morphbin_menu,
                                     0);
     button_affiche = panel_create_item(menu_morphbin, PANEL_BUTTON,
                                     PANEL_LABEL_IMAGE, panel_button_image(menu_morphbin, "DISPLAY      ",15,0),
                                     PANEL_LABEL_X, ATTR_COL(1),
                                     PANEL_LABEL_Y, ATTR_ROW(7),
                                     PANEL_NOTIFY_PROC, proc_affiche_morphbin,
                                     0);

     button_mbquit = panel_create_item(menu_morphbin, PANEL_BUTTON,
                                     PANEL_NOTIFY_PROC, proc1_sortie_morphbin,
                                     PANEL_LABEL_IMAGE, panel_button_image(menu_morphbin,"QUIT          ",15,0),
                                     PANEL_LABEL_X, ATTR_COL(1),
                                     PANEL_LABEL_Y, ATTR_ROW(11),
                                     0);


     window_fit_width(menu_morphbin);
     window_fit_width(menu_frame); 
                              
    
    if (flag_creer){
	com = (struct commande *)malloc(sizeof(*com));
	com = (struct commande *)new_commande (&macro_cour);
	strcpy(com->nom,"PROBMO");
	com->code = 600;
	com->param = NULL;
	sprintf (buf, "PROBMO\n");
	write_macro(buf);
    }
    else {
	sprintf(buf,mastertabs[97]);
	write_master(buf);
	entree_morpho (0);
    }
}

/*****************************************************************************/


void handle_morphbin_menu(item, event)
  Panel_item item;
  Event *event;
{
   extern Menu mmb1, mmb2, mmb3, mmb4, mmb5, mmb6, mmb7, mmb8, mmb9;
   int resul;
  
   if (event_id(event) == MS_RIGHT && event_is_down(event)){
       panel_begin_preview(item, event);
       if (item==button_mbmenu) resul = (int)menu_show(mmorphbin, menu_morphbin, event,0);
       panel_accept_preview(item, event);
   }
}


/*****************************************************************************/

caddr_t proc_morphbin (m, mi)
    Menu m;
    Menu_item mi;

{
    char rep[80];
    long n;
    int no_menu = (int)menu_get (mi, MENU_VALUE);
    
    switch (no_menu){
	case 1:if (flag_bother) {
		 hproc_affiche_morphbin();
		 return;
	}
		 break;
	case 20: if (flag_bother) {
		 hproc_complem_mbtranslog();
		 return;
	}
		 break;
	case 21:if (flag_bother) {
		 hproc_intersect_mbtranslog();
		 return;
	}
		 break;
	case 22:if (flag_bother){
		 hproc_union_mbtranslog();
		 return;
	}
		 break;
	case 23: if (flag_bother){
		 hproc_diffsym_mbtranslog();
		 return;
	}
		 break;
	case 24:if (flag_bother){
		 hproc_diff_mbtranslog(); 
		 return;
	}
		 break;
	case 30:if (flag_bother){
		 hproc_erosion_mbtranssimple();
		 return; 
	}
		 break;
	case 31: if (flag_bother){
		 hproc_erocond_mbtranssimple();
		 return;
	}
		 break;
	case 32:if (flag_bother){
		 hproc_erolin_mbtranssimple(); 
		 return;
	}
		 break;
	case 33:if (flag_bother){
		 hproc_dilate_mbtranssimple(); 
		 return;
	}
		 break;
	case 34:if (flag_bother){
		 hproc_dilate_mbtranssimple(); 
		 return;
	}
		 break;
	case 35:if (flag_bother){  
		 hproc_dilalin_mbtranssimple(); 
		 return;
	}
		 break;
	case 36: if (flag_bother){
		 hproc_ouvert_mbtranssimple();
		 return;
	}
	         break;
	case 37:if (flag_bother){
		 hproc_ferme_mbtranssimple();
		 return; 
	}
	         break;
	case 40:if (flag_bother){
		 hproc_homotopL_mbaminciss();
		 return;
	}
		 break;
	case 41: if (flag_bother){
		 hproc_homotopD_mbaminciss();
		 return;
	}
		 break;
	case 42:if (flag_bother){
		 hproc_ebarb_mbaminciss();
		 return;
	}
		 break;
	case 43:if (flag_bother){
		 hproc_contour_mbaminciss();
		 return;
	}
	         break;
	case 50: if (flag_bother){
		 hproc_M_epaiss();
		 return;
	}
		 break;
	case 51: if (flag_bother){
		 hproc_L_epaiss();
		 return;
	}
		 break;
	case 52:if (flag_bother){
		 hproc_D_epaiss();
		 return;
	}
		 break;
	case 53: if (flag_bother){
		 hproc_E_epaiss();
		 return;
	}
		 break;
	case 54:if (flag_bother){
		 hproc_C_epaiss();
		 return; 
	}
		 break;
	case 60:if (flag_bother){
		 hproc_extrem_toutrien();
		 return;
	}
		 break;
	case 61:if (flag_bother){
		 hproc_triple_toutrien();
		 return; 
	}
		 break;
	case 62:if (flag_bother){
		 hproc_isole_toutrien();
		 return;
	}
		 break;
	case 63:if (flag_bother) {
		hproc_cont_hautniv();
		 return;
	}
		 break;
	case 70:if (flag_bother){
		 hproc_bord_hautniv();
		 return; 
	}
		 break;
	case 71:if (flag_bother) {
		hproc_trou_hautniv();
		 return;
	}
		 break;
	case 72: if (flag_bother){
		 hproc_squelhom_hautniv();
		 return;
	}
		 break;
	case 73: if (flag_bother) {
		hproc_marqhom_hautniv();
		 return;
	}
	         break;
	case 74:if (flag_bother) {
		hproc_envquasicomp_hautniv();
		 return;
	}
	         break;
	case 75:if (flag_bother) {
		hproc_envfortcomp_hautniv();
		 return; 
	}
	         break;
	case 76:if (flag_bother) {
		hproc_squelzone_hautniv();
		 return;
	}
	         break;
	case 77:if (flag_bother) {
		hproc_homotopL_mbamincond();
		 return; 
	}
	         break;
	case 80:if (flag_bother) {
		hproc_homotopD_mbamincond();
		 return;
	}
	         break;
	case 81: if (flag_bother) {
		hproc_ebarb_mbamincond();
		 return;
	}
	         break;
	case 82: if (flag_bother) {
		hproc_M_epaisscond();
		 return;
	}
	         break;
	case 90: if (flag_bother) {
		hproc_L_epaisscond();
		 return;
	}
		 break;
	case 91:if (flag_bother) {
		hproc_D_epaisscond();
		 return;
	}
		 break;
	case 92:if (flag_bother) {
		hproc_E_epaisscond();
		 return;
	}
		 break;
	case 93:if (flag_bother) {
		hproc_C_epaisscond();       
		 return;
	}
		 break;
	case 94: if (flag_bother) {
		hproc_C_epaisscond();
		 return;
	}
                 break;


    }
    if (flag_creer) {
	com = (struct commande *)malloc(sizeof(*com));
	com = (struct commande *)new_commande (&macro_cour);
    }
    switch (no_menu){
	case 1 :if (flag_help) hproc_affiche_morphbin();
                if (flag_creer){
		    strcpy(com->nom,"PROBMODIS");
		    com->code = 601;
		}
		else sprintf(buf,mastertabs[98]);
		break;
	case 20:if (flag_help) hproc_complem_mbtranslog();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOLTRCOM");
		    com->code = 620;
		}
		else sprintf(buf,"not");
		break;
	case 21:if (flag_help) hproc_intersect_mbtranslog();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOLTRINT");
		    com->code = 621;
		}
		else sprintf(buf,"and");
		break;
	case 22:if (flag_help) hproc_union_mbtranslog();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOLTRUNI");
		    com->code = 622;
		}
		else sprintf(buf,"or");
		break;
	case 23:if (flag_help) hproc_diffsym_mbtranslog();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOLTRSDI");
		    com->code = 623;
		}
		else sprintf(buf,"xor");
		break;
	case 24:if (flag_help) hproc_diff_mbtranslog();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOLTRDIF");
		    com->code = 624;
		}
		else sprintf(buf,"diff");
		break;
	case 30:if (flag_help) hproc_erosion_mbtranssimple();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOSTRERO");
		    com->code = 630;
		}
		else sprintf(buf,"erosion");
		break;
	case 31:if (flag_help) hproc_erocond_mbtranssimple();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOSTRCER");
		    com->code = 631;
		}
		else sprintf(buf,mmb3tabs[0]);
		break;
	case 32:if (flag_help) hproc_erolin_mbtranssimple();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOSTRLER");
		    com->code = 632;
		}
		else sprintf(buf,mmb3tabs[1]);
		break;
	case 33:if (flag_help) hproc_dilate_mbtranssimple();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOSTRDIL");
		    com->code = 633;
		}
		else sprintf(buf,"dilatation");
		break;
	case 34:if (flag_help) hproc_dilacond_mbtranssimple();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOSTRCDI");
		    com->code = 634;
		}
		else sprintf(buf,mmb3tabs[2]);
		break;
	case 35:if (flag_help) hproc_dilalin_mbtranssimple();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOSTRLDI");
		    com->code = 635;
		}
		else sprintf(buf,mmb3tabs[3]);
		break;
	case 36:if (flag_help) hproc_ouvert_mbtranssimple();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOSTROPE");
		    com->code = 636;
		}
		else sprintf(buf, mmb3tabs[4]);
		break;
	case 37:if (flag_help) hproc_ferme_mbtranssimple();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOSTRCLO");
		    com->code = 637;
		}
		else sprintf(buf,mmb3tabs[5]);
		break;
	case 40:if (flag_help) hproc_homotopL_mbaminciss();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOTHIHOL");
		    com->code = 640;
		}
		else sprintf(buf,mmb4tabs[0]);
		break;
	case 41:if (flag_help) hproc_homotopD_mbaminciss();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOTHIHOD");
		    com->code = 641;
		}
		else sprintf(buf,mmb4tabs[1]);
		break;
	case 42:if (flag_help) hproc_ebarb_mbaminciss();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOTHIPRU");
		    com->code = 642;
		}
		else sprintf(buf,mmb4tabs[2]);
		break;
	case 43:if (flag_help) hproc_contour_mbaminciss();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOTHIBOU");
		    com->code = 643;
		}
		else sprintf(buf, mmb4tabs[3]);
		break;
	case 50:if (flag_help) hproc_M_epaiss();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOTHCIPM");
		    com->code = 650;
		}
		else sprintf(buf,mmb5tabs[0]);
		break;
	case 51:if (flag_help) hproc_L_epaiss();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOTHCHOL");
		    com->code = 651;
		}
		else sprintf(buf, mastertabs[99]);
		break;
	case 52:if (flag_help) hproc_D_epaiss();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOTHCHOD");
		    com->code = 652;
		}
		else sprintf(buf, mastertabs[100]);
		break;
	case 53:if (flag_help) hproc_E_epaiss();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOTHCTCE");
		    com->code = 653;
		}
		else sprintf(buf,mmb5tabs[3]);
		break;
	case 54:if (flag_help) hproc_C_epaiss();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOTHCTCC");
		    com->code = 654;
		}
		else sprintf(buf,mmb5tabs[4]);
		break;
	case 61:if (flag_help) hproc_extrem_toutrien();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOEPS");
		    com->code = 661;
		}
		else sprintf(buf,mastertabs[101]);
		break;
	case 62:if (flag_help) hproc_triple_toutrien();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOHMTIPI");
		    com->code = 662;
		}
		else sprintf(buf,mmb6tabs[1]);
		break;
	case 63:if (flag_help) hproc_isole_toutrien();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOHMTTPS");
		    com->code = 663;
		}
		else sprintf(buf,mmb6tabs[2]);
		break;
	case 70:if (flag_help) hproc_cont_hautniv();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOHLTBOU");
		    com->code = 670;
		}
		else sprintf(buf,mmb7tabs[0]);
		break;
	case 71:if (flag_help) hproc_bord_hautniv();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOHLTEBO");
		    com->code = 671;
		}
		else sprintf(buf,mastertabs[102]);
		break;
	case 72:if (flag_help) hproc_trou_hautniv();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOHLTFHO");
		    com->code = 672;
		}
		else sprintf(buf, mmb7tabs[2]);
		break;
	case 73:if (flag_help) hproc_squelhom_hautniv();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOHLTHSK");
		    com->code = 673;
		}
		else sprintf(buf,mmb7tabs[3]);
		break;
	case 74:if (flag_help) hproc_marqhom_hautniv();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOHLTHMA");
		    com->code = 674;
		}
		else sprintf(buf, mmb7tabs[4]);
		break;
	case 75:if (flag_help) hproc_envquasicomp_hautniv();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOHLTPCH");
		    com->code = 675;
		}
		else sprintf(buf, mmb7tabs[5]);
		break;
	case 76:if (flag_help) hproc_envfortcomp_hautniv();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOHLTSCH");
		    com->code = 676;
		}
		else sprintf(buf, mmb7tabs[6]);
		break;
	case 77:if (flag_help) hproc_squelzone_hautniv();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOHLTSZI");
		    com->code = 677;
		}
		else sprintf(buf, mmb7tabs[7]);
		break;
	case 80:if (flag_help) hproc_homotopL_mbamincond();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOCTHHOL");
		    com->code = 680;
		}
		else sprintf(buf, mmb4tabs[0]);
		break;
	case 81:if (flag_help) hproc_homotopD_mbamincond();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOCTHHOD");
		    com->code = 681;
		}
		else sprintf(buf, mmb4tabs[1]);
		break;
	case 82:if (flag_help) hproc_ebarb_mbamincond();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOCTHPRU");
		    com->code = 682;
		}
		else sprintf(buf,"ebarbulage:E");
		break;
	case 90:if (flag_help) hproc_M_epaisscond();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOCTCIPM");
		    com->code = 690;
		}
		else sprintf(buf,mmb5tabs[0]);
		break;
	case 91:if (flag_help) hproc_L_epaisscond();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOCTCHOL");
		    com->code = 691;
		}
		else sprintf(buf,mmb5tabs[1]);
		break;
	case 92:if (flag_help) hproc_D_epaisscond();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOCTCHOD");
		    com->code = 692;
		}
		else sprintf(buf,mmb5tabs[2]);
		break;
	case 93:if (flag_help) hproc_E_epaisscond();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOCTCTCE");
		    com->code = 693;
		}
		else sprintf(buf,mmb5tabs[3]);
		break;
	case 94:if (flag_help) hproc_C_epaisscond();
		if (flag_creer){
		    strcpy(com->nom,"PROBMOCTCTCC");
		    com->code = 694;
		}
		else sprintf(buf,mmb5tabs[4]);
		break;
    }
    if (!flag_creer) write_master(buf);

    switch (no_menu){
        case 1:
	    if (flag_exec==AUTO || flag_exec == FROMTO_AUTO){
		index_image[0] = macro_cour->from[0];
	    }
            else fromto (FROM, DEFAUT);
	    if (flag_break){
		interruption();
		return;
	    }
	    if (flag_creer){
		com->from[0] = index_image[0];
		sprintf (buf, "%s FROM %d", com->nom,index_image[0]);
	    }
	    else{
		sprintf (buf, " %d", index_image[0]);
		write_master (buf);
	    }
            break;
        case 21: case 22: case 23: case 24:
        case 31: case 34:
	    if (flag_exec==AUTO || flag_exec == FROMTO_AUTO){
		index_image[0] = macro_cour->from[0];
		index_image[2] = macro_cour->from[1];
		index_image[1] = macro_cour->to[0];
	    }
            else fromto (FROMTO, DEF21);
	    if (flag_break){
		interruption();
		return;
	    }
	    if (flag_creer){
		com->from[0] = index_image[0];
		com->from[1] = index_image[2];
		com->to[0] = index_image[1];
		sprintf (buf, "%s FROM %d %d TO %d",
		   com->nom,index_image[0],index_image[2],index_image[1]);
	    }
	    else{
		sprintf (buf, " (%d,%d) -->%d ",
			index_image[0],index_image[2],index_image[1]);
		write_master (buf);
	    }
            break;
        default:
	    if (flag_exec==AUTO || flag_exec == FROMTO_AUTO){
		index_image[0] = macro_cour->from[0];
		index_image[1] = macro_cour->to[0];
	    }
            else fromto (FROMTO, DEFAUT);
	    if (flag_break){
		interruption();
		return;
	    }
	    if (flag_creer){
		com->from[0] = index_image[0];
		com->to[0] = index_image[1];
		sprintf (buf, "%s FROM %d TO %d",
		    com->nom,index_image[0], index_image[1]);
	    }
	    else{
		sprintf (buf, " %d --> %d ",
			index_image[0], index_image[1]);
		write_master (buf);
	    }
            break;
    }
    switch (no_menu){
        case 30: case 31: case 33: case 34:
        case 36: case 37: case 40: case 41: case 42:
        case 50: case 51: case 52: case 53: case 54:
        case 80: case 81: case 82: case 90: case 91: case 92: case 93: case 94:
	    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
		taille = ((struct morphobin *)macro_cour->param)->taille;
		sprintf (buf, mastertabs[103], taille);
		write_master (buf);
		taille = ((struct morphobin *)macro_cour->param)->taille;
	    }
            else{
		slider_taille(no_menu);
	    }
	    if (flag_break){
		interruption();
		return;
	    }
	    if (!flag_creer) {
		entree_morpho (no_menu);
	    }
            break;
        case 32: case 35:
	    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
/*	    if (no_menu == 32 || no_menu == 35) */
		taille = ((struct morphobin *)macro_cour->param)->taille;
		angle = ((struct morphobin *)macro_cour->param)->angle;
		sprintf (buf, mastertabs[104], taille, angle);
		write_master (buf);
		taille = ((struct morphobin *)macro_cour->param)->taille;
		angle = ((struct morphobin *)macro_cour->param)->angle;
	    }
            else{
		slider_taille(no_menu);
	    }
	    if (flag_break){
		interruption();
		return;
	    }
	    if (!flag_creer) {
		entree_morpho (no_menu);
	    }
            break;
        default:
	    if (flag_creer) {
		com->param = NULL;
		strcat (buf, "\n");
		write_macro(buf);
	    }
	    else{
		n = entree_morpho (no_menu);
		if (no_menu == 61 || no_menu == 62) 
		    sprintf(buf,mastertabs[105],n);
		else 
		    sprintf(buf,"\n"); 
		write_master (buf);
	    }
            break;
    }
    

}

/*****************************************************************************/
/*									     */
/* nom      : lire_taille						     */
/*									     */
/* fonction : declanche la creation d'une image "binaire" avec un seuil	     */
/*	      contenu dans value.				             */
/*                                                                           */
/* entrees  : panel_item item		: item d'interaction	             */
/*            Evant event	        : evenements		             */
/*                                                                           */
/* globales : Frame frameseuil		: frame du slider		     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : creer_image_bin						     */
/*									     */
/*****************************************************************************/

static Panel_setting lire_taille (item, value, event)
    Panel_item item;
    int value;
    Event *event;

{
    if (item == barre_taille) taille = value;
    if (item == cercle_angle)
	switch (value) {
	    case 0: angle=0;	break;
	    case 1: angle=60;	break;
	    case 2: angle=120;	break;
	    case 3: angle=180;	break;
	    case 4: angle=240;	break;
	    case 5: angle=300;	break;
	}
}


static Panel_setting lire_action (item, event)
    Panel_item	item;
    Event	*event;
{
    char rep[80];

    int no_menu = (int)panel_get (panel_taille, PANEL_CLIENT_DATA);
    if (item == ok_bouton){
	if (flag_creer) {
	    struct morphobin *p;
	    p = (struct morphobin *)malloc(sizeof(*p));
	    com->param = (char *)p;
	    if (no_menu == 32 || no_menu == 35){
		p->taille = taille;
		p->angle = angle;
		strcat (buf, sprintf(rep, " WITH %d %d\n", taille, angle));
	    }
	    else{  		
		p->taille = taille;
		strcat (buf, sprintf(rep, " WITH %d\n", taille));
	    }
	    write_macro(buf);
	}
	else{
	    if (no_menu == 32 || no_menu == 35)
		sprintf (buf, mastertabs[104], taille, angle);
	    else sprintf (buf, mastertabs[103], taille);
	    write_master (buf);
	}
    }
    else {
       flag_break = TRUE;
    }
    window_return ();
    window_destroy (frame_taille);
    return;
}

/*****************************************************************************/
/*                							     */
/* nom      : slider_taille						     */
/*									     */
/* fonction : initialisation d'un panneau contenant un "slider" pour         */
/*	      lire une taille (morphologie)				     */
/*									     */
/* entrees  : int vmin			: valeur minimum du slider           */
/*	      int vmax                  : valeur maximum du slider	     */
/*	      int vmoy			: valeur initiale du slider          */
/*									     */
/* globales : neant						             */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : neant							     */
/*								             */
/*****************************************************************************/

int slider_taille(no_menu)
    int no_menu;
{
    int	x_ok, y_ok, x_quit, y_quit;

    frame_taille = window_create(frame, FRAME, WIN_X, 500, WIN_Y, 500,
			FRAME_NO_CONFIRM, TRUE, 0);
    panel_taille = window_create(frame_taille, PANEL,
                        PANEL_LABEL_BOLD, TRUE, 
                        PANEL_CLIENT_DATA, no_menu, 0);

    barre_taille = panel_create_item (panel_taille, PANEL_SLIDER,
                       PANEL_LABEL_STRING, paneltabs[211],
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_MIN_VALUE, -1,
		       PANEL_MAX_VALUE, 20,
                       PANEL_SLIDER_WIDTH, 300,
                       PANEL_NOTIFY_PROC, lire_taille,
                       0);
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO){
	taille = ((struct morphobin *)(macro_cour->param))->taille;
	panel_set_value (barre_taille, taille);
    }
    else {
	taille = 1;
	panel_set_value (barre_taille, 1);
    }

    if (no_menu == 32 || no_menu == 35) {
        cercle_angle = panel_create_item (panel_taille, PANEL_CHOICE,
            PANEL_CHOICE_STRINGS, "0", "60", "120", "180", "240", "300", 0,
            PANEL_MARK_IMAGES,  &dial_0_pr,   &dial_60_pr,  &dial_120_pr, 
				&dial_180_pr, &dial_240_pr, &dial_300_pr, 0,
            PANEL_NOMARK_IMAGES, 0,
            PANEL_CHOICE_XS, 215, 195, 122, 100, 122, 195, 0,
            PANEL_CHOICE_YS, 72, 33, 33, 72, 111, 111, 0,
            PANEL_MARK_XS, 136, 0,
            PANEL_MARK_YS, 45, 0,
            PANEL_LABEL_STRING, "Angle",
            PANEL_LABEL_X, 10,
            PANEL_LABEL_Y, 20,
	    PANEL_NOTIFY_PROC, lire_taille,
            0);
            window_fit (cercle_angle);
	if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO){
	    angle = ((struct morphobin *)(macro_cour->param))->angle;
	    panel_set_value (cercle_angle, (int)(angle % 60));
	}
	else {
	    angle = 0;
	    panel_set_value (cercle_angle, 0);
	}
	x_ok = 300;    y_ok = 50;
	x_quit = 300;  y_quit = 80;
    }
    else { 
	cercle_angle = NULL;
	x_ok = 125;    y_ok = 30;
	x_quit = 225;  y_quit = 30;
    }
    ok_bouton = panel_create_item (panel_taille, PANEL_BUTTON,
	    PANEL_NOTIFY_PROC, lire_action,
	    PANEL_LABEL_IMAGE, panel_button_image (panel_taille, "OK",7,0),
	    PANEL_ITEM_X, x_ok, PANEL_ITEM_Y, y_ok,
	    0);
    quit_bouton = panel_create_item (panel_taille, PANEL_BUTTON,
	    PANEL_NOTIFY_PROC, lire_action,
	    PANEL_LABEL_IMAGE, panel_button_image (panel_taille, "Cancel",7,0),
	    PANEL_ITEM_X, x_quit, PANEL_ITEM_Y, y_quit,
	    0);
    window_fit (ok_bouton);
    window_fit (quit_bouton);
    window_fit (panel_taille);
    window_fit (frame_taille);
    window_loop (frame_taille);
}

/*****************************************************************************/
/*  MORPHOLOGIE A NIVEAUX DE GRIS                                            */
/*****************************************************************************/

Frame       frame_elem, frame_elstruct;
Panel       panel_elem, panel_elstruct;
Panel_item  elem_rayon, elem_hauteur, elem_amplitude, elem_sigmax, elem_sigmay;
Panel_item  elstruct;

extern	Menu	mchoixelem;
extern	void	    entree_morpho_nivgris();

/*****************************************************************************/

static Panel_setting lire_elem (item, event)
    Panel_item item;
    Event *event;

{
    static struct element elem;
    int i;
    float f;

    if (event_id(event) == CTRLC) {
        /* demande d'interruption de l'interaction par l'utilisateur */
	flag_break = TRUE;
        window_return (NULL);
        window_destroy (frame_elem);
        return;
    }
    else { 
	if (event_id(event) == '\t')
	    return (PANEL_NEXT);
	else{
	    if (elem_rayon != NULL) 
		elem.param1=(short)atoi((char *)panel_get_value(elem_rayon));
	    if (elem_hauteur != NULL) 
		elem.param2=(short)atoi((char *)panel_get_value(elem_hauteur));
	    if (elem_amplitude != NULL) 
		elem.param3 = atof((char *)panel_get_value (elem_amplitude));
	    if (elem_sigmax != NULL) 
		elem.param4 = atof((char *)panel_get_value (elem_sigmax));
	    if (elem_sigmay != NULL) 
		elem.param5 = atof((char *)panel_get_value (elem_sigmay));
	    window_return(&elem);
	    window_destroy (frame_elem);
	    return;
	}
    }
}

/*****************************************************************************/

struct element *choix_elem_panel(type_elem)

short type_elem;

{
    Panel_item titre;
    char stitre[40];
    char *rep;
    struct element *elem;

    elem_rayon = elem_hauteur = elem_amplitude = elem_sigmax = elem_sigmay
    = NULL;
    if ((flag_exec == MANUEL || flag_exec == FROMTO_AUTO) &&
    type_elem == (short)((struct element *)macro_cour->param)->type) 
	elem = (struct element *)macro_cour->param;
    else elem = NULL;
    frame_elem = window_create (frame, FRAME, WIN_X, 500, WIN_Y, 500,
                         FRAME_NO_CONFIRM, TRUE, 0);
    panel_elem = window_create (frame_elem, PANEL, PANEL_LABEL_BOLD,
			 TRUE, 0);
    rep = (char *)malloc(20);
    strcpy (rep, "");

    strcpy (stitre, "Element structurant: ");
    switch (type_elem) {
	case 0 : strcat (stitre, "SPHERE\n"); break; 
	case 1 : strcat (stitre, "CONE\n"); break; 
	case 2 : strcat (stitre, paneltabs[212]); break;
	case 3 : strcat (stitre, paneltabs[213]); break;
    }
    titre = panel_create_item (panel_elem, PANEL_MESSAGE,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(0),
		       PANEL_LABEL_Y, ATTR_ROW(0),
                       PANEL_LABEL_STRING, stitre,
                       0);
    if (type_elem == 3){
        elem_amplitude = panel_create_item (panel_elem, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(2),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[221],
                       PANEL_VALUE, (elem != NULL ? 
		       (char *)sprintf(rep,"%f",elem->param3) : ""),
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_elem,
                       0);
        elem_sigmax  = panel_create_item (panel_elem, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(3),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[214],
                       PANEL_VALUE, (elem != NULL ? 
		       (char *)sprintf(rep,"%f",elem->param4) : ""),
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_elem,
                       0);
        elem_sigmay  = panel_create_item (panel_elem, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(4),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[215],
                       PANEL_VALUE, (elem != NULL ? 
		       (char *)sprintf(rep,"%f",elem->param5) : ""),
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_elem,
                       0);
    }
    else{
	elem_rayon = panel_create_item (panel_elem, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(2),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[216],
                       PANEL_VALUE, (elem != NULL ? 
		       (char *)sprintf(rep,"%d",elem->param1) : ""),
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_elem,
                       0);
	if (type_elem == 1 || type_elem == 2) 
	    elem_hauteur = panel_create_item (panel_elem, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(3),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[217],
                       PANEL_VALUE, (elem != NULL ? 
		       (char *)sprintf(rep,"%d",elem->param2) : ""),
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_elem,
                       0);
    }
    window_fit (panel_elem);
    window_fit (frame_elem);
    if (type_elem == 3)
	window_set (panel_elem, PANEL_CARET_ITEM, elem_amplitude, 0);
    else
	window_set (panel_elem, PANEL_CARET_ITEM, elem_rayon, 0);
    elem = (struct element *)window_loop(frame_elem);
    return (elem);
}
/*****************************************************************************/

static Panel_setting lire_elstruct (item, value, event)
    Panel_item	item;
    int		value;
    Event	*event;

{
    if (event_id(event) == CTRLC) {
	flag_break == TRUE;
	window_return (value);
	window_destroy (frame_elstruct);
    }
    if (event_id(event) == MS_LEFT || event_id(event) == 13){
	window_return (value);
	window_destroy (frame_elstruct);
    }
}

/*****************************************************************************/

int choix_elstruct_panel(type_def)
    int type_def;
{
    Panel_item titre;
    char stitre[40];

    frame_elstruct = window_create (frame, FRAME, WIN_X, 500, WIN_Y, 500,
                        FRAME_NO_CONFIRM, TRUE, WIN_CONSUME_PICK_EVENTS,
			WIN_MOUSE_BUTTONS, WIN_ASCII_EVENTS, 0,
			0);
    panel_elstruct = window_create (frame_elstruct, PANEL, PANEL_LABEL_BOLD,
			 TRUE, 0);
    elstruct = panel_create_item (panel_elstruct, PANEL_CHOICE,
		    PANEL_LABEL_STRING, paneltabs[218],
		    PANEL_LAYOUT, PANEL_VERTICAL,
		    PANEL_CHOICE_STRINGS, "Sphere", "Cone", paneltabs[219],
					  paneltabs[220], "Image", 0,
		    PANEL_VALUE, (int)(type_def==10 ? 4 : type_def),
		    PANEL_NOTIFY_PROC, lire_elstruct,
		    0);    
    window_fit (panel_elstruct);
    window_fit (frame_elstruct);
    type_def = (int) window_loop (frame_elstruct);
    return ((int)(type_def==4 ? 10 : type_def));
}

/*****************************************************************************/

caddr_t proc_choix_elem (m, mi)
    Menu m;
    Menu_item mi;

{
    struct element *elem, *copyelem;
    char rep[80];
    int choix, choixelem, val;
    short *image;

    val = (int)menu_get(mi, MENU_VALUE);

    if (!flag_creer){ /* ecrire l'operation + choix eventuel elem struct */
        if (flag_exec == OFF)
	    sprintf (buf,(char *)menu_get((Menu_item)menu_get(m, MENU_PARENT), 
				    MENU_STRING));    /* nom de l'operation */
	else {
	    sprintf (buf,(char *)menu_get(mi, MENU_STRING));
	    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO){
		/* choix de l'element structurant */
		choixelem = choix_elstruct_panel
			    (((struct element *)macro_cour->param)->type);
	    }
	    else choixelem = ((struct element *)macro_cour->param)->type;
	    val = choixelem;
	    if (flag_break) {
		interruption();
		return;
	    }
	    switch (choixelem){
		case 0: mi = menu_get(mchoixelem,MENU_NTH_ITEM,2); break;
		case 1: mi = menu_get(mchoixelem,MENU_NTH_ITEM,3); break;
		case 2: mi = menu_get(mchoixelem,MENU_NTH_ITEM,4); break;
		case 3: mi = menu_get(mchoixelem,MENU_NTH_ITEM,5); break;
		case 10:mi = menu_get(mchoixelem,MENU_NTH_ITEM,6); break;
	    }
	}
	switch (*buf) {
	    case 'e' : choix = 10; break;
	    case 'd' : choix = 11; break;
	    case 'o' : choix = 12; break;
	    case 'f' : choix = 13; break;
	    case 'c' : choix = 13; break; /* anglais => closure */
	}
	write_master (buf);
	    if (flag_help || flag_bother){
		switch (val){
		    case 0:switch (*buf){
			    case 'e': hproc_erode_sphere();
					break;
			    case 'd':hproc_dilate_sphere();
					break;
			    case 'o':hproc_ouverture_sphere();
					break;
			    case 'f':
			    case 'c':hproc_fermeture_sphere();
					break;
			    }
			    break;
		    case 1:switch (*buf){
			    case 'e':hproc_erode_cone();
					break;
			    case 'd':hproc_dilate_cone();
					break;
			    case 'o':hproc_ouverture_cone();
					break;
			    case 'f':
			    case 'c':hproc_fermeture_cone();
					break;
			   }
			   break;
		    case 2:switch (*buf){
			    case 'e': hproc_erode_cylinder();
					break;
			    case 'd': hproc_dilate_cylinder();
					break;
			    case 'o':hproc_ouverture_cylinder();
					break;
			    case 'f':
			    case 'c':hproc_fermeture_cylinder();
					break;
			   }
			   break;
		    case 3:switch (*buf){
			    case 'e': hproc_erode_gauss();
					break;
			    case 'd':hproc_dilate_gauss();
					break;
			    case 'o':hproc_ouverture_gauss();
					break;
			    case 'f': hproc_fermeture_gauss();
			    case 'c':
					break;
			    }
			    break;
		    case 10:switch (*buf){
			    case 'e': hproc_erode_plan_image(); 
					break;
			    case 'd': hproc_dilate_plan_image(); 
					break;
			    case 'o':hproc_ouverture_plan_image(); 
					break;
			    case 'f':
			    case 'c':hproc_fermeture_plan_image(); 
					break;
			    }
			    break;
		}
		if (flag_bother) return;
	    }			    
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	elem = (struct element *)malloc(sizeof(*elem));
	*elem = *((struct element *)macro_cour->param);	
    }
    else{
	if ((short)menu_get(mi, MENU_VALUE) == 10) {
	    fromto(FROM, CONDI);
/*	    if (dir_desc[index_image[0]].type > 1){
		write_erreur(18);
		return;
	    }
*/
	    elem = (struct element *) malloc (sizeof (*elem));
	    elem->type = 10;
	    elem->param1 = (short)index_image[0];
	}
	else {
	    elem = (struct element *)choix_elem_panel
				 ((short)menu_get(mi, MENU_VALUE));
	    if (flag_break== FALSE) elem->type=(short)menu_get(mi, MENU_VALUE);
	}
    }
    if (flag_break) interruption();
    else {
	if (!flag_creer){
	    switch (elem->type){
	    case 0: sprintf (buf, mastertabs[106], elem->param1);
		break;
	    case 1: sprintf (buf, mastertabs[107],
			 elem->param1, elem->param2);  break;
	    case 2: sprintf (buf, mastertabs[108],
			 elem->param1, elem->param2);  break;
	    case 3: sprintf (buf, mastertabs[109],elem->param3, elem->param4, elem->param5);  break;
	    case 10: sprintf (buf, mastertabs[110], elem->param1); 
		break;
	    }
	    write_master (buf);
	}
	if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	    index_image[0] = macro_cour->from[0];
	    index_image[1] = macro_cour->to[0];
	}
	else fromto (FROMTO, DEFAUT);
	if (flag_break){
	    interruption();
	    return;
	}
	if (!flag_creer){    
/*	    if (dir_desc[index_image[0]].type > 1){
		write_erreur(18);
		return;
	    }
	    else {
*/
		sprintf(buf, " %d --> %d\n", 
			index_image[0], index_image[1]);    
		write_master (buf);
		entree_morpho_nivgris(choix,
		/*
		(int)menu_get((Menu_item)menu_get(m, MENU_PARENT), MENU_VALUE),
		*/
		index_image[0], index_image[1], elem);    
/*	    } */
	}
	else {
	    struct commande *com;
	    com = (struct commande *)new_commande(&macro_cour);
	    sprintf (buf,(char *)menu_get((Menu_item)menu_get(m, MENU_PARENT), 
				    MENU_STRING));    /* nom de l'operation */
	    com->from[0] = index_image[0];
	    com->to[0] = index_image[1];
	    switch (*buf){
		case 'e' : strcpy (com->nom, "PROGSMERO");
			   com->code = 160;
			   strcpy (buf, "PROGSMERO");
			   break;
		case 'd' : strcpy (com->nom, "PROGSMDIL");
			   com->code = 161;
			   strcpy (buf, "PROGSMDIL");
			   break;
		case 'o' : strcpy (com->nom, "PROGSMOPE");
			   com->code = 162;
			   strcpy (buf, "PROGSMOPE");
			   break;
		case 'c' :
		case 'f' : strcpy (com->nom, "PROGSMCLO");
			   com->code = 163;
			   strcpy (buf, "PROGSMCLO");
			   break;
	    }
	    strcat (buf, sprintf (rep, " FROM %d TO %d ", 
		    index_image[0], index_image[1]));
	    switch (menu_get(mi, MENU_VALUE)){
		case 0: strcat (buf, sprintf (rep, "WITH SP %d\n",
				elem->param1));
			break;
		case 1: strcat (buf, sprintf (rep, "WITH CO %d %d\n",
				elem->param1, elem->param2));
			break;
		case 2: strcat (buf, sprintf (rep, "WITH CY %d %d\n",
				elem->param1, elem->param2));
			break;
		case 3: strcat (buf, sprintf (rep, "WITH IM %f %f %f\n",
				elem->param3, elem->param4, elem->param5));
			break;
	    }
	    write_macro(buf);
	    copyelem = (struct element *)malloc(sizeof(*copyelem));
	    *copyelem = *elem;
	    com->param = (char *)copyelem;
	}
    }
}

/*****************************************************************************/
/*  GENERATION D'IMAGES                                                      */
/*****************************************************************************/

extern void saisie_pts();
extern void entree_gen();
extern void cree_fenetre_mono();

caddr_t proc_gen (m, mi)
    Menu m;
    Menu_item mi;

{
    int no_menu = (int)menu_get (mi, MENU_VALUE);
    entree_gen (no_menu);
}

