/****************************************************************************/
/* module gel1D_in.c							     */
/*									     */
/* Author: Thierry PUN, Krassimir TODOROV				     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   August 1989							     */
/* Modifications:							     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
#include <suntool/sunview.h>
#include <suntool/textsw.h>
#include <suntool/panel.h>
#include <suntool/canvas.h>
#include <suntool/scrollbar.h>
#include <pixrect/pr_line.h>
#include <stdio.h>
#include <memory.h>
#include <malloc.h>
#include <math.h>

#include "define.h"
#include "global.h"
#include "structure.h"
#include "type.h"

#include "gel1D.h"

#define NO_RAM 1
#define HEIGHT_MAX 530
#define WIDTH_MAX 800

#define MY_DEBUG
/* #define TEST */

#ifdef MY_DEBUG
#define Point(X,Y) { pw_put(gel_pixwin,X,Y,pw_get(gel_pixwin,X,Y)^0x80);}
static void
Stop()
{
    int             I = 0;
}
#define Test_Error(error)				    \
{if (error) {fprintf(stderr,"%cERROR (error) at line %d in %s!\n",  \
		    7,__LINE__,__FILE__); Stop();}}
#else
#define Test_Error(error)
#define Point(X,Y)
#endif

#define Adresse(x,y) (y * PrXMax + x)

#define free_if(x) if (x)		\
			{			\
			    free((char *)x);	\
			    x = NULL;		\
			}

#define mPolynome_3(Y, Adr)			\
    ((((* Adr * Y ) + *( Adr +1)) * Y + *( Adr +2)) * Y + *( Adr +3))



extern Pixrect Mouse_Left_Pixrect_Icon, Mouse_Mid_Pixrect_Icon,
	       Mouse_Right_Pixrect_Icon;

short           gel_cursor_mire[] = {
#include "icon/graphics.cursor"
};
mpr_static(cursor_image_mire, 16, 16, 1, gel_cursor_mire);


short      gel1d_icon_image[] = {
#include "icon/gel1d.icon"
};
mpr_static(icongel1d, 64, 64, 1, gel1d_icon_image);


/*short           Mouse_Left_Pixrect_Data_Icon[] = {
#include "icon/mouse_left.icon"
};
mpr_static(Mouse_Left_Pixrect_Icon, 16, 16, 1, Mouse_Left_Pixrect_Data_Icon);

short           Mouse_Mid_Pixrect_Data_Icon[] = {
#include "icon/mouse_mid.icon"
};
mpr_static(Mouse_Mid_Pixrect_Icon, 16, 16, 1, Mouse_Mid_Pixrect_Data_Icon);

short           Mouse_Right_Pixrect_Data_Icon[] = {
#include "icon/mouse_right.icon"
};
mpr_static(Mouse_Right_Pixrect_Icon, 16, 16, 1, Mouse_Right_Pixrect_Data_Icon); */



extern  Menu	mgel1dtool, mgel1_1, mgel1_2, mgel1_3, mgel1_4, mgel1_cor1;
extern  Menu    mprincipal;
extern  Textsw  master;
extern char *buttontabs[];
extern Frame menu_frame;
extern Panel menu_win;

Panel menu_gel1d_tool;
Panel_item geltool_title, menu_button, quit_button;
void handle_gel1dtool();

extern void profil_Notify_Proc();
/* extern	char	*buf; */

struct fname *fname_panel();

#ifdef TEST
static int Dumped;
#endif

int PrXMax, PrYMax, Prplan;
float *PrHistogr, *PrHist_Aff, *Largeurs;
int Ideal_espace = 10, Ideal_largeur, Profil_Aff_1;
int Pro_Height, Pro_Offset, regime_corr, X_Move, N_Points;
char Str_x[100], *Courbe_Affichee;
Pixwin *gel_pixwin, *pro_pixwin;
Frame gel_frame;
unsigned short *Frontieres_Preest;
float *Coefficients;
int Nearest;
Panel_item Matiere_item;
Gel_Pic_type *Gel_Pics_List, **Dir_Pics;
Gel_Global_type Gel_Global;

static short *Matiere_Condensee;
static float   Coeff_L[4], Coeff_R[4], Coeff_M[4], *AdrCoeff, *Milieux_2;
static Frame frame_in;
static Canvas gel_canvas, pro_canvas;
static Pixrect *gel_pixrect, *pro_pixrect;
static Panel panel_in;
static Panel_item Npanel;
static Flag_Plus_1;
static int New_RAM, X_Undo, N_Undo, Premier_Calcul;
static Scrollbar scrollbar_h, scrollbar_v;
static Cursor gel_cursor;
static char Map[256], Map_Color[3][256];
static unsigned char *VIRAM, *ADR_VIRAM;
static int *Ligne_de_Travail_i, X_Down, Y_Down;
static unsigned short *Polynomes_Milieux, *Frontieres;
static unsigned short *X_Milieux, Point_X[30], Point_Y[30];
static float   *T_Gliss_Res, Float_Max, Float_Min, *T_valeurs;
static int      n_left, n_right, Sigma_L, Sigma_R;
static float   Sigma_L_2_d, Sigma_R_2_d;
static int      Sigma_L_2_i, Sigma_R_2_i;
       float Matrice_4[4][5];
static float Matrice_Save[4][5], Coeff_Undo[4];
static Panel_item Help1, Help2, Help31, Help32, Help33;


extern char *mastertabs[];
extern char *paneltabs[];

struct commande *com;

void Creer_Frame();
void Centrer_Frame();

extern void hproc_gel1DTool();
extern void hproc_write_gel1D();
extern void hproc_read_gel1D();
extern void hproc_affiche_gel1D();
extern void hproc_gel_donnees_init();
extern void hproc_gel_lisser();
extern void hproc_gel_calculFrontPreEst();
extern void hproc_gel_affichFrontPreEst();
extern void hproc_gel_affichFrontPrecises();
extern void hproc_gel_calculProfilBand();
extern void hproc_gel_affichGelIdeal();
extern void hproc_gel_affichGelIdeal();
extern void hproc_gel_GelUnprofil();
extern void hproc_gel_AjoutBand_CorrectMan();
extern void hproc_gel_SupprimeBand_CorrectMan();
extern void hproc_gel_DeplaceFrontiere_CorrectMan();


/*****************************************************************************/

static void
Fleche(X,Y)
int X, Y; 
{
    if (window_get(gel_frame,WIN_SHOW) == FALSE)
	return;
    pw_batch_on(gel_pixwin);
    pw_vector(gel_pixwin,X,Y-1,X+5,Y-1,PIX_SRC^PIX_DST,128);
    pw_vector(gel_pixwin,X,Y,X+7,Y,PIX_SRC^PIX_DST,128);
    pw_vector(gel_pixwin,X,Y+1,X+5,Y+1,PIX_SRC^PIX_DST,128);
    pw_batch_off(gel_pixwin);
}

/*****************************************************************************/

static void
Free_Pointers(N)
int N;
{
    switch (N) {
	case 0 :
	    free_if(Frontieres_Preest);
	case 1 :
	    free_if(Coefficients);
	    free_if(Matiere_Condensee);
	    free_if(Frontieres);
	case 2 :
	    free_if(PrHistogr);
	    free_if(PrHist_Aff);
	    free_if(Largeurs);
    }
    Gel_Global.Total_Pics = 0;
    free_if(Ligne_de_Travail_i);
    free_if(Polynomes_Milieux);
    free_if(X_Milieux);
    free_if(T_Gliss_Res);
    free_if(T_valeurs);
    free_if(Milieux_2);
    free_Gel_Pics_List();
/*    Courbe_Affichee = NULL; */
    Profil_Aff_1 = -1;
    Gel_Global.Lissage = 0;
}

/*****************************************************************************/

static void
Free_Image()
{
    free_if(VIRAM);
    if (New_RAM && Flag_Plus_1)
	free_if(ADR_VIRAM);
    ADR_VIRAM = NULL;
    New_RAM = 0;
    Flag_Plus_1 = 0;
    dir_image[Prplan].image = NULL;
    Prplan = -1;
}

/*****************************************************************************/

static void
Test_VIRAM_Pair()
{
    unsigned char *Adrs, *Adrd, *Adr;
    int X, Y, PrXM = PrXMax;
    if ((ADR_VIRAM != NULL) && New_RAM)
	free_if(ADR_VIRAM);
    if (PrXMax & 1)
    	PrXM ++;
    Adrs = (unsigned char *)VIRAM;
    Adrd = ADR_VIRAM = (unsigned char *)malloc(PrXM*PrYMax);
    if (Adrd == NULL)
    {
    	write_erreur(22);
	New_RAM = 0;
	return;
    }
    else
    {
	New_RAM = 1;
	for (Y = 0 ; Y < PrYMax ; Y++)
	{
	    memcpy(Adrd,Adrs,PrXMax);
	    for (X = 0 , Adr = Adrd ; X < PrXMax ; X++ , Adr++)
	    	(*Adr )--;
	    Adrs += PrXMax;
	    Adrd += PrXMax;
	    if (PrXM != PrXMax)
	    {
	    	*Adrd = 255;
	    	Adrd ++;
	    }
	}
    }
}

/*****************************************************************************/

static void
lecture_gel1d(fn)
struct fname *fn;
{
    FILE *F;
    int Res;
    Res = read_desc(fn->fpdesc, &desc);
    switch (Res){
      case -1: write_erreur(104);
                 return;
      case 0: write_erreur(103);
                 return;
    }
    if (desc.type) {
	write_erreur(953);
	return;
    }
    /*
    if (fread(&desc,sizeof(desc),1,fn->fpdesc) != 1)
    {
	write_erreur(953);
	return;
    }
    */
    Free_Pointers(0);
    Courbe_Affichee = NULL;
    Free_Image();
    Prplan = index_image[1];
    dir_desc[Prplan].type = desc.type;
    dir_desc[Prplan].nligne = desc.nligne;
    strcpy(dir_desc[Prplan].filename,fn->filename);
    PrYMax = desc.nligne;
    dir_desc[Prplan].ncolonne = desc.ncolonne;
    PrXMax = desc.ncolonne;
    strcpy(dir_desc[Prplan].date,desc.date);
    dir_desc[Prplan].mmax = desc.maxi[0];
    dir_desc[Prplan].mmin = desc.mini[0];
    dir_desc[Prplan].mu = desc.mu[0];
    dir_desc[Prplan].ecart = desc.ecart[0];
    strcpy(dir_desc[Prplan].comment,desc.comment);
    VIRAM = (unsigned char*)malloc(PrXMax * PrYMax);
    if (VIRAM == NULL)
    {
	write_erreur(900);
	return;
    }
    dir_image[Prplan].image = VIRAM;
    if (fread(VIRAM,PrXMax * PrYMax, 1, fn->fpim) != 1)
    {
	Free_Image();
	write_erreur(953);
	return;
    }
    Test_VIRAM_Pair();
    sprintf(Str_x,"%s.gel",fn->filename);
    F = fopen(Str_x,"rb");
    if (F == NULL)
    {
	Free_Image();
	write_erreur(958);
	return;
    }
    if (fread(&Gel_Global,sizeof(Gel_Global), 1, F) != 1)
    {
	Free_Image();
	fclose(F);
	write_erreur(953);

	return;
    }
    Frontieres_Preest = (unsigned short *)malloc((Gel_Global.N_Bandes<<1)*sizeof(short));
    if (Frontieres_Preest == NULL)
    {
	Free_Image();
	fclose(F);
	write_erreur(900);
	return;
    }
    if (fread(Frontieres_Preest,(Gel_Global.N_Bandes<<1)*sizeof(short), 
		1, F) != 1)
    {
	Free_Image();
	fclose(F);
	write_erreur(953);
	return;
    }
    Frontieres = (unsigned short *)
		    malloc(PrYMax*(Gel_Global.N_Bandes<<1)*sizeof(short));
    if (Frontieres == NULL)
    {
	Free_Image();
	fclose(F);
	write_erreur(900);
	return;
    }
    if (fread(Frontieres,(Gel_Global.N_Bandes<<1)*sizeof(short)*PrYMax, 
		1, F) != 1)
    {
	Free_Image();
	fclose(F);
	write_erreur(953);
	return;
    }
    Coefficients = (float *)malloc((Gel_Global.N_Bandes<<3)*sizeof(float));
    if (Coefficients == NULL)
    {
	Free_Image();
	fclose(F);
	write_erreur(900);
	return;
    }
    if (fread(Coefficients,(Gel_Global.N_Bandes<<3)*sizeof(float), 
		1, F) != 1)
    {
	Free_Image();
	fclose(F);
	write_erreur(953);
	return;
    }
    Matiere_Condensee = (short *)malloc(Gel_Global.N_Bandes*sizeof(short)*PrYMax);
    if (Matiere_Condensee == NULL)
    {
	Free_Image();
	fclose(F);
	write_erreur(900);
	return;
    }
    if (fread(Matiere_Condensee,Gel_Global.N_Bandes*sizeof(short)*PrYMax, 
		1, F) != 1)
    {
	Free_Image();
	fclose(F);
	write_erreur(953);
	return;
    }
    PrHistogr = (float *)malloc(Gel_Global.N_Bandes*sizeof(float)*PrYMax);
    if (PrHistogr == NULL)
    {
	Free_Image();
	fclose(F);
	write_erreur(900);
	return;
    }
    if (fread(PrHistogr,Gel_Global.N_Bandes*sizeof(float)*PrYMax, 
		1, F) != 1)
    {
	Free_Image();
	fclose(F);
	write_erreur(953);
	return;
    }
    Largeurs = (float *)malloc(Gel_Global.N_Bandes*sizeof(float)*PrYMax);
    if (Largeurs == NULL)
    {
	Free_Image();
	fclose(F);
	write_erreur(900);
	return;
    }
    if (fread(Largeurs,Gel_Global.N_Bandes*sizeof(float)*PrYMax, 
		1, F) != 1)
    {
	Free_Image();
	fclose(F);
	write_erreur(953);
	return;
    }
    PrHist_Aff = (float *)malloc(Gel_Global.N_Bandes*sizeof(float)*PrYMax);
    if (PrHist_Aff == NULL)
    {
	Free_Image();
	fclose(F);
	write_erreur(900);
	return;
    }
    if (Gel_Global.Lissage)
    {
	int L = Gel_Global.Lissage;
	Gel_Global.Lissage = -1;
	Proc_Lissage_Gel(L);
    }
    else
	memcpy(PrHist_Aff, PrHistogr, Gel_Global.N_Bandes*sizeof(float)*PrYMax);
    if (Gel_Global.Total_Pics)
	Read_Pics(F);
    fclose(F);
    Creer_Frame(0);
    Update_Menu_Active();
}

/*****************************************************************************/

void 
Clear_Help()
{
    if (gel_frame == NULL)
	return;
    panel_set(Help1,PANEL_LABEL_STRING," ",0);
    panel_set(Help2,PANEL_LABEL_STRING," ",0);
    panel_set(Help31,PANEL_LABEL_STRING," ",0);
    panel_set(Help32,PANEL_LABEL_STRING," ",0);
    panel_set(Help33,PANEL_LABEL_STRING," ",0);
}

/*****************************************************************************/

caddr_t
read_gel1d_proc(m , mi)
    Menu m;
    Menu_item mi;
{
    struct fname *fn, *copyfn;

    
    if (flag_bother){
	hproc_read_gel1d();
	return;
    }
    if (flag_help) hproc_read_gel1d();
    if (!flag_creer) {
	if (Frontieres_Preest != NULL)
	    if (!Confirm(paneltabs[91]))
		return((caddr_t)0);
	Clear_Help();
	Nearest = -1;
	regime_corr = 0;
	X_Move = -1;
	N_Points = -1;
	sprintf (buf, mastertabs[50]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	char *filen;
	filen = (char *)malloc(60);
	fn = (struct fname *)macro_cour->param;
	fn->fpim = fopen (sprintf(filen,"%s.ima",fn->filename), "r"); 
	fn->fpdesc = fopen (sprintf(filen,"%s.desc",fn->filename), "r"); 
    }
    else
	fn = fname_panel(paneltabs[92], paneltabs[93], 10);
    if (flag_break) 
    {
	interruption();
	return((caddr_t)0);
    }
    if ((flag_exec == AUTO) || (flag_exec == FROMTO_AUTO))
	index_image[1] = macro_cour->to[0];
    else
	fromto(TO,DEFAUT);
    if (flag_break) 
    {
	if (fn->fpim != NULL)
	    fclose(fn->fpim);
	if (fn->fpdesc != NULL)
	    fclose(fn->fpdesc);
	interruption();
	return((caddr_t)0);
    }
    if (flag_creer)
    {
	struct commande *com;
	char filename[60];
/*	    strcpy (filename, fn->filename);
	    strcat (filename, ".desc"); */
	com = (struct commande *)new_commande (&macro_cour);
	com->code = 993;
	strcpy (com->nom, "GEL1DGET"); 
	com->to[0] = index_image[1];
	sprintf (buf, "GEL1DGET TO %d WITH %s\n", 
			     index_image[1], fn->filename);
	write_macro (buf);
	fn->fpim = fn->fpdesc = NULL;
	copyfn = (struct fname *)malloc(sizeof(*copyfn));
	*copyfn = *fn;
	com->param = (char *)copyfn;
    }
    else
    {
	sprintf(buf,mastertabs[51],fn->filename,
		index_image[1]);
	write_master(buf);
	if (fn->fpdesc != NULL && fn->fpim != NULL){
	    lecture_gel1d(fn);
	    fclose (fn->fpim);
	    fclose (fn->fpdesc);
	}
	else 
	    write_erreur (20);
    }
}

/*****************************************************************************/

static void
sauve_gel1d()
{
    int Res;
    FILE *F;
    if (dir_image[Prplan].image == NULL)
    {
	write_erreur(1);
	return;
    }
    if (Frontieres_Preest == NULL)
    {
	write_erreur(955);
	return;
    }
    if (Gel_Global.N_Bandes < 1)
    {
	write_erreur(954);
	return;
    }
    if (Coefficients == NULL)
    {
	write_erreur(956);
	return;
    }
    if (PrHistogr == NULL)
    {
	write_erreur(957);
	return;
    }
    sprintf(Str_x,"%s.gel",dir_desc[Prplan].filename);
    F = fopen(Str_x,"wb");
    Res = fwrite(&Gel_Global,sizeof(Gel_Global),1,F);
    if (Res != 1)
    {
	write_erreur(952);
	fclose(F);
	return;
    }
    Res = fwrite(Frontieres_Preest,(Gel_Global.N_Bandes << 1)*sizeof(short),
	    1, F);
    if (Res != 1)
    {
	write_erreur(952);
	fclose(F);
	return;
    }
    Res = fwrite(Frontieres,PrYMax*(Gel_Global.N_Bandes<<1)*sizeof(short),
	    1, F);
    if (Res != 1)
    {
	write_erreur(952);
	fclose(F);
	return;
    }
    Res = fwrite(Coefficients,(Gel_Global.N_Bandes << 3)*sizeof(float),
	    1, F);
    if (Res != 1)
    {
	write_erreur(952);
	fclose(F);
	return;
    }
    Res = fwrite(Matiere_Condensee,Gel_Global.N_Bandes*sizeof(short)*PrYMax,1, F);
    if (Res != 1)
    {
	write_erreur(952);
	fclose(F);
	return;
    }
    Res = fwrite(PrHistogr,Gel_Global.N_Bandes*sizeof(float)*PrYMax,1, F);
    if (Res != 1)
    {
	write_erreur(952);
	fclose(F);
	return;
    }
    Res = fwrite(Largeurs,Gel_Global.N_Bandes*sizeof(float)*PrYMax,1, F);
    if (Res != 1)
    {
	write_erreur(952);
	fclose(F);
	return;
    }
    if (Gel_Global.Total_Pics)
	Write_Pics(F);
    fclose(F);
}

/*****************************************************************************/

caddr_t
write_gel1d_proc(m, mi)
    Menu m;
    Menu_item mi;
{
    
    if (flag_bother){
	hproc_write_gel1d();
	return;
    }
    if (flag_help) hproc_write_gel1d();
    if (!flag_creer) {
	Clear_Help();
	Nearest = -1;
	regime_corr = 0;
	X_Move = -1;
	N_Points = -1;
	sprintf (buf, mastertabs[52]);
	write_master (buf);
    }
    if (flag_creer){
	struct commande *com;
	com = (struct commande *)new_commande (&macro_cour);
	com->code = 992;
	sprintf (com->nom, "GEL1DSAV"); 
	sprintf (buf, "GEL1DSAV\n");
	write_macro (buf);
    }
    else
	sauve_gel1d ();
}

/*****************************************************************************/

static void
Condenser_Matiere(N)
int N;
{
    int Y, X1, XX1, X2, XX2, X, S;
    for (Y = 0 ; Y < PrYMax ; Y++)
    {
	AdrCoeff = Coefficients+(N<<3);
	X1 = mPolynome_3((float)Y,AdrCoeff);
	AdrCoeff += 4;
	X2 = mPolynome_3((float)Y,AdrCoeff);
	XX1 = *(Frontieres+N*2*PrYMax+Y);
	XX2 = *(Frontieres+(N*2+1)*PrYMax+Y);
	S = 0;
	for (X = XX1 ; X < X1 ; X++)
	    S += ~(*(VIRAM + Adresse(X,Y)));
	for (X = X2 ; X < XX2 ; X++)
	    S += ~(*(VIRAM + Adresse(X,Y)));
	*(Matiere_Condensee+PrYMax*N+Y) = S/(X2-X1+1);
    }
}

/*****************************************************************************/

static void
Former_Matrice_Irreguliere()
{
    int N;
    float X, Y;
    memset(Matrice_4,0,sizeof(Matrice_4));
    Matrice_4[3][3] = N_Points;
    for (N = 0 ; N < N_Points ; N++)
    {
	X = Point_X[N];
	Y = Point_Y[N];
	Matrice_4[3][4] += X;
	X = X * Y;
	Matrice_4[2][4] += X;
	X = X * Y;
	Matrice_4[1][4] += X;
	X = X * Y;
	Matrice_4[0][4] += X;
	X = Y;
	Matrice_4[2][3] += X;
	X = X * Y;
	Matrice_4[1][3] += X;
	X = X * Y;
	Matrice_4[0][3] += X;
	X = X * Y;
	Matrice_4[0][2] += X;
	X = X * Y;
	Matrice_4[0][1] += X;
	X = X * Y;
	Matrice_4[0][0] += X;
    }
    Matrice_4[3][2] = Matrice_4[2][3];
    Matrice_4[3][1] = Matrice_4[2][2] = Matrice_4[1][3];
    Matrice_4[3][0] = Matrice_4[2][1] = Matrice_4[1][2] = Matrice_4[0][3];
    Matrice_4[2][0] = Matrice_4[1][1] = Matrice_4[0][2];
    Matrice_4[1][0] = Matrice_4[0][1];
}

/*****************************************************************************/

static void 
Max_Line(NN,size)
    int             NN, size;
{
    float          Dbl = abs(Matrice_4[NN][NN]);
    int             NMax = NN, N;
    if (NN == size-1)
	return;
    for (N = NN + 1; N < size; N++)
    {
	if (abs(Matrice_4[N][NN]) > Dbl)
	{
	    Dbl = Matrice_4[N][NN];
	    NMax = N;
	}
    }
    if (NMax != NN)
	for (N = NN; N < size+1; N++)
	{
	    Dbl = Matrice_4[NMax][N];
	    Matrice_4[NMax][N] = Matrice_4[NN][N];
	    Matrice_4[NN][N] = Dbl;
	}
}

/*****************************************************************************/

static void 
Transformation_de_Gauss(size)
int size;
{
    int             I, J, K;
    float          Dbl;
    for (I = 0; I < size ; I++)
    {
	Max_Line(I , size);
	for (J = I + 1; J < size ; J++)
	{
	    if (Matrice_4[J][I] == 0.0)
		continue;
	    Dbl = Matrice_4[I][I] / Matrice_4[J][I];
	    Matrice_4[J][I] = 0.0;
	    for (K = I + 1; K < size+1; K++)
	    {
		Matrice_4[J][K] *= Dbl;
		Matrice_4[J][K] -= Matrice_4[I][K];
	    }
	}
/*	Max_Line(I+1 , size); */
    }
}

/*****************************************************************************/

void 
Calculer_Coefficients(Adrf,size)
    float *Adrf;
    int size;
{
    int I, J;
    Transformation_de_Gauss(size);
    for (I = size-1 ; I >= 0 ; I--)
    {
	*(Adrf+I) = Matrice_4[I][size];
	for (J = size-1 ; J > I ; J--)
	    *(Adrf+I) -= *(Adrf+J) * Matrice_4[I][J];
	*(Adrf+I) /= Matrice_4[I][I];
    }
/*    float          A,B,C,D;
    Transformation_de_Gauss(size);
    D = Matrice_4[3][4] / Matrice_4[3][3];
    C = (Matrice_4[2][4] - D * Matrice_4[2][3]) / Matrice_4[2][2];
    B = (Matrice_4[1][4] - D * Matrice_4[1][3] - 
	 C * Matrice_4[1][2]) / Matrice_4[1][1];
    A = (Matrice_4[0][4] - D * Matrice_4[0][3] - C * Matrice_4[0][2]
	 - B * Matrice_4[0][1]) / Matrice_4[0][0];
    for (I = 0 ; I < size ; I++)
    *Adrf = A;
    *(Adrf+1) = B;
    *(Adrf+2) = C;
    *(Adrf+3) = D;
*/
}

/*****************************************************************************/

static void
Croix(X,Y)
int X,Y;
{
    pw_vector(gel_pixwin,X-2,Y-2,X+2,Y+2,
	PIX_SRC^PIX_DST,128);
    pw_vector(gel_pixwin,X-2,Y+2,X+2,Y-2,
	PIX_SRC^PIX_DST,128);
}

#ifdef TEST
/*****************************************************************************/

static int 
Dump_In()
{
    FILE           *F;
    int             Res;
    F = fopen("dump_gel.dat", "rb");
    if (F == NULL)
    {
	return (1);
    }
    free_if(Coefficients);
    Coefficients = (float *) malloc(2 * 4 * Gel_Global.N_Bandes * sizeof(float));
    if (Coefficients == NULL)
	return (1);
    free_if(Milieux_2);
    Milieux_2 = (float *) malloc(4 * Gel_Global.N_Bandes * sizeof(float));
    if (Milieux_2 == NULL)
    {
	free((char *) Coefficients);
	return (1);
    }
    if (fread(&Gel_Global.N_Bandes, sizeof(int), 1, F) != 1)
	return (1);
    if (fread(Coefficients, sizeof(float), 8 * Gel_Global.N_Bandes, F) != 8 * Gel_Global.N_Bandes)
	return (1);
    if (fread(Milieux_2, sizeof(float), 4 * Gel_Global.N_Bandes, F) != 4 * Gel_Global.N_Bandes)
	return (1);
    fclose(F);
    Dumped = 1;
    printf("%cDumped !!!!\n",7);
    return (0);
}

/*****************************************************************************/

static void 
Dump_Out()
{
    FILE           *F;
    int             Res;
    F = fopen("dump_gel.dat", "wb");
    if (F == NULL)
	return;
    if (fwrite(&Gel_Global.N_Bandes, sizeof(int), 1, F) != 1)
	return;
    if (fwrite(Coefficients, sizeof(float), 8 * Gel_Global.N_Bandes, F) != 8 * Gel_Global.N_Bandes)
	return;
    if (fwrite(Milieux_2, sizeof(float), 4 * Gel_Global.N_Bandes, F) != 4 * Gel_Global.N_Bandes)
	return;
    fclose(F);
}

#endif

/*****************************************************************************/

static float 
Polynome_2(DblX, Coeff)
    float         *Coeff, DblX;
{
    float          Res;
    Res = ((*Coeff * DblX) + *(Coeff + 1)) * DblX + *(Coeff + 2);
    return (Res);
}

/*****************************************************************************/

static void 
Tracer_Polynome_3(Adr)
    float         *Adr;
{
    int             Y, X;
    for (Y = 0; Y < PrYMax; Y++)
    {
	X = mPolynome_3((float)Y,Adr);
	pw_put(gel_pixwin,X,Y,0);
    }
}

/*****************************************************************************/

static void 
Effacer_Polynome_3(Adr)
    float         *Adr;
{
    int             Y, X;
    for (Y = 0; Y < PrYMax; Y++)
    {
	X = mPolynome_3((float)Y,Adr);
	pw_put(gel_pixwin,X,Y,*(VIRAM+Adresse(X,Y)));
    }
}

/*****************************************************************************/

void Draw_New_Gel()
{
    pw_batch_on(gel_pixwin);
    if (Flag_Plus_1)
	if (New_RAM)
	    pw_write(gel_pixwin, 0, 0, PrXMax+1, PrYMax,
		    PIX_SRC, gel_pixrect, 0, 0);
	else
	{
	    window_set(gel_canvas,
		   WIN_WIDTH,
		    (int)window_get(gel_canvas, WIN_WIDTH) - 1,
		   CANVAS_WIDTH,
		    (int)window_get(gel_canvas, CANVAS_WIDTH) - 1,
		   0);
	    pw_write(gel_pixwin, 0, 0, PrXMax-1, PrYMax,
		    PIX_SRC, gel_pixrect, 0, 0);
	}
    else
	pw_write(gel_pixwin, 0, 0, PrXMax, PrYMax,
		PIX_SRC, gel_pixrect, 0, 0);
    pw_batch_off(gel_pixwin);
    Courbe_Affichee = NULL;
}

/*****************************************************************************/

static void 
Cumuler_Niveaux()
{
    int             X, Y;
    u_char         *Adr = VIRAM;;
    for (Y = 0; Y < PrYMax; Y++)
	for (X = 0; X < PrXMax; X++, Adr++)
	    *(Ligne_de_Travail_i + X) += *Adr;
}

/*****************************************************************************/

static int 
Filtre_Extremal_1(X, Adr_In)
    int             X, *Adr_In;
{
    int             XX, Val;
    unsigned int    Min = (u_int) - 1, Max = 0;
    for (XX = max(0, X - Gel_Global.Fenetre_T_Glissant);
	 XX < min(PrXMax, X + Gel_Global.Fenetre_T_Glissant); XX++)
    {
	Val = *(Adr_In + XX);
	Min = min(Min, Val);
	Max = max(Max, Val);
    }
    Val = *(Adr_In + X);
    if (Val - Min < Max - Val)
	return (Min);
    else
	return (Max);
}

/*****************************************************************************/

static int 
Filtre_Extremal()
{
    int            *Adr_i, *Adr_Out, X, Delta;
    int		    Up = 1, Taille = 1, Taille_Min = 99999;
    unsigned int    Min = (u_int) - 1, Max = 0;
    u_char         *Adr_c;
    Adr_i = (int *) malloc(PrXMax * sizeof(int));
    if (Adr_i == NULL)
    {
	write_erreur(900);
	return (NO_RAM);
    }
    Adr_c = (u_char *) malloc(PrXMax * sizeof(u_char));
    if (Adr_c == NULL)
    {
	write_erreur(900);
	free((char *) Adr_i);
	return (NO_RAM);
    }
    Adr_Out = Adr_i;
    for (X = 0; X < PrXMax; X++, Adr_i++)
    {
	*Adr_i = Filtre_Extremal_1(X, Ligne_de_Travail_i);
	Min = min(Min, *Adr_i);
	Max = max(Max, *Adr_i);
    }
    Delta = (Max - Min) / 10;
    *Adr_c = 255;
    for (X = 1; X < PrXMax; X++)
    {
	if (Up)
	    if ((*(Adr_Out + X - 1) - *(Adr_Out + X) > Delta) && (Taille >= 5))
	    {
		Up = 0;
		*(Adr_c + X) = 0;
		Taille_Min = min(Taille_Min, Taille);
		Taille = 1;
	    } else
	    {
		*(Adr_c + X) = 128;
		Taille++;
	    }
	else if ((*(Adr_Out + X) - *(Adr_Out + X - 1) > Delta) && (Taille >= 5))
	{
	    Up = 1;
	    *(Adr_c + X) = 128;
	    Taille_Min = min(Taille_Min, Taille);
	    Taille = 1;
	} else
	{
	    *(Adr_c + X) = 0;
	    Taille++;
	}
    }
    free_if((char *) Adr_Out);
    free_if((char *) Adr_c);
    Gel_Global.Fenetre_T_Glissant = Taille_Min;
    return (0);
}

/*****************************************************************************/

static void 
Trouver_Maximum(Maxs)
    char           *Maxs;
{
    int             N;
    int             Max;
    float           T_Max;
    Max = 0;
    T_Max = *T_Gliss_Res;
    for (N = 1; N < PrXMax; N++)
	if ((T_Max < *(T_Gliss_Res + N)) && !*(Maxs + N))
	{
	    T_Max = *(T_Gliss_Res + N);
	    Max = N;
	}
    *(Maxs + Max) = 1;
    N = Max + 1;
    while (N < PrXMax)
    {
	if (*(T_Gliss_Res + N) >= 0.0)
	    *(Maxs + N) = -1;
	else
	    break;
	N++;
    }
    N = Max - 1;
    while (N >= 0)
    {
	if (*(T_Gliss_Res + N) >= 0.0)
	    *(Maxs + N) = -1;
	else
	    break;
	N--;
    }
}

/*****************************************************************************/

static void 
Trouver_Minimum(Mins)
    char           *Mins;
{
    int             N;
    int             Min;
    float           T_Min;
    Min = 0;
    T_Min = *T_Gliss_Res;
    for (N = 1; N < PrXMax; N++)
	if ((T_Min > *(T_Gliss_Res + N)) && !*(Mins + N))
	{
	    T_Min = *(T_Gliss_Res + N);
	    Min = N;
	}
    *(Mins + Min) = 1;
    N = Min + 1;
    while (N < PrXMax)
    {
	if (*(T_Gliss_Res + N) <= 0.0)
	    *(Mins + N) = -1;
	else
	    break;
	N++;
    }
    N = Min - 1;
    while (N >= 0)
    {
	if (*(T_Gliss_Res + N) <= 0.0)
	    *(Mins + N) = -1;
	else
	    break;
	N--;
    }
}

/*****************************************************************************/

static int t_XX, t_Fl, t_n;
static float t_Fl1, t_Fl2;
static float t_s, t_t;

static float 
int_T_Glissant_1(X, Ligne_char)
    int             X;
    u_char         *Ligne_char;
{
    if (X == 1)
    {
	n_left = 1;
	n_right = Gel_Global.Fenetre_T_Glissant;
	Sigma_L = *Ligne_char;
	t_Fl = Sigma_L;
	Sigma_L_2_i = t_Fl * t_Fl;
	Sigma_R = 0;
	Sigma_R_2_i = 0.0;
	for (t_XX = 2; t_XX < Gel_Global.Fenetre_T_Glissant + 2; t_XX++)
	{
	    Sigma_R += *(Ligne_char + t_XX);
	    t_Fl = *(Ligne_char + t_XX);
	    Sigma_R_2_i += t_Fl * t_Fl;
	}
    } else if (X <= Gel_Global.Fenetre_T_Glissant)
    {
	n_left++;
	Sigma_L += *(Ligne_char + X - 1);
	t_Fl = *(Ligne_char + X - 1);
	Sigma_L_2_i += t_Fl * t_Fl;
	Sigma_R -= *(Ligne_char + X);
	Sigma_R += *(Ligne_char + X + Gel_Global.Fenetre_T_Glissant);
	t_Fl = *(Ligne_char + X);
	Sigma_R_2_i -= t_Fl * t_Fl;
	t_Fl = (float) *(Ligne_char + X + Gel_Global.Fenetre_T_Glissant);
	Sigma_R_2_i += t_Fl * t_Fl;
    } else if (X <= PrXMax - 1 - Gel_Global.Fenetre_T_Glissant)
    {
	Sigma_L -= *(Ligne_char + X - Gel_Global.Fenetre_T_Glissant - 1);
	Sigma_L += *(Ligne_char + X - 1);
	t_Fl = (float) *(Ligne_char + X - Gel_Global.Fenetre_T_Glissant - 1);
	Sigma_L_2_i -= t_Fl * t_Fl;
	t_Fl = (float) *(Ligne_char + X - 1);
	Sigma_L_2_i += t_Fl * t_Fl;
	Sigma_R -= *(Ligne_char + X);
	Sigma_R += *(Ligne_char + X + Gel_Global.Fenetre_T_Glissant);
	t_Fl = (float) *(Ligne_char + X);
	Sigma_R_2_i -= t_Fl * t_Fl;
	t_Fl = (float) *(Ligne_char + X + Gel_Global.Fenetre_T_Glissant);
	Sigma_R_2_i += t_Fl * t_Fl;
    } else
    {
	n_right--;
	Sigma_L -= *(Ligne_char + X - Gel_Global.Fenetre_T_Glissant - 1);
	Sigma_L += *(Ligne_char + X - 1);
	t_Fl = (float) *(Ligne_char + X - Gel_Global.Fenetre_T_Glissant - 1);
	Sigma_L_2_i -= t_Fl * t_Fl;
	t_Fl = (float) *(Ligne_char + X - 1);
	Sigma_L_2_i += t_Fl * t_Fl;
	Sigma_R -= *(Ligne_char + X);
	t_Fl = (float) *(Ligne_char + X);
	Sigma_R_2_i -= t_Fl * t_Fl;
    }
    t_n = n_left + n_right;
    t_Fl1 = (float) Sigma_L *(float) Sigma_L / (float) n_left;
    t_Fl1 = Sigma_L_2_i - t_Fl1;
    t_Fl2 = (float) Sigma_R *(float) Sigma_R / (float) n_right;
    t_Fl2 = Sigma_R_2_i - t_Fl2;
    t_s = (t_Fl1 + t_Fl2) / (float)(t_n * (t_n - 2));
    if (t_s < 1.0)
	t_s = 1.0;
    t_t = ((float)Sigma_R/(float)n_right - (float)Sigma_L/(float)n_left) /
	     ((float)sqrt((float) t_s));
    return (t_t);
}

/*****************************************************************************/

static void 
int_T_Glissant(Ligne_char)
    u_char         *Ligne_char;
{
    float          *Adr_Float, *Adr;
    int             X;
    *T_Gliss_Res = 0.0;
    *(T_Gliss_Res + PrXMax - 1) = 0.0;
    Adr = T_Gliss_Res + 1;
    for (X = 1; X < PrXMax - 1; X++, Adr++)
	*Adr = int_T_Glissant_1(X, Ligne_char);
}

/*****************************************************************************/

static float 
float_T_Glissant_1(X, Ligne_int)
    int             X;
    int            *Ligne_int;
{
    int             XX;
    float          Dbl1, Dbl2;
    float           Fl, s, t, n, r, l, sqrt_s;
    if (X == 1)
    {
	n_left = 1;
	n_right = Gel_Global.Fenetre_T_Glissant;
	Sigma_L = *Ligne_int;
	Fl = Sigma_L;
	Sigma_L_2_d = (float) Fl *(float) Fl;
	Sigma_R = 0;
	Sigma_R_2_d = 0.0;
	for (XX = 2; XX < Gel_Global.Fenetre_T_Glissant + 2; XX++)
	{
	    Sigma_R += *(Ligne_int + XX);
	    Fl = *(Ligne_int + XX);
	    Sigma_R_2_d += (float) Fl *(float) Fl;
	}
    } else if (X <= Gel_Global.Fenetre_T_Glissant)
    {
	n_left++;
	Sigma_L += *(Ligne_int + X - 1);
	Fl = (float) *(Ligne_int + X - 1);
	Sigma_L_2_d += (float) Fl *(float) Fl;
	Sigma_R -= *(Ligne_int + X);
	Sigma_R += *(Ligne_int + X + Gel_Global.Fenetre_T_Glissant);
	Fl = (float) *(Ligne_int + X);
	Sigma_R_2_d -= (float) Fl *(float) Fl;
	Fl = (float) *(Ligne_int + X + Gel_Global.Fenetre_T_Glissant);
	Sigma_R_2_d += (float) Fl *(float) Fl;
    } else if (X <= PrXMax - 1 - Gel_Global.Fenetre_T_Glissant)
    {
	Sigma_L -= *(Ligne_int + X - Gel_Global.Fenetre_T_Glissant - 1);
	Sigma_L += *(Ligne_int + X - 1);
	Fl = (float) *(Ligne_int + X - Gel_Global.Fenetre_T_Glissant - 1);
	Sigma_L_2_d -= (float) Fl *(float) Fl;
	Fl = (float) *(Ligne_int + X - 1);
	Sigma_L_2_d += (float) Fl *(float) Fl;
	Sigma_R -= *(Ligne_int + X);
	Sigma_R += *(Ligne_int + X + Gel_Global.Fenetre_T_Glissant);
	Fl = (float) *(Ligne_int + X);
	Sigma_R_2_d -= (float) Fl *(float) Fl;
	Fl = (float) *(Ligne_int + X + Gel_Global.Fenetre_T_Glissant);
	Sigma_R_2_d += (float) Fl *(float) Fl;
    } else
    {
	n_right--;
	Sigma_L -= *(Ligne_int + X - Gel_Global.Fenetre_T_Glissant - 1);
	Sigma_L += *(Ligne_int + X - 1);
	Fl = (float) *(Ligne_int + X - Gel_Global.Fenetre_T_Glissant - 1);
	Sigma_L_2_d -= (float) Fl *(float) Fl;
	Fl = (float) *(Ligne_int + X - 1);
	Sigma_L_2_d += (float) Fl *(float) Fl;
	Sigma_R -= *(Ligne_int + X);
	Fl = (float) *(Ligne_int + X);
	Sigma_R_2_d -= (float) Fl *(float) Fl;
    }
    n = (float) (n_left + n_right) / 2;
    r = (float) Sigma_R / (float) n_right;
    l = (float) Sigma_L / (float) n_left;
    Dbl1 = (float) Sigma_L *(float) Sigma_L / (float) n_left;
    Dbl1 = Sigma_L_2_d - Dbl1;
    s = (float) Dbl1;
    Dbl2 = (float) Sigma_R *(float) Sigma_R / (float) n_right;
    Dbl2 = Sigma_R_2_d - Dbl2;
    s += (float) Dbl2;
    s /= (float) (n * (n - 1.0));
    if (s < 10)
	s = 10;
    sqrt_s = (float) sqrt((float) s);
    t = (float) ((float) r - (float) l) / (float) sqrt_s;
    return (t);
}

/*****************************************************************************/

static float   *
float_T_Glissant(Ligne_int)
    int            *Ligne_int;
{
    float          *Adr_Float, *Adr;
    int             X;
    Adr_Float = (float *) malloc(PrXMax * sizeof(float));
    if (Adr_Float == NULL)
    {
	write_erreur(900);
	return (NULL);
    }
    *Adr_Float = 0.0;
    *(Adr_Float + PrXMax - 1) = 0.0;
    Adr = Adr_Float + 1;
    Float_Min = 99999.0;
    Float_Max = -99999.0;
    for (X = 1; X < PrXMax - 1; X++, Adr++)
    {
	*Adr = float_T_Glissant_1(X, Ligne_int);
	Float_Min = min(Float_Min, *Adr);
	Float_Max = max(Float_Max, *Adr);
    }
    return (Adr_Float);
}

/*****************************************************************************/

static int 
Decouvrir_Frontieres_1()
{
    char           *Extr;
    int             N, NN;
    Extr = (char *) malloc(PrXMax * sizeof(char));
    if (Extr == NULL)
    {
	write_erreur(900);
	return (NO_RAM);
    }
    memset(Extr, 0, PrXMax * sizeof(char));
    for (N = 0; N < Gel_Global.N_Bandes; N++)
	Trouver_Maximum(Extr);
    for (N = 0, NN = 0; N < PrXMax; N++)
	if (*(Extr + N) == 1)
	{
	    *(Frontieres_Preest + (NN << 1) + 1) = N;
	    NN++;
	}
    memset(Extr, 0, PrXMax * sizeof(char));
    for (N = 0; N < Gel_Global.N_Bandes; N++)
	Trouver_Minimum(Extr);
    for (N = 0, NN = 0; N < PrXMax; N++)
	if (*(Extr + N) == 1)
	{
	    *(Frontieres_Preest + (NN << 1)) = N;
	    NN++;
	}
    return (0);
}

/*****************************************************************************/

static int 
Decouvrir_Frontieres(Delta)
    float           Delta;
{
    int             X, Up = 0, N = 0, Fr = 0;
    float           Extrem = 999999.0;
    for (X = 0; X < PrXMax; X++)
    {
	if (Up)
	{
	    if (*(T_Gliss_Res + X) < -Delta)
	    {
		*(Frontieres_Preest + N) = (short) Fr;
		N++;
		Extrem = *(T_Gliss_Res + X);
		Up = 0;
	    } else
	    {
		if (Extrem < *(T_Gliss_Res + X))
		{
		    Extrem = *(T_Gliss_Res + X);
		    Fr = X;
		}
	    }
	} else
	{
	    if (*(T_Gliss_Res + X) > Delta)
	    {
		*(Frontieres_Preest + N) = (short) Fr;
		N++;
		Extrem = *(T_Gliss_Res + X);
		Up = 1;
	    } else
	    {
		if (Extrem > *(T_Gliss_Res + X))
		{
		    Extrem = *(T_Gliss_Res + X);
		    Fr = X;
		}
	    }
	}
    }
    *(Frontieres_Preest + N) = (short) Fr;
    return (N + 1);
}

/*****************************************************************************/

static void
Tracer_Frontieres_Preestimees()
{
    int I, IMax = Gel_Global.N_Bandes << 1, Y = PrYMax >> 1;
    pw_batch_on(gel_pixwin);
    for (I = 0 ; I < IMax ; I++)
	pw_vector(gel_pixwin,*(Frontieres_Preest+I),0,
			*(Frontieres_Preest+I),PrYMax,
			PIX_SRC^PIX_DST,128);
    for (I = 0 ; I < Gel_Global.N_Bandes ; I++)
    {
	pw_vector(gel_pixwin,*(Frontieres_Preest+I+I)+1,Y-1,
			    *(Frontieres_Preest+I+I+1)-1,Y-1,
			    PIX_SRC^PIX_DST,128);
	pw_vector(gel_pixwin,*(Frontieres_Preest+I+I)+1,Y,
			    *(Frontieres_Preest+I+I+1)-1,Y,
			    PIX_SRC^PIX_DST,128);
	pw_vector(gel_pixwin,*(Frontieres_Preest+I+I)+1,Y+1,
			    *(Frontieres_Preest+I+I+1)-1,Y+1,
			    PIX_SRC^PIX_DST,128);
    }
    pw_batch_off(gel_pixwin);
}

/*****************************************************************************/

static void
Affiche_Gel(Courbe,Flag_Display)
char *Courbe;
int Flag_Display;
{
    int N;
    char Str_x[40];
    Flag_Display = Flag_Display;
    if (gel_frame == NULL)
	return;
    Draw_New_Gel();
    if (Courbe) {
    	sprintf(Str_x,"%.1f",Gel_Global.fMin);
    	pw_text(pro_pixwin,3,Pro_Offset-8,PIX_SRC,NULL,Str_x);
    	sprintf(Str_x,"%.1f",Gel_Global.fMax);
    	pw_text(pro_pixwin,210,Pro_Offset-8,PIX_SRC,NULL,Str_x);
    	if (Courbe == (char *)Frontieres_Preest)
	    Tracer_Frontieres_Preestimees();
	else if (Courbe == (char *)Coefficients)
	{
	    pw_batch_on(gel_pixwin);
	    for (N = 0 ; N < (Gel_Global.N_Bandes<<1) ; N++)
		Tracer_Polynome_3(Coefficients+(N<<2));		
	    pw_batch_off(gel_pixwin);
	    Courbe_Affichee = (char *)Coefficients;
	}
    }
    if ((int)window_get(gel_frame, WIN_SHOW) != TRUE)
	    window_set(gel_frame, WIN_SHOW, TRUE, 0);
/*
    int N;
    char Str_x[40];
    Test_Error(gel_frame == NULL);
    if (gel_frame == NULL)
	return;
    if ((Courbe == Courbe_Affichee) &&
	((Courbe == (char *)0xffffffff) || 
	 (Courbe == NULL)))
    {
	if (Flag_Display && ((int)window_get(gel_frame, WIN_SHOW) != TRUE))
	    window_set(gel_frame, WIN_SHOW, TRUE, 0);
	return;
    }
    sprintf(Str_x,"%.1f",Gel_Global.fMin);
    pw_text(pro_pixwin,3,Pro_Offset-8,PIX_SRC,NULL,Str_x);
    sprintf(Str_x,"%.1f",Gel_Global.fMax);
    pw_text(pro_pixwin,210,Pro_Offset-8,PIX_SRC,NULL,Str_x);
    if (Courbe_Affichee != NULL)
    {
	if (Courbe_Affichee == (char *)Frontieres_Preest)
	    Tracer_Frontieres_Preestimees();
	else 
	    Draw_New_Gel();
	Courbe_Affichee = NULL;
    }
    if (Courbe != NULL)
    {
	if (Courbe == (char *)Frontieres_Preest)
	{
	    Tracer_Frontieres_Preestimees();
	    Courbe_Affichee = (char *)Frontieres_Preest;
	}
	else if (Courbe == (char *)Coefficients)
	{
	    pw_batch_on(gel_pixwin);
	    for (N = 0 ; N < (Gel_Global.N_Bandes<<1) ; N++)
		Tracer_Polynome_3(Coefficients+(N<<2));		
	    pw_batch_off(gel_pixwin);
	    Courbe_Affichee = (char *)Coefficients;
	}
    }
    if (Flag_Display && ((int)window_get(gel_frame, WIN_SHOW) != TRUE))
	window_set(gel_frame, WIN_SHOW, TRUE, 0);
*/
}

/*****************************************************************************/

static int
Calcul_Frontieres_Preestimees()
{
    int             Res, N, N1;
    float           Delta;
    char *Courbe;
    if (Gel_Global.N_Bandes < 1)
    {
	write_erreur(954);
	return(0);
    }
    Free_Pointers(0);
    if (Courbe_Affichee == (char *)Frontieres_Preest)
	Affiche_Gel(Frontieres_Preest,0);
    else
	Affiche_Gel(NULL,0);
    X_Undo = -1;
    Premier_Calcul = 1;
    Ligne_de_Travail_i = (int *) malloc(PrXMax * sizeof(int));
    if (Ligne_de_Travail_i == NULL)
    {
	write_erreur(900);
	return (NO_RAM);
    }
    Frontieres_Preest = (u_short *) malloc((Gel_Global.N_Bandes << 2) * sizeof(short));
    if (Frontieres_Preest == NULL)
    {
	write_erreur(900);
	free_if((char *) Ligne_de_Travail_i);
	Ligne_de_Travail_i = NULL;
	return (NO_RAM);
    }
    Ligne_de_Travail_i = (int *) memset((char *) Ligne_de_Travail_i, 0,
					PrXMax * sizeof(int));
    Cumuler_Niveaux();
    Res = Filtre_Extremal();
    if (Res)
    {
	free_if((char *) Ligne_de_Travail_i);
	return (Res);
    }
    T_Gliss_Res = float_T_Glissant(Ligne_de_Travail_i);
    if (T_Gliss_Res == NULL)
    {
	free_if((char *) Ligne_de_Travail_i);
	return (NO_RAM);
    }
    Delta = (Float_Max - Float_Min) / 8;
    N = Decouvrir_Frontieres(Delta);
    if (Gel_Global.N_Bandes != (N >> 1))
    {
	N1 = -1;
	write_erreur(950);
	for (N1 = -1;;)
	{
	    int NNN;
	    NNN = N/2;
	    get_int(paneltabs[95],
		    paneltabs[96],
		    &NNN, &N1);
/*	    N1 = Entree_Nombre_Bandes
		    (paneltabs[96],1); */
	    if ((N1 > 0) && (N1 <= MAX_BANDES))
		break;
	}
	if ((N1 << 1) != N)
	    if (Decouvrir_Frontieres_1())
		return (NO_RAM);
	Gel_Global.N_Bandes = N1;
    }
    for	(N1 = 0 ; N1 < MAX_BANDES ; N1++)
	Gel_Global.Somme_NGris[N1] = 0.0;
    free_if((char *) Ligne_de_Travail_i);
    free_if((char *) T_Gliss_Res);
    Courbe = (char *)Courbe_Affichee;
    Draw_New_Gel();
    if (Courbe != NULL)
	Affiche_Gel(Courbe,0);
    Update_Menu_Active();
    return (0);
}

/*****************************************************************************/

void 
Print_Help(Str1, Str2, Str31, Str32, Str33)
char *Str1, *Str2, *Str31, *Str32, *Str33;
{
    if (*Str1)
	panel_set(Help1,PANEL_LABEL_STRING,Str1,0);
    if (*Str2)
	panel_set(Help2,PANEL_LABEL_STRING,Str2,0);
    if (*Str31)
	panel_set(Help31,PANEL_LABEL_STRING,Str31,0);
    if (*Str32)
	panel_set(Help32,PANEL_LABEL_STRING,Str32,0);
    if (*Str33)
	panel_set(Help33,PANEL_LABEL_STRING,Str33,0);
}

/*****************************************************************************/

static int 
Find_Nearest_Polynome(X,Y)
int X, Y;
{
    int MMin = 99999, NN, XPoly;
    for (NN = 0 ; NN < (Gel_Global.N_Bandes << 1) ; NN++)
    {
	AdrCoeff = Coefficients + (NN<<2);
	XPoly = mPolynome_3((float)Y, AdrCoeff);
	if (abs(X - XPoly) < MMin)
	    MMin = abs(X-XPoly);
	else
	    break;
    }
    return(NN-1);
}


/*****************************************************************************/

static void 
gel_Notify_Proc(win, event, arg)
    Window          win;
    Event          *event;
    caddr_t         arg;
{
    char Side[10];
    int event_code, X, NN, XL, XR, MMin, XXMin, XPrXMax, XPoly, Y;
    unsigned short *Adr_save, *Adrs, *Adrd;
    event_code = event_id(event);
    if (event_code == MS_RIGHT)
    {
	if (regime_corr < 20)
	{
	    if (X_Undo != -1)
	    {
		Affiche_Gel(NULL,1);
		*(Frontieres_Preest + N_Undo) = X_Undo;
		Affiche_Gel(Frontieres_Preest,1);
		X_Undo = -1;
	    }
	    regime_corr = 0;
	    X_Move = -1;
	    Nearest = -1;
	    Clear_Help();
	    return;
	}
	else if (regime_corr == 22)
	{
	    X = event_x(event);
	    Y = event_y(event);
	    if (Nearest == -1)
	    {
		Tracer_Polynome_3(Coeff_Undo);
		Nearest = -1;
		regime_corr = 0;
		Clear_Help();
		return;
	    }
	    else
	    {
		if (N_Points > 0)
		{
		    if ((X == X_Down) && (Y == Y_Down))
			return;
		    N_Points--;
		    sprintf(Str_x,paneltabs[97],N_Points);
		    Print_Help("",Str_x,"","","");
		    Croix(Point_X[N_Points],Point_Y[N_Points]);
		    X_Down = X;
		    Y_Down = Y;
		    return;
		}
	    }
	}
	else if (regime_corr == 32)
	{
	    Nearest = -1;
	    regime_corr = 0;
	    Clear_Help();
	    return;
	}
    }
    switch (event_code) {
	case LOC_DRAG :
	    if ((regime_corr != 14) || (X_Move == -1) || (Nearest == -1))
	    {
/*		Nearest = -1;
		X_Move = -1; */
		return;
	    }
	    X = event_x(event);
	    if ((X != X_Move) && (X >= XXMin) && (X < XPrXMax))
	    {
		pw_batch_on(gel_pixwin);
		pw_vector(gel_pixwin,X_Move,0,X_Move,PrYMax,
				PIX_SRC^PIX_DST,128);
		pw_vector(gel_pixwin,X,0,X,PrYMax,
				PIX_SRC^PIX_DST,128);
		pw_vector(gel_pixwin,X,(PrYMax>>1)-1,X_Move,(PrYMax>>1)-1,
				PIX_SRC^PIX_DST,128);
	        pw_vector(gel_pixwin,X,(PrYMax>>1),X_Move,(PrYMax>>1),
				PIX_SRC^PIX_DST,128);
		pw_vector(gel_pixwin,X,(PrYMax>>1)+1,X_Move,(PrYMax>>1)+1,
				PIX_SRC^PIX_DST,128);
		pw_batch_off(gel_pixwin);
		X_Move = X;
	    }
	    return;
	case MS_MIDDLE :
	    if (regime_corr != 22)
		return;
	    if (N_Points <= 3)
		return;
	    {
		int N;
		for (N = 0 ; N < N_Points ; N++)
		    Croix(Point_X[N],Point_Y[N]);
	    }
	    Former_Matrice_Irreguliere();
	    Calculer_Coefficients(Coefficients + (Nearest << 2),4);
	    Tracer_Polynome_3(Coefficients + (Nearest << 2));
	    if (Nearest & 1)
		strcpy(Side,mastertabs[53]);
	    else
		strcpy(Side,mastertabs[54]);
	    sprintf(Str_x,mastertabs[55],
			Side,(Nearest>>1)+1);
			write_master(Str_x);
	    {
		int N;
		for (N = 0 ; N < N_Points ; N++)
		{
		    sprintf(Str_x,mastertabs[56],N+1,
			    Point_X[N],Point_Y[N]);
		    write_master(Str_x);
		}
	    }
	    Condenser_Matiere(Nearest >> 1);
	    Nearest = -1;
	    regime_corr = 0;
	    Clear_Help();
	    Free_Pointers(2);
	    Update_Menu_Active();
	    return;
	case MS_LEFT :
	    switch (regime_corr) {
		case  0:
		    Nearest = -1;
		    return;
		case 12 :
		    X_Undo = -1;
		    Affiche_Gel(NULL,1);
		    X = event_x(event);
		    Adr_save = (unsigned short *)
			    malloc(((Gel_Global.N_Bandes+1)<<1)*sizeof(short));
		    if (Adr_save == NULL)
		    {
			write_erreur(900);
			Clear_Help();
			return;
		    }
		    XL = 0;
		    Adrs = Frontieres_Preest;
		    Adrd = Adr_save;
		    for (NN = 0 ; NN < (Gel_Global.N_Bandes << 1) ; NN++, Adrs ++, Adrd++)
		    {
			XR = *(Adrs);
			if (XR > X)
			    break;
			*Adrd = *Adrs;
			XL = XR;
		    }
		    if (NN == (Gel_Global.N_Bandes << 1))
			XR = PrXMax;
		    *Adrd = XL + (XR-XL)/3;
		    Adrd ++;
		    *Adrd = XL + 2*(XR-XL)/3;
		    Adrd ++;
		    if (NN != (Gel_Global.N_Bandes << 1))
			memcpy(Adrd, Adrs,((Gel_Global.N_Bandes<<1)-NN)*sizeof(short));
		    Gel_Global.N_Bandes++;
		    Free_Pointers(0);
		    Frontieres_Preest = Adr_save;
		    Affiche_Gel(Frontieres_Preest,1);
		    regime_corr = 0;
		    sprintf(Str_x,mastertabs[57],
			    (NN>>1)+1,XL,XR);
		    write_master(Str_x);
		    Clear_Help();
		    Update_Menu_Active();
		    return;
		case 13 :
		    X_Undo = -1;
		    if (Gel_Global.N_Bandes == 0)
			return;
		    X = event_x(event);
		    for (NN = 0 ; NN < Gel_Global.N_Bandes ; NN++)
			if ((X >= *(Frontieres_Preest+NN+NN)) &&
			    (X < *(Frontieres_Preest+NN+NN+1)))
			    break;
		    if (NN == Gel_Global.N_Bandes)
		    {
			regime_corr = 0;
			return;
		    }
		    Affiche_Gel(NULL,1);
		    if (NN < Gel_Global.N_Bandes-1)
			memcpy(Frontieres_Preest+NN+NN,Frontieres_Preest+NN+NN+2,
				(Gel_Global.N_Bandes-NN-1)*2*sizeof(short));
		    Gel_Global.N_Bandes--;
		    Affiche_Gel(Frontieres_Preest,1);
		    regime_corr = 0;
		    sprintf(Str_x,mastertabs[58],NN+1);
		    write_master(Str_x);
		    Clear_Help();
		    Free_Pointers(1);
		    Update_Menu_Active();
		    return;
		case 14 :
		    if (Gel_Global.N_Bandes == 0)
			return;
		    X_Move = event_x(event);
		    if ((Nearest == -1) && event_is_down(event))
		    {
			for (MMin = 9999 , NN = 0 ; NN < (Gel_Global.N_Bandes << 1) ; NN++)
			    if (abs(X_Move - *(Frontieres_Preest+NN)) < MMin)
			    {
				MMin = abs(X_Move-*(Frontieres_Preest+NN));
				Nearest = NN;
			    }
			    else
				break;
			X_Move = *(Frontieres_Preest + Nearest);
			if (Nearest == 0)
			{
			    XXMin = 1;
			    XPrXMax = *(Frontieres_Preest+1);
			}
			else if (Nearest == (Gel_Global.N_Bandes<<1) -1)
			{
			    XXMin = *(Frontieres_Preest+((Gel_Global.N_Bandes-1)<<1))+1;
			    XPrXMax = PrXMax;
			}
			else
			{
			    XXMin = *(Frontieres_Preest+Nearest-1)+1;
			    XPrXMax = *(Frontieres_Preest+Nearest+1);
			}
			X_Undo = X_Move;
			N_Undo = Nearest;
		    }
		    else if (!event_is_down(event))
		    {
/*			pw_vector(gel_pixwin,X_Move,0,X_Move,PrYMax,
				    PIX_SRC^PIX_DST,128);
			pw_vector(gel_pixwin,*(Frontieres_Preest+Nearest),0,
					     *(Frontieres_Preest+Nearest),PrYMax,
				    PIX_SRC^PIX_DST,128); */
/*			Affiche_Gel(NULL,1); */
			*(Frontieres_Preest+Nearest) = X_Move;
/*			Affiche_Gel(Frontieres_Preest,1); */
			if (Nearest & 1)
			    strcpy(Side,mastertabs[53]);
			else
			    strcpy(Side,mastertabs[54]);
			sprintf(Str_x,mastertabs[59],
				Side,(Nearest>>1)+1,X_Move);
			write_master(Str_x);
			Nearest = -1;
			regime_corr = 0;
			Free_Pointers(1);
			Update_Menu_Active();
			Clear_Help();
		    }
		    return;
		case 22 :
                    if (event_is_up(event))
			return;
		    X = event_x(event);
		    Y = event_y(event);
		    if (Nearest == -1)
		    {
			Nearest = Find_Nearest_Polynome(X,Y);
			N_Undo = Nearest;
			memcpy(Coeff_Undo,
				Coefficients + (Nearest<<2),4*sizeof(float));
			N_Points = 0;
			Print_Help("",paneltabs[98],
				    "",paneltabs[99],"");
			Effacer_Polynome_3(Coeff_Undo);
			X_Down = X;
			Y_Down = Y;
		    }
		    else
		    {
			if ((X == X_Down) && (Y == Y_Down))
			    return;
			if (N_Points < 30)
			{
			    Point_X[N_Points] = X;
			    Point_Y[N_Points] = Y;
			    N_Points++;
			    sprintf(Str_x,paneltabs[97],N_Points);
			    Print_Help("",Str_x,"","","");
			    Croix(X,Y);
			}
			X_Down = X;
			Y_Down = Y;
		    }
		    return;
		case 32 :
		    X = event_x(event);
		    Y = event_y(event);
		    if (Courbe_Affichee == (char *)0xffffffff)
			Nearest = X/(Ideal_espace+Ideal_largeur);
		    else
		    {
			Nearest = Find_Nearest_Polynome(X,Y);
			Nearest = Nearest >> 1;
		    }
		    Affiche_Profil_1(Nearest);
		    regime_corr = 0;
		    Clear_Help();
		    return;
	    }
	    return;
    }
}

/*****************************************************************************/

static void
Creer_Frame(flag_free)
    int flag_free;
{
    Panel Help_Panel;
    Panel_item Help31i, Help32i, Help33i;
#ifdef TEST
    Dumped = 0;
#endif
    regime_corr = 0;
    if (flag_free)
	Free_Pointers(0);
    Courbe_Affichee = NULL;
    X_Move = -1;
    Nearest = -1;
    X_Undo = -1;
    Premier_Calcul = 1;
    Profil_Aff_1 = -1;
    if (gel_frame != NULL)
    {
	window_destroy(gel_frame);
	gel_frame = NULL;
    }
    if (scrollbar_h != NULL)
    {
	scrollbar_destroy(scrollbar_h);
	scrollbar_h = NULL;
    }
    if (scrollbar_v != NULL)
    {
	scrollbar_destroy(scrollbar_v);
	scrollbar_v = NULL;
    }
    sprintf(Str_x, "Labo Image - Gel1DTool : [%d] %s",
	    Prplan, dir_desc[Prplan].filename);
    gel_frame = window_create(frame, FRAME,
				FRAME_SHOW_LABEL, TRUE,
				FRAME_LABEL, Str_x,
				FRAME_NO_CONFIRM, TRUE,
				0);
    Help_Panel = window_create(gel_frame, PANEL,
				 0);
    Help1  = panel_create_item(Help_Panel, PANEL_MESSAGE,
				    PANEL_LABEL_BOLD, TRUE,
				    PANEL_LABEL_STRING, "",
				    PANEL_LABEL_X, ATTR_COL(3),
				    PANEL_LABEL_Y, ATTR_ROW(0),
				    0);
    Help2  = panel_create_item(Help_Panel, PANEL_MESSAGE,
				    PANEL_LABEL_STRING, "",
				    PANEL_LABEL_X, ATTR_COL(0),
				    PANEL_LABEL_Y, ATTR_ROW(1),
				    0);
    Help31i = panel_create_item(Help_Panel, PANEL_MESSAGE,
				    PANEL_LABEL_IMAGE, &Mouse_Left_Pixrect_Icon,
				    PANEL_LABEL_X, ATTR_COL(1),
				    PANEL_LABEL_Y, ATTR_ROW(2),
				    0);
    Help31 = panel_create_item(Help_Panel, PANEL_MESSAGE,
				    PANEL_LABEL_BOLD, TRUE,
				    PANEL_LABEL_STRING, "",
				    PANEL_LABEL_X, ATTR_COL(4),
				    PANEL_LABEL_Y, ATTR_ROW(2),
				    0);
    Help32i = panel_create_item(Help_Panel, PANEL_MESSAGE,
				    PANEL_LABEL_IMAGE, &Mouse_Mid_Pixrect_Icon,
				    PANEL_LABEL_X, ATTR_COL(21),
				    PANEL_LABEL_Y, ATTR_ROW(2),
				    0);
    Help32 = panel_create_item(Help_Panel, PANEL_MESSAGE,
				    PANEL_LABEL_BOLD, TRUE,
				    PANEL_LABEL_STRING, "",
				    PANEL_LABEL_X, ATTR_COL(24),
				    PANEL_LABEL_Y, ATTR_ROW(2),
				    0);
    Help33i = panel_create_item(Help_Panel, PANEL_MESSAGE,
				    PANEL_LABEL_IMAGE, &Mouse_Right_Pixrect_Icon,
				    PANEL_LABEL_X, ATTR_COL(41),
				    PANEL_LABEL_Y, ATTR_ROW(2),
				    0);
    Help33 = panel_create_item(Help_Panel, PANEL_MESSAGE,
				    PANEL_LABEL_BOLD, TRUE,
				    PANEL_LABEL_STRING, "            ",
				    PANEL_LABEL_X, ATTR_COL(44),
				    PANEL_LABEL_Y, ATTR_ROW(2),
				    0);
    sprintf(Str_x,paneltabs[115],
		 (int)Gel_Global.Threshold_Height, Gel_Global.Threshold_Area);   
    Matiere_item = panel_create_item(Help_Panel, PANEL_MESSAGE,
				    PANEL_LABEL_BOLD, TRUE,
				    PANEL_LABEL_STRING, Str_x,
				    PANEL_LABEL_X, ATTR_COL(0),
				    PANEL_LABEL_Y, ATTR_ROW(3),
				    0);
    window_fit(Help_Panel);

    gel_canvas = window_create(gel_frame, CANVAS,
				 WIN_CONSUME_PICK_EVENT, LOC_DRAG,
				 WIN_X, 0,
				 WIN_BELOW, Help_Panel,
				 WIN_CURSOR, gel_cursor,
				 CANVAS_RETAINED, FALSE,
				 CANVAS_AUTO_SHRINK, FALSE,
				 WIN_EVENT_PROC, gel_Notify_Proc,
				 WIN_HEIGHT, PrYMax,
				 WIN_WIDTH, PrXMax,
				 CANVAS_HEIGHT, PrYMax,
				 CANVAS_WIDTH, PrXMax,
				 0);
    Pro_Offset = (int)window_get(gel_canvas, WIN_Y);
    Pro_Height = Pro_Offset + PrYMax;
    pro_canvas = window_create(gel_frame, CANVAS,
				 WIN_CONSUME_PICK_EVENT, LOC_DRAG,
				 WIN_Y, 0,
				 WIN_RIGHT_OF, gel_canvas,
				 WIN_HEIGHT,
				    window_get(gel_canvas, WIN_HEIGHT) + 
				    Pro_Offset,
				 WIN_WIDTH, 260,
				 WIN_CURSOR, gel_cursor,
				 CANVAS_RETAINED, FALSE,
				 CANVAS_AUTO_SHRINK, FALSE,
				 CANVAS_HEIGHT, Pro_Height,
				 CANVAS_WIDTH, 260,
				 WIN_EVENT_PROC, profil_Notify_Proc,
				 0);
/*    if (PrXMax > WIDTH_MAX)
    {
	scrollbar_h = scrollbar_create(0);
	window_set(gel_canvas,
		   WIN_HORIZONTAL_SCROLLBAR, scrollbar_h,
		   WIN_WIDTH, WIDTH_MAX,
		   WIN_HEIGHT,
		    (int)window_get(gel_canvas, WIN_HEIGHT) +
		    (int)scrollbar_get(scrollbar_h, SCROLL_Thickness),
		   0);
    }
    if (PrYMax > HEIGHT_MAX)
    {
	scrollbar_v = scrollbar_create(0);
	window_set(gel_canvas,
		   WIN_VERTICAL_SCROLLBAR, scrollbar_v,
		   WIN_HEIGHT, HEIGHT_MAX,
		   WIN_WIDTH,
		    (int)window_get(gel_canvas, WIN_WIDTH) +
		    (int)scrollbar_get(scrollbar_v, SCROLL_THICKNESS),
		   0);
    } */
    window_fit(pro_canvas);
    window_fit(gel_canvas);
    window_fit(gel_frame);
    Centrer_Frame(gel_frame);
    gel_pixwin = (Pixwin *) canvas_pixwin(gel_canvas);
    pro_pixwin = (Pixwin *) canvas_pixwin(pro_canvas);
    if (Flag_Plus_1)
	if (New_RAM)
	    gel_pixrect = mem_point(PrXMax+1, PrYMax, 8, ADR_VIRAM);
	else
	    gel_pixrect = mem_point(PrXMax-1, PrYMax, 8, ADR_VIRAM);
    else
	gel_pixrect = mem_point(PrXMax, PrYMax, 8, ADR_VIRAM);
    pw_setcmsname(gel_pixwin, paneltabs[116]);
    pw_putcolormap(gel_pixwin, 0, 256, Map, Map, Map);
    memcpy(Map_Color[0],Map,256);
    memcpy(Map_Color[1],Map,256);
    memcpy(Map_Color[2],Map,256);
    Map_Color[0][0] = 3;
    Map_Color[1][0] = 8;
    Map_Color[2][0] = 173;
    Map_Color[0][124] = 206;
    Map_Color[1][124] = 110;
    Map_Color[2][124] = 91;
    Map_Color[0][128] = 0;
    Map_Color[1][128] = 160;
    Map_Color[2][128] = 161;
    Map_Color[0][129] = 255;
    Map_Color[1][129] = 113;
    Map_Color[2][129] = 65;
    Map_Color[0][130] = 255;
    Map_Color[1][130] = 255;
    Map_Color[2][130] = 255;
    Map_Color[0][131] = 133;
    Map_Color[1][131] = 221;
    Map_Color[2][131] = 112;
    Map_Color[0][254] = 0;
    Map_Color[1][254] = 255;
    Map_Color[2][254] = 255;
    Map_Color[0][255] = 255;
    Map_Color[1][255] = 255;
    Map_Color[2][255] = 120;
    pw_setcmsname(pro_pixwin, "My_Color_Map");
    pw_putcolormap(pro_pixwin, 0, 256,
		    Map_Color[0], Map_Color[1], Map_Color[2]);
    window_set(gel_canvas, CANVAS_RETAINED, TRUE, 0);
    window_set(pro_canvas, CANVAS_RETAINED, TRUE, 0);
    Draw_New_Gel();
    {
	int Height = (int)((Gel_Global.Threshold_Height - Gel_Global.fMin)/
		(Gel_Global.fMax - Gel_Global.fMin) * 256.0);
	pw_vector(pro_pixwin,Height,Pro_Offset,Height, Pro_Height-1,PIX_SRC,130);
    }
}

/*****************************************************************************/

static          Panel_setting
lire_n_bandes(item, event)
    Panel_item      item;
    Event          *event;

{
    int N;
    if (event_id(event) == CTRLC)
    {
	/* demande d'interruption de l'interaction par l'utilisateur */
	flag_break = TRUE;
	window_return(NULL);
	window_destroy(frame_in);
	return ((Panel_setting) 0);
    } else
    {
    	if (event_id(event) == '\t')
	    return (PANEL_NEXT);
	else
	{
	    if (panel_get(Npanel, PANEL_VALUE) != NULL)
		N = atoi((char *) panel_get(Npanel, PANEL_VALUE));
	    if ((N < 1) || (N > MAX_BANDES))
	    {
		panel_set(item, PANEL_VALUE, "",0);
		return((Panel_setting)0);
	    }
	    window_return(N);
	    window_destroy(frame_in);
	    return ((Panel_setting) 0);
	}
    }
}
/*****************************************************************************/

static int
Entree_Nombre_Bandes(Strr_x,flag)
int flag;
char *Strr_x;
{
    Panel_item      titre;
    char            rep[20];
    int N;
    rep[0] = 0;
    frame_in = window_create(frame, FRAME,
				FRAME_NO_CONFIRM, TRUE, 0);
    panel_in = window_create(frame_in, PANEL, PANEL_LABEL_BOLD,
				TRUE, 0);

    if ((flag_exec == MANUEL || flag_exec == FROMTO_AUTO) && !flag)
	N = *((int *)(macro_cour->param));
    else
	N = 0;

    titre = panel_create_item(panel_in, PANEL_MESSAGE,
			      PANEL_SHOW_ITEM, TRUE,
			      PANEL_LABEL_X, ATTR_COL(0),
			      PANEL_LABEL_Y, ATTR_ROW(0),
		              PANEL_LABEL_STRING, paneltabs[118],
			      0);

    if ((flag_exec == MANUEL || flag_exec == FROMTO_AUTO) && !flag)
	sprintf(rep, "%d", N);
    Npanel = panel_create_item(panel_in, PANEL_TEXT,
			     PANEL_SHOW_ITEM, TRUE,
			     PANEL_LABEL_X, ATTR_COL(1),
			     PANEL_LABEL_Y, ATTR_ROW(2),
			     PANEL_VALUE_DISPLAY_LENGTH, 20,
			     PANEL_VALUE_STORED_LENGTH, 20,
	PANEL_LABEL_STRING,  Strr_x,
			     PANEL_VALUE, rep,
			     PANEL_NOTIFY_STRING, "\r\n\t\03",
			     PANEL_NOTIFY_PROC, lire_n_bandes,
			     0);
    window_fit(panel_in);
    window_fit(frame_in);
    Centrer_Frame(frame_in);
    N = (int) window_loop(frame_in);
    return (N);
}

/*****************************************************************************/

static int 
Trouver_Milieux()
{
    int             X_Left, X_Right = 0, NB, S1, S2, Y, X, g;
    u_short        *Adr_sh;
    free_if(Polynomes_Milieux);
    Polynomes_Milieux = (u_short *) malloc(Gel_Global.N_Bandes * PrYMax * sizeof(short));
    if (Polynomes_Milieux == NULL)
	return (NO_RAM);
    Adr_sh = Polynomes_Milieux;
    for (NB = 0; NB < Gel_Global.N_Bandes; NB++)
    {
	if (!NB)
	    X_Left = 0;
	else
	    X_Left = X_Right;
	if (NB == Gel_Global.N_Bandes - 1)
	    X_Right = PrXMax - 2;
	else
	    X_Right = (*(Frontieres_Preest + NB + NB + 1) + 
		       *(Frontieres_Preest + NB + NB + 2)) >> 1;
	for (Y = 0; Y < PrYMax; Y++)
	{
	    S1 = 0;
	    S2 = 0;
	    for (X = X_Left; X < X_Right; X++)
	    {
/*        g = abs(*(VIRAM + X + 1 + Y*PrXMax) - *(VIRAM + X + Y*PrXMax)); */
/*        g =  *(VIRAM + X + Y*PrXMax); */
		g = 255 - *(VIRAM + X + Y * PrXMax);
		S1 += X * g * g;
		S2 += g * g;
	    }
	    if (S2)
		*Adr_sh = S1 / S2;
	    else
		*Adr_sh = (X_Left + X_Right) >> 1;
	    Adr_sh++;
	}
    }
/*  for (X = 0 ; X < Gel_Global.N_Bandes ; X++)
    for (Y = 0 ; Y < PrYMax ; Y++)
	Point(*(Polynomes_Milieux+PrYMax*X+Y),Y) */
    return (0);
}

/*****************************************************************************/

static void 
Former_Matrice(Adr)
    u_short        *Adr;
{
    float          YN, Val;
    int             X, Y;
    if (Premier_Calcul)
	memset((char *) Matrice_4, 0, sizeof(Matrice_4));
    else
	memcpy((char *) Matrice_4, (char *) Matrice_Save, sizeof(Matrice_4));
    Matrice_4[3][3] = PrYMax;
    if (Premier_Calcul)
    {
	Matrice_4[2][3] = ((float) (PrYMax - 1)) * (float) PrYMax / (float) 2.0;
	Matrice_4[3][2] = Matrice_4[2][3];
    }
    Matrice_4[3][4] = *Adr;;
    for (Y = 1; Y < PrYMax; Y++)
    {
	YN = Y;
	Val = *(Adr + Y);
	Matrice_4[3][4] += Val;
	Matrice_4[2][4] += Val * YN;
	YN *= (float) Y;
	Matrice_4[1][4] += Val * YN;
	if (Premier_Calcul)
	    Matrice_4[1][3] += YN;
	YN *= (float) Y;
	Matrice_4[0][4] += Val * YN;
	if (Premier_Calcul)
	{
	    Matrice_4[0][3] += YN;
	    YN *= (float) Y;
	    Matrice_4[0][2] += YN;
	    YN *= (float) Y;
	    Matrice_4[0][1] += YN;
	    YN *= (float) Y;
	    Matrice_4[0][0] += YN;
	}
    }
    if (Premier_Calcul)
    {
	Matrice_4[2][2] = Matrice_4[1][3];
	Matrice_4[3][1] = Matrice_4[1][3];
	Matrice_4[1][2] = Matrice_4[0][3];
	Matrice_4[2][1] = Matrice_4[0][3];
	Matrice_4[3][0] = Matrice_4[0][3];
	Matrice_4[1][1] = Matrice_4[0][2];
	Matrice_4[2][0] = Matrice_4[0][2];
	Matrice_4[1][0] = Matrice_4[0][1];
    }
    if (Premier_Calcul)
    {
	memcpy((char *) Matrice_Save, (char *) Matrice_4, sizeof(Matrice_Save));
	for (Y = 0; Y < 4; Y++)
	    Matrice_Save[Y][4] = 0.0;
	Premier_Calcul = 0;
    }
/*  Print_Matrice(); */
}

/*****************************************************************************/

static int 
f_Polynomes_Milieux()
{
    int             N, X, Y;
    free_if(Coefficients);
    Coefficients = (float *) malloc(4 * Gel_Global.N_Bandes * sizeof(float));
    if (Coefficients == NULL)
	return (NO_RAM);
    for (N = 0; N < Gel_Global.N_Bandes; N++)
    {
	Former_Matrice(Polynomes_Milieux + PrYMax * N);
	Calculer_Coefficients(Coefficients + (N << 2),4);
    }
/*  for (X = 0 ; X < Gel_Global.N_Bandes ; X++)
  {
    Tracer_Polynome_3(Coefficients+(X<<2));
  } */
    return (0);
}

/*****************************************************************************/

int 
Decouvrir_Frontieres_Precises(Y)
    int             Y;
{
    int             N, Left, Right, Min_X, Max_X, X;
    float           Min_T, Max_T;
    if ((Y % 10) == 0)
    {
	sprintf(Str_x,paneltabs[119], Y);
	Print_Help("",Str_x,"","","");
    }
    for (N = 0; N <= Gel_Global.N_Bandes; N++)
	if (!N)
	{
	    Left = 0;
	    Right = *X_Milieux;
	    Min_T = *T_Gliss_Res;
	    Min_X = 0;
	    for (X = Left; X < Right; X++)
	    {
		if (Min_T > *(T_Gliss_Res + X))
		{
		    Min_T = *(T_Gliss_Res + X);
		    Min_X = X;
		}
	    }
	    Min_X = max(Min_X, *Frontieres_Preest);
	    Min_T = *(T_Gliss_Res + Min_X);
	    *(Frontieres + Y) = Min_X;
	    *(T_valeurs + Y) = Min_T;
/*	    Point(Min_X,Y) */
	} else if (N == Gel_Global.N_Bandes)
	{
	    Left = Right;
	    Right = PrXMax;
	    Min_T = *(T_Gliss_Res + Left);
	    Max_T = Min_T;
	    Max_X = Left;
	    Min_X = Left;
	    for (X = Left; X < Right; X++)
	    {
		if (Max_T < *(T_Gliss_Res + X))
		{
		    Max_T = *(T_Gliss_Res + X);
		    Max_X = X;
		}
	    }
	    *(Frontieres + Y + PrYMax * (2 * N - 1)) = Max_X;
	    *(T_valeurs + Y + PrYMax * (2 * N - 1)) = Max_T;
/*	    Point(Max_X,Y) */
	} else
	{
	    Left = Right;
	    Right = *(X_Milieux + N);
	    Min_T = *(T_Gliss_Res + Left);
	    Max_T = Min_T;
	    Max_X = Left;
	    Min_X = Left;
	    for (X = Left; X < Right; X++)
	    {
		if (Min_T > *(T_Gliss_Res + X))
		{
		    Min_T = *(T_Gliss_Res + X);
		    Min_X = X;
		}
		if (Max_T < *(T_Gliss_Res + X))
		{
		    Max_T = *(T_Gliss_Res + X);
		    Max_X = X;
		}
	    }
	    Min_X = max(Min_X, *(Frontieres_Preest + 2 * N));
	    Min_T = *(T_Gliss_Res + Min_X);
	    Max_X = min(Max_X, *(Frontieres_Preest + 2 * N - 1));
	    Max_T = *(T_Gliss_Res + Max_X);
	    *(Frontieres + Y + 2 * PrYMax * N) = Min_X;
	    *(T_valeurs + Y + 2 * PrYMax * N) = Min_T;
	    *(Frontieres + Y + PrYMax * (2 * N - 1)) = Max_X;
	    *(T_valeurs + Y + PrYMax * (2 * N - 1)) = Max_T;
/*	    Point(Min_X,Y)
	    Point(Max_X,Y) */
	}
}

/*****************************************************************************/

static void 
Remplir_Matrice_Ponderee(Adr, Adr_fl)
    u_short        *Adr;
    float          *Adr_fl;
{
    float          YN, Val, Pond;
    int             X, Y;
    memset((char *) Matrice_4, 0, sizeof(Matrice_4));
    for (Y = 0; Y < PrYMax; Y++)
    {
	Pond = abs(*(Adr_fl + Y));
	Matrice_4[3][3] += Pond;
	YN = Y * Pond;
	Val = *(Adr + Y);
	Matrice_4[2][3] += YN;
	Matrice_4[3][4] += Val * Pond;
	Matrice_4[2][4] += Val * YN;
	YN *= (float) Y;
	Matrice_4[1][4] += Val * YN;
	Matrice_4[1][3] += YN;
	YN *= (float) Y;
	Matrice_4[0][4] += Val * YN;
	Matrice_4[0][3] += YN;
	YN *= (float) Y;
	Matrice_4[0][2] += YN;
	YN *= (float) Y;
	Matrice_4[0][1] += YN;
	YN *= (float) Y;
	Matrice_4[0][0] += YN;
    }
    Matrice_4[2][2] = Matrice_4[1][3];
    Matrice_4[3][1] = Matrice_4[1][3];
    Matrice_4[1][2] = Matrice_4[0][3];
    Matrice_4[2][1] = Matrice_4[0][3];
    Matrice_4[3][0] = Matrice_4[0][3];
    Matrice_4[1][1] = Matrice_4[0][2];
    Matrice_4[2][0] = Matrice_4[0][2];
    Matrice_4[1][0] = Matrice_4[0][1];
    Matrice_4[3][2] = Matrice_4[2][3];
}

/*****************************************************************************/

static void 
Approximer_Frontiere(F)
    int             F;
{
    Remplir_Matrice_Ponderee(Frontieres + PrYMax * F, T_valeurs + PrYMax * F);
    Calculer_Coefficients(Coefficients + (F << 2),4);
}

/*****************************************************************************/

static void 
Calculer_Milieux_2(Adr1, Adr2, Adr3)
    float         *Adr1, *Adr2, *Adr3;
{
    int             N;
    for (N = 0; N < 4; N++)
	*(Adr3 + N) = (*(Adr1 + N) + *(Adr2 + N)) / (float) 2.0;
}

/*****************************************************************************/

static int 
Estimer_Frontieres()
{
    int             Y, N_Front, NB = Gel_Global.N_Bandes << 1, N, C;
    Free_Pointers(2);
    if (Frontieres_Preest == NULL)
    {
	write_erreur(955);
	return(0);
    }
    if (Gel_Global.N_Bandes < 1)
    {
	write_erreur(954);
	return(0);
    }
    Frontieres = (u_short *) malloc(2 * Gel_Global.N_Bandes * PrYMax * sizeof(short));
    if (Frontieres == NULL)
    {
	free_if((char *) Coefficients);
	return (NO_RAM);
    }
    T_valeurs = (float *) malloc(2 * Gel_Global.N_Bandes * PrYMax * sizeof(float));
    if (T_valeurs == NULL)
    {
	free_if((char *) Coefficients);
	free_if((char *) Frontieres);
	return (NO_RAM);
    }
    T_Gliss_Res = (float *) malloc(PrXMax * sizeof(float));
    if (T_Gliss_Res == NULL)
    {
	free_if((char *) Coefficients);
	free_if((char *) T_valeurs);
	free_if((char *) Frontieres);
	return (NO_RAM);
    }
    X_Milieux = (u_short *) malloc(Gel_Global.N_Bandes * sizeof(short));
    if (X_Milieux == NULL)
    {
	free_if((char *) Coefficients);
	free_if((char *) T_valeurs);
	free_if((char *) Frontieres);
	free_if((char *) T_Gliss_Res);
	return (NO_RAM);
    }
    for (Y = 0; Y < PrYMax; Y++)
    {
	Fleche(0,Y);
	int_T_Glissant(VIRAM + Y * PrXMax);
	for (N = 0; N < Gel_Global.N_Bandes; N++)
	{
	    AdrCoeff = Coefficients+(N<<2);
	    *(X_Milieux + N) = mPolynome_3((float)Y,AdrCoeff);
/*	    Point(*(X_Milieux + N),Y);*/
	}
	N_Front = Decouvrir_Frontieres_Precises(Y);
	Fleche(0,Y);
    }
    free_if((char *) X_Milieux);
    Milieux_2 = (float *) malloc(4 * Gel_Global.N_Bandes * sizeof(float));
    if (Milieux_2 == NULL)
    {
	free_if((char *) Frontieres);
	free_if((char *) T_valeurs);
	return (NO_RAM);
    }
    Coefficients = (float *) malloc(2 * 4 * Gel_Global.N_Bandes * sizeof(float));
    if (Coefficients == NULL)
    {
	free_if((char *) Milieux_2);
	free_if((char *) Frontieres);
	free_if((char *) T_valeurs);
	return (NO_RAM);
    }
    Matiere_Condensee = (short *) malloc(PrYMax*Gel_Global.N_Bandes*sizeof(short));
    if (Matiere_Condensee == NULL)
    {
	free_if(Coefficients);
	free_if(Milieux_2);
	free_if(Frontieres);
	free_if(T_valeurs);
	return (NO_RAM);
    }
    for (N = 0; N < (Gel_Global.N_Bandes << 1); N++)
	Approximer_Frontiere(N);
    Print_Help("",paneltabs[123],"","","");
    for (N = 0; N < Gel_Global.N_Bandes; N++)
    {
	Condenser_Matiere(N);
	Calculer_Milieux_2(Coefficients + 8 * N, Coefficients + 8 * N + 4,
			   Milieux_2 + 4 * N);
    }
    free_if((char *) T_valeurs);
    return (0);
}

/*****************************************************************************/

static float 
Resolution_Polynome_3(Coeff, Y)
    float         *Coeff, Y;
{
    int             N;
    float          Coeff_DX[3];
    float          YNew, X, DX, Delta, YOld = Y;
    memcpy(Coeff_DX, Coeff, 3 * sizeof(float));
    Coeff_DX[0] *= (float) 3.0;
    Coeff_DX[1] *= (float) 2.0;
    for (N = 0; N < 50; N++)
    {
	X = (float)mPolynome_3(YOld, Coeff);
	DX = Polynome_2(YOld, Coeff_DX);
	Delta = X / DX;
	YNew = YOld - Delta;
	if (abs(Delta) < (float) 0.01)
	    break;
	YOld = YNew;
    }
    return (YNew);
}

/*****************************************************************************/

static    int             I__X1, I__Y1, I__G1, I__G2, I__G3, I__G4, I__Type;
static    u_char         *I__Adr;
static    float           I__Z, I__DX;

static float 
Interpolation_Bilineaire(X, Y, NG)
    float X, Y;
    int NG;
{
    I__X1 = (int) X;
    I__Y1 = (int) Y;
    I__Adr = VIRAM + I__X1 + I__Y1 * PrXMax;
    if ((I__Y1 == PrYMax - 1) || (I__X1 == PrXMax - 1))
	return ((float) *I__Adr);
    I__G1 = *I__Adr - *(Matiere_Condensee+PrYMax*NG+I__Y1);
    I__G2 = *(I__Adr + 1) - *(Matiere_Condensee+PrYMax*NG+I__Y1);
    I__G3 = *(I__Adr + PrXMax) - *(Matiere_Condensee+PrYMax*NG+I__Y1+1);
    I__G4 = *(I__Adr + PrXMax + 1) - *(Matiere_Condensee+PrYMax*NG+I__Y1+1);
/* */
    I__Type = 0;
    if (I__G1 == I__G2)
	I__Type = 1;
    if (I__G1 == I__G3)
	I__Type += 2;
    if (I__G3 == I__G4)
	I__Type += 4;
    switch (I__Type) {
	case 0x5:
	    return (I__G1 + (Y - I__Y1) * (I__G3 - I__G1));
	case 0x6: case 0x3:
	    return(I__G1 + (X - I__X1) * 
		    (I__G2 + (Y - I__Y1) * (I__G4 - I__G2) - I__G1));
	case 0x7:
	    return((float)I__G1);
    }
    if (I__G2 == I__G4)
	I__Type += 8;
    switch (I__Type) {
	case 0x0:
	    I__DX = (X - I__X1);
	    I__Z = I__G1 + I__DX * (I__G2 - I__G1);
	    return (I__Z + (Y - I__Y1) * 
		    (I__G3 + I__DX * (I__G4 - I__G3) - I__Z));
	case 0x1: case 0x9 :
	    return (I__G1 + (Y - I__Y1) * 
		    (I__G3 + (X - I__X1) * (I__G4 - I__G3) - I__G1));
	case 0x4: case 0xc :
	    I__Z = I__G1 + (X - I__X1) * (I__G2 - I__G1);
	    return (I__Z + (Y - I__Y1) * (I__G3 - I__Z));
	case 0xa:
	    return (I__G1 + (X - I__X1) * (I__G2 - I__G1));
	case 0x2:
	    I__Z = I__G2 + (Y - I__Y1) * (I__G4 - I__G2);
	    return(I__G1 + (X - I__X1) * (I__Z - I__G1));
	case 0x8:
	    I__Z = I__G1 + (Y - I__Y1) * (I__G3 - I__G1);
	    return(I__Z + (X - I__X1) * (I__G3 - I__Z));
    }
/* */
/*
    if ((I__G1 == I__G2) && (I__G1 == I__G3) && (I__G1 == I__G4))
	return ((float) *I__Adr);
    if ((I__G1 == I__G2) && (I__G3 == I__G4))
	return (I__G1 + (Y - I__Y1) * (I__G3 - I__G1));
    if ((I__G1 == I__G3) && (I__G2 == I__G4))
	return (I__G1 + (X - I__X1) * (I__G2 - I__G1));
    I__DX = X - I__X1;
    I__Z = I__G1 + I__DX * (I__G2 - I__G1);
    return (I__Z + (Y - I__Y1) * (I__G3 + I__DX * (I__G4 - I__G3) - I__Z));
*/
}

/*****************************************************************************/

static float 
Estimer_Ligne_Gel(NG, Y)
    int             NG, Y;
{
    float          A, B, YL, YR, XL, XR, Length, DX, DY;
    float          X;
    float	    Xi, Yi, LL;
    int             N;
    float           S;
    memcpy(Coeff_M, Milieux_2 + (NG << 2), 4 * sizeof(float));
    X = (float)mPolynome_3((float) Y, Coeff_M);
    Coeff_M[0] *= (float) 3.0;
    Coeff_M[1] *= (float) 2.0;
    A = (float) (-1.0) / Polynome_2((float) Y, Coeff_M);
    B = X - A * (float) Y;
    memcpy(Coeff_L, Coefficients + (NG << 3), 4 * sizeof(float));
    memcpy(Coeff_R, Coefficients + (NG << 3) + 4, 4 * sizeof(float));
    Coeff_L[2] -= A;
    Coeff_L[3] -= B;
    Coeff_R[2] -= A;
    Coeff_R[3] -= B;
    YL = Resolution_Polynome_3(Coeff_L, (float) Y);
    YL = max(YL, (float) 0.0);
    YL = min(YL, (float) PrYMax);
    YR = Resolution_Polynome_3(Coeff_R, (float) Y);
    YR = max(YR, (float) 0.0);
    YR = min(YR, (float) PrYMax);
    memcpy(Coeff_L + 2, Coefficients + (NG << 3) + 2, 2 * sizeof(float));
    memcpy(Coeff_R + 2, Coefficients + (NG << 3) + 6, 2 * sizeof(float));
    XL = (float)mPolynome_3(YL, Coeff_L);
    XR = (float)mPolynome_3(YR, Coeff_R);
    Length = (XR - XL) * (XR - XL) + (YR - YL) * (YR - YL);
    Length = sqrt(Length);
    LL = 0.0;
    N = 0;
    DX = (XR - XL) / Length;
    DY = (YR - YL) / Length;
    S = 0.0;
    for (Xi = XL, Yi = YL; LL <= Length; N++, LL += 1.0,
	 Xi += DX, Yi += DY)
	S += 255.0 - Interpolation_Bilineaire(Xi, Yi, NG);
    *(Largeurs + PrYMax*NG + Y) = N;
    return (S / (float) N);
}

/*****************************************************************************/

static void 
Evaluer_Gel(NG)
    int             NG;
{
    int             Y;
    int X;
    float FF;
    for (Y = 0; Y < PrYMax; Y++)
    {
	AdrCoeff = Coefficients+(NG<<3);
	X = mPolynome_3((float)Y,AdrCoeff)+3;
	Fleche(X,Y);
	FF = Estimer_Ligne_Gel(NG, Y);
	*(PrHistogr + Y + PrYMax * NG) = FF;
	if (Gel_Global.fMax < FF)
	    Gel_Global.fMax = FF;
	if (Gel_Global.fMin > FF)
	    Gel_Global.fMin = FF;
	Fleche(X,Y);
    }

}

/*****************************************************************************/

caddr_t
proc_gel1d(m, mi)
Menu m;
Menu_item mi;
{
    int *Parami, *CopyParami, Res, N, Lissage_New;
    int n_menu = (int)menu_get (mi, MENU_VALUE);
    if (!flag_creer)
	Clear_Help();
    Nearest = -1;
    regime_corr = 0;
    X_Move = -1;
    N_Points = -1;
    Update_Menu_Active();
    if ((flag_bother) || (flag_help)){
      switch (n_menu) {	
	case 40: hproc_gel_donnees_init();
		 break;
	case 41: hproc_affiche_gel1d();
		 break;
	case 42: hproc_gel_lisser();
		 break;
	case 10: hproc_gel_calculFronPreEst();
		 break;
	case 11: hproc_gel_affichFronPreEst();
		 break;
	case 20: hproc_gel_calculFronPrecises();
		 break;
	case 21: hproc_gel_affichFronPrecises();
		 break;
	case 30: hproc_gel_calculProfilBand();
		 break;
	case 31: hproc_gel_affichGelIdeal();
		 break;
	case 32: hproc_gel_GelUnprofil();
		 break;
	case 12: hproc_gel_AjoutBand_CorrectMan();
		 break;	
	case 13: hproc_gel_SupprimeBand_CorrectMan();
		 break;	
	case 14: hproc_gel_DeplaceFrontiere_CorrectMan();
		 break;				
      }
      if (flag_bother) return;
    }
    switch (n_menu) {
	    case 12:
	      if ((flag_creer) || (Frontieres_Preest == NULL))
		return((caddr_t)0);
	      if (Courbe_Affichee != (char *)Frontieres_Preest)
		Affiche_Gel(Frontieres_Preest,1);
	      Print_Help(paneltabs[127],paneltabs[128],
			 paneltabs[129],"",paneltabs[130]);
	      regime_corr = 12;
	      return((caddr_t)0);
	    case 13:
	      if ((flag_creer) || (Frontieres_Preest == NULL) || (Gel_Global.N_Bandes == 0))
		return((caddr_t)0);
	      if (Courbe_Affichee != (char *)Frontieres_Preest)
		Affiche_Gel(Frontieres_Preest,1);
	      Print_Help(paneltabs[132],paneltabs[135],
			 paneltabs[136],"",paneltabs[130]);
	      regime_corr = 13;
	      return((caddr_t)0);
	    case 14:
	      if ((flag_creer) || (Frontieres_Preest == NULL) || (Gel_Global.N_Bandes == 0))
		return((caddr_t)0);
	      if (Courbe_Affichee != (char *)Frontieres_Preest)
		Affiche_Gel(Frontieres_Preest,1);
	      Print_Help(paneltabs[137],paneltabs[138],
			 paneltabs[139],"",paneltabs[130]);
	      regime_corr = 14;
	      return((caddr_t)0);
	    case 22:
	      if ((flag_creer) || (Coefficients == NULL) || (Gel_Global.N_Bandes == 0))
		return((caddr_t)0);
	      if (Courbe_Affichee != (char *)Coefficients)
		Affiche_Gel(Coefficients,1);
	      Print_Help(paneltabs[141],paneltabs[138],paneltabs[143],"",paneltabs[130]);
	      regime_corr = 22;
	      Nearest = -1;
	      X_Move = -1;
	      N_Points = -1;
	      return((caddr_t)0);
	    case 32:
	      if ((PrHistogr == NULL) || !Gel_Global.N_Bandes || (PrHist_Aff == NULL) ||
		  ((Courbe_Affichee == (char *)0xffffffff) &&
		   (Coefficients == NULL)))
		return((caddr_t)0);
	      Print_Help(paneltabs[144],paneltabs[145],
			 paneltabs[143],"",paneltabs[130]);
	      regime_corr = 32;
	      if ((int)window_get(gel_frame, WIN_SHOW) != TRUE)
		window_set(gel_frame, WIN_SHOW, TRUE, 0);
	      return((caddr_t)0);
    }
    if (flag_creer) 
    {
/*	com = (struct commande *)malloc(sizeof(*com)); */
	com = (struct commande *)new_commande (&macro_cour);
    }
    switch (n_menu){
	case 10 :
		if (flag_creer){
		    strcpy(com->nom,"GEL1CFP");
		    com->code = 960;
		}
		else 
		{
		    if (Frontieres_Preest != NULL)
			if (!Confirm(paneltabs[91]))
			    return((caddr_t)0);
		    sprintf(buf,mastertabs[60]);
		}
		break;
	case 11 :
		if (flag_creer){
		    strcpy(com->nom,"GEL1AFP");
		    com->code = 961;
		}
		else sprintf(buf,mastertabs[61]);
		break;
	case 20 :
		if (flag_creer){
		    strcpy(com->nom,"GEL1CFE");
		    com->code = 970;
		}
		else
		{
		    if (Coefficients != NULL)
			if (!Confirm(paneltabs[147]))
			    return((caddr_t)0);
		    sprintf(buf,mastertabs[62]);
		}
		break;
	case 21 :
		if (flag_creer){
		    strcpy(com->nom,"GEL1AFE");
		    com->code = 971;
		}
		else sprintf(buf,mastertabs[69]);
		break;
	case 30 :
		if (flag_creer){
		    strcpy(com->nom,"GEL1CPR");
		    com->code = 980;
		}
		else
		{
		    if (PrHistogr != NULL)
			if (!Confirm(paneltabs[148]))
			    return((caddr_t)0);
		    sprintf(buf,mastertabs[63]);
		}
		break;
	case 31 :
		if (flag_creer){
		    strcpy(com->nom,"GEL1AFID");
		    com->code = 981;
		}
		else sprintf(buf,mastertabs[64]);
		break;
/*	case 32 :
		if (flag_creer){
		    strcpy(com->nom,"GEL1AFPR");
		    com->code = 981;
		}
		else sprintf(buf,mastertabs[64]);
		break; */
	case 40 :
		if (flag_creer){
		    strcpy(com->nom,"GEL1PLAN");
		    com->code = 990;
		}
		else sprintf(buf,mastertabs[65]);
		break;
	case 41 :
		if (flag_creer){
		    strcpy(com->nom,"GEL1AFFI");
		    com->code = 991;
		}
		else sprintf(buf,mastertabs[68]);
		break;
	case 42 :
		if (flag_creer){
		    strcpy(com->nom,"GEL1DLIS");
		    com->code = 994;
		}
		else sprintf(buf,mastertabs[66]);
		break;
    }
    if (!flag_creer) 
	write_master(buf);
    else
    {
	strcpy(buf,com->nom);
	write_macro(buf);
    }
    if(n_menu == 40)
    {
	if ((flag_exec == FROMTO_AUTO) || (flag_exec == AUTO))
	    index_image[0] = macro_cour->from[0];
	else
	    fromto(FROM,DEFAUT);
	if (!flag_creer)
	{
	    if (flag_break)
	    {
		interruption();
		return ((caddr_t)0);
	    }
	    sprintf(buf,"--> %d ",index_image[0]);
	    write_master(buf);
	}
	Parami = (int *)malloc(sizeof(int *));
	if ((flag_exec == PARAM_AUTO) || (flag_exec == AUTO))
	    *Parami = *((int *)macro_cour->param);
	else
	    *Parami = 
	      Entree_Nombre_Bandes(paneltabs[149],0);
	if (flag_break)
	{
	    interruption();
	    return ((caddr_t)0);
	}
	Gel_Global.N_Bandes = *Parami;
	if (flag_creer)
	{
	    com->from[0] = index_image[0];
	    sprintf(buf," FROM %d WITH %d",index_image[0],*Parami);
	    write_macro(buf);
	    CopyParami = (int *)malloc(sizeof(int *));
	    *CopyParami = *Parami;
	    com->param = (char *)CopyParami;
	}
	else
	{
	    sprintf(buf,mastertabs[67],*Parami);
	    write_master(buf);
	    Prplan = index_image[0];
	}
    }
    else if(n_menu == 42)
    {
	if ((flag_exec == PARAM_AUTO) || (flag_exec == AUTO))
	{
	    Parami = (int *)malloc(sizeof(int *));
	    *Parami = *((int *)macro_cour->param);
	}
	else
	{
	    Parami = (int *)malloc(sizeof(int));
	    get_int(paneltabs[150],paneltabs[151],NULL, Parami);
	    *Parami = abs(*Parami);
/*	    *Parami = 
	      Entree_Nombre_Bandes
		    (paneltabs[152],1); */
	}
	if (flag_break)
	{
	    interruption();
	    return ((caddr_t)0);
	}
	if (flag_creer)
	{
	    sprintf(buf," WITH %d",*Parami);
	    write_macro(buf);
	    CopyParami = (int *)malloc(sizeof(int *));
	    *CopyParami = *Parami;
	    com->param = (char *)CopyParami;
	}
	else
	{
	    sprintf(buf,"%d",*Parami);
	    write_master(buf);
	}
	Lissage_New = abs(*Parami);
    }
    if (!flag_creer)
    {
	write_master("\n");
	if (dir_image[Prplan].image == NULL)
	{
	    write_erreur(1);
	    return ((caddr_t)0);
	}
	if (dir_desc[Prplan].type)
	{
	    write_erreur(16);
	    return ((caddr_t)0);
	}
	switch (n_menu) {
	    case 10:
		Gel_Global.Fenetre_T_Glissant = 1.3 * PrXMax / (Gel_Global.N_Bandes << 2);
		Print_Help(paneltabs[153],"","","","");
		if (Calcul_Frontieres_Preestimees())
		    write_erreur(900);
		Clear_Help();
		break;
	    case 11:
		Affiche_Gel(Frontieres_Preest,1);
		break;
	    case 20:
		Print_Help("Estimation precise des frontieres",
			   "Recherche des milieux des bandes","","","");
		if (Trouver_Milieux())
		{
		    write_erreur(900);
		    Clear_Help();
		    break;
		}
		Print_Help("","Polynomes pour les milieux des bandes",
			   "","","");
		Res = f_Polynomes_Milieux();
		free_if(Polynomes_Milieux);
		if (Res)
		{
		    write_erreur(900);
		    free_if(Polynomes_Milieux);
		    Clear_Help();
		    break;
		}
#ifdef TEST
		if (Dump_In())
		    if (Estimer_Frontieres())
		    {
			write_erreur(900);
			Clear_Help();
			break;
		    }
		if (!Dumped)
		    Dump_Out();
#else
		if (Estimer_Frontieres())
		{
		    write_erreur(900);
		    Clear_Help();
		    break;
		}
#endif
		Clear_Help();
		Update_Menu_Active();
		break;
	    case 21:
		Affiche_Gel(Coefficients,1);
		break;
	    case 30:
		if (Frontieres_Preest == NULL)
		{
		    write_erreur(955);
		    return((caddr_t)0);
		}
		if (Gel_Global.N_Bandes < 1)
		{
		    write_erreur(954);
		    return((caddr_t)0);
		}
		if (Coefficients == NULL)
		{
		    write_erreur(956);
		    return((caddr_t)0);
		}
		Free_Pointers(2);
		Print_Help("Calcul des profils","","","","");
		PrHistogr = (float *) malloc(Gel_Global.N_Bandes * PrYMax * sizeof(float));
		if (PrHistogr == NULL)
		{
		    write_erreur(900);
		    Clear_Help();
		    break;
		}
		Largeurs = (float *) malloc(Gel_Global.N_Bandes * PrYMax * sizeof(float));
		if (Largeurs == NULL)
		{
		    write_erreur(900);
		    Clear_Help();
		    break;
		}
		PrHist_Aff = (float *) malloc(Gel_Global.N_Bandes * PrYMax * sizeof(float));
		if (PrHist_Aff == NULL)
		{
		    write_erreur(900);
		    Clear_Help();
		    break;
		}
		if (Milieux_2 == NULL)
		{
		    Milieux_2 = (float *) 
				malloc(4 * Gel_Global.N_Bandes * sizeof(float));
		    if (Milieux_2 == NULL)
		    {
			write_erreur(900);
			Clear_Help();
			break;
		    }
		    for (N = 0; N < Gel_Global.N_Bandes; N++)
			Calculer_Milieux_2(Coefficients + 8*N,
					    Coefficients + 8 * N + 4,
					    Milieux_2 + 4 * N);
		}
		Gel_Global.fMin = 9999.0;
		Gel_Global.fMax = -9999.0;
		for (N = 0; N < Gel_Global.N_Bandes; N++)
		{
		    sprintf(Str_x, paneltabs[174],N+1);
		    Print_Help("",Str_x,"","","");
		    Evaluer_Gel(N);
		}
		Cumuler_NGris();
		memcpy(PrHist_Aff, PrHistogr, Gel_Global.N_Bandes * PrYMax * sizeof(float));
		Clear_Help();
		Update_Menu_Active();
		if (Profil_Aff_1 != -1)
		    pw_writebackground(pro_pixwin,0,0,260,Pro_Height,PIX_SRC);
		Profil_Aff_1 = -1;
		break;
	    case 31:
		if ((PrHistogr != NULL) && Gel_Global.N_Bandes)
		    Draw_gel1d_id();
		break;
	    case 40:
		Prplan = index_image[0];
		Gel_Global.N_Bandes = *Parami;
		PrXMax = dir_desc[Prplan].ncolonne;
		PrYMax = dir_desc[Prplan].nligne;
		Flag_Plus_1 = (PrXMax & 1);
		New_RAM = 0;
		VIRAM = (unsigned char *) dir_image[Prplan].image;
		Test_VIRAM_Pair();
		if (!New_RAM)
			break;
		Creer_Frame(1);
		Update_Menu_Active();
		break;
	    case 41:
		Affiche_Gel(NULL,1);
		break;
	    case 42:
		Proc_Lissage_Gel(Lissage_New);
	}
    }
    else
	write_macro ("\n");
}

/*****************************************************************************/

static void
entree_gel1d()
{
    int I;
    for (I = 0 ; I < 256 ; I++)
	Map[I] = I+1;
#ifdef TEST
    Dumped = 0;
#endif
    Gel_Global.N_Bandes = 0;
    Prplan = -1;
    Gel_Global.Lissage = 0;
    Gel_Global.Total_Pics = 0;
    regime_corr = 0;
    X_Move = -1;
    Nearest = -1;
    X_Undo = -1;
    Premier_Calcul = 1;
    if (gel_frame != NULL)
	window_destroy(gel_frame);
    for	(I = 0 ; I < MAX_BANDES ; I++)
	Gel_Global.Matiere_1[I] = 100.0;
    gel_frame = NULL;
    scrollbar_h = NULL;
    scrollbar_v = NULL;
    Gel_Global.Threshold_Height = 0;
    Gel_Global.Threshold_Area = 0.0;
    Profil_Aff_1 = -1;
    Free_Pointers(0);
    Courbe_Affichee = NULL;
    gel_cursor = cursor_create(CURSOR_SHOW_CROSSHAIRS, TRUE,
				 CURSOR_IMAGE, &cursor_image_mire,
				 CURSOR_OP, PIX_SRC ^ PIX_DST,
				 CURSOR_XHOT, 7, CURSOR_YHOT, 7,
				 CURSOR_CROSSHAIR_GAP, 21,
				 CURSOR_CROSSHAIR_OP, PIX_SRC ^ PIX_DST,
				 CURSOR_CROSSHAIR_LENGTH, 100,
				 0);
    Update_Menu_Active();
}

/*****************************************************************************/

static void
sortie_gel1d()
{
    Free_Pointers(0);
    Courbe_Affichee = NULL;
    if (scrollbar_h != NULL)
    {
	scrollbar_destroy(scrollbar_h);
	scrollbar_h = NULL;
    }
    if (scrollbar_v != NULL)
    {
	scrollbar_destroy(scrollbar_v);
	scrollbar_v = NULL;
    }
    if (gel_cursor != NULL)
    {
	cursor_destroy(gel_cursor);
	gel_cursor = NULL;
    }
    if ((ADR_VIRAM != NULL) && New_RAM)
    {
	free(ADR_VIRAM);
	ADR_VIRAM = NULL;
    }
    if (gel_frame != NULL)
    {
	window_destroy(gel_frame);
	gel_frame = NULL;
    }
}

/*****************************************************************************/

caddr_t
proc_entree_gel1d(m, mi)
    Menu m;
    Menu_item mi;
{
   extern Menu mgel1dtool;
   int resul;
   static void proc1_sortie_gel1d();


    if (flag_bother){
	hproc_gel1dTool();
	return;
    }
    if (flag_help) hproc_gel1dTool();
    window_set (menu_win, WIN_IGNORE_PICK_EVENTS, WIN_MOUSE_BUTTONS,
                0,  0);
    window_set (menu_win, WIN_SHOW, FALSE, 0);

    menu_gel1d_tool= window_create(menu_frame, PANEL,
                                  WIN_COLUMNS, 18, WIN_ROWS, 14,
                                  WIN_SHOW, TRUE,
                                  WIN_RIGHT_OF, master,
				  WIN_X, 0, WIN_Y, 0,
				  WIN_HEIGHT, 320,  
				  PANEL_LABEL_BOLD, TRUE,
				  PANEL_LAYOUT, PANEL_VERTICAL,
                                  0);


    geltool_title = panel_create_item (menu_gel1d_tool, PANEL_MESSAGE,
				PANEL_LABEL_X, ATTR_COL(0),
				PANEL_LABEL_Y, ATTR_ROW(0),
				PANEL_LABEL_STRING,"** GEL1DTOOL **",
				0);
/*    input_button = panel_create_item(menu_gel1d_tool, PANEL_BUTTON,
                       PANEL_LABEL_IMAGE, panel_button_image(menu_gel1d_tool,"INPUT           ",16,0),
                       PANEL_LABEL_X, ATTR_COL(1),
                       PANEL_LABEL_Y, ATTR_ROW(6),
                       PANEL_EVENT_PROC, handle_gel1dtool,  
                       0);
*/
    menu_button = panel_create_item(menu_gel1d_tool, PANEL_BUTTON,
                       PANEL_LABEL_IMAGE, panel_button_image(menu_gel1d_tool,"MENU          =>",16,0),
                       PANEL_LABEL_X, ATTR_COL(1),
                       PANEL_LABEL_Y, ATTR_ROW(6),
                       PANEL_EVENT_PROC, handle_gel1dtool,  
                       0);

    quit_button = panel_create_item(menu_gel1d_tool, PANEL_BUTTON,
                      PANEL_LABEL_IMAGE, panel_button_image(menu_gel1d_tool,"QUIT            ",16,0),
                      PANEL_LABEL_X, ATTR_COL(1),
                      PANEL_LABEL_Y, ATTR_ROW(10),
                      PANEL_NOTIFY_PROC, proc1_sortie_gel1d,   
                      0);

     window_fit_width(menu_gel1d_tool);
     window_fit_width(menu_frame); 


    /* active le menu de gel1dtool dans la fenetre de commandes */
    Prplan = -1;
    Profil_Aff_1 = -1;
    Update_Menu_Active();
    if (flag_creer){
	Update_Menu_Active();
	com = (struct commande *)malloc(sizeof(*com));
	com = (struct commande *)new_commande (&macro_cour);
	strcpy(com->nom,"GEL1D");
	com->code = 950;
	com->param = NULL;
	sprintf (buf, "GEL1D\n");
	write_macro(buf);
    }
    else {
	sprintf(buf,mastertabs[70]);
	write_master(buf);
	entree_gel1d();
    }
}

/*****************************************************************************/


void handle_gel1dtool(item, event)
  Panel_item item;
  Event *event;
{
  extern Menu mgel1dtool;
  int resul;

    if (event_id(event) == MS_RIGHT && event_is_down(event)){
        if (item == menu_button){
            panel_begin_preview(item, event);
	    resul = (int)menu_show(mgel1dtool, menu_gel1d_tool, event, 0);
            panel_accept_preview(item, event);
        }
    }
}
/*****************************************************************************/

caddr_t
proc_sortie_gel1d(m,mi)
    Menu m;
    Menu_item mi;
{
    Update_Menu_Active();
    if (flag_creer){
        window_set (menu_win, WIN_SHOW, TRUE, 0);
        window_destroy(menu_gel1d_tool); 
	window_set (master, TEXTSW_MENU, mprincipal, 0);
        window_set (menu_win, WIN_CONSUME_PICK_EVENTS, WIN_MOUSE_BUTTONS,
		    0,  0);        

        window_fit_width(menu_frame);
	com = (struct commande *)malloc(sizeof(*com));
	com = (struct commande *)new_commande (&macro_cour);
	strcpy(com->nom,"GEL1DEXT");
	com->code = 999;
	com->param = NULL;
	sprintf (buf, "GEL1DEXT\n");
	write_macro(buf);
    }
    else {
	 if (!Confirm(paneltabs[178]))
	    return((caddr_t)0); 
        window_destroy(menu_gel1d_tool); 
        window_set (menu_win, WIN_SHOW, TRUE, 0);
        window_set (menu_win, WIN_CONSUME_PICK_EVENTS, WIN_MOUSE_BUTTONS,
		    0,  0);        
    	sprintf(buf,mastertabs[71]);
	write_master(buf);
	sortie_gel1d();
    }
}


void
proc1_sortie_gel1d(item, event)
  Panel_item item;
  Event *event;
{
    Update_Menu_Active(); 
    if (flag_creer){
        window_set (menu_win, WIN_SHOW, TRUE, 0);
        window_destroy(menu_gel1d_tool); 
	window_set (master, TEXTSW_MENU, mprincipal, 0);
        window_set (menu_win, WIN_CONSUME_PICK_EVENTS, WIN_MOUSE_BUTTONS,
		    0,  0);        

        window_fit_width(menu_frame);
	com = (struct commande *)malloc(sizeof(*com));
	com = (struct commande *)new_commande (&macro_cour);
	strcpy(com->nom,"GEL1DEXT");
	com->code = 999;
	com->param = NULL;
	sprintf (buf, "GEL1DEXT\n");
	write_macro(buf);
    }
    else {
	 if (!Confirm(paneltabs[178]))
	    return; 
        window_destroy(menu_gel1d_tool); 
        window_set (menu_win, WIN_SHOW, TRUE, 0);
        window_set (menu_win, WIN_CONSUME_PICK_EVENTS, WIN_MOUSE_BUTTONS,
		    0,  0);        
    	sprintf(buf,mastertabs[71]);
	write_master(buf);
	sortie_gel1d();
    }
}



#undef WIDTH_MAX
#undef HEIGHT_MAX
#undef NO_RAM

#ifdef MY_DEBUG
#undef MY_DEBUG
#endif

#ifdef TEST
#undef TEST
#endif
