/*----------------------------------------------------------------------------*/
/* Programme generateur de bruit uniforme ou gaussien, destine a etre inclu   */
/* dans le labo image "win"                                                   */
/* Christian GIRARD 5.12.1988                                                 */
/*----------------------------------------------------------------------------*/

/* Partie declarative */

#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <stdio.h>
#include <math.h>

#include "define.h"
#include "structure.h"
#include "global.h"
#include "type.h"
/*
#include "alea.c" 
*/
Frame frame_noise;
Panel panel_noise;
Panel_item noise_esp, noise_var;

#define taille dir_desc[index_image[0]].nligne * dir_desc[index_image[0]].ncolonne

/* constantes pour les calculs */
double carre, d_M_PI = 2.0 * (double) M_PI, maxrand;

struct noise *noisy;		     /* variable globale parametre du bruit */
void srandom ();
int getpid ();


extern void hproc_bruit_gauss();
extern void hproc_bruit_unif();

extern char *paneltabs[];
extern char *mastertabs[];

/*---------------------------------------------------------------------------*/
/* Nom : lire_noise							     */
/* Fonction : lecture des parametres du bruit a additionner a l'image	     */
/* Entree : Panel_item item, Event *event				     */
/* Global : Frame frame_noise						     */
/* Routine : -								     */
/* Sortie : struct noise *noisy						     */
/*---------------------------------------------------------------------------*/

static Panel_setting lire_noise (item, event)

Panel_item item;
Event *event;

{
    static struct noise noisy;
    double d;

    if (event_id (event) == CTRLC)
    {
	flag_break = TRUE;
	window_return (NULL);
	window_destroy (frame_noise);
	return;
    }
    else
    {
	if (event_id (event) == '\t')
	    return (PANEL_NEXT);
	else
	{
	    noisy.esp = (double) atof ((char *) panel_get (noise_esp, PANEL_VALUE));
	    noisy.var = (double) atof ((char *) panel_get (noise_var, PANEL_VALUE));
	    window_return (&noisy);
	    window_destroy (frame_noise);
	    return;
	}
    }
}

/*---------------------------------------------------------------------------*/
/* Nom : noise_panel							     */
/* Fonction : Afficher les fenetres d'interraction pour lire les parametres  */
/* du bruit a additionner						     */
/* Entree : int unif_gauss						     */
/* Global : Frame frame_noise, Panel panel_noise, Panel_item noise_esp,	     */
/*							     noise_var	     */
/* Routine : lire_noise							     */
/* Sortie : struct noise *noisy						     */
/*---------------------------------------------------------------------------*/

struct noise *noise_panel (unif_gauss)

int unif_gauss;

{
    Panel_item titre;
    char stitre [30], rep[20];
    struct noise *noisy;

    frame_noise = window_create (frame, FRAME, WIN_X, 500, WIN_Y, 500,
    FRAME_NO_CONFIRM, TRUE, 0);
    panel_noise = window_create (frame_noise, PANEL, PANEL_LABEL_BOLD, TRUE,
    0);

    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	noisy = (struct noise *) (macro_cour->param);
    else noisy = NULL;

    switch (unif_gauss)
    {
	case 0 : strcpy (stitre, paneltabs[17]); break;
	case 1 : strcpy (stitre, paneltabs[18]); break;
    }
    titre = panel_create_item (panel_noise, PANEL_MESSAGE,
			        PANEL_SHOW_ITEM, TRUE,	
				PANEL_LABEL_X, ATTR_COL(0),
				PANEL_LABEL_Y, ATTR_ROW(0),
				PANEL_LABEL_STRING, stitre, 0);
    switch (unif_gauss)
    {
	case 0 : strcpy (stitre, paneltabs[19]); break;
	case 1 : strcpy (stitre, paneltabs[5]); break;
    }

    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	sprintf (rep, "%f", noisy->esp);
    else strcpy (rep, "");

    noise_esp = panel_create_item (panel_noise, PANEL_TEXT,
			    PANEL_SHOW_ITEM,TRUE,
			    PANEL_LABEL_X, ATTR_COL(1),	
    			    PANEL_LABEL_Y, ATTR_ROW(2),
			    PANEL_VALUE_DISPLAY_LENGTH, 20,
			    PANEL_VALUE_STORED_LENGTH, 20,
			    PANEL_LABEL_STRING, stitre,	
			    PANEL_VALUE, rep,
    			    PANEL_NOTIFY_STRING,"\r\n\t\03",
			    PANEL_NOTIFY_PROC, lire_noise, 0);

    switch (unif_gauss)
    {
	case 0 : strcpy (stitre, paneltabs[20]); break;
	case 1 : strcpy (stitre, paneltabs[6]); break;
    }

    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	sprintf (rep, "%f", noisy->var);
    else strcpy (rep, "");

    noise_var = panel_create_item (panel_noise, PANEL_TEXT,
			    PANEL_SHOW_ITEM, TRUE,
			    PANEL_LABEL_X, ATTR_COL(1),
			    PANEL_LABEL_Y, ATTR_ROW(3),
			    PANEL_VALUE_DISPLAY_LENGTH, 20,
			    PANEL_VALUE_STORED_LENGTH, 20,
			    PANEL_LABEL_STRING, stitre,	
			    PANEL_VALUE, rep,
			    PANEL_NOTIFY_STRING, "\r\n\t\03",
			    PANEL_NOTIFY_PROC, lire_noise, 0);
    
    window_fit (panel_noise);
    window_fit (frame_noise);
    window_set (panel_noise, PANEL_CARET_ITEM, noise_esp, 0);
    noisy = (struct noise *) window_loop (frame_noise);
    return (noisy);
}
/*---------------------------------------------------------------------------*/
/* Nom : proc_bruit                                                          */
/* Fonction : Cette procedure sert a lire le choix de l'utilisateur (generer */
/* bruit uniforme ou gaussien) puis a appeler la procedure correspondante,   */
/* en tenant compte du type de l'image a bruiter; enfin elle procede a la    */
/* sauvegarde de la nouvelle image apres avoir calcule les caracteristiques  */
/* de celle-ci								     */
/* Entree : -		                                                     */
/* Global : struct noise *noisy						     */
/* Routines : noise_panel, pow, unif_byte, unif_short, unif_int, unif_float  */
/*	      gauss_byte, gauss_short, gauss_int, gauss_float		     */
/* Sortie : -								     */
/*---------------------------------------------------------------------------*/

caddr_t proc_bruit (m, mi)
    Menu    m;
    Menu_item	mi;
{
    int unif_gauss, pid;
    unsigned char *ima;             /* pointeur sur le plan_image de depart */
    struct noise *copynoisy;		     /* parametres du bruit */

    pid = getpid ();		  /* initialisation du generateur aleatoire */
    srandom (pid);		    /* en utilisant le numero du processus */

    unif_gauss = (int) menu_get (mi, MENU_VALUE);
if (flag_bother){ 
    if (unif_gauss) hproc_bruit_gauss();
    else hproc_bruit_unif();
    return;
}
if (flag_help){
    if (unif_gauss) hproc_bruit_gauss();    
    else hproc_bruit_unif();    
}
    if (!flag_creer)
    {
	if (unif_gauss)
	    sprintf (buf,mastertabs[14]);
	else 
	    sprintf (buf,mastertabs[15]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO)
    {
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else fromto (FROMTO, DEFAUT);

    if (flag_break) interruption();
    else
    {
	if (!flag_creer)
	{
	   sprintf (buf,"Image %d --> Image %d :",index_image[0],index_image[1]); 
	   write_master (buf);
	}

	if (flag_exec == AUTO || flag_exec == PARAM_AUTO)
	{
	    noisy = (struct noise *) malloc (sizeof (*noisy));
	    *noisy = *((struct noise *)macro_cour->param);
	}
	else noisy = noise_panel(unif_gauss);
	if (flag_break) interruption();
	else 
	{
	    if (flag_creer)				/* creation de macro */
	    {
		struct commande *com;
		com = (struct commande *) new_commande (&macro_cour);
		com->from[0] = index_image[0];
		com->to[0] = index_image[1];
		switch (unif_gauss)
		{
		    case 0 : sprintf(buf,"AUXMODNOIUNI FROM %d TO %d WITH %d %d\n",
				    index_image[0], index_image[1], (int)
				    rint(noisy->esp),(int) rint(noisy->var));
			    sprintf(com->nom,"AUXMODNOIUNI");
			    com->code = 1250;
			    break;
		    case 1 :sprintf(buf,"AUXMODNOIGAU FROM %d TO %d WITH %d %d\n",
				    index_image[0], index_image[1], (int)
				    rint(noisy->esp), (int) rint(noisy->var));
			    sprintf(com->nom,"AUXMODNOIGAU");
			    com->code = 1251;
			    break;
		} /* switch */
		write_macro(buf);
		copynoisy = (struct noise *) malloc (sizeof (*noisy));
		*copynoisy = *noisy;
		com->param = (char *) copynoisy;
	    }
	    else
	    {
		maxrand = pow (2.0, 31) - 1.0;
		carre = 2.0 * pow (noisy->var, 2);
		ima = (unsigned char *) dir_image[index_image[0]].image;

		if (unif_gauss)      /* si unif_gauss <> 0 => bruit gaussien */
		{
		    sprintf (buf,mastertabs[16],(int)rint(noisy->esp), (int) rint (noisy->var));
		    write_master (buf);
		    switch ( dir_desc[index_image[0]].type ) {
			case -1 :
			case 0 : gauss_byte(ima);
				 break;
			case 1 : gauss_short(ima);
				 break;
			case 2 : gauss_int(ima);
				 break;
			case 3 : gauss_float(ima);
			         break;

		    }
		}	
		else                       /* bruit uniforme */
		{
		    sprintf (buf,mastertabs[17],
			    (int) rint(noisy->esp),(int) rint (noisy->var));
		    write_master (buf);
		    switch ( dir_desc[index_image[0]].type ) {
			case -1 :
			case 0 : unif_byte(ima);
				 break;
			case 1 : unif_short(ima);
				 break;
			case 2 : unif_int(ima);
				 break;
			case 3 : unif_float(ima);
				 break;
		    }
		}

		dir_desc[index_image[1]].nligne = dir_desc[index_image[0]].nligne;
		dir_desc[index_image[1]].ncolonne = dir_desc[index_image[0]].ncolonne;
		if (dir_desc[index_image[0]].type <= 2)
		    dir_desc[index_image[1]].type = 2;
		else
		    dir_desc[index_image[1]].type =3;
		statis (dir_image[index_image[1]].image,
		    dir_desc[index_image[1]].type,
		    dir_desc[index_image[1]].nligne,
		    dir_desc[index_image[1]].ncolonne,
		    &dir_desc[index_image[1]].mmin,
		    &dir_desc[index_image[1]].mmax,
		    &dir_desc[index_image[1]].mu,
		    &dir_desc[index_image[1]].ecart);
	    }
	} /* else !flag_break */
    } /* !flag_break */

} /* proc_bruit */

/*----------------------------------------------------------------------*/
/* Nom : pow								*/
/* Fonction : calcul la puissance n-ieme d'un double			*/
/* Entree : double x,y							*/
/* Sortie : double p							*/
/*----------------------------------------------------------------------*/

double pow (x, y)

double x;
int y;

{
    double p = 1;

    while (y > 0) 
    {
	p = p * x;
	y --;
    }
    return (p);
}

/*----------------------------------------------------------------------*/
/* Nom : unif_byte                                                      */
/* Fonction : Ajoute du bruit uniforme (aleatoire) sur une image de     */
/* type byte                                                            */
/* Entree : *pic = unsigned char (pointeur sur l'image a bruiter)       */
/* Global : struct noise *noisy : parametres du bruit			*/
/* Routine : -								*/
/* Sortie : dir_image[index_image[1]].image		                */
/*----------------------------------------------------------------------*/

unif_byte (pic)

unsigned char *pic;

{
    int i;
    double res;
    unsigned char *wrk1;
    int *wrk2;
 
    wrk1 = pic;                 /* wrk1 = ptr de travail sur image depart */
    wrk2 = (int*) calloc (taille, sizeof (*wrk2) );
    dir_image[index_image[1]].image = (unsigned char *) wrk2;
    for (i=0; i < taille; i++)
	{					     /* on bruite l'image */
	    res = ((random()/maxrand)*(noisy->var+1)) - (noisy->var / 2.0);
	    *wrk2 = (int) *wrk1 + (int) rint(res) + (int) rint(noisy->esp);
	    wrk1++;
	    wrk2++;
	}
}

/*----------------------------------------------------------------------*/
/* Nom : unif_short                                                     */
/* Fonction : Ajoute du bruit uniforme (aleatoire) sur une image de     */
/* type short                                                           */
/* Entree : *pic = unsigned char (pointeur sur l'image a bruiter)       */
/* Global : struct noise *noisy : parametres du bruit			*/
/* Routine : -								*/
/* Sortie : dir_image[index_image[1]].image		                */
/*----------------------------------------------------------------------*/

unif_short (pic)

unsigned char *pic;

{
    int i;
    double res;
    short int *wrk1;
    int *wrk2;

    wrk1 = (short int*) pic;     /* wrk1 = ptr de travail sur image depart */
    wrk2 = (int*) calloc (taille, sizeof (*wrk2) );
    dir_image[index_image[1]].image = (unsigned char *) wrk2;
    for (i=0; i < taille; i++)
	{					      /* on bruite l'image */
	    res = ((random()/maxrand) * noisy->var)-(noisy->var / 2.0);
	    *wrk2 = (int) *wrk1 + (int) rint(res) + (int) rint(noisy->esp);
	    wrk1++;
	    wrk2++;
	}
}

/*----------------------------------------------------------------------*/
/* Nom : unif_int                                                       */
/* Fonction : Ajoute du bruit uniforme (aleatoire) sur une image de     */
/* type integer                                                         */
/* Entree : *pic = unsigned char (pointeur sur l'image a bruiter)       */
/* Global : struct noise *noisy : parametres du bruit			*/
/* Routine : -								*/
/* Sortie : dir_image[index_image[1]].image		                */
/*----------------------------------------------------------------------*/

unif_int (pic)

unsigned char *pic;

{
    int i;
    double res;
    int *wrk1, *wrk2;

    wrk1 = (int*) pic;       /* wrk1 = ptr de travail sur image depart */
    wrk2 = (int*) calloc (taille, sizeof (*wrk2) );
    dir_image[index_image[1]].image = (unsigned char *) wrk2;
    for (i=0; i < taille; i++)
	{					/* on bruite l'image */
	    res = ((random()/maxrand) * noisy->var)-(noisy->var/ 2.0);
	    *wrk2 = (int) *wrk1 + (int) rint(res) + (int) rint(noisy->esp);
	    wrk1++;
	    wrk2++;
	}
}

/*----------------------------------------------------------------------*/
/* Nom : unif_float                                                     */
/* Fonction : Ajoute du bruit uniforme (aleatoire) sur une image de     */
/* type float                                                           */
/* Entree : *pic = unsigned char (pointeur sur l'image a bruiter)       */
/* Global : struct noise *noisy : parametres du bruit			*/
/* Routine : -								*/
/* Sortie : dir_image[index_image[1]].image		                */
/*----------------------------------------------------------------------*/

unif_float (pic)

unsigned char *pic;

{
    int i;
    double res;
    float *wrk1, *wrk2;

    wrk1 = (float*) pic;     /* wrk1 = ptr de travail sur image depart */
    wrk2 = (float*) calloc (taille, sizeof (*wrk2) );
    dir_image[index_image[1]].image = (unsigned char *) wrk2;
    for (i=0; i < taille; i++)
	{					 /* on bruite l'image */
	    res = ((random()/maxrand) * noisy->var)-(noisy->var / 2.0);
	    *wrk2 = *wrk1 + (float) res + (float) noisy->esp;
	    wrk1++;
	    wrk2++;
	}
}

/*--------------------------------------------------------------------*/
/* Nom : gauss_byte                                                   */
/* Fonction : Ajoute du bruit de type gaussien sur une image de type  */
/* byte  							      */
/* Entree : *pic = unsigned char (pointeur sur l'image a bruiter)     */
/* Global : struct noise *noisy : parametres du bruit			*/
/* Routine : -								*/
/* Sortie : dir_image[index_image[1]].image		              */
/*--------------------------------------------------------------------*/

gauss_byte (pic)

unsigned char *pic;

{
    int i;
    int *wrk2;
    double y, alea;
    unsigned char *wrk1;

    wrk1 = pic;                /* 1er element du fichier a bruiter */
    wrk2 = (int*) calloc (taille, sizeof (*wrk2));
    dir_image[index_image[1]].image = (unsigned char *) wrk2;
    for (i = 0; i < taille; i++)
	{
	if (i % 2 == 0)
	    {
	    alea = (double) (random () / maxrand);
	    y = sqrt (carre * log(1.0 / alea ));
				  /* v.a a distribution de Rayleigh */
	    alea = (double) (random () / maxrand);
	    *wrk2 = (int) *wrk1 + (int) rint((y * cos(d_M_PI * alea)) + noisy->esp);
			       	   /* on a ajoute le bruit gaussien */
	    }
	    else 
	     *wrk2 = (int)*wrk1 + (int) rint((y * sin(d_M_PI * alea)) + noisy->esp);
			       	   /* on a ajoute le bruit gaussien */
	wrk1++;
	wrk2++;
       }
}

/*--------------------------------------------------------------------*/
/* Nom : gauss_short                                                  */
/* Fonction : Ajoute du bruit de type gaussien sur une image de type  */
/* short							      */
/* Entree : *pic = unsigned char (pointeur sur l'image a bruiter)     */
/* Global : struct noise *noisy : parametres du bruit			*/
/* Routine : -								*/
/* Sortie : dir_image[index_image[1]].image		              */
/*--------------------------------------------------------------------*/

gauss_short (pic)

unsigned char *pic;

{
    int i;
    int *wrk2;
    double y, alea;
    short int *wrk1;

    wrk1 = (short int*) pic;     /* 1er element du fichier a bruiter */
    wrk2 = (int*) calloc (taille, sizeof (*wrk2));
    dir_image[index_image[1]].image = (unsigned char *) wrk2;
    for (i = 0; i < taille; i++)
	{
	if (i % 2 == 0)
	    {
	    alea = (double) (random () / maxrand);
	    y = sqrt (carre * log(1.0 / alea ));
				  /* v.a a distribution de Rayleigh */
	    alea = (double) (random () / maxrand);
	    *wrk2 = (int) *wrk1 + (int) rint((y * cos(d_M_PI * alea)) + noisy->esp);
			       	   /* on a ajoute le bruit gaussien */
	    }
	    else 
	     *wrk2 = (int)*wrk1 + (int) rint((y * sin(d_M_PI * alea)) + noisy->esp);
			       	   /* on a ajoute le bruit gaussien */
	wrk1++;
	wrk2++;
       }
}

/*--------------------------------------------------------------------*/
/* Nom : gauss_int                                                    */
/* Fonction : Ajoute du bruit de type gaussien sur une image de type  */
/* integer							      */
/* Entree : *pic = unsigned char (pointeur sur l'image a bruiter)     */
/* Global : struct noise *noisy : parametres du bruit			*/
/* Routine : -								*/
/* Sortie : dir_image[index_image[1]].image		              */
/*--------------------------------------------------------------------*/

gauss_int (pic)

unsigned char *pic;

{
    int i;
    int *wrk1, *wrk2;
    static double y, alea;

    wrk1 = (int*) pic;           /* 1er element du fichier a bruiter */
    wrk2 = (int*) calloc (taille, sizeof (*wrk2));
    dir_image[index_image[1]].image = (unsigned char *) wrk2;
    for (i = 0; i < taille; i++)
	{
	if (i % 2 == 0)
	    {
	    alea = (double) (random () / maxrand);
	    y = (double) sqrt (carre * log( (double)1.0 / alea ));
				  /* v.a a distribution de Rayleigh */
	    alea = (double) (random () / maxrand);
	    *wrk2 = *wrk1 + (int) rint((y * cos(d_M_PI * alea)) + noisy->esp);
			       	   /* on a ajoute le bruit gaussien */
	    }
	    else 
	     *wrk2 = *wrk1 + (int) rint((y * sin(d_M_PI * alea)) + noisy->esp);
			       	   /* on a ajoute le bruit gaussien */
	wrk1++;
	wrk2++;
       }
}

/*--------------------------------------------------------------------*/
/* Nom : gauss_float                                                  */
/* Fonction : Ajoute du bruit de type gaussien sur une image de type  */
/* float							      */
/* Entree : *pic = unsigned char (pointeur sur l'image a bruiter)     */
/* Global : struct noise *noisy : parametres du bruit			*/
/* Routine : -								*/
/* Sortie : dir_image[index_image[1]].image		              */
/*--------------------------------------------------------------------*/

gauss_float (pic)

unsigned char *pic;

{
    int i;
    double y, alea;
    float *wrk1, *wrk2;

    wrk1 = (float*) pic;         /* 1er element du fichier a bruiter */
    wrk2 = (float*) calloc (taille, sizeof (*wrk2));
    dir_image[index_image[1]].image = (unsigned char *) wrk2;
    for (i = 0; i < taille; i++)
	{
	if (i % 2 == 0)
	    {
	    alea = (double) (random () / maxrand);
	    y = sqrt ( carre * log(1.0 / alea ));
				  /* v.a a distribution de Rayleigh */
	    alea = (double) (random () / maxrand);
	    *wrk2 = *wrk1 + (float) ((y * cos(d_M_PI * alea)) + noisy->esp); 
			       	   /* on a ajoute le bruit gaussien */
	    }
	    else 
	     *wrk2 = *wrk1 + (float) ((y * sin(d_M_PI * alea)) + noisy->esp); 
			       	   /* on a ajoute le bruit gaussien */
	wrk1++;
	wrk2++;
       }
}
