; segment.lisp -- Common lisp functions for using segment memory
; Feb. 21, 1988

;instead of declaration global variables and external functions,
;load file "global" and "rel_ordre" for compiler

(eval-when (compile) (load "rel_ordre.sbin"))
(eval-when (compile) (load "global.sbin"))



(defun Reponsep1_p2 (p1 p2 &optional str)
  (let (lu)
    (and str (format t str)
             (finish-output t))
    (format t " ~S or ~S !" p1 p2)
    (finish-output t)
    (setq lu (read-line))
    (cond ((equal lu p1) p1)
          ((equal lu p2) p2)
          (T (Reponsep1_p2 p1 p2 "~%Please: Your answer must be")))))
 

(defun Lire_float (&optional str)
  (let (lu)
    (and str (format t str)
             (finish-output t))
    (format t "Input your belief factor -1 -> 1 (No -> Yes): ")
    (finish-output t)
    (setq lu (read-from-string (read-line)))        ;;(read))
    (cond ((and (numberp lu) (>= lu -1) (<= lu 1)) (float lu))
          (T (Lire_float "~%Error: You must give a float !")))))


(defun Lire_int (&optional str)
  (let (lu)
    (and str (format t str)
             (finish-output t))
    (setq lu (read-from-string (read-line)))        ;;(read))
    (cond ((and (numberp lu) (integerp lu)) lu)
          (T (Lire_int "~%Error: You must give an integer !")))))



; pass command word to c proc.
; "e": awake c proc, lisp proc. terminate
; "i": input integer, "b": input float
; "c": input string whose value should be p1 or p2

(defun wait_answer (flg p1 p2)
; flg must be a string
    (cond ((string= flg "e") (format t "~%Fin de l'execution!")
                             (finish-output t))
          ((string= flg "c") (Reponsep1_p2 p1 p2))
          ((string= flg "i") (Lire_int))
          ((string= flg "b") (Lire_float))
          ((string= flg "s") (sleep 5))
	  (t ())
))

(defun ACQUIRE (c)
    (terpri)
    (msg "Are you satisfied with the result of " c " ? ")
    (wait_answer "c" "y" "n")
)

(defun EXPLAIN (para)
  (msg "Explaination? ")
  (let (q)
     (setq q (wait_answer "c" "y" "n"))
     (cond ((string= q "y")
            (msg "	Because you gave me these information: " #\N)
            (DIS_RECORD (reverse para)))
     )
  )
  (msg "Please: APPLY the METHOD using LABOIMAGE" #\N)
  (finish-output t)
)


    
(defun READ_F (name)
  (msg #\N #\T "-------------------------------------------------")
  (msg #\N #\T "RECORD OF PROCESSING : " #\N)
  (let (p_file rcdlst)
    (setq p_file (open name :direction :input))
    (setq rcdlst (read p_file NIL))
    (REPEAT p_file rcdlst)
    (close p_file)
  )
)

(defun B_W ()
  (msg #\N "For your video terminal " #\N)
  (msg "   1. gray level 0 corresponds to black and dark" #\N)
  (msg "   2. gray level 0 corresponds to white and bright" #\N)
  (msg "Input: ")
  (let (q)
     (setq q (wait_answer "c" "1" "2"))
     (cond ((string= q "1") (setq blackwhite 'black_0))
	   (t (setq blackwhite 'white_0))
     )
  )
)

(defun DY_RANGE (inform)
    (for
	eachtime
	    (msg #\N "The maximal gray level of the image: ")
	    (setq max_gray_level (wait_answer "i" "0" "0"))
	    (msg "The minimal gray level of the image: ")
	    (setq min_gray_level (wait_answer "i" "0" "0"))
	    (msg "The available range of gray level scale: ")
	    (setq scale (wait_answer "i" "0" "0"))
	until (and (>= max_gray_level min_gray_level)
		   (>= scale max_gray_level))
    )
    (let ((tie inform))
        (set tie (cons (list 'maximal_gray_level max_gray_level) (eval tie)))
        (set tie (cons (list 'minimal_gray_level min_gray_level) (eval tie)))
        (set tie (cons (list 'gray_level_scale scale) (eval tie)))
    )
)

(defun MEDIAN_FLT (inform context)
    (LINE)
    (preced context)
    (msg #\T "- USE MEDIAN FILTER WITH WINDOW SIZE N * N, IF DEFECTS TO " #\N)
    (msg #\T "  ELIMINATE ARE LESS THAN N * N / 2")
    (LINE)
    (let ((tie inform))
	(EXPLAIN (eval tie))
        (wait_answer "s" "0" "0")
	(msg "The window size S = ")
	(setq window_size (wait_answer "i" "0" "0"))
	(set tie (cons (list 'filter_size window_size) (eval tie)))
	(setq record (cons (list 'median_filter window_size) record))
    )
)

(defun CORRELATION (context)
  (LINE)
  (preced context)
  (msg #\T "- USE CHABLON TO SELECT ONE TYPICAL ELEMENT AS TEMPLATE,")
  (LINE)
  (EXPLAIN info_crlt)
  (wait_answer "s" "0" "0")
  (let (m s)
    (msg #\N "The size of template T = ")
    (setq m (wait_answer "i" "0" "0"))
    (msg "The size of image P = ")
    (setq s (wait_answer "i" "0" "0"))
    (setq info_crlt (cons (list 'template_size m) info_crlt))
    (setq info_crlt (cons (list 'image_size s) info_crlt))
    (LINE)
    (cond ((< (* m m) (+ 4 (* (/ (log s) (log 2)) (/ 27 2))))
	   (msg #\T "- PERFORM CORRELATION BETWEEN THIS IMAGE AND TEMPLATE WITH" #\N)
	   (msg #\T "  DIRECT METHOD")
	   (setq record (cons 'correlation_with_direct_method record)))
	  (t
 	    (msg #\T "- USE FOURIER TRANSFORMATION TO PERFORM CORRELATION BETWEEN" #\N)
	    (msg #\T "  THIS IMAGE AND TEMPLATE : " #\N)
	    (msg #\T "  IF THE SIZE OF THE IMAGE IS NOT THE POWER OF 2, EXTEND IT" #\N)
	    (msg #\T "  WITH THE GRAY LEVEL VALUE AT ITS EDGE," #\N)
	    (msg #\T "  EXTEND THE TEMPLATE TO THE SAME SIZE OF THE IMAGE WITH THE" #\N)
	    (msg #\T "  GRAY LEVEL VALUE 0," #\N)
	    (msg #\T "  IMAGE ==> FFT ==> X(f)" #\N)
	    (msg #\T "  TEMPLATE ==> FFT ==> Y(f)" #\N)
	    (msg #\T "- PERFORM MULTIPLICATION:" #\N)
	    (msg #\T "  X(f) * Y(f) ==> Z(f)" #\N)
	    (msg #\T "- CALCULATE INVERSE FOURIER TRANSFORMATION OF Z(f).")
	    (setq record (cons 'correlation_with_FFT record))
	  )
    )
    (LINE)
    )
    (EXPLAIN info_crlt)
    (wait_answer "s" "0" "0")
    (putprop context 'correlation 'step)
)

(defun RECURSIVE_MAP (inform context)
    (LINE)
    (preced context)
    (msg #\T "1. CALCULATE GRAY LEVEL HISTOGRAM OF THE UNSEGMENTED REGION," #\N)
    (msg #\T "   ACCORDING TO THE BEST PEAK, SELECT THE UPPER AND LOWER" #\N)
    (msg #\T "   THRESHOLDS DERIVED FROM ITS UPPER AND LOWER BOUNDS;" #\N)
    (msg #\T "2. THRESHOLD THIS REGION: " #\N)
    (msg #\T "   THE POINTS WITHIN THE TWO THRESHOLD LIMITS ARE EXTRACTED" #\N)
    (msg #\T "   AS A CLASS OF OBJECTS," #\N)
    (msg #\T "   THE REMAINS ARE KEPT AS UNSEGMENTED REGION;" #\N)
    (msg #\T "3. EXTRACT CONNECTED AREAS FROM THE UNSEGMENTED REGION, SAVE" #\N)
    (msg #\T "   THEM FOR FURTHER SEGMENTATION," #\N)
    (msg #\T "EXECUTE 1.~ 3. RECURSIVELY UNTIL THERE IS NO BETTER PEAKS IN" #\N)
    (msg #\T "HISTOGRAM OR ALL THE AREAS ARE SMALL ENOUGH.")
    (LINE)
    (let ((tie inform))
        (EXPLAIN (eval tie))
        (wait_answer "s" "0" "0")
        (set tie (cons (list 'recursive 'segmentation) (eval tie)))
        (setq record (cons (list 'recursive 'segmentation) record))
    )
    (putprop context 'non 'step)
)

