;uommacs.lisp

(eval-when (compile) (load "uomfuncs"))

(defvar poport)
(defvar $$val)

(defmacro push1 (stk &rest items)
  (cond ((onep (length items))
	   `(setf ,stk (cons ,(car items) ,stk)))
	(t `(setf ,stk (nconc (list ,.items) ,stk)))))


;
;	for:	        a macro for generalized looping and mapping.
;                       based loosely on that found in Interlisp.
;
;	initial release:	August 1981           Randy Trigg
;	05/10/82	added	keywords from, fromd, quit, being, eachtime.
;                       improved efficiency somewhat.  Removed selectq and if
;                                calls from code.
;	04/2/84		added destructuring to in, thinking about adding it
;			elsewhere. JRB@UOM




(defmacro for (&rest COMM)
   (let ((var-val '($$val))
         do-args conds var-conds if-conds result body 
         in-on-arg let-args do-stmt
         inits eaches final)
    (do ((key-phrase (divide-at-key COMM)) (key))
        ((null COMM))
        (setq key (car COMM))
	(setq key-phrase (divide-at-key (cdr COMM)))
        (cond
	 ((eq key 'while)
	  (setq conds (cons (list 'not (mkprogn key-phrase)) conds)))
	 ((eq key 'until)
	  (setq conds (cons (mkprogn key-phrase) conds)))
	 ((eq key 'when)
	  (setq if-conds (cons (mkprogn key-phrase) if-conds)))
	 ((eq key 'unless)
	  (setq if-conds (cons (list 'not (mkprogn key-phrase)) 
			       if-conds)))
	 ((eq key 'let)
	  (setq let-args (nconc let-args key-phrase)))
	 ((eq key 'bind)
	  (setq do-args (nconc do-args (mapcar 'mklist key-phrase))))
	 ((eq key 'being)
	  (setq do-args 
		(nconc do-args 
		       (mapcar #'(lambda (x)
					 (setq x (mklist x))
					 (cond ((onep (length x))
						`(,(car x) nil nil))
					       ((eq (length x) 2)
						`(,(car x) ,(cadr x) ,(cadr x)))
					       (t x)))
			       key-phrase))))
	 ((eq key 'on)
	  (and (cddr key-phrase) (error "missing for keyword"))
	  (setq in-on-arg (car key-phrase))
	  (setq do-args 
		(nconc do-args (list (on-hdlr in-on-arg (cadr key-phrase)))))
	  (setq var-conds (cons (list 'null in-on-arg) var-conds)))
	 ((eq key 'in)
	  (and (cddr key-phrase) (error "missing for keyword"))
	  (setq in-on-arg (gensym)
		let-args (nconc let-args (ncons in-on-arg)))
	  (setq do-args (nconc do-args (in-hdlr (car key-phrase) 
						in-on-arg 
						(cadr key-phrase))))
	  (setq var-conds (cons (list 'null in-on-arg) var-conds)))
	 ((eq key 'from)
	  (and (cddddr key-phrase) (error "missing for keyword"))
	  (let ((var (car key-phrase))
		(from-arg (cadr key-phrase))
		(to-arg (caddr key-phrase))
		(by-arg (cadddr key-phrase))
		save-val)
	       (and (dtpr to-arg)
		    (setq save-val to-arg to-arg (gensym))
		    (setq let-args (nconc let-args `((,to-arg ,save-val)))))
	       (and (dtpr by-arg)
		    (setq save-val by-arg by-arg (gensym))
		    (setq let-args (nconc let-args `((,by-arg ,save-val)))))
	       (setq do-args 
		     (nconc do-args (list `(,var 
					    ,from-arg 
					    ,(cond ((onep by-arg) `(add1 ,var))
						   (t `(+ ,var ,by-arg)))))))
	       (and to-arg (setq var-conds (cons `(greaterp ,var ,to-arg)
						 var-conds)))))
	 ((eq key 'fromd)
	  (and (cddddr key-phrase) (error "missing for keyword"))
	  (let ((var (car key-phrase))
		(fromd-arg (cadr key-phrase))
		(to-arg (caddr key-phrase))
		(by-arg (cadddr key-phrase))
		save-val)
	       (and (dtpr to-arg)
		    (setq save-val to-arg to-arg (gensym))
		    (setq let-args (nconc let-args `((,to-arg ,save-val)))))
	       (and (dtpr by-arg)
		    (setq save-val by-arg by-arg (gensym))
		    (setq let-args (nconc let-args `((,by-arg ,save-val)))))
	       (setq do-args 
		     (nconc do-args (list `(,var 
					    ,fromd-arg 
					    ,(cond ((onep by-arg) `(1- ,var))
						   (t `(difference
							,var ,by-arg)))))))
	       (and to-arg (setq var-conds (cons `(lessp ,var ,to-arg)
						 var-conds)))))
	 ((eq key 'initially)
	  (setq inits (nconc inits key-phrase)))
	 ((eq key 'eachtime)
	  (setq eaches (nconc eaches key-phrase)))
	 ((eq key 'do)
	  (setq body (mkprogn key-phrase)
		result nil))
	 ((eq key 'collect)
	  (setq body `(setq $$val (cons ,(mkprogn key-phrase) $$val))
		result '(reverse $$val)))
	 ((eq key 'tcollect)
	  (setq body `(tconc $$val ,(mkprogn key-phrase))
		var-val '($$val (ncons nil))
		result '$$val))
	 ((eq key 'join)
	  (setq body `(setq $$val (nconc $$val ,(mkprogn key-phrase)))
		result '$$val))
	 ((eq key 'tjoin)
	  (setq body `(lconc $$val ,(mkprogn key-phrase))
		var-val '($$val (ncons nil))
		result '$$val))
	 ((eq key 'sum)
	  (setq body `(setq $$val (+ $$val ,(mkprogn key-phrase)))
		var-val '($$val 0)
		result '$$val))
	 ((eq key 'count)
	  (setq body `(and (setq $$val (add1 $$val)) 
			   ,(mkprogn key-phrase))
		var-val '($$val 0)
		result '$$val))
	 ((eq key 'always)
	  (setq body `(or (setq $$val ,(mkprogn key-phrase)) 
			  (return nil))
		result '(or $$val t)))
	 ((eq key 'never)
	  (setq body `(and ,(mkprogn key-phrase) (return nil))
		result 't))
	 ((eq key 'thereis)
	  (setq body `(and (setq $$val ,(mkprogn key-phrase))
			   (return $$val))
		result nil))
	 ((eq key 'quit)
	  (setq body `(return ,(mkprogn key-phrase))
		result nil))
	 ((eq key 'last)
	  (setq body `(setq $$val ,(mkprogn key-phrase))
		result '$$val))
	 ((eq key 'finally)
	  (setq final 
		(cond ((eq result '$$val) key-phrase)
		      (t (cons `(setq $$val ,result) key-phrase)))))
	 (t '())))

    (and if-conds 
	 (setq body `(and ,@(nreverse if-conds) ,body)))

    (setq conds (nconc (nreverse var-conds) (nreverse conds)))
    (cond ((cdr conds) (setq conds (cons 'or conds)))
          (t (setq conds (car conds))))
    (and eaches
	 (setq conds `(progn ,@eaches ,conds)))

    (cond (final (setq result final))
	  (t (setq result (list result))))

    (cond (body
              (setq do-stmt 
	       `(do ,(cons var-val do-args) (,conds ,@result) ,body)))
          (t  (setq do-stmt
               `(do ,(cons var-val do-args) (,conds ,@result)))))
    (cond ((or inits let-args) `(let ,let-args ,@inits ,do-stmt))
          (t do-stmt))))


; auxiliary functions for macro msg

(defun warn-msg-F (x)
  (princ "Warning:  msg contains old-fashioned F form: ")
  (princ x)
  (princ ".")
  (terpri)
  (princ "       Use just ")
  (princ (cadr x))
  (princ " instead." )
  (terpri))

(defun printblanks(n prt)
      (let ((easy (member n '( 0  ""
			     1  " "
			     2  "  "
			     3  "   "
			     4  "    "
			     5  "     "
			     6  "      "
			     7  "       "
			     8  "        "))))
	 (cond (easy (princ (cadr easy) prt))
	       (t (do ((i n (1- i)))
		      ((lessp i 1))
		      (princ " " prt))))))


; alias to translate spaces to printblanks
(defmacro spaces (x &optional port)
  `(printblanks ,x ,port))


(defun common-tabs (n &optional (oport poport))
  (for i from 1 to n bind (tab (code-char 9)) do (princ tab oport)))

(defun crlf (n &optional (oport poport))
  (for i from 1 to n do (terpri oport)))

(defun column (n &optional (oport poport))
        (terpri oport)
        (spaces n oport))



;
; msg -- handy macro for formatting output.  Written by Liz Allen.
;

(defmacro msg (&rest lst)
  (do ((lx lst (cdr lx))
       (x) (oport) (result))
      ((null lx) (cond ((null result) nil)
		       ((cdr result) `(progn ,.(nreverse result)))
		       (t (car result))))
      (setq x (car lx))
      (cond ((and (dtpr x) (eq (car x) 'P))
	     (setq oport (ncons (cadr x))))
	    ((equal x ""))
	    ((equal x ''||))
	    (t (setq result
		     (cons (cond ((stringp x) `(princ ,x ,.oport))
				 ((eq x #\B) `(princ " " ,.oport))
				 ((eq x #\T) `(princ "       "  ,.oport))
				 ((eq x #\N) `(terpri ,.oport))
				 ((eq x #\D) `(finish-output ,.oport))
				 ((atom x) `(princ ,x ,.oport))
				 ((eq (car x) #\B) `(spaces ,(cadr x) ,.oport))
				 ((eq (car x) #\T)
				              `(common-tabs ,(cadr x) ,.oport))
				 ((eq (car x) #\C) `(column ,(cadr x) ,.oport))
				 ((eq (car x) #\N) `(crlf ,(cadr x) ,.oport))
				 ((eq (car x) #\L) `(print ,(cadr x) ,.oport))
				 ((eq (car x) #\F)  (warn-msg-F x)
				                   `(princ ,(cadr x) ,.oport))
				 (t `(princ ,x ,.oport)))
			   result))))))

