/*
  File: devTriangle.c
  Author: K.R. Sloan
          Jamie Painter
  Last Modified: 7 July 1989
  Purpose: draw solid and shaded triangles.
  Assumptions: L<R , B<T           
 */

#include <stdio.h>
#include "DEVICE.h"
#include "vertigo.h"

extern int pb_id;

#define Interpolate(u, u0, u1, v0, v1 ) \
  ((u1 == u0) ? (v0+v1) / 2 : (v0 + ((u-u0)*(v1-v0))/(u1-u0)))

/*
   This is the place to optimize for a particular device...
 */
pbshadeline( y1, x1, x2, c1, c2 )
 register int y1, x1;
 int c1, c2, x2;
 {
  register int r,  g,  b;
  register dr, dg, db;
  register rerr, gerr, berr;
  int er, eg, eb;
  int erincr1, erincr2, egincr1, egincr2, ebincr1, ebincr2;
  int rincr, gincr, bincr;  
  int count;
  byte buffer[4][640];
  int i, x0=x1, y0=y1;

  if (x2 == x1) 
   {
    fb_w_pixel( pb_id, x1, y1,
                (c1&0xff), ( (c1>>8) & 0xff), ( (c1>>16) & 0xff),
	        0xff );
    return;
   }

  r = c1 & 0xff;
  g = (c1 >> 8)  & 0xff;
  b = (c1 >> 16) & 0xff;

  count = x2 - x1 + 1;
  x2 = x2 - x1;

  dr = (c2 & 0xFF) - r;
  er = dr % x2;
  dr /= x2;
  if (er < 0) { er = -er; rincr = -0x1; } else rincr = 0x1;
  erincr1 = 2*er - 2*x2;
  erincr2 = 2*er;

  dg = ((c2 >> 8) & 0xff)  - g;
  eg = dg % x2;
  dg /= x2;
  if (eg < 0) { eg = -eg; gincr = -0x1; } else gincr = 0x1;
  egincr1 = 2*eg - 2*x2;
  egincr2 = 2*eg;

  db = ((c2 >> 16) & 0xFF)  - b;
  eb = db % x2;
  db /= x2;
  if (eb < 0) { eb = -eb; bincr = -0x1; } else bincr = 0x1;
  ebincr1 = 2*eb - 2*x2;
  ebincr2 = 2*eb;

  rerr = 2*er - x2;
  gerr = 2*eg - x2;
  berr = 2*eb - x2;

  for(i=0; i<count; i++) 
   {
    buffer[0][i] = r;
    buffer[1][i] = g;
    buffer[2][i] = b ;
    buffer[3][i] = 0xFF;
    x1 ++;
    r += dr; g += dg; b += db;

    if (rerr > 0) 
     {
      r += rincr;;
      rerr += erincr1;
     }
    else 
     {
      rerr += erincr2;
     }

    if (gerr > 0) 
     {
      g += gincr;
      gerr += egincr1;
     }
    else 
     {
      gerr += egincr2;
     }

    if (berr > 0) 
     {
      b += bincr;
      berr += ebincr1;
     }
    else
     {
      berr += ebincr2;
     }
   }
  fb_w_row( pb_id, x0, y0, count, 
	   &(buffer[0][0]), 
	   &(buffer[1][0]), 
	   &(buffer[2][0]), 
	   &(buffer[3][0])  );
 }
      
  
/*
   Note that this version uses INTEGER r,g,b values and hand
   encodes/decodes the color values
 */
static void devShadeLine(y, xL, xR, rL, gL, bL, rR, gR, bR)
 int y, xL, xR;
 int rL, gL, bL, rR, gR, bR;
 {
  int cxL, cxR, clr1, clr2;
  int t;
   
  if (xL > xR) 
   {
    t = xR;  xR = xL; xL = t;
    t = rR;  rR = rL; rL = t;
    t = gR;  gR = gL; gL = t;
    t = bR;  bR = bL; bL = t;
   }

  if (   (y  < devClipB)
       ||(y  > devClipT)
       ||(xR < devClipL)
       ||(xL > devClipR) 
     )
   return;

  cxL = xL;
  cxR = xR;
  if (cxL < devClipL) 
   {
    cxL = devClipL;
    clr1 = (  ((Interpolate( cxL, xL, xR, rL, rR ) & 0xFF)       )
            | ((Interpolate( cxL, xL, xR, gL, gR ) & 0xFF) << 8  )
            | ((Interpolate( cxL, xL, xR, bL, bR ) & 0xFF) << 16 ) );
   }
  else 
   {
    clr1 = (rL & 0xff) | ((gL & 0xff) << 8) | ((bL & 0xff) << 16);
   }

  if (cxR > devClipR) 
   {
    cxR = devClipR;
    clr2 = (  ((Interpolate( cxR, xL, xR, rL, rR ) & 0xFF)       )
            | ((Interpolate( cxR, xL, xR, gL, gR ) & 0xFF) << 8  )
            | ((Interpolate( cxR, xL, xR, bL, bR ) & 0xFF) << 16 ) );
   }
  else 
   {
    clr2 = (rR & 0xff) | ((gR & 0xff) << 8) | ((bR & 0xff) << 16);
   }

   pbshadeline( y, cxL, cxR, clr1, clr2 );
 }

int devSolidTriangle(x0, y0, x1, y1, x2, y2)
 int x0, y0, x1, y1, x2, y2;
 {
  int xR, xL, x, y, t;
  int left, right, middle, top, bottom;

  /* sort the vertices in increasing order */
  if (y0 > y1)
   {
    t=y0; y0 = y1; y1 = t;
    t=x0; x0 = x1; x1 = t;
   }
  if (y1 > y2)
   {
    t=y1; y1 = y2; y2 = t;
    t=x1; x1 = x2; x2 = t;
   }
  if (y0 > y1)
   {
    t=y0; y0 = y1; y1 = t;
    t=x0; x0 = x1; x1 = t;
   }

  /* look for a quick kill */
  top = y2; bottom = y0;
  left = x0; middle = x1; right = x2;
  if (left   > middle) { t =   left; left   = middle; middle = t; }
  if (middle > right ) { t = middle; middle =  right; right  = t; }
  if (left   > middle) { t =   left; left   = middle; middle = t; }
  if (devClipRectangle(&left, &top, &right, &bottom))
   return 0;

  /* scan convert */
  for (y = y0; y <= y1; y++)
   {
    xL=Interpolate(y, y0, y1, x0, x1);
    xR=Interpolate(y, y0, y2, x0, x2);
    devRect(xL, y, xR, y);
   }

  for (y = y1; y<= y2; y++)
   {
    xL=Interpolate(y, y1, y2, x1, x2);
    xR=Interpolate(y, y0, y2, x0, x2);
    devRect(xL, y, xR, y);
   }

  return (0); /* success */
 } 

int devShadeTriangle(x0, y0, c0, x1, y1, c1, x2, y2, c2)
 int x0, y0, c0, x1, y1, c1, x2, y2, c2; 
 {
  int t;
  double r0, g0, b0, r1, g1, b1, r2, g2, b2;
  int    ir0, ig0, ib0, ir1, ig1, ib1, ir2, ig2, ib2;
  int y, xL, xR, rL, rR, gL, gR, bL, bR;
  int left, top, right, bottom, middle;

  /* sort vertices in increasing y order */
  if (y0 > y1)
   {
    t=y0; y0 = y1; y1 = t;
    t=x0; x0 = x1; x1 = t;
    t=c0; c0 = c1; c1 = t;
   }
  if (y1 > y2)
   {
    t=y1; y1 = y2; y2 = t;
    t=x1; x1 = x2; x2 = t;
    t=c1; c1 = c2; c2 = t;
   }
  if (y0 > y1)
   {
    t=y0; y0 = y1; y1 = t;
    t=x0; x0 = x1; x1 = t;
    t=c0; c0 = c1; c1 = t;
   }

  /* look for a quick kill */
  top = y2; bottom = y0;
  left = x0; middle = x1; right = x2;
  if (left   > middle) { t =   left; left   = middle; middle = t; }
  if (middle > right ) { t = middle; middle =  right; right  = t; }
  if (left   > middle) { t =   left; left   = middle; middle = t; }
  if (devClipRectangle(&left, &top, &right, &bottom))
   return 0;

  /* in general, we can't interpolate codes - go to r,g,b */
  (void)devColorDecode(c0, &r0, &g0, &b0);
  ir0 = r0*255.0;
  ig0 = g0*255.0;
  ib0 = b0*255.0;
  (void)devColorDecode(c1, &r1, &g1, &b1);
  ir1 = r1*255.0;
  ig1 = g1*255.0;
  ib1 = b1*255.0;
  (void)devColorDecode(c2, &r2, &g2, &b2);
  ir2 = r2*255.0;
  ig2 = g2*255.0;
  ib2 = b2*255.0;

  /* scan convert */
  for (y = y0; y <= y1; y++)
   {
    xL=Interpolate(y, y0, y1, x0, x1);
    rL=Interpolate(y, y0, y1, ir0, ir1);
    gL=Interpolate(y, y0, y1, ig0, ig1);
    bL=Interpolate(y, y0, y1, ib0, ib1);
    xR=Interpolate(y, y0, y2, x0, x2);
    rR=Interpolate(y, y0, y2, ir0, ir2);
    gR=Interpolate(y, y0, y2, ig0, ig2);
    bR=Interpolate(y, y0, y2, ib0, ib2);
    devShadeLine(y, xL, xR, rL, gL, bL, rR, gR, bR);
   }

  for (y = y1; y <= y2; y++)
   {
    xL=Interpolate(y, y1, y2, x1, x2);
    rL=Interpolate(y, y1, y2, ir1, ir2);
    gL=Interpolate(y, y1, y2, ig1, ig2);
    bL=Interpolate(y, y1, y2, ib1, ib2);
    xR=Interpolate(y, y0, y2, x0, x2);
    rR=Interpolate(y, y0, y2, ir0, ir2);
    gR=Interpolate(y, y0, y2, ig0, ig2);
    bR=Interpolate(y, y0, y2, ib0, ib2);
    devShadeLine(y, xL, xR, rL, gL, bL, rR, gR, bR);
   }
 }

