/*
   File: devLine.c
   Author: K.R. Sloan
   Last Modified: 6 July 1989
   Purpose: a primitive line-drawing function (Bresenham's algorithm)
            the basic graphics primitives used are:
                   devClipLine and devRect.
 */
#include <stdio.h>
#include "DEVICE.h"

/*
  Draw a line from (x1,y1) to (x2,y2) using Bresenham's algorithm.
  We require that:
                  x1<x2 ,  (y2-y1) <= (x2-x1)

  swap = 1 indicates that the x/y coordinates should be interchanged
 */
static void BresenhamOctant(x1,y1,x2,y2,swap)
 int x1,y1,x2,y2,swap;
 {
  int dx, dy, incr1, incr2, d, x, y, yinc;
  
  dx = x2-x1;
  dy = y2-y1;

  if (dy<0) { yinc = -1; dy = -dy; }
  else        yinc =  1;

  d = 2*dy - dx;
  incr1 = 2*dy;
  incr2 = 2*(dy-dx);

  x = x1; y = y1;
  if (swap) devRect(y,x,y,x); else devRect(x,y,x,y);
  while (x<x2)
   {
    x++;
    if (d<0)   d += incr1;
    else     { d += incr2;   y += yinc;  }
    if (swap) devRect(y,x,y,x); else devRect(x,y,x,y);
   }
 }

/*
   Draw a line from (x1,y1) to (x2,y2) using Bresenham's algorithm.
   All coordinates are assumed to be expressed in raw device coordinates.
 */
int devLine(x1, y1, x2, y2)
 int x1, y1, x2, y2;		/* The coordinates of the endpoints */
 {
  if (devClipLine(&x1,&y1,&x2,&y2)) return(0); /* success */

  if ( abs(x2-x1) > abs(y2-y1) )
   {
    if (x2>x1) BresenhamOctant(x1,y1,x2,y2,0);
    else       BresenhamOctant(x2,y2,x1,y1,0);
   }
  else
   {
    if (y2>y1) BresenhamOctant(y1,x1,y2,x2,1);
    else       BresenhamOctant(y2,x2,y1,x1,1);
   }
  return(0);
 }
