/*
  File: TestSGP.c
  Author: K.R. Sloan, Jr.
  Last Modified: 19 July 1985
  Purpose: test SGP
 */
#include <stdio.h>
#include <math.h>
#include "SGP.h"

static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s\n", RoutineName);
 }

static sgpColorType Gray18= {0.5, 0.5, 0.5};
static sgpColorType Red   = {1.0, 0.0, 0.0};
static sgpColorType Green = {0.0, 1.0, 0.0};
static sgpColorType Blue  = {0.0, 0.0, 1.0};

main(argc, argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  sgpDisplayType Display = ColorDisplay;
  sgpRectangleType Window, Viewport;
  sgpPointType Points[3];
  sgpColorType Colors[3];

  RoutineName = argv[ArgsParsed++];

  while (ArgsParsed < argc) { usage(); exit (-1); }

  sgpInit(Display);

                        Window.Top    = 1.0;
  Window.Left   = 0.0;                        Window.Right = 1.0;
                        Window.Bottom = 0.0;
  sgpSetWindow(Window);

                        Viewport.Top   = 1.0;
  Viewport.Left   = 0.0;                       Viewport.Right = 1.0;
                        Viewport.Bottom = 0.0;
  sgpSetViewport(Viewport);

  sgpColor(Gray18);
  sgpClearScreen();

  Points[0].x =  1.0;  Points[0].y =  0.0;  Colors[0] = Red;
  Points[1].x =  0.5;  Points[1].y =  1.0;  Colors[1] = Green;
  Points[2].x =  0.0;  Points[2].y =  0.0;  Colors[2] = Blue;

  sgpShadeTriangle(Points, Colors);

  sgpQuit();

 }
