A TRIANGLE is defined by:


 [
  [ x0 y0 z0 ]  
  [ x1 y1 z1 ]
  [ x2 y2 z2 ]
 ]
  [ dx0 dy0 dz0 ]
  [ dx1 dy1 dz1 ]
  [ dx2 dy2 dz2 ]
 ]
 [
  [
   [  DiffuseR0  DiffuseG0  DiffuseB0 ] 
   [ SpecularR0 SpecularG0 SpecularB0 ]
   Specularity0
  ]
  [
   [  DiffuseR1  DiffuseG1  DiffuseB1 ] 
   [ SpecularR1 SpecularG1 SpecularB1 ]
   Specularity1
  ]
 [
  [
   [  DiffuseR2   iffuseG2  DiffuseB2 ] 
   [ SpecularR2 SpecularG2 SpecularB2 ]
   Specularity2
  ]
 ]
 sgpTriangle

where:

x,y,z = world coordinates
dx,dy,dz = surface normal vector (need not be normalized, but...)
DiffuseR,G,B = diffuse reflectance,   0.0 <= R,G,B <= 1.0
SpecularR,G,B = specular reflectance, 0.0 <= R,G,B <= 1.0
Specularity = power of the cosine in the usual lighting model.

All are REAL, even Specularity!

The vertices are ORDERED according to the right-hand rule. That is:

    n = (v1-v0) x (v2-v0)

where:

    n is the normal vector for the triangle as a whole 
    vi = [xi yi zi]
    x = CROSS PRODUCT

The renderer will calculate n and d to represent the plane of the triangle.
Back-facing triangles will be culled.


The "[]"'s are necessary for the RealPostscript.  They will almost certainly
be ignored in the C-based renderers.

See ../data for examples.
