NAME
     newmail,wnewmail - programs to asynchronously notify of new mail

SYNOPSIS
     newmail [-d] [-i interval] [-w] file-spec {file-spec...}
     wnewmail [-d] [-i interval] [-w] file-spec {file-spec...}

DESCRIPTION
     Newmail is a program to allow monitoring of mailboxes in  an  intelligent
     fashion.   It is based loosely on biff(1) and the version of newmail that
     was distributed with Elm 1.7.

     The basic operation is that the program will check the list of  specified
     mailboxes  each  interval  seconds  and  will  list any new mail that has
     arrived in any of the mailboxes, indicating  the  sender  name,  and  the
     subject of the message.

     Each entry displayed can be in a number of different formats depending on
     the  mode  of the program, the number of folders being monitored, and the
     status of the message.  If you're running it as a window (e.g. ``-w''  or
     invoked as wnewmail) then the output will be similar to:

        sender name - subject of message
        Priority: sender name - subject of message

     where <sender name> is either the name  of  the  person  sending  it,  if
     available  (the  ARPA  'From:'  line)  or  some other brief indication of
     origin If there is no subject, the message "<no subject>" will appear  on
     the screen.

     Folders are indicated by having the  folder  name  appear  first  on  the
     output line, as in:

        folder: sender name - subject of message

     If you're running newmail without the windows option, then the output  is
     more  suitable  for popping up on an otherwise active screen, and will be
     formatted:

        >> New mail from sender name - subject of message
        >> Priority mail from sender name - subject of message

     Again, with folder names indicated as a prefix.

     The flags available are:

     -d          This will turn on the debugging, verbose output mode.  It  is
                 not  recommended  that  you  use  this  option  unless you're
                 interested in actually debugging the program.

     -i interval This will change the frequency that the  program  checks  the
                 folders  to  the interval specified, in seconds.  The default
                 interval for the program is 60 seconds.  Note: if you  change
                 the  interval  to less than 10 seconds, the program will warn
                 you that it isn't recommended.

     -w          Use of the ``-w'' flag will simulate having the  program  run
                 from  within  a window (e.g. the more succinct output format,
                 and so on).  Most likely, rather than using this  option  you
                 should be simply invoking wnewmail instead.

     File specs are made up of two components, the folder name and the  prefix
     string,  the  latter  of  which  can  always  be  omitted.  The format is
     foldername=prefixstring, and you can specify folders  by  full  name,  by
     simply  the name of the user whose mailbox should be monitored, or by the
     standard Elm metacharacters to specify your folder directory (e.g. ``+'',
     ``='', or ``%'').

     Folders that cannot be opened due to permission mismatches will cause the
     program to immediately abort.  On the other hand, files that do not exist
     will continue to be checked every interval seconds, so some  care  should
     be exercised when invoking the program.

     The program will run until you log out or explicitly  kill  it,  and  can
     internally  reset  itself  if  any of the folders shrink in size and then
     grow again.

     The default folder to monitor is always your incoming mailbox.

EXAMPLES
     Some example invocations:

          $ newmail

     will check your imcoming mailbox every 60 seconds.

          $ newmail  -i  15  joe  root

     will monitor the incoming mailboxes for ``joe''  and  ``root'',  checking
     every 15 seconds for new mail.

          $ newmail  "mary=Mary"  +postmaster=POBOX

     will monitor the  incoming  mailbox  for  user  ``mary'',  prefixing  all
     messages  with  the  string ``Mary'', and the folder in the users maildir
     directory called ``postmaster'', prefixing all  of  those  messages  with
     ``POBOX''.

     You can also have more complex monitoring too, for example:

          $ newmail  -i  30  $LOGNAME=me  ${LOGNAME}su=myroot   /tmp/mbox

     will check every 30 seconds for the users mailbox, a mailbox that is  the
     users   login-name  with  ``su''  appended  (e.g.  ``joe''  would  become
     ``joesu'') and the file /tmp/mbox,  prefixing  new  mail  for  each  with
     ``me'', ``myroot'' and ``mbox'' respectively.

AUTHOR
     Dave Taylor, Hewlett-Packard Laboratories.

SEE ALSO
     notify in sh(1) or csh(1)

BUG REPORTS TO
     Syd Weinstein elm@DSI.COM (dsinc!elm)

COPYRIGHTS
     (c) Copyright 1986, 1987 by Dave Taylor
     (c) Copyright 1988, 1989, 1990 by The USENET Community Trust
