/* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */
/*  San Diego OS/2 User Group                    */
/*  December 1993 Newsletter                     */
/*  REXX Tip - Bitmap Razzle Dazzle              */
/*  Original posted by Simon Lindsay             */
/*  From Fidonet OS2 Rexx Conference             */
/*  File provided as a courtesy to our readers   */
/*  Refer to article for use and other tips      */
/* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */
/* insert the following line into startup.cmd, and you will */
/* get a different background each boot.                    */
/* startup.cmd                                              */
/* c:\os2\utils\chgback c:\os2\bitmap                       */

/* chgback.cmd */
/*
 * Change the lockup workplace background
 */
call RxFuncAdd 'SysIni', 'rexxutil', 'SysIni'
call RxFuncAdd 'SysFileTree', 'rexxutil', 'SysFileTree'

arg cSearchDir

/* Retrieve the system information about the workplace lockup */
cTemp = SysIni('USER', 'Lock Up Workplace', 'Lockup_options3')
/* say 'Old total string .......'cTemp */

/* Extract the name string from it */
cName = STRIP(TRANSLATE(SUBSTR(cTemp, 27, 200), ' ', D2C(0)))
say 'Old lockup background ..'cName

if STRIP(cSearchDir, 'B') \= '' then
    cDir = cSearchDir
else do
    /* Search in the directory of the previous bitmap for others */
    cDir = SUBSTR(cName, 1, LASTPOS('\', cName) - 1)
    say 'Directory to search ....'cDir
end

call SysFileTree cDir'\*.BMP', aDirStem, 'F'
if aDirStem.0 > 0 then do

    /* Choose one using a random number */
    nChoose = RANDOM(0, aDirStem.0)

    /* Get Filename, tell user */
    cFile = SUBSTR(aDirStem.nChoose, 38)
    say 'New lockup background ..'cFile

    /* If it is smaller than 10 K, then tile it */
    /* Byte 0C = tiled, 0B = normal, 0D = scaled */
    nSize = LEFT(RIGHT(WORD(aDirStem.nChoose, 3), 9), 10)
    if nSize < 10240 then
        cTemp = OVERLAY(X2C('0C'), cTemp, 287)
    else
        cTemp = OVERLAY(X2C('0B'), cTemp, 287)

    /* Create the new string, padding with nulls */
    cNew = OVERLAY(cFile, cTemp, 27, 50, D2C(0))
    /* say 'New total string .......'cNew */

    /* Actually write to the ini file */
    if SysIni('USER', 'Lock Up Workplace',
'Lockup_options3', cNew) = 'ERROR:' then
        say 'Change failed'
    else
        say 'Change suceeded'
    end
else
    say 'No bitmaps to choose from!'

