/*--------------------------------------------------------------------*/
/*Copyright 1994 Lars Olofsson                                        */
/*Last modified 1994-05-09 by Lars Olofsson <larso@wmute.trillium.se> */
/*                                                                    */
/*Please feel free to modify, changing 'Last Modified' above to       */
/*'Modified' and adding 'Last Modified' with date and your name.      */
/*                                                                    */
/*Description: This is the SUBSCRIBE command for the WMail mailing    */
/*             list server.                                           */
/*Usage: SUBSCRIBE list                                               */
/*--------------------------------------------------------------------*/

ARG arg1 arg2

IF arg2<>"" | arg1="" THEN CALL USAGE

/* Get the filename where the list is stored */
file=arg1".lst"
IF STREAM(file,'c','query exists')="" THEN CALL NOTFOUND
input=LINEIN(file)
PARSE VAR input "=" listfile

/* Get the senders id */
input=LINEIN("user.ini")
input=LINEIN("user.ini")
PARSE VAR input "=" username  /*Get the reply-to id*/

/*Search and add user if he isn't in the list*/
input=LINEIN(listfile,,0)
DO WHILE (COMPARE(input,username)>0 & LINES(listfile)=1)
   input=LINEIN(listfile)
END

/*If it wasn't in the list; Add it*/
IF COMPARE(input,username)>0 THEN
  DO
     result=LINEOUT(listfile,username)
     SAY username "added to mailinglist."
  END
ELSE 
  SAY username "already in mailinglist. Not added."
EXIT

NOTFOUND:
SAY "There is no such mailinglist:" arg1
EXIT

USAGE:
SAY "There was an error in your specified command."
SAY "The correct usage is: SUBSCRIBE list"
