/*****************************************************************************
 * $Id: scsi.h,v 1.1.1.1 1992/01/06 20:27:28 ak Exp $
 *****************************************************************************
 * $Log: scsi.h,v $
 * Revision 1.1.1.1  1992/01/06  20:27:28  ak
 * Interface now based on ST01 and ASPI.
 * AHA_DRVR no longer supported.
 * Files reorganized.
 *
 * Revision 1.1  1992/01/06  20:27:26  ak
 * Initial revision
 *
 *****************************************************************************/

/************************************************************************
 *		S C S I   C o m m a n d   D e f i n i t i o n s		*
 ************************************************************************/

/*
 * Command Codes
 *	Codes 00..1F:  6 bytes
 *	Codes 20..3F: 10 bytes
 */
	/* General commands: */
#define CmdTestUnitReady	0x00
#define CmdRequestSense		0x03
#define CmdInquiry		0x12
	/* Device commands: */
#define CmdModeSelect		0x15
#define CmdModeSense		0x1A
#define CmdReserveUnit		0x16
#define CmdReleaseUnit		0x17
	/* Random access device commands (Quantum 120/170/210S): */
#define RanRezeroUnit		0x01
#define RanFormatUnit		0x04
#define RanReassignBlocks	0x07
#define RanRead			0x08
#define RanWrite		0x0A
#define RanSeek			0x0B
#define RanReadExtended		0x28
#define RanStartStop		0x1B
#define RanRequestDiagnostics	0x1C
#define RanSendDiagnostics	0x1D
#define RanReadCapacity		0x25
#define RanWriteExtended	0x2A
#define RanSeekExtended		0x2B
#define RanWriteVerify		0x2E
#define RanVerify		0x2F
	/* Sequential access device commands (Tandberg TDC3600): */
#define SeqRewind		0x01
#define SeqRequestBlockAddress	0x02	/* Tandberg specific */
#define SeqReadBlockLimits	0x05
#define SeqRead			0x08
#define SeqWrite		0x0A
#define SeqSeek			0x0C	/* Tandberg specific */
#define SeqWriteFilemark	0x10
#define SeqSpace		0x11
#define SeqVerify		0x13
#define SeqRecoverBuffer	0x14
#define SeqCopy			0x18
#define SeqErase		0x19
#define SeqLoad			0x1B
#define SeqRequestDiagnostics	0x1C
#define SeqSendDiagnostics	0x1D
#define SeqPreventRemoval	0x1E
	/* Processor type device commands (Adaptec AHA154x/1640): */
#define ProcReceive		0x08
#define ProcSend		0x0A

/*
 * Status bits.
 */
#define VADD	0x80
#define FM	0x80
#define EOM	0x40

/*
 * SCSI Command Sense Keys:
 */
				/* QTA (Quantum,Tandberg,Adaptec) */
#define NoSense		0x0	/* QT  No sense code / Invalid command (A) */
#define RecoveredData	0x1	/* Q   Recovered data error */
#define NotReady	0x2	/* QT  Unit not ready */
#define MediaError	0x3	/* QT  Unrecoverable data error */
#define Hardware	0x4	/* QT  Hardware error */
#define IllegalRequest	0x5	/* QTA Illegal parameter */
#define UnitAttention	0x6	/* QTA Reset, Media changed, Mode changed, ..*/
#define WriteProtected	0x7	/*  T  Write protected */
#define BlankCheck	0x8	/*  T  Logical end-of-media detected */
#define VendorUnique	0x9	/* Q   Look at additional sense code */
#define CopyAborted	0xA	/*  T  Error in copy command */
#define AbortedCommand	0xB	/* QTA Aborted command / Parity error (A) */
#define Reserved_SC_1	0xC	/*     ? */
#define MediaOverflow	0xD	/*  T  Beyond physical end-of-media */
#define Miscompare	0xE	/*  T  Verification failed */
#define Reserved_SC_2	0xF	/*     ? */

/*
 * SCSI Status Byte:
 */
#define GoodStatus	0x00	/* Command successful, good status */
#define CheckStatus	0x02	/* Command failed, check status */
#define BusyStatus	0x08	/* Drive busy */
#define IntermedStatus	0x10	/* Linked command successful */
#define ReserveConflict	0x18	/* Reservation conflict */

/************************************************************************
 *			S C S I   C o m m a n d s			*
 ************************************************************************/

#ifndef ASM_DECL

extern void scsi_init(void);
extern void scsi_term(void);

extern void * scsi_alloc(void);		/* allocate control block */
extern void   scsi_free(void *);	/* deallocate control block */

extern void scsi_trace(int);

extern int scsi_cmd (int target, int lun,
		    void *cdb, int cdb_len, void *sense, int sense_len,
		    void far *data, long data_len,
		    int readflag);

extern int scsi_start (void *dcb,
		    int target, int lun,
		    void *cdb, int cdb_len, int sense_len,
		    void far *data, long data_len,
		    int readflag);
extern int scsi_wait (void *dcb, void *sense, int wait);

extern int scsi_reset (int target, int lun, int bus);

/*
 * Sense data mode:
 */
typedef enum SenseMode {
	Sensekey	= 0,
	TDC3600		= 1,
	SCSI2		= 2,
} SenseMode;

extern SenseMode	senseMode;

typedef struct ErrorTable {
	unsigned	code;
	char		*text;
} ErrorTable;

extern char *		senseTab[];
extern ErrorTable	targetStatusTab[];
extern ErrorTable	tdc3600ercd[];
extern ErrorTable	tdc3600xercd[];

extern char *	scsi_error (int);
extern char *	find_error (ErrorTable *, unsigned);

#define ErrorClass(x)	((x) & 0x7800)
#define ErrorCode(x)	((x) & 0x07FF)
#define NoError		0	/* completed without error */
#define SenseKey	0x0800	/* SCSI sense key code, see below */
#define ExtendedError	0x1000	/* SCSI sense error class + error code */
				/* only if standard sense block received */
#define StatusError	0x1800	/* SCSI status byte */
#define DriverError	0x2000	/* Driver error code */
#define SystemError	0x2800	/* System error code */
#define HostError	0x3000	/* host adapter error */
#define UnknownError	0x3800	/* Cannot find error code */
#define ComeAgain	-1	/* Command not yet completed */

#endif
