/*****************************************************************************
 * $Id: errtab.c,v 1.1.1.1 1992/01/06 20:27:22 ak Exp $
 *****************************************************************************
 * $Log: errtab.c,v $
 * Revision 1.1.1.1  1992/01/06  20:27:22  ak
 * Interface now based on ST01 and ASPI.
 * AHA_DRVR no longer supported.
 * Files reorganized.
 *
 * Revision 1.1  1992/01/06  20:27:20  ak
 * Initial revision
 *
 *****************************************************************************/

static char *rcsid = "$Id: errtab.c,v 1.1.1.1 1992/01/06 20:27:22 ak Exp $";

#include "scsi.h"

char	*senseTab[] = {
	"No error",
	"Recovered data",
	"Not ready",
	"Media error",
	"Hardware error",
	"Illegal request",
	"Unit attention",
	"Write protected",
	"At end of logical media",
	"Vendor sense key",
	"Copy aborted",
	"Aborted",
	"Search equal",
	"Media overflow",
	"Verify failed",
	"Reserved"
};

ErrorTable targetStatusTab[] = {
	GoodStatus,	"Good status",
	CheckStatus,	"Check status",
	BusyStatus,	"Device busy",
	IntermedStatus,	"Linked good status",
	ReserveConflict,"Reservation conflict",
	-1
};

ErrorTable tdc3600ercd[] = {
	0x00,	"No error",
	0x02,	"Hardware error",
	0x04,	"Media not loaded",
	0x09,	"Media not loaded",
	0x0A,	"Insufficient capacity",
	0x11,	"Uncorrectable data error",
	0x14,	"No record found",
	0x17,	"Write protected",
	0x19,	"Bad block found",
	0x1C,	"File mark detected",
	0x1D,	"Compare error",
	0x20,	"Invalid command",
	0x30,	"Unit attention",
	0x33,	"Append error",
	0x34,	"Read End-Of-Media",
	-1
};

ErrorTable tdc3600xercd[] = {
	0x00,	"No error",
	0x01,	"Append error",
	0x02,	"Bad command block",
	0x03,	"Bad parameter block",
	0x04,	"Bus parity error",
	0x05,	"Busy",
	0x06,	"Capstan servo error",
	0x07,	"Cartridge removed",
	0x08,	"Compare error",
	0x09,	"Copy data error",
	0x0A,	"Copy management error",
	0x0B,	"File mark error",
	0x0C,	"Head servo error",
	0x0D,	"Illegal command",
	0x0E,	"Illegal copy",
	0x0F,	"Illegal length",
	0x10,	"Inappropriate request",
	0x11,	"Latch error",
	0x12,	"No cartridge",
	0x13,	"Not loaded",
	0x14,	"Power-on request",
	0x15,	"QIC. No data detected",
	0x16,	"Read after write error",
	0x17,	"Read EOM logical",
	0x18,	"Read EOM physical",
	0x19,	"Reservation conflict",
	0x1A,	"Sensor error",
	0x1B,	"Tape runout",
	0x1C,	"Unit attention",
	0x1D,	"Write EOM warning",
	0x1E,	"Write EOM",
	0x1F,	"Catridge write protected",
	0x20,	"16 rewrite errors",
	0x21,	"24 rereads, block found",
	0x22,	"24 rereads, block not found",
	0x23,	"Illegal copy function",
	0x24,	"Illegal header",
	0x25,	"No header",
	0x26,	"Too large address",
	0x27,	"Bad ID or LUN",
	0x28,	"Partial description",
	0x29,	"Bad target status",
	0x2A,	"Check condition",
	0x2B,	"Data transfer error",
	0x2C,	"Selection failure",
	0x2D,	"Sequence error",
	0x2E,	"Illegal block size",
	-1
};

char *
find_error(ErrorTable *p, unsigned code)
{
	static char other[20];

	for (; p->code != (unsigned)-1; ++p)
		if (p->code == code)
			return p->text;
	sprintf(other, "Unknown error code: %02X", code);
	return other;
}
