/*****************************************************************************
 * $Id: record.c,v 1.1.1.1 1992/01/06 20:41:25 ak Exp $
 *****************************************************************************
 * $Log: record.c,v $
 * Revision 1.1.1.1  1992/01/06  20:41:25  ak
 * -Y = don't recurse: new.
 * -X = exclude list: for extract.
 * Use BUFFER for OS/2 tape compression.
 * No own tape buffering for OS/2.
 * Support for SYSTEM and HIDDEN files.
 *
 * Revision 1.1  1992/01/06  20:41:24  ak
 * Initial revision
 *
 *****************************************************************************/

static char *rcsid = "$Id: record.c,v 1.1.1.1 1992/01/06 20:41:25 ak Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <io.h>
#include <assert.h>
#include <getopt.h>

int	blocksize = 0;
long	magic	  = 0x12349876;

void
block(int fd)
{
	long oldsize = filelength(fd);
	long newsize = ((oldsize + 2 * sizeof(long) + blocksize-1) / blocksize)
			* blocksize;
	long w[2];
	assert(chsize(fd, newsize) == 0);
	assert(lseek(fd, newsize - 2 * sizeof(long), 0) >= 0);
	w[0] = magic;
	w[1] = oldsize;
	assert(write(fd, w, 2 * sizeof(long)) == 2 * sizeof(long));
	assert(chsize(fd, newsize) == 0);
}

void
deblock(int fd)
{
	long w[2];
	assert(lseek(fd, filelength(fd) - (2 * sizeof(long)), 0) >= 0);
	assert(read(fd, w, 2 * sizeof(long)) == 2 * sizeof(long));
	if (w[0] == magic)
		assert(chsize(fd, w[1]) == 0);
	else
		fprintf(stderr, "not blocked\n");
}

main(int argc, char **argv)
{
	int c, i;
	void (*ptr)(int) = 0;

	while ((c = getopt(argc, argv, "b:d")) != EOF) {
		switch (c) {
		case 'b':
			if (optarg)
				blocksize = atoi(optarg);
			ptr = block;
			break;
		case 'd':
			ptr = deblock;
			break;
		default:
		usage:	fprintf(stderr,
				"(1) record [-b<n>] [-d] file(s)\n"
				"	block/deblock files for VM records\n"
				"	-b[n]:	<n>-byte records (default=80)\n"
				"	-d:	deblock\n"
				"(2) record [-b<n>]\n"
				"	align stdin to block size\n"
				"	-b<n>:	<n> byte records (default=20*512)\n"
				);
			exit(1);
		}
	}
	if (!ptr)
		goto usage;

	if (optind == argc) {
		long	size;
		int	n, nr;
		char	*buf;

		if (blocksize == 0)
			blocksize = 20 * 512;
		if ((buf = malloc(blocksize)) == NULL) {
			fprintf(stderr, "Not enough memory\n");
			exit(1);
		}
		setmode(0, O_BINARY);
		setmode(1, O_BINARY);
		do {
			nr = 0;
			do {
				n = read(0, buf, blocksize - nr);
/**/ fprintf(stderr, "read %d\n", n);
			} while (n > 0 && (nr += n) < blocksize);
			if (nr > 0) {
				if (nr != blocksize)
					memset(buf + nr, 0, blocksize - nr);
				if (write(1, buf, blocksize) != blocksize) {
					perror("Write error");
					exit(1);
				}
			}
		} while (nr > 0);
	} else {
		if (blocksize == 0)
			blocksize = 80;
		for (i = optind; i < argc; ++i) {
			int fd = open(argv[i], O_RDWR|O_BINARY);
			if (fd < 0) {
				perror(argv[i]);
				exit(1);
			}
			ptr(fd);
			close(fd);
		}
	}
	exit(0);

}
