/*****************************************************************************
 * $Id: port.h,v 1.2 1992/01/10 13:28:12 ak Exp $
 *****************************************************************************
 * $Log: port.h,v $
 * Revision 1.2  1992/01/10  13:28:12  ak
 * [tar/tape -> ] buffer -> compress [ -> tar/tape] (-Z)
 * DOS & OS/2 file attributes (-p)
 * Don't recurse (-Y)
 *
 * Revision 1.1.1.1  1992/01/06  20:41:21  ak
 * -Y = don't recurse: new.
 * -X = exclude list: for extract.
 * Use BUFFER for OS/2 tape compression.
 * No own tape buffering for OS/2.
 * Support for SYSTEM and HIDDEN files.
 *
 * Revision 1.1  1992/01/06  20:41:20  ak
 * Initial revision
 *
 *****************************************************************************/

/* Portability declarations.
   Copyright (C) 1988 Free Software Foundation

This file is part of GNU Tar.

GNU Tar is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU Tar is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Tar; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */
/*
 * Portability declarations for tar.
 *
 * @(#)port.h 1.3	87/11/11	by John Gilmore, 1986
 */

/*
 * Everybody does wait() differently.  There seem to be no definitions
 * for this in V7 (e.g. you are supposed to shift and mask things out
 * using constant shifts and masks.)  So fuck 'em all -- my own non
 * standard but portable macros.  Don't change to a "union wait"
 * based approach -- the ordering of the elements of the struct 
 * depends on the byte-sex of the machine.  Foo!
 */
#define	TERM_SIGNAL(status)	((status) & 0x7F)
#define TERM_COREDUMP(status)	(((status) & 0x80) != 0)
#define TERM_VALUE(status)	((status) >> 8)

#ifdef	MSDOS

/* missing things from sys/stat.h */
#define	S_ISUID		0
#define	S_ISGID		0
#define	S_ISVTX		0

/* device stuff */
#define	makedev(ma, mi)		((ma << 8) | mi)
#define	major(dev)		(dev)
#define	minor(dev)		(dev)

#if !defined(NO_REMOTE) && defined(DIRECT)
#define perror	my_perror
#endif

#ifdef __TURBOC__
#undef  EIO
#undef  ENOSPC
#endif

#ifndef EIO
# define EIO	2000
#endif
#ifndef ENOSPC
# define ENOSPC	2001
#endif
#ifndef EINVOP
# define EINVOP	2002
#endif

#if defined(__ZTC__) || defined(__TURBOC__)
#define index	bsd_index
#endif

#include <string.h>
#include <stdlib.h>

#ifdef __ZTC__
# include <ztc.h>	/* _fmemxxx */
#endif

#endif	/* MSDOS */

#ifdef OS2
#include <os2eattr.h>
PEAList		eabuf;		/* extended attribute buffer */
long		ealen;		/* length of .. */
#ifdef NAMSIZ
char		eaname[NAMSIZ];	/* file name of current EA */
#endif
#endif

#ifndef _FAR_
#define _FAR_
#endif

#define opendir(p) (f_use_protection ? openxdir(p, A_HIDDEN|A_SYSTEM) : openxdir(p, 0))
