/*****************************************************************************
 * $Id: ddebug.c,v 1.2 1992/01/06 20:09:26 ak Exp $
 *****************************************************************************
 * $Log: ddebug.c,v $
 * Revision 1.2  1992/01/06  20:09:26  ak
 * *** empty log message ***
 *
 * Revision 1.1.1.1  1992/01/06  19:54:09  ak
 * Alpha version.
 *
 * Revision 1.1  1992/01/06  19:54:07  ak
 * Initial revision
 *
 *****************************************************************************/

static char _far rcsid[] = "$Id: ddebug.c,v 1.2 1992/01/06 20:09:26 ak Exp $";

#include "dd.h"
#define INCL_DOS
#include <os2.h>
#include <string.h>

#define Address 	0x0B0000L
#define Farptr	 	(Address << 12)
#define NCols		80
#define NRows		25
#define LineSize	(NCols * sizeof(word))
#define ScreenSize	(NRows * LineSize)
#define Attrib		0x0700

static word	_far * screen;
static int	row, col;

void _cdecl
_STI_ddebug()
{
	word sel;
	AllocGDTSelector(&sel, 1);
	PhysToGDTSelector(Address, ScreenSize, sel);
	screen = Pointer(sel, 0);
	row = col = 0;
}

void
putc(byte c)
{
	if (inInitPhase()) {
		USHORT nw;
		static byte cr = 0x0D;
		if (c == '\n')
			DosWrite(1, &cr, 1, &nw);
		DosWrite(1, &c, 1, &nw);
	} else if (c == '\t') {
		do putc(' '); while (col & 7);
	} else {
		word _far *scr = inProtMode() ? screen : (word _far *)Farptr;
		if (c == '\n' || col == 80) {
			col = 0;
			row += 1;
		}
		if (row == NRows) {
			int i;
			movedata(Segment(scr), LineSize, Segment(scr), 0,
				ScreenSize - LineSize);
			for (i = 0; i < NCols; ++i)
				scr[(NRows - 1) * NCols + i] = ' ' + Attrib;
			row = NRows - 1;
		}
		if (c != '\n')
			scr[row * NCols + col++] = c | Attrib;
	}
}

void
puts(char _far *s)
{
	while (*s)
		putc(*s++);
}

void
putx(dword x)
{
	int i = 32 - 4;
	for (; i != 0; i -= 4)
		if (x >= 1L << i)
			break;
	for (; i >= 0; i -= 4)
		putc("0123456789ABCDEF"[x >> i & 0x0F]);
}

void
putd(long x)
{
	if (x == -0x80000000L) {
		puts("-2147483648");
		return;
	}
	if (x < 0) {
		putc('-');
		x = -x;
	}
	if (x >= 10) {
		putd(x / 10);
		x %= 10;
	}
	putc("0123456789"[x]);
}
