/*****************************************************************************
 * $Id: host.c,v 1.1.1.1 1992/01/06 20:41:06 ak Exp $
 *****************************************************************************
 * $Log: host.c,v $
 * Revision 1.1.1.1  1992/01/06  20:41:06  ak
 * -Y = don't recurse: new.
 * -X = exclude list: for extract.
 * Use BUFFER for OS/2 tape compression.
 * No own tape buffering for OS/2.
 * Support for SYSTEM and HIDDEN files.
 *
 * Revision 1.1  1992/01/06  20:41:05  ak
 * Initial revision
 *
 *****************************************************************************/

static char *rcsid = "$Id: host.c,v 1.1.1.1 1992/01/06 20:41:06 ak Exp $";

#ifdef HOST

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>		/* For non-Berkeley systems */
#include <sys/stat.h>
#include <process.h>

#include "tar.h"

#define INCL_DOSFILEMGR
#define INCL_DOSPROCESS
#include <os2.h>

#define SHELL		"SHELL"		/* environment name for shell */
#define PATH		"PATH"		/* environment name for script path */
#define TAR_SEND	"tar_send.sh"	/* SEND command script */
#define TAR_RECV	"tar_recv.sh"	/* RECEIVE command script */

static USHORT	pid_xmit	= 0;
static char	vm_name[9], vm_mode[9];
static char	last[260];
static char *	shell;
static char	tar_send[260]	= "./" TAR_SEND;
static char	tar_recv[260]	= "./" TAR_RECV;

host_init(char *name)
{
	FSALLOCATE	fsall;
	USHORT		drv;
	long		size;
	char		*p;

	if ((shell = getenv(SHELL)) == NULL) {
		msg("Can't find SHELL");
		exit(EX_SYSTEM);
	}
	_searchenv(TAR_SEND, PATH, tar_send);
	_searchenv(TAR_RECV, PATH, tar_recv);

	if (isalpha(name[0]) && name[1] == ':')
		drv = 1 + tolower(name[0] - 'a');
	else
		drv = 0;

	if (DosQFSInfo(drv, FSIL_ALLOC, (PBYTE)&fsall, sizeof fsall)) {
		msg("Cannot get info about file system");
		exit(EX_SYSTEM);
	}
	size = (long)fsall.cbSector * (long)fsall.cSectorUnit * (long)fsall.cUnitAvail;
	if (f_split >= size / 2)
		msg("Chunks of size %ld bytes %s overflow free disk space",
			f_split, f_compress ? "might" : "will");
}

static void
waitfor(USHORT pid, char *who)
{
	RESULTCODES	rc;
	USHORT		rpid;

	if (DosCwait(DCWA_PROCESS, DCWW_WAIT, &rc, &rpid, pid)) {
		msg("Could not get status of child %s", who);
		exit(EX_SYSTEM);
	}
	if (rc.codeTerminate) {
		msg("Child %s aborted (reason %u)", who, rc.codeTerminate);
		exit(EX_SYSTEM);
	}
	if (rc.codeResult) {
		msg("Child %s exit status %u", who, rc.codeResult);
		exit(EX_SYSTEM);
	}
}

static void
map_name(char *name)
{
	char *p;
	for (p = name + strlen(name); !strchr("\\/:", *(p-1)) && --p != name; )
		;
	strncpy(vm_name, p, 8);
	if ((p = strchr(vm_name, '.')) != NULL)
		*p = 0;
	strcpy(vm_mode, f_compress ? "taz-" : "tar-");
	if ((p = strrchr(name, '.')) != NULL)
		strcat(vm_mode, p+1);
}
	
host_send(char *name)
{
	map_name(name);
	if (pid_xmit) {
		waitfor(pid_xmit, "VM Send");
		remove(last);
	}
	pid_xmit = spawnlp(P_NOWAIT, shell, shell,
		tar_send, name, vm_name, vm_mode, NULL);
	if (pid_xmit < 0) {
		msg("Cannot spawn VM send");
		exit(EX_SYSTEM);
	}
	strcpy(last, name);
}

host_recv(char *name)
{
	int rc;
	if (last[0])
		remove(last);
	map_name(name);
	rc = spawnlp(P_WAIT, shell, shell,
		tar_recv, name, vm_name, vm_mode, NULL);
	if (rc < 0) {
		msg("Cannot spawn VM receive");
		exit(EX_SYSTEM);
	}
	strcpy(last, name);
}

host_end()
{
	if (pid_xmit > 0)
		waitfor(pid_xmit, "VM Send");
	if (last[0])
		remove(last);
}

#endif /*HOST*/
