
#define INCL_NOPM
#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_DOSDEVIOCTL
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>


typedef struct _qbr {   // extended query bit-rate
    LONG rate;
    BYTE fraction;
    LONG min_rate;
    BYTE min_fraction;
    LONG max_rate;
    BYTE max_fraction;
}QBR;

void cdecl main(int argc, char **argv)
{
    USHORT rc;
    QBR qbr;
    RXQUEUE rxq;
    FILE *inf;

    if(argc != 2){
        printf("\n");
        printf(" MaxRate                                                   \n");
        printf("                                                           \n");
        printf(" Usage:  MaxRate <com port>                                \n");
        printf("                                                           \n");
        printf(" This program asks your serial device driver for the       \n");
        printf(" maximum bps rate that your hardware supports.             \n");
        printf("\n");
        exit(1);
    }

    inf = fopen(argv[1], "rb");
    if(!inf){
        perror(argv[1]);
        exit(1);
    }


    DosDevIOCtl(&rxq, 0L, ASYNC_GETINQUECOUNT, IOCTL_ASYNC, fileno(inf));
    printf("\nInput  queue size = %d bytes\n", rxq.cb);

    DosDevIOCtl(&rxq, 0L, ASYNC_GETOUTQUECOUNT, IOCTL_ASYNC, fileno(inf));
    printf("Output queue size = %d bytes\n", rxq.cb);

    rc = DosDevIOCtl(&qbr, 0L, 0x63, IOCTL_ASYNC, fileno(inf));
    if(rc){
        printf("SYS%04u:  Couldn't query baud rate\n", rc);
        if(rc == ERROR_BAD_COMMAND)
            printf("(may require a newer version of com*.sys or OS/2 to run this program)\n");
        exit(1);
    }
    printf("Current Rate = %ld\n", qbr.rate);
    printf("Min     Rate = %ld\n", qbr.min_rate);
    printf("Max     Rate = %ld\n", qbr.max_rate);
    exit(0);
}

