/*
 Copyright (c) 2003 RIPE

 All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of the author not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
 AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
 DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

 $Id: sockinfo.c,v 1.17 2003/04/16 09:00:48 can Exp $
*/

#include "sockinfo.h"

/*
 * Put zeros in the ipv6 address to unify its length
 */
gchar *sockInfo_zeropad(const gchar * str)
{
    gchar *result, **vstr, **spstr, digStr[10], *dColPos, *newStr, *tmpStr,
        *p, *cols;
    gint colCount = 7;

    result = g_new0(char, INET6_ADDRSTRLEN);
    newStr = g_strdup(str);
    p = newStr;
    dColPos = g_strrstr(newStr, "::");
    if (dColPos != NULL) {
        while ((p != NULL) && (*p != 0)) {
            if (*p == ':')
                colCount--;
            p++;
        }
        *dColPos = 0;
        cols = g_strnfill(colCount + 2, ':');
        tmpStr = g_strdup_printf("%s%s%s", newStr, cols, dColPos + 2);
        g_free(cols);
        g_free(newStr);
        newStr = tmpStr;
    }
    spstr = g_strsplit(newStr, ":", -1);
    vstr = spstr;
    while (*vstr != NULL) {
        sprintf(digStr, "%.4lx:", strtol(*vstr, NULL, 16));
        strcat(result, digStr);
        vstr++;
    }
    result[strlen(result) - 1] = 0;
    g_free(newStr);
    g_strfreev(spstr);
    return (result);
}

/*
 * Init sock
 */
sockInfo *sockInfo_new(gint s, gchar * n)
{
    sockInfo *result;

    result = g_new(sockInfo, 1);
    result->s = s;
    result->nodeName = sockInfo_zeropad(n);
    result->fRead = fdopen(s, "r");
    if (result->fRead == NULL)
        local_error("fdopen(r): %s", strerror(errno));
    result->fWrite = fdopen(s, "w");
    setvbuf(result->fRead, NULL, _IONBF, 0);
    if (result->fWrite == NULL)
        local_error("fdopen(w): %s", strerror(errno));
    setvbuf(result->fWrite, NULL, _IONBF, 0);
    return (result);
}

/*
 * Free sock
 */
void sockInfo_free(sockInfo * s)
{
    if (s == NULL)
        return;
    g_free(s->nodeName);
    close(s->s);
    if (s->fRead != NULL) {
        fclose(s->fRead);
        s->fRead = NULL;
    }
    if (s->fWrite != NULL) {
        fclose(s->fWrite);
        s->fWrite = NULL;
    }
    g_free(s);
    s = NULL;
}
