/***************************************
  $Revision: 1.1 $

  Privacy Authorisation (PA) - er_PA_errors.h - definition of errors for the
				PA module.

  Status: NOT COMPLETE, NOT REVUED, NOT TESTED, 

  Design and implementation by: daniele@ripe.net

  ******************/ /******************
  Copyright (c) 2000                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

/* I see no way of automating things here... Maybe with a perl script.

   There are three things to do:
   1. Get a new integer number from the enum 
	(using a ??_LOW_<mnem> symbol)
   2. define a new error code (??_<mnem>) by adding the facility and
	severity codes.
   3. put the symbol (using macro ERDUP) and text of the message into the
	array. Should fit in one line with the macro.

   The order of codes in enum does NOT have to match the order of texts.
   The last in the texts array must be the ER_LASTTXT constant.

   Sounds familiar ? That's because facilities and errors are parts
   of the error reporting fractal :-)
*/

/* use m4 macros to keep stuff in sync */




     /******************************************/
     /* ***** DEFINE THE CURRENT FACILITY **** */
     /* * make sure no whitespaces are inside! */
     /* */               /* */
     /* ************************************** */
     /******************************************/

/* last thing: disable processing of commented text (this allows to comment
   out some macro entries. Alas, the #%$@&* designers screwed up, so now we
   have to manually disable messing with C preprocessor commands */





typedef enum {
  /*  fac  code    sev  descr
      
      current facility specified inside the line below as CFAC
   */

   LOW_PA_OK ,
   LOW_PA_CANTSPWN ,
   LOW_PA_CANTOPEN ,
   LOW_PA_LINETOOLONG ,
} PA_err_code_t;

/* paste the #define'd codes */
#define PA_OK  (ER_SEV_I + (FAC_PA<<16) + LOW_PA_OK)
#define PA_CANTSPWN  (ER_SEV_F + (FAC_PA<<16) + LOW_PA_CANTSPWN)
#define PA_CANTOPEN  (ER_SEV_F + (FAC_PA<<16) + LOW_PA_CANTOPEN)
#define PA_LINETOOLONG  (ER_SEV_F + (FAC_PA<<16) + LOW_PA_LINETOOLONG)
 

#ifdef ER_IMPL
er_list_t PA_mod_err[]={

  /* paste the ERDUP's */
    { ERDUP(PA_OK),"OK" },
  { ERDUP(PA_CANTSPWN),"Cannot spawn" },
  { ERDUP(PA_CANTOPEN),"Cannot open file" },
  { ERDUP(PA_LINETOOLONG),"Line too long: line number" },
 
  
  ER_LASTTXT
};
#endif /* ER_IMPL */
