/*
 * testclient.c,v 1.1 1994/01/28 17:21:56 franktor Exp
 */

#ifndef VMS
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <errno.h>
#include <high/sr_structcodec.h>
#else
#include <string.h>
#include <types.h>
#include <time.h>
#include <errno.h>

#include <sr_structcodec.h>

char *strdup(char *str)
{
  char *s = (char *) malloc(strlen(str)+1);
  strcpy(s,str);
  return s;
}
#endif /* VMS */

connectionParameters    conn;
int			FD;


main ()
{
  conn.method = connect_tcpip;
  conn.u.ip.address = strdup ( "gandalf.uio.no" );
  conn.u.ip.port = 2401;

  switch ( ConnectToDatabaseServer ( &conn, &FD ) )
  {
   case sockStatOK:
     fprintf ( stderr, "ConnectToSocket() returned OK\n" );
     break;
     
   case sockStatFailed:
     fprintf ( stderr, "ConnectToSocket() returned Failed\n" );
     exit ( 0 );
     
   default:
     fprintf ( stderr, "ConnectToSocket() returned something else\n" );
     exit ( 0 );
  }

  while ( 1 )
  {
     fd_set	readfds, writefds, exceptfds;
     Boolean	selectOnWrite			= False;
     EapiPacket pkt;

     pkt.type = eapiOpenRequest;
     pkt.ref = 4711;

     send_struct ( FD, (void *) &pkt, &selectOnWrite );

     FD_ZERO ( &readfds), FD_ZERO ( &writefds ), FD_ZERO ( &exceptfds );
     FD_SET ( FD, &readfds ),  FD_SET ( FD, &exceptfds );
     if ( selectOnWrite )
	FD_SET ( FD, &writefds );
     
     if ( select ( 64, &readfds, &writefds, &exceptfds, (struct timeval *) NULL ) < 0 )
     {
	if ( errno = EINTR )
	   continue;
	
	fprintf ( stderr, "select() failed with errno=%d - closing\n", errno );
	break;
     }

     switch ( handle_socket ( FD,
			      FD_ISSET(FD, &readfds) ? True : False, 
			      FD_ISSET(FD, &writefds) ? True : False, 
			      FD_ISSET(FD, &exceptfds) ? True : False, &selectOnWrite ) )
     {
      case sockStatOK:
	fprintf ( stderr, "handle_socket() returned OK\n" );
	break;
	
      case sockStatFailed:
      case sockStatClosed:
	fprintf ( stderr, "handle_socket() returned one of Failed or Closed\n" );
	goto EXIT;
	break;
	
      case sockStatPacketReady:
	fprintf ( stderr, "Packet ready\n" );
	break;
     }
  }

 EXIT:;

  LOG ( facApp, llevTrace, "Exiting" );

  close ( FD );
}
