/* 
* util.c,v 1.1 1994/01/28 17:21:44 franktor Exp
*
* util.c
*
* Various utility functions
*
*/

#include <syslog.h>
#include <malloc.h>
#include <errno.h>
#include <string.h>

#include <sr-logger.h>
#include <sr-util.h>

int Warn_UNIMPLEMENTED ( Facility fac, const char *fn )
{
   LOG ( fac, llevExceptions, "%s is NOT YET IMPLEMENTED", fn );
   /* abort (); */
   return 0;
}


#if 0				/* Moved to cli-util/smalloc.c.	-hbf */
char *smalloc ( unsigned int size );
				/* Moved to ../cli-util/str*.	-hbf */
char *strdup (const char *s);
char *safe_strdup ( const char *s );
int safe_strlen ( const char *s );
char *safe_strcpy ( char *s1, const char *s2 );
#endif

/* Functions to handle record compositions */

#if 0				/* Moved to cli-lib/newRec.c.	-hbf */
RecordComposition *new_RecordComposition ( Boolean isGeneric, char *genericComposition );
#endif

void add_RecCompElem ( RecordComposition *recComp, char *dbName, char *recCompId )
{
   RCNameAndId *new, *last;
   if ( (!recComp) || (!dbName) || (!recCompId) )
   {
      LOG ( facUtil, llevExceptions, "add_RecCompElem() parameter missing" );
      return;
   }

   if ( recComp->genericRecordComposition )
   {
      LOG ( facUtil, llevExceptions,
	   "add_RecordCompElem(): Can't add dbName/recCompId to generic record composition" );
      return;
   }

   for (last = recComp->u.databaseSpecific; last != NULL && last->next != NULL; last = last->next);

   new = (RCNameAndId *) malloc(sizeof(RCNameAndId));

   new->databaseName = (char *) safe_strdup(dbName);
   new->recordCompositionId = (char *) safe_strdup(recCompId);
   new->next = NULL;
   if (last)
      last->next = new;
   else
      recComp->u.databaseSpecific = new;
#if 0				/* This is how it was before lined lists were used */
   if ( !recComp->u.s.no )
   {
      recComp->u.s.databaseName = (char **) malloc ( sizeof ( char * ) );
      recComp->u.s.recordCompositionId = (char **) malloc ( sizeof ( char * ) );
   }
   else
   {
      recComp->u.s.databaseName = (char **) realloc ( (char *) recComp->u.s.databaseName,
						     recComp->u.s.no+1 * sizeof ( char * ) );
      recComp->u.s.recordCompositionId = (char **) realloc ( (char *) recComp->u.s.recordCompositionId,
							    recComp->u.s.no+1 * sizeof ( char * ) );
   }
   recComp->u.s.databaseName[recComp->u.s.no] = (char *) safe_strdup ( dbName );
   recComp->u.s.recordCompositionId[recComp->u.s.no] = (char *) safe_strdup ( recCompId );

   recComp->u.s.no++;
#endif
}

int recCompSize ( RecordComposition *recComp )
{
   int count;
   RCNameAndId *tmp;

   if ( !recComp )
      return 0;

   if ( recComp->genericRecordComposition )
      return 0;

   for (count = 0, tmp = recComp->u.databaseSpecific; tmp; tmp = tmp->next)
      count++;
   return count;
}

Boolean get_RecCompElem ( RecordComposition *recComp, int index, char **dbName, char **recCompId )
{
   int count;
   RCNameAndId *tmp;

   if ( (!recComp) || (!dbName) || (!recCompId) )
      return False;

   if ( recComp->genericRecordComposition )
   {
      *dbName = *recCompId = (char *) NULL;
      return False;
   }

   for (count = 0, tmp = recComp->u.databaseSpecific; tmp && count < index; tmp = tmp->next)
   
   if ( !tmp )
   {
      *dbName = *recCompId = (char *) NULL;
      return False;
   }

   *dbName = tmp->databaseName;
   *recCompId = tmp->recordCompositionId;

   return True;
}

char *get_RecCompForDb ( RecordComposition *recComp, char *dbName )
{
   if ( !recComp )
      return (char *) NULL;

   if ( recComp->genericRecordComposition )
      return recComp->u.generic;
   else
   {
      RCNameAndId	*tmp;

      for ( tmp = recComp->u.databaseSpecific; tmp; tmp=tmp->next )
	 if ( !strcasecmp ( dbName, tmp->databaseName ) )
	    return tmp->recordCompositionId;
   }

   return (char *) NULL;
}


#if 0
/* Oid utility functions */

#include <assert.h>
#include <sr-oid.h>

Oid str2Oid ( const char *s )
{
   Oid			oid = OID_str2Oid ( s );
   assert ( ! s || OID_contents ( oid ) );
   return		oid;
}

char *Oid2str ( Oid oid, int proto )
{
   return OID_strdup ( OID_Oid2str ( oid, proto ) );
}

Oid Oiddup ( Oid oid )
{
   return oid;
}

int Oidcmp ( Oid o1, Oid o2 )
{
   return OID_cmp ( o1, o2 );
}

Boolean isNullOid ( Oid o )
{
   return OID_isNull ( o );
}

void Oidfree ( Oid o )
{
}
#endif
