/*
 * backend.c,v 1.1 1994/01/28 17:06:19 franktor Exp
 */

#include "client.h"

/*
 * OpenConnection:
 * Tries to connect to a highlevel client server by the method specified
 * in the address argument.
 * It returns a file-descriptor for the new connection, or -1 on failure.
 */


int OpenConnection(connectionParameters *conn)
{
  int fd;

  switch ( ConnectToDatabaseServer ( conn, &fd, desc_HC_Packet ) )
  {
    case sockStatOK:
      LOG(facHigh, llevTrace, "Successfully connected to server.");
      break;
    case sockStatFailed:
      LOG(facHigh, llevExceptions, "ConnectToSocket() failed.");
      return (-1);
    default:
      LOG(facHigh, llevExceptions, "ConnectToSocket() returned unknown.");
      return (-1);
  }
  return fd;
}
