/* 
 * sr-parser.h,v 1.1 1994/01/28 17:05:49 franktor Exp
 *
 * parser.h
 *
*/

#ifndef SR_PARSER_H
#define SR_PARSER_H

#include <stdio.h>
#include <ctype.h>
#include <string.h>

#include <sr-general.h>
#include <sr-api.h>

typedef enum {_none, _oprAND, _oprOR, _oprANDNOT, _attributeElement, _resultSetId, _term} termKind; 

struct AttributeSet;

struct Attribute {
   int			type, value;
   char			*name;
   struct AttributeSet  *set;
   struct Attribute	*next;
};

struct AttributeSet {
   char			*name;
   Oid			oid;
   struct Attribute	*attributes;
   struct AttributeSet	*next;
};

struct rpnElem {
   Boolean		isOperand;
   union {
      struct operandElem *operand;
      struct {
	 struct operatorElem *operator;
	 struct rpnElem *rpn1;
	 struct rpnElem *rpn2;
      } rpn;
   } un;
};

struct operandElem {
   Boolean		isResultSet;
   union {
      char		*resultSetId;
      struct { 
	 struct attributeElem *attrList;
	 char		*term;
      } attributesPlusTerm;
   } un;
};

struct operatorElem { 
   enum {AND, OR, ANDNOT} operator;
};

struct attributeElem { 
   struct Attribute	*attr;
   struct attributeElem *next;
};

typedef struct DiagMsg { 
   int			condition;
   char			*msg;
   struct DiagMsg     	*next;
} DiagMsg;

typedef struct DiagSet {
   Oid			oid;
   char			*name;
   DiagMsg	      	*messages;
   struct DiagSet      	*next;
} DiagSet;



Boolean parseAttrSet ( FILE *input );
Boolean parseDiagSet ( FILE *input );

char		*getToken ( void );
struct rpnElem	*parseRPN ( char * );

#endif /* SR_PARSER_H */
