/*
 * eapi.h,v 1.1 1994/01/28 17:05:58 franktor Exp
 *
 * EAPI definitions:
 */

#ifndef EAPI_H
#define EAPI_H

typedef struct DatabaseName {
  char *database;
  struct DatabaseName *next;
} DatabaseName;

typedef struct SearchRequest {
  DatabaseName *databaseNames;
  Query *query;
} SearchRequest;

typedef struct SearchResponse {
  int numberOfRecordsFound;
  Boolean searchStatus;
  ResultSetStatus resultSetStatus;
  int resultSetId;
} SearchResponse;

typedef struct PresentRequest {
  int resultSetId;
  int resultSetStartPoint;
  int numberOfRecordsRequested;
  RecordComposition *recordComposition;
  char *preferredRecordSyntax;
} PresentRequest;

typedef struct PresentResponse {
  int numberOfRecordsReturned;
  PresentStatus presentStatus;
  struct EapiRecords *records;
} PresentResponse;

typedef enum EapiRecordKind {
  recEapiNamePlusRecord = 0, recEapiNonSurrogateDiagRec = 1
} EapiRecordKind;

typedef struct EapiRecords {
  EapiRecordKind recKind;
  union {
    struct EapiNamePlusRecord *databaseOrSurDiagnostics;
    struct EapiDiagRec *nonSurrogateDiagnosticRecord;
  } u;
} EapiRecords;

typedef enum EapiNamePlusRecordKind {
  recEapiRecord = 0, recEapiSurrogateDiagRec = 1
} EapiNamePlusRecordKind;

typedef struct EapiNamePlusRecord {
  EapiNamePlusRecordKind recKind;
  union {
    struct EapiRecord {
      octetString databaseRecord;
      char *databaseName;
      char *recordSyntax;
    } record;
    struct EapiDiagRec *surrogateDiagnostic;
  } u;
  struct EapiNamePlusRecord *next;
} EapiNamePlusRecord;

typedef struct EapiDiagRec {
  char *diagnosticSetId;   /* OID */
  int condition;
  char *addinfo;
} EapiDiagRec;

typedef struct DeleteResultSetRequest {
  Boolean all;
  int resultSetId;
} DeleteResultSetRequest;

typedef struct DeleteResultSetResponse {
  Boolean status;
} DeleteResultSetResponse;

typedef struct InterruptRequest {
  int filler;
} InterruptRequest;

typedef struct InterruptResponse {
  Boolean canceled;
} InterruptResponse;

typedef struct OpenRequest {
  int filler;
} OpenRequest;

typedef struct OpenResponse {
  Boolean openAccepted;
  char *message;		/* Optional diagnostic message */
} OpenResponse;

typedef struct CloseRequest {
  int filler;
} CloseRequest;

typedef struct CloseResponse {
  Boolean closeAccepted;
  char *message;		/* Optional diagnostic message */
} CloseResponse;

/*
 * The EapiPacket structure holds the data which is to be sent to the
 * database via the API-2 protocol.
 * I've collected them in a single struct so that the interface will
 * only need one function to send data and one to receive data.
 */

/*
 * enums describing the type (of union) for an eapi packet.
 */

typedef enum EapiTypes {
  eapiSearchRequest = 0, eapiSearchResponse = 1,
  eapiPresentRequest = 2, eapiPresentResponse = 3,
  eapiDeleteResultSetRequest = 4, eapiDeleteResultSetResponse = 5,
  eapiInterruptRequest = 6, eapiInterruptResponse = 7,
  eapiOpenRequest = 8, eapiOpenResponse = 9,
  eapiCloseRequest = 10, eapiCloseResponse = 11,
  eapiNone = 12
} EapiTypes;

typedef struct EapiPacket
{
  EapiTypes type;	/* Tells which of the below is used */
  int ref;		/* Identifies which connection for send/receive */
  union
  {				/* the ordering and numbering here must correspond with EapiType */
    SearchRequest		*search_request;
    SearchResponse		*search_response;
    PresentRequest		*present_request;
    PresentResponse		*present_response;
    DeleteResultSetRequest	*delete_result_set_request;
    DeleteResultSetResponse	*delete_result_set_response;
    InterruptRequest		*interrupt_request;
    InterruptResponse		*interrupt_response;
    OpenRequest			*open_request;
    OpenResponse		*open_response;
    CloseRequest		*close_request;
    CloseResponse		*close_response;
  } u;
} EapiPacket;
#endif
