/*
 * client-structdesc.h,v 1.1 1994/01/28 17:05:53 franktor Exp
 *
 * client-structdesc.h
 *
 * Description of datastructures usable for code
 *
*/

#ifndef CLIENT_STRUCTDESC_H
#define CLIENT_STRUCTDESC_H

#include <sr-general.h>
#ifndef VMS
#include <high/structcodec.h>
#include <high/common-structdesc.h>
#include <high/client-structs.h>
#else
#include <structcodec.h>
#include <common-structdesc.h>
#include <client-structs.h>
#endif

				/* structures from general.h */
extern elemDesc desc_octetString[];

				/* structures from client-structs.h */

extern elemDesc desc_HC_OpenRequest[];
extern elemDesc desc_HC_OpenResponse[];
extern elemDesc desc_HC_SearchRequest[];
extern elemDesc desc_HC_SearchResponse[];
extern elemDesc desc_HC_PresentRequest[];
extern elemDesc desc_HC_PresentResponse[];
extern elemDesc desc_HC_DeleteResultSetRequest[];
extern elemDesc desc_HC_DeleteResultSetResponse[];
extern elemDesc desc_HC_CloseRequest[];
extern elemDesc desc_HC_CloseResponse[];
extern elemDesc desc_HC_ErrorMsg[];
extern elemDesc desc_HC_Packet_u[];
extern elemDesc desc_HC_Packet[];

elemDesc desc_HC_OpenRequest[] = {
  { elemCharPtr,	0,			sizeof(char *),		0 },
  { elemInt,		0,			sizeof(int),		0 },
  { elemInt,		0,			sizeof(int),		0 },
  { elemCharPtr,	0,			sizeof(char *),		0 },
  { elemCharPtr,	0,			sizeof(char *),		0 },
  { elemDone,		0,			0,			0 }
};

elemDesc desc_HC_OpenResponse[] = {
  { elemBoolean,	0,			sizeof(Boolean),	0 },
  { elemCharPtr,	0,			sizeof(char *),		0 },
  { elemInt,		0,			sizeof(int),		0 },
  { elemInt,		0,			sizeof(int),		0 },
  { elemBoolean,	0,			sizeof(Boolean),	0 },
  { elemCharPtr,	0,			sizeof(char *),		0 },
  { elemCharPtr,	0,			sizeof(char *),		0 },
  { elemCharPtr,	0,			sizeof(char *),		0 },
  { elemCharPtr,	0,			sizeof(char *),		0 },
  { elemDone,		0,			0,			0 }
};

elemDesc desc_HC_SearchRequest[] = {
  { elemInt,		0,			sizeof(int),		0 },
  { elemInt,		0,			sizeof(int),		0 },
  { elemInt,		0,			sizeof(int),		0 },
  { elemBoolean,	0,			sizeof(Boolean),	0 },
  { elemCharPtr,	0,			sizeof(char *),		0 },
  { elemStructPtr,	desc_DatabaseName,	sizeof(DatabaseName *),	0 },
  { elemStructPtr,	desc_RecordComposition,	sizeof(RecordComposition *), 0 },
  { elemStructPtr,	desc_RecordComposition,	sizeof(RecordComposition *), 0 },
  { elemCharPtr,	0,			sizeof(char *),		0 },
  { elemStructPtr,	desc_Query,		sizeof(Query *),	0 },
  { elemDone,		0,			0,			0 }
};

elemDesc desc_HC_SearchResponse[] = {
  { elemInt,		0,			sizeof(int),		0 },
  { elemInt,		0,			sizeof(int),		0 },
  { elemInt,		0,			sizeof(int),		0 },
  { elemBoolean,	0,			sizeof(Boolean),	0 },
  { elemEnum,		0,			sizeof(ResultSetStatus),0 },
  { elemEnum,		0,			sizeof(PresentStatus),	0 },
  { elemStructPtr,	desc_HlvlRecords,	sizeof(HlvlRecords *),	0 },
  { elemDone,		0,			0,			0 }
};

elemDesc desc_HC_PresentRequest[] = {
  { elemCharPtr,	0,			sizeof(char *),		0 },
  { elemInt,		0,			sizeof(int),		0 },
  { elemInt,		0,			sizeof(int),		0 },
  { elemStructPtr,	desc_RecordComposition,	sizeof(RecordComposition *), 0 },
  { elemCharPtr,	0,			sizeof(char *),		0 },
  { elemDone,		0,			0,			0 }
};

elemDesc desc_HC_PresentResponse[] = {
  { elemInt,		0,			sizeof(int),		0 },
  { elemInt,		0,			sizeof(int),		0 },
  { elemEnum,		0,			sizeof(PresentStatus),	0 },
  { elemStructPtr,	desc_HlvlRecords,	sizeof(HlvlRecords *),	0 },
  { elemDone,		0,			0,			0 }
};

elemDesc desc_HC_DeleteResultSetRequest[] = {
  { elemBoolean,	0,			sizeof(Boolean),	0 },
  { elemCharPtr,	0,			sizeof(char *),		0 },
  { elemDone,		0,			0,			0 }
};

elemDesc desc_HC_DeleteResultSetResponse[] = {
  { elemBoolean,	0,			sizeof(Boolean),	0 },
  { elemDone,		0,			0,			0 }
};

elemDesc desc_HC_CloseRequest[] = {
  { elemInt,		0,			sizeof(int),		0 },
  { elemDone,		0,			0,			0 }
};

elemDesc desc_HC_CloseResponse[] = {
  { elemBoolean,	0,			sizeof(Boolean),	0 },
  { elemCharPtr,	0,			sizeof(char *),		0 },
  { elemDone,		0,			0,			0 }
};

elemDesc desc_HC_ErrorMsg[] = {
  { elemCharPtr,	0,			sizeof(char *),		0 },
  { elemBoolean,	0,			sizeof(Boolean),	0 },
  { elemDone,		0,			0,			0 }
};

elemDesc desc_HC_Packet_u[] = {
  { elemStructPtr,	desc_HC_OpenRequest,	sizeof(HC_OpenRequest *),	0},
  { elemStructPtr,	desc_HC_OpenResponse,	sizeof(HC_OpenResponse *),	0},
  { elemStructPtr,	desc_HC_SearchRequest,	sizeof(HC_SearchRequest *),	0},
  { elemStructPtr,	desc_HC_SearchResponse,	sizeof(HC_SearchResponse *),	0},
  { elemStructPtr,	desc_HC_PresentRequest,	sizeof(HC_PresentRequest *),	0},
  { elemStructPtr,	desc_HC_PresentResponse,sizeof(HC_PresentResponse *),	0},
  { elemStructPtr,	desc_HC_DeleteResultSetRequest,	sizeof(HC_DeleteResultSetRequest *),	0},
  { elemStructPtr,	desc_HC_DeleteResultSetResponse,sizeof(HC_DeleteResultSetResponse *),	0},
  { elemStructPtr,	desc_HC_CloseRequest,	sizeof(HC_CloseRequest *),	0},
  { elemStructPtr,	desc_HC_CloseResponse,	sizeof(HC_CloseResponse *),	0},
  { elemStructPtr,	desc_HC_ErrorMsg,	sizeof(HC_ErrorMsg *),		0},
  { elemDone,		0,			0,			0 }
};

char *HC_Packet_name[] = {
   "open request",		"open response",
   "search request",		"search response",
   "present request",		"present response",
   "delete result set request",	"delete result set response",
   "close request",		"close response",
   "error message",
   0
};

elemDesc desc_HC_Packet[] = {
  { elemEnum,		0,			sizeof(HC_PacketTypes), 0},
  { elemInt,		0,			sizeof(int),		0 },
  { elemUnion,		desc_HC_Packet_u,	0,			0 },
  { elemDone,		0,			0,			0 }
};

#endif /* CLIENT_STRUCTDESC_H */
