/* ansidef.h -- compatibility macros for C++ / ANSI C / traditional C
 *
 * Usage:
 *  IF_CPLUSPLUS(extern "C" {, EMPTY_ARG)	/ * For anti-#if fanatics * /
 *	extern int    printf ARGDCL((CONST char * VA_DOTS));
 *	extern VOIDFN foo ARGDCL((VOIDDATA *, int)), bar (NOARGS);
 *  IF_CPLUSPLUS(}, EMPTY_ARG)
 *
 *  VOIDFN foo ARGDEF((a, b),			/ * traditional-C args   * /
 *		      VOIDDATA *a ARG int b)	/ * Argument definitions * /
 *  {
 *	bar();
 *	return VOIDVAL;			/ * Avoid 'no returnvalue' warning * /
 *  }
 *  / * Definitions as above can become ugly.  You may prefer ARGDCL to
 *	*declare* functions and traditional C syntax to *define* them.
 *	To check that definition, #include the file with the matching ARGDCL.
 *	WARNING: traditional short/char args must be ARGDCLed as int, and
 *	float as double.  Avoid *unsigned* short/char args if possible. * /
 *
 *  #if HAS_STDARG
 *  #  include <stdarg.h>
 *  #else
 *  #  include <varargs.h>	/ * Sorry, varargs is not really portable * /
 *  #endif
 *  int xprintf VA_ARGDEF((format, va_alist),
 *			  CONST char *format)
 *  {...va_list ap; VA_START(ap,format); ... va_end(ap); ...}
 *
 * Macros CONST, VOLATILE, SIGNED, INLINE are defined as const... or empty.
 * VOIDDATA, VOIDFN, VOIDCAST  are  void, void, (void)  or  char, int, empty.
 *
 * You may predefine the IS_xxx/HAS_xxx macros (define as 0 or 1),
 * VA_DOTS, VOIDxxx macros, CONST/VOLATILE/SIGNED, and INLINE.
 * HAS_STDARG is reset if !HAS_PROTOTYPES.
 * Defaults come from defined(__cplusplus or c_plusplus) and __STDC__!=0.
 *	(No defined(__STDC__).  __STDC__ == 0 is untrustable nonANSI.)
 * For example, many non-ANSI compilers have void, so could set HAS_VOID.  Or
 * the other way around: because system headers on some machines declare
 * char* instead of void* functions, you may want to reset HAS_VOID or define
 * VOIDDATA/VOIDFN to make your declarations match the system headers.
 *
 * Extract the commented lines in the code for more documentation.
 *
 * Version 1.4, modified 23 Oct 1992
 *
 * Please add to this file to rope in more machine types/compilers.
 * Do not use empty macro args, backslash-newline or very long lines.
 *   -- Hallvard B Furuseth <H.B.Furuseth@usit.uio.no>
 */

#ifndef ANSIDEF_H_
#define ANSIDEF_H_

#define EMPTY_ARG /* Use this as empty macro arg; some cpp''s fail otherwise */

/* C++ */
#if defined(IS_CPLUSPLUS) ? (IS_CPLUSPLUS) : (defined(__cplusplus) || defined(c_plusplus))
#  define IS_CPLUSPLUS		1	/* True if C++ */
#  define IF_CPLUSPLUS(cplpl,c)	cplpl	/* Macro to choose C++ vs nonC++ arg */
#else
#  define IF_CPLUSPLUS(cplpl,c)	c
#endif


/* ANSI C */
#if defined(IS_ANSI) ? (IS_ANSI) : ((__STDC__) || (IS_CPLUSPLUS))
#  define IS_ANSI		1	/* True if C++ or ANSI C */
#  define IF_ANSI(ansi,trad)	ansi	/* Choose C++/ANSI vs traditional C */
#else
#  define IF_ANSI(ansi,trad)	trad
#endif

/* Prototypes */
#if defined(HAS_PROTOTYPES) ? (HAS_PROTOTYPES) : (IS_ANSI)
#  define HAS_PROTOTYPES	1	/* True if ANSI C prototypes work    */
#  define ARGDCL(args)		args	/* Arguments in function declaration */
#  define ARGDEF(args,defs)	(defs)	/* Arguments in function definition  */
#  define ARG			,	/* Argument separator in definition  */
#  define NOARGS		void	/* "Argument" to func. without args  */
#else
#  define ARGDCL(args)		()
#  define ARGDEF(args,defs)	args defs;
#  define ARG			;
#  define NOARGS
#endif

/* Stdarg/varargs protypes */
#if (defined(HAS_STDARG) ? (HAS_STDARG) : (IS_ANSI)) && (HAS_PROTOTYPES)
#  define HAS_STDARG		1		/* True if we have stdarg.h */
#  define VA_ARGDCL(args)	args
#  define VA_ARGDEF(args,defs)	(defs VA_DOTS)	/* Args to variable arg fn  */
#  define VA_START		va_start	/* Used instead of va_start */
#  ifndef   VA_DOTS				/* Def. to end var.arglist  */
#    define VA_DOTS		IF_CPLUSPLUS(...,ARG...)
#  endif
#else
#  undef  HAS_STDARG
#  define HAS_STDARG		0
#  define VA_ARGDCL(args)	()
#  define VA_ARGDEF(args,defs)	args defs; va_dcl
#  define VA_START(ptr,last)	va_start(ptr)
#endif

/* Void */
#ifndef HAS_VOID
#  if defined(sun) || defined(ultrix) || defined(__ultrix) || defined(MIPSEL)
#    define	HAS_VOID	1
#  endif
#endif
#if defined(HAS_VOID) ? (HAS_VOID) : (IS_ANSI)
#  define	HAS_VOID	1	/* True if 'void' exists */
#  ifndef	VOIDFN
#    define	VOIDFN		void	/* Return type of void functions */
#  endif
#  ifndef	VOIDDATA
#    define	VOIDDATA	void	/* Data type of void* "contents" */
#  endif
#  ifndef	VOIDCAST
#    define	VOIDCAST	(void)	/* Ignore value of expression */
#  endif
#else
#  ifndef	VOIDFN
#    define	VOIDFN		int
#    ifndef	VOIDVAL
#      define	VOIDVAL		0	/* Return value of void functions */
#    endif				/*   (useful to shut up warnings) */
#  endif
#  ifndef	VOIDDATA
#    define	VOIDDATA	char
#  endif
#  ifndef	VOIDCAST
#    define	VOIDCAST
#  endif
#endif
#ifndef		VOIDVAL
#  define	VOIDVAL
#endif

/* CONST/VOLATILE/SIGNED.  They need a type as well, do not default to 'int' */
#ifndef		CONST
#  define	CONST		IF_ANSI(const,EMPTY_ARG)
#endif
#ifndef		VOLATILE
#  define	VOLATILE	IF_ANSI(volatile,EMPTY_ARG)
#endif
#ifndef		SIGNED
#  define	SIGNED		IF_ANSI(signed,EMPTY_ARG)
#endif

/* INLINE: *ATTEMPT* to define a  local inline  function */
#ifndef		INLINE
#  if IS_CPLUSPLUS
#    define	INLINE		inline
#  else
#    if __GNUC__
#      define	INLINE		static __inline__
#    else
#      define	INLINE		static
#    endif
#  endif
#endif

#endif /* ANSIDEF_H_ */
