

/*
 *
 * sr-address.h  -  Addressing and directory related stuff
 *
 * Copyright (c) 1993 Nordic SR-NET 
 * All Rights Reserved 
 *
 *

   Addresses are represented in a structure that may hold one each of 
   all addresses supported by the underlaing network internfaces (the 
   lower layers). A mask identifies which addresses are present. Use
   str2address() to convert a string possibly entered by a user into 
   an Address structure.

   TCP/IP addresses are represented as an DNS name or IP network address
   optionally followed by a port number. The two components separated by
   a "+" character. Some examples of valid addresses: gandalf.uio.no, 
   gandalf, gandalf+4711, 129.240.2.7, 129.240.2.7+4711

   OSI addresses are represented according to RFC 1278. 

*/

#ifndef SR_ADDRESS_H
#define SR_ADDRESS_H

#include <sr-general.h>


typedef enum SR_protocolVersion { proto_SR_V2, proto_Z3950_V2 } SR_protocolVersion;

typedef enum SR_addressType { addrOSI, addrTCPIP } SR_addressType;
  
typedef struct SR_Address {
   SR_protocolVersion	protocolVersion;
   SR_addressType	addressType;
   union { 
      char		*osi_address;
      char		*tcpip_address;
   } addr;
   struct SR_Address	*next;
} SR_Address;

Boolean str2sr_address ( char *str, SR_Address **addr, char **msg );
void free_sr_address ( SR_Address *addr );
char *sr_address2str ( SR_Address *addr );

#endif
