/*
 * client.h,v 1.2 1994/01/30 17:10:37 franktor Exp
 */

#ifndef CLIENT_H
#define CLIENT_H

#include <sr-general.h>
#include <high/client-structs.h>
#include <high/sr_structcodec.h>

#define MAX_BUF	2048

#define MAX_LOOPS 10

typedef struct ServerConnection {
  struct ServerConnection *next;
  int client_ref;		/* Used in the HC_Packet structure */
  int server_ref;		/* Used in SR_Read_[packettype](ref) function */
  HC_PacketTypes last_packet;	/* Used as status variable to detect prot. errors */
  Boolean aborted;		/* If true, let the client know at next request */
} ServerConnection;

typedef struct Client {
  struct Client *next;	/* Linked list, starting with first_client */
  int fd;		/* File descriptor in structcodec connection */
  ServerConnection *servers;
  Boolean selectOnWrite;
  int loopcount;		/* To "fix" a bug in structcodec */
} Client;

Client *first_client;

#ifndef __CEXTRACT__
#include "proto.h"
#endif

/*
 * No need to have prototypes here, they are all included from proto.h
 *   -Frank.
 */
#if 0
/* From backend.c */
void	add_client	(int fd);
void	remove_client	(Client *);
Client	*fd2client	(int fd);
Client	*find_client	(int ref);
Client	*find_client_from_SR_ref (int ref);
ServerConnection *find_connection (Client *client, int ref);

/* From client.c */
void	handleOpenRequest	(int fd, HC_OpenRequest *req);
void	handleCloseRequest	(int fd, HC_CloseRequest *req);
void	handlePresentRequest	(int fd, HC_PresentRequest *req);
void	handleSearchRequest	(int fd, HC_SearchRequest *req);
void	handleDeleteResultSetRequest (int fd, HC_DeleteResultSetRequest *req);


/* From responses.c */
void	handleInitialiseResponse (int ref);
void	handleCloseResponse (int ref);
void	handleSearchResponse (int ref);
void	handlePresentResponse(int ref);
void	handleDeleteResultSetResponse (int ref);
void	handleAbortResponse (int ref);
void	sendErrorResponse (Client *to_client, ServerConnection *from_conn,
			   const char *message, Boolean abort);

/* From records.c */
octetString *oscpy (octetString *dest, octetString *src);
DiagRec		*ConvertFromHlvlDiagRec		(HlvlDiagRec *);
NamePlusRecord	*ConvertFromHlvlNamePlusRecord	(HlvlNamePlusRecord *);
Records		*ConvertFromHlvlRecords		(HlvlRecords *);
Query		*ConvertToHlvlQuery		(Query *);

/* From hlvlrecords.c */
HlvlDiagRec	   *ConvertToHlvlDiagRec	(DiagRec *);
HlvlNamePlusRecord *ConvertToHlvlNamePlusRecord	(NamePlusRecord *);
HlvlRecords	   *ConvertToHlvlRecords	(Records *);

/* From util.c */
RecordComposition *copyRecordCompositon (RecordComposition *);
#endif /* #if 0 */

#endif
