#include "fem.h"

#ifndef CRAY
#define INITPF initpf_
#define DBRNU  dbrnu_
#define DBFILE dbfile_
#define JOBPAR jobpar_
#endif

#ifdef __convex__
#undef  JOBPAR
#define JOBPAR _jobpar_
#endif


/* ABAQUS Fortran Library Routines */

extern void INITPF (int *nru, int *lrunit, int *loutf);
extern void DBRNU  (int *file_output_fortran_unit);
extern void DBFILE (int *lop, REAL *array, int *returncode);

/* C-callable routines to retrieve/monitor ABAQUS data */

extern int ABAQUS_Open(char *filename);
extern int ABAQUS_Rewind();
extern int ABAQUS_Close();

extern int ABAQUS_Debug(FILE *fp, 
			bool rewind_flag_start,
			bool rewind_flag_end
			);

extern Node    *ABAQUS_Read_Nodes();
extern Element *ABAQUS_Read_Elements();
extern int      ABAQUS_Read_Model(Model *model);
extern int      ABAQUS_Time_Data(STime *timeinc);

extern int ABAQUS_Alloc_NodalData(NodalData *nd, int ndatacomp);
extern int ABAQUS_Free_NodalData(NodalData *nd);
extern int ABAQUS_Read_Disp(NodalData *nd);
extern int ABAQUS_Read_Temp(NodalData *nd);
extern int ABAQUS_Read_Stress(NodalData *str, 
			      int str_flag, int str_type, int str_layer);
extern int ABAQUS_Next_Time_Step(NodalData *nd);
extern int ABAQUS_Locate_Time_Step(NodalData *nd, int step, int inc);


