/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */


#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/SelectioB.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <Xm/Separator.h>

#include "net.h"

#ifndef MALLOC
#define MALLOC	malloc
#define FREE	free
#endif


extern void NewConnect();
extern void AddUser();
extern void RemoveUser();


extern char *UserID;


static Widget dialog = NULL;
static Widget txt;
static Widget hostTxt;
static char *serverLocation = NULL;

void SetServerLocation(newLocation)
char *newLocation;
{
	serverLocation = newLocation;
}


void CBDisplayServerLocation(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
char buff[256];

	NetPort *p;
	p = NetIsConnected();
	if (p) {
		if (serverLocation) {
			WriteMesg(serverLocation);
			}
		else {
			sprintf(buff,"sending to port %s", p->portName);
			}
		}
	else {
		WriteMesg("Currently this session is not connected to a server\nYou may click on Begin session or Join session\n to connect to a server");
		}
}

void CBConnect(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Arg argList[10];
Cardinal i;
XmString string;
char *id;
char *value;
char *hostName;
char portName[256];
char *p;
char portNum[256];
int n;


	/* Get port address */
        XtSetArg(argList[0], XmNtextString, &string);
        XtGetValues(dialog, argList, 1);
        XmStringGetLtoR(string, XmSTRING_DEFAULT_CHARSET, &value);

	portNum[0] = '\0';
	sscanf(value," %s", portNum);

	p = portNum;
	if (p[0] == ':')
		p++;

	n = atoi(p);
	if ((n < 1024) || (n > 65535)) {
		ErrMesg("port number must be between 1024 and 65535\n");
		XtManageChild(dialog);
		return;
		}

	hostName = XmTextFieldGetString(hostTxt);
	if (hostName && hostName[0]) {
		sprintf(portName,"%s:%s",hostName,p);
		}
	else {
		sprintf(portName,":%s",p);
		}

	serverLocation = (char *)  MALLOC(strlen(portName) + 1);
	strcpy(serverLocation,portName);

	/* get ID */
	id = NULL;
	id = XmTextFieldGetString(txt);

	XtUnmanageChild(dialog);
	XtDestroyWidget(dialog);
	dialog = NULL;

	if ((id != NULL)&&(id[0] != '\0')) {
		if (UserID != NULL) {
			RemoveUser(UserID);
			FREE((char *)UserID);
			UserID = NULL;
			}
		UserID = (char *)MALLOC(strlen(id) + 1);
		strcpy(UserID, id);
		NetSetUserID(UserID);
		AddUser(UserID);
		}


	if (portName[0] != '\0') {
		NewConnect(":0", portName);
		}
}


void CBBegin(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Arg argList[10];
Cardinal i;
XmString string;
char portNum[256];
char portName[256];
char comm[256];
char *value;
char *id;
int retStatus;
int n;
char hostName[80];


        XtSetArg(argList[0], XmNtextString, &string);
        XtGetValues(dialog, argList, 1);
        XmStringGetLtoR(string, XmSTRING_DEFAULT_CHARSET, &value);

	portNum[0] = '\0';
	sscanf(value," %s", portNum);

	if ((!portNum) || (!portNum[0])) {
		ErrMesg("port name must be between 1024 and 65535\n");
		XtManageChild(dialog);
		return;
		}
	if (portNum[0]==':') {
		n = atoi(&(portNum[1]));
		}
	else {
		n = atoi(portNum);
		}
	if ((n < 1024) || (n > 65535)) {
		ErrMesg("port name must be a number between 1024 and 65535\n");
		XtManageChild(dialog);
		return;
		}

	sprintf(portName,":%d",n);

	if (-1 == gethostname(hostName,80)) { /*error*/
		serverLocation = (char *)  MALLOC(strlen(portName) + 1);
		strcpy(serverLocation,portName);
		}
	else {
		serverLocation = (char *) MALLOC(strlen(portName)
				+ strlen(hostName) + 1);
		sprintf(serverLocation,"%s%s",hostName,portName);
		}
	
	id = NULL;
	id = XmTextFieldGetString(txt);

	XtUnmanageChild(dialog);
	XtDestroyWidget(dialog);
	dialog = NULL;

	if ((id != NULL)&&(id[0] != '\0')) {
		if (UserID != NULL) {
			RemoveUser(UserID);
			FREE((char *)UserID);
			UserID = NULL;
			}
		UserID = (char *)MALLOC(strlen(id) + 1);
		strcpy(UserID, id);
		NetSetUserID(UserID);
		AddUser(UserID);
		}


	if (portName[0] != '\0') {
		sprintf(comm, "collage_server -DTMIN %s", portName);
		retStatus = system(comm);
		if (retStatus) {
			ErrMesg("Can't execute collage server \"collage_server\"\n");
			return;
			}
#ifdef DEBUG
		printf("system() retStatus = %d\n",retStatus);
#endif
		sleep(2);

		NewConnect(":0", portName);
		}
}


static void
CBCancelDialog(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
        XtUnmanageChild(dialog);
	XtDestroyWidget(dialog);
	dialog = NULL;
}


void
CBJoinSession(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	Widget rootW = (Widget)client_data;
	Widget work, lab, sep;
	Widget t2;
	Cardinal i;
	Arg argList[15];
	XmString label, valLabel;
	char buff[1024];
	char value[1024];
	XmTextScanType sel[2];


	if (dialog != NULL)
	{
		return;
	}

	sprintf(buff, "Server port number:");
	strcpy(value, "");

        label = XmStringCreateSimple(buff);
        valLabel = XmStringCreateSimple(value);
        i = 0;
	XtSetArg(argList[i], XtNtitle, "Join Session"); i++;
        XtSetArg(argList[i], XmNselectionLabelString, label); i++;
        XtSetArg(argList[i], XmNtextString, valLabel); i++;
        XtSetArg(argList[i], XmNcolumns, 4); i++;
	XtSetArg(argList[i], XmNkeyboardFocusPolicy, XmPOINTER); i++;
        dialog = XmCreatePromptDialog(rootW, "sessionDialog", argList, i);
	XmStringFree(valLabel);
	XmStringFree(label);

        i = 0;
        XtSetArg(argList[i], XmNshadowThickness, 0); i++;
	work = XmCreateForm(dialog, "WorkForm", argList, i);

        label = XmStringCreateSimple("Your name:");
        i = 0;
        XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNalignment, XmALIGNMENT_BEGINNING); i++;
        XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
	lab = XmCreateLabel(work, "workLabel", argList, i);
	XmStringFree(label);
	XtManageChild(lab);

	sel[0] = XmSELECT_POSITION;
	sel[1] = XmSELECT_LINE;
        i = 0;
        XtSetArg(argList[i], XmNvalue, UserID); i++;
        XtSetArg(argList[i], XmNselectionArray, sel); i++;
        XtSetArg(argList[i], XmNselectionArrayCount, 2); i++;
        XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
        XtSetArg(argList[i], XmNtopWidget, lab); i++;
        XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
	txt = XmCreateTextField(work, "workText", argList, i);
	XtManageChild(txt);

        i = 0;
        XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
        XtSetArg(argList[i], XmNtopWidget, txt); i++;
        XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
	sep = XmCreateSeparator(work, "separator", argList, i);
	XtManageChild(sep);

        label = XmStringCreateSimple("Host name of collage server:");
        i = 0;
        XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNalignment, XmALIGNMENT_BEGINNING); i++;
        XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
        XtSetArg(argList[i], XmNtopWidget, sep); i++;
        XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
	lab = XmCreateLabel(work, "workLabel", argList, i);
	XmStringFree(label);
	XtManageChild(lab);

	sel[0] = XmSELECT_POSITION;
	sel[1] = XmSELECT_LINE;
        i = 0;
        XtSetArg(argList[i], XmNvalue, ""); i++;
        XtSetArg(argList[i], XmNselectionArray, sel); i++;
        XtSetArg(argList[i], XmNselectionArrayCount, 2); i++;
        XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
        XtSetArg(argList[i], XmNtopWidget, lab); i++;
        XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
	hostTxt = XmCreateTextField(work, "workText", argList, i);
	XtManageChild(hostTxt);

	XtManageChild(work);

        XtAddCallback(dialog, XmNokCallback, CBConnect, NULL);
        XtAddCallback(dialog, XmNcancelCallback, CBCancelDialog, NULL);

	XtManageChild(dialog);
}


void
CBBeginSession(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	Widget rootW = (Widget)client_data;
	Widget work, lab, sep;
	Cardinal i;
	Arg argList[15];
	XmString label, valLabel;
	char buff[1024];
	char value[1024];
	XmTextScanType sel[2];

	if (dialog != NULL)
	{
		return;
	}

	sprintf(buff, "Server Port Number:");
	strcpy(value, "");

        label = XmStringCreateSimple(buff);
        valLabel = XmStringCreateSimple(value);
        i = 0;
	XtSetArg(argList[i], XtNtitle, "Begin Session"); i++;
        XtSetArg(argList[i], XmNselectionLabelString, label); i++;
        XtSetArg(argList[i], XmNtextString, valLabel); i++;
        XtSetArg(argList[i], XmNcolumns, 4); i++;
	XtSetArg(argList[i], XmNkeyboardFocusPolicy, XmPOINTER); i++;
        dialog = XmCreatePromptDialog(rootW, "sessionDialog", argList, i);
	XmStringFree(valLabel);
	XmStringFree(label);

        i = 0;
        XtSetArg(argList[i], XmNshadowThickness, 0); i++;
	work = XmCreateForm(dialog, "WorkForm", argList, i);

        label = XmStringCreateSimple("Your name:");
        i = 0;
	XtSetArg(argList[i], XmNalignment, XmALIGNMENT_BEGINNING); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
	lab = XmCreateLabel(work, "workLabel", argList, i);
	XmStringFree(label);
	XtManageChild(lab);

	sel[0] = XmSELECT_POSITION;
	sel[1] = XmSELECT_LINE;
        i = 0;
        XtSetArg(argList[i], XmNvalue, UserID); i++;
        XtSetArg(argList[i], XmNselectionArray, sel); i++;
        XtSetArg(argList[i], XmNselectionArrayCount, 2); i++;
        XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
        XtSetArg(argList[i], XmNtopWidget, lab); i++;
        XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
	txt = XmCreateTextField(work, "workText", argList, i);
	XtManageChild(txt);

        i = 0;
        XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
        XtSetArg(argList[i], XmNtopWidget, txt); i++;
        XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
	sep = XmCreateSeparator(work, "separator", argList, i);
	XtManageChild(sep);

	XtManageChild(work);

        XtAddCallback(dialog, XmNokCallback, CBBegin, NULL);
        XtAddCallback(dialog, XmNcancelCallback, CBCancelDialog, NULL);
	XtManageChild(dialog);
}

