/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */



#define MIN3(a,b,c) ((a<b)&&(a<c)) ? a : ((b < c)? b : c)
#define MAX3(a,b,c) ((a>b)&&(a>c)) ? a : ((b > c)? b : c)


void ConvertHSVtoRGB(h,s,v,pr,pg,pb)
double h; /* 0.0 to 360.0 */
double s; /* 0.0 to 1.0 */
double v; /* 0.0 to 1.0 */
unsigned short *pr,*pg,*pb; /* 0 to 65535 */
{
double r,g,b;
int i;
double f;
double p1,p2,p3;

	r = ((double) *pr) / (double) 65535.0;
	g = ((double) *pg) / (double) 65535.0;
	b = ((double) *pb) / (double) 65535.0;

	if (h == 360.0)
		h = 0.0;

	h = h / 60.0;

	i = (int) h;
	f = h - ((double) i);

	p1 = v * (1.0 - s);
	p2 = v * (1.0 - (s * f));
	p3 = v * (1.0 - (s * (1.0 - f)));

	switch (i) {
		case 0:
			r = v; g = p3; b = p1;
			break;
		case 1:
			r = p2; g = v; b = p1;
			break;
		case 2:
			r = p1; g = v; b = p3;
			break;
		case 3:
			r = p1; g = p2; b = v;
			break;
		case 4:
			r = p3; g = p1; b = v;
			break;
		case 5:
			r = v; g = p1; b = p2;
			break;
		}

	*pr = (unsigned short) (r * 65535.0);
	*pg = (unsigned short) (g * 65535.0);
	*pb = (unsigned short) (b * 65535.0);

} /* ConvertHSVtoRGB */

int ConvertRGBtoHSV(pr,pg,pb,h,s,v)
/* will return 0 if hue is undefined else return 1*/
unsigned short pr,pg,pb; /* 0 to 65535 */
double	*h; /* between 0.0 and 360.0 */
double	*s; /* between 0.0 and 1.0 */
double	*v; /* between 0.0 and 1.0 */
{
double	r,g,b;
double	range;
double	min;
double  rl,gl,bl;

	r = ((double)pr) / (double)65535.0;
	g = ((double)pg) / (double)65535.0;
	b = ((double)pb) / (double)65535.0;

	*v  = MAX3(r,g,b);
	min = MIN3(r,g,b);

	range = *v - min;

	if (*v)
		*s = range / *v;
	else
		*s = 0;

        if (*s) {
		rl = (*v - r) / range;
		gl = (*v - g) / range;
		bl = (*v - b) / range;

	        if ( *v == r ) {
			if ( min == g)
				*h = 5.0 + bl;
			else
				*h = 1.0 - gl;
	                }
		else {
			if ( *v == g) {
				if ( min == b)
					*h = 1.0 + rl;
				else
					*h = 3.0 - bl;
				}
			else {
				if (min == r)
					*h = 3.0 + gl;
				else
					*h = 5.0 - rl;
				}
			}
		*h = *h * 60.0;
		} /* if (*s)
	else
		return(0); /* h is undefined */

	return(1);
	
} /* ConvertRGBtoHSV() */

