/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */


#define PAL_MODULE_NAME "Palette"

#define CRED            (1 << 9)
#define CGREEN          (1 << 8)
#define CBLUE           (1 << 7)
#define CCYAN           (1 << 6)
#define CMAGENTA        (1 << 5)
#define CYELLOW         (1 << 4)
#define CHUE            (1 << 3)
#define CSATURATION     (1 << 2)
#define CVALUE          (1 << 1)
#define CLIGHTNESS      1

typedef enum { RGB, CMY, HSV } ColorModel;


typedef struct {
        char	*palName;
        Widget	top;
        Widget	mainWindow;
        Widget	menuBar;
        Widget	pulldown[10];
        Widget	button[10];
	Widget	editButton;
        Widget	compWindow;
	GC	compWinGC;
        Widget	colorBar;
        unsigned char *colorBarImage;
        XImage	*colorBarXImage;
        int	colorBarWidth;
        int	colorBarHeight;
        GC	colorBarGC;
        Widget	toggleBox;
        Widget	toggleBoxRadio;
        Widget	toggleDraw[3];
        Widget	toggleShow[3];
        ColorModel model;
        Widget	fiddleButton;
        Pixmap	fiddlePixmap;
        XColor  ccells[256];
        XColor  resetCCells[256];
        XColor  undoCCells[256];
        XColor  tmpCCells[256];
        Colormap cmap;
        int     useAllEntries;
        int     displayNewPalettes;
        int     mainWindowHeight;       /* used in Fiddle */
        int     mainWindowWidth;
        int     lastx;          /* used in Rotate */
	XPoint  rpoints[256];           /*drawn red points(CBDrawComponent)*/
	XPoint  gpoints[256];           /*drawn green points*/
	XPoint  bpoints[256];           /*drawn blue points*/
	XPoint  cpoints[256];           /*drawn cyan  */
	XPoint  mpoints[256];           /*drawn magenta  */
	XPoint  ypoints[256];           /*drawn yellow */
	XPoint  hpoints[256];           /*drawn hue */
	XPoint  spoints[256];           /*drawn saturation*/
	XPoint  vpoints[256];           /*drawn value */
	int	compWinHeight;
	int	compWinWidth;
	int	rgbcmyhsv;
	int	fiddleStart;
	int	rotateStart;
	int 	compPen;
	int	compPenDrawColor;
	int	compLastX,compLastY;
	Pixel	background;
	Pixel	foreground;
	Boolean finishCreate;
        } Pal;

typedef struct {
        char *name;
        XmString motifName;
        XColor *ccells;
        } PaletteEntry;

typedef struct {
        PaletteEntry *palette;
        Pal     *pal;
        } PalGroup;
